#include        <fc.h>          /* fcs header                   */

#DEFINE INLUN1  1               /* lun for fdbin1               */

#DEFINE EOF     -10             /* end of file status           */

#define RECSIZ  132             /* size of the largest record   */

int     fdbin1[ SFDBW ] = {0};  /* fdb for file .stb file       */

char    outbuf[RECSIZ] = {0};    /* input file buffer            */
int     riob[2] = {0};          /* record i/o status block      */

struct {
	int     type;
	struct  {
		int     nam[2];
		int     filler;
		int     adr;
		} symbol[20];
	} stbbuf = {0};

char    filstr[40] = {0};       /* .stb file name               */
char    fil[22] = {0};          /* parsed file name             */
char    dev[6]  = {0};          /* parsed device name           */
char    uic[12] = {0};          /* parsed uic                   */
char    *definf = "LB:[1,54]rsx11m.stb";
char	*defsym = "$DEVHD";



int *find_r()
{
int     status;
int     i, j;
char    tbuf[8];
char    ss[8];
int     ssl=0;

	/* provide default STB input file */

	cpystr ( filstr, definf, '\0' );

	/* provide for default symbol search string      */

	ssl = 5;
	cpystr ( ss, defsym, '\0' );
	ss[ssl] = '\0';
	lctouc ( ss );          /* convert to upper case        */

	/* parse device, uic, and filename from file name string*/

	pfilnm ( &filstr, &dev, &uic, &fil );

	filopn ( fdbin1, dev, uic, fil, INLUN1, FCSEQIO+FCROACC, NOFOB );

	while (  getrec ( fdbin1, &stbbuf, 132, riob ) != EOF )
		{
		i = (riob[1]- 2)/ 8;    /* loop count   */

		if ( stbbuf.type != 1 )
			continue;

		for ( j=0; j<i; j++ )
			{
			fill ( tbuf, 6, ' ' );
			r50asc( tbuf, stbbuf.symbol[j].nam[0] );
			r50asc( &tbuf[3], stbbuf.symbol[j].nam[1] );

			if ( ss )
				{
				if ( cmpbuf ( ss, tbuf, ssl ) )
					{
					status = fcclos ( fdbin1 );
					return( stbbuf.symbol[j].adr );
					}
				}
			}
		}
	status = fcclos ( fdbin1 );
	return( 0 );
}

/*
**      Name:           filopn  -  Open a fcs file using fcopen.
**
**      Arguments:      fdb     - Pointer to an fdb.
**                      filnm   - Pointer to a character name string.
**                      lun     - Lun to be used for the file.
**                      func    - Open file function code.
**
**      Call:           filopn ( fdb, filnm, lun, func, fob )
**
**      Returns:        The status of fcopen is returned.
**
*/

filopn ( fdb, dvnm, dir, filnm, lun, func, fob )

int     *fdb;
char    *dvnm;
char    *dir;
char    *filnm;
int     lun;
int     func;
int     *fob;

{
int     status;

	status = fcopen ( fdb, dvnm, dir, filnm, lun, func, fob );

	if ( status != ISSUC )
		filerr ( fdb, status );

	return ( status );
}


/*
**      Name:           getrec  -  Get an fcs file record.
**
**      Arguments:      fdb     - Pointer to an fdb.
**                      buf     - Pointer to an input character buffer.
**                      size    - Number of bytes to get.
**                      iob     - Record i/o status block pointer.
**
**      Call:           getrec ( fdb, buf, size, iob )
**
**      Returns:        The status of getrc is returned.
**
*/


getrec ( fdb, buf, size, iob )

int     *fdb;
char    *buf;
int     size;
int     iob[];

{
int     status;

	status = getrb ( fdb, buf, size, NORECNUM, iob );

	if ( status != ISSUC )
		status = filerr ( fdb, status );

	return ( status );
}


/*
**      Name:           filerr  - Report an fcs error.
**
**      Arguments:      fdb     - Pointer to an fdb.
**                      status  - Status returned from an fcs function.
**
**      Call:           filerr ( fdb, status )
**
**      Returns:        - none.
*/

filerr ( fdb, status )

int     *fdb;
int     status;

{
char    fclob;
char    lun;

	fclob = status;         /* get low byte of i/o status word      */
	lun = *( fdb + 17 );    /* get lun number out of the fdb        */

	if ( fclob == EOF )
		return;

	putfmt ( "\n--- FCS error %i, on LUN %i\n", fclob, lun );

	exit();
}

pfilnm ( text, dev, uic, fil )

char    *text;
char    *dev;
char    *uic;
char    *fil;

{
int     i=0;
char    *buf;


	lctouc ( text );        /* convert lower to upper case */

	buf = text;

	/* parse out device     */

	if ( ( i = scnstr ( text, ':' ))  <  lenstr( text ) )
		{
		i++;
		cpybuf ( dev, buf, i );
		buf += i;
		*( dev + i ) = '\0';
		}
	else
		*dev = '\0';


	/* parse out uic        */

	if ( ( i = scnstr ( buf, ']' ))  <  lenstr( buf ) )
		{
		i++;
		cpybuf ( uic, buf, i );
		buf += i;
		*( uic + i ) = '\0';
		}
	else
		*uic = '\0';


	/* parse out file name  */

	cpybuf ( fil, buf, lenstr( buf )+1  );
}


/*	Name:		lctouc	- Convert lower to upper case.
**
**	Arguments:	text	- Pointer to a text string.
**
**	Call:		lctouc ( text )
**
**	Returns:	none
*/

lctouc ( text )

char    *text;

{
char    *buf;
int     inc;

	buf = text;
	inc = 'A'-'a';

	while ( *buf != '\0' )
		{
		if ( *buf >= 'a' && *buf <= 'z' )
			*buf += inc;

		buf++;
		}
}
