{$E+}

{ Externals Procedues -- for DLV11-J  or DL11-E } 

FUNCTION CheckTheConsole : boolean;
EXTERNAL;
 
{ Xbreak has to be external }
PROCEDURE Xbreak(VAR f :text);
BEGIN
  break(f);
END;

Procedure GETCL(VAR { Returning	} c, { use integer not character }
		    { Using	} TimeLeft : integer);
{ Get character	from line }
VAR			
 count : integer;
BEGIN

	REPEAT 
{$C
	MOV	BCOUNT,count(SP)		;GET ACTIVE COUNT
}

	UNTIL CheckTheConsole OR (count >0) OR (TimeLeft <=0);

{$C	
	TST	BCOUNT				;ANY THING IN BUFFER ?
	BEQ	9$				;NO, SKIP
1$:	MOVB	@ADDR2,R0			;GET CHARACTER
	INC	ADDR2				;ADVANCE PROC ADR PTR
	DEC	BCOUNT				;DEC ACTIVE CHAR COUNT
	DEC	CNT2				;DEC PROC CHAR COUNT
	BNE	9$				;END OF	REC. BUFFER ?
	MOV	#BUFA,ADDR2			;YES, RESET PROC ADR PTR
	MOV	#^O1000,CNT2			;RESET PROC CHAR COUNT
9$:	MOV	R0,@c(SP)

}
END;

Procedure PUTCL(VAR c :	integer); { Output character to	line }
BEGIN
 {$C

	MOV	@c(SP),R0			;MOVE TO REG 0
	JSR	PC,SEND1			;OUTPUT
}

END;
 
{$C
;	 
;	Main Part of Code
;
;	FROM TSTE.MAC -	TIME SHARE TERMINAL EMULATOR UNDER RT-11
;		 ( ORIGINALLY FROM DECUS )
;
;	Use Octal !!
	.RADIX	8		 
;
DCSR = 176500	;DEFAULT CSR	( SYSTEM DEPENDENT )
DVEC = 300	;DEFAULT VECTOR		"  
IMASK =	106	;INIT MASK -- START INTERUPT & RTS
ESCAPE=35	;ESCAPE	CHARACTER - 33 FOR <ESC> IF YOU LIKE
JSW=44		;JOB STATUS WORD
CR=15		;CARRAGE RETURN
LF=12		;LINE FEED
;*****************************************************
	.MCALL .PRINT
	.MCALL .SCCA
	.MCALL .TTINR,.TTYOUT
	.GLOBL	SETLIN
	.GLOBL	VIRTUA
	.GLOBL	RESETL
	.GLOBL	CLRBUF
	.GLOBL	RCSR
	.GLOBL	RVEC
	.GLOBL	PARFLG
	.GLOBL	ECHO
	.GLOBL	CONLOW
	.GLOBL	TTSPEC,TTNORM
;********************************************************
;
; SetLine Entry	Point
;
SETLIN:	MOV	#RINT,@RVEC			;LOAD DL11 INT VECTOR
	MOV	#200,@RVEC2			;BR4
	BIS	#IMASK,@RCSR			;ENABLE	INT & REQ SEND
	JSR	PC,CLRBUF			;CLEAR BUFFER
	RTS	PC				;RETURN
						;
;
; Virtual Entry	Point
;						
VIRTUA:	CLR	SWITCH				;SET CONTROL SWITCH OFF
	CLR	SENDLF				;NO <LF>'S
	.SCCA	#AREA,#CHECKC			;INHIBIT CONTROL C ABORT
;*****************************************************
;MAIN LOOP
READY:	JSR	PC,PRINT			;CHECK PRINT BUFFER
	JSR	PC,TTSPEC			;KEYBOARD IN SPECIAL MODE
	.TTINR					;KEYBOARD INPUT?
	BCS	READY				;NO KEYBORAD INPUT, SKIP
	TST	SENDLF
	BNE	1$	
	CMPB	R0,#LF				;LF ?
	BEQ	READY				;YES, SKIP
1$:	TST	SWITCH				;CHECK FOR CONTROL MODE
	BEQ	13$
	CLR	SWITCH				;IN CONTROL MODE 
	CMPB	R0,#'L
	BNE	2$
	COM	SENDLF				;FLIP FLAG	
	BR	READY
2$:	CMPB	R0,#'B				;BREAK CHARACTER ?
	BNE	8$
7$:	JSR	PC,BREAK
	BR	READY
8$:	CMPB	R0,#ESCAPE			;SEND ESCAPE TO	HOST
	BNE	9$
	CLR	SWITCH				;SET CONTROL OFF
	BR	14$
9$:	CMPB	R0,#'?				;CHECK FOR HELP
	BNE	11$
10$:	JSR	PC,PHELP
	BR	READY
11$:	CMPB	R0,#'C				;CHECK FOR END
	BNE	10$				;PRINT HELP ON ERROR
;
;  EXIT	HERE BACK TO MAIN PROGRAM AFTER	VIRTUAL	CONNECTION
;  RESET POINTERS FIRST
;
	JSR	PC,CLRBUF
	JSR	PC,TTNORM			;NORMAL	MODE
	JSR	PC,CONLOW			;LOWER CASE 
	.SCCA	#AREA,#0			;RESTORE CONTROL C ABORT
	RTS	PC
13$:	CMPB	R0,#ESCAPE			;CHECK FOR ESCAPE
	BNE	14$				;IF NOT	SEND
	MOV	#1,SWITCH			;SET SWITCH
	BR	READY
14$:	JSR	PC,SEND				;SEND ALL OTHER	CHAR
	BR	READY
;
;  CLEAR INTERUPTS - ResetLine 
;
RESETL:	BIC	#IMASK,@RCSR			;CLEAR BITS
	RTS	PC
;*****************************************************
; CLEAR BUFFER - CLRBUF
CLRBUF:	MOV	#BUFA,ADDR			;RING BUFFER ADR PTR
	MOV	#1000,CNT			;RING BUFFER CHAR COUNT
	CLR	BCOUNT				;ACTIVE	CHAR COUNT
	MOV	#BUFA,ADDR2			;PROCESS ADR POINTER
	MOV	#1000,CNT2			;PROCESS CHAR COUNT
	RTS	PC
;*****************************************************
;
;SEND A	BREAK
;
BREAK:	CLR	R0
	JSR	PC,SEND1			;SEND A	NULL
	MOV	#30.,FILL1
1$:	BIS	#1,@XCSR			;SET BREAK BIT
	JSR	PC,SEND1			;SEND A	NULL, 30 TIMES
	DEC	FILL1
	BNE	1$
	JSR	PC,SEND1			;SEND A	NULL
	BIC	#1,@XCSR			;CLEAR BREAK BIT
	RTS	PC
;*****************************************************
;
;TRANSMIT A CHARACTER TO REMOTE
;
SEND:	TST	SENDLF
	BNE	2$	
	CMPB	R0,#LF				; IS CHARACTER A <LF>
	BEQ	9$				; YES, DO NOT SEND IT
2$:	JSR	PC,SEND1			;SEND CHARACTER
	TST	ECHO				;ECHO ?
	BEQ	9$		
	BICB	#200,R0				;STRIP PARITY
	.TTYOUT					;AND ECHO 
9$:	RTS	PC
SEND1:	TST	PARFLG
	BLT	30$
	BIC	#177600,R0			;MAKE SURE WE HAVE 7 BITS
	TST	PARFLG				;EVEN OR ODD
	BEQ	10$
	TSTB	PARTAB(R0)			;ODD
	BEQ	20$	
	BR	30$
10$:	TSTB	PARTAB(R0)			;EVEN
	BEQ	30$
20$:	BISB	#200,R0				;SET BIT 8
30$:	NOP
40$:	TSTB	@XCSR				;BUSY ?
	BPL	40$				;AGAIN
	MOVB	R0,@XBUF			;SEND CHAR
	RTS	PC
;*****************************************************
;
;PRINT REMOTE INPUTS AND TRANSMISSION ECHOS - VIRTUAL
;
PRINT:	TST	BCOUNT				;ANY THING IN BUFFER ?
	BEQ	9$				;NO, SKIP
	MOV	R0,-(SP)			;SAVE REG R0
1$:	MOVB	@ADDR2,R0			;GET CHARACTER
	BICB	#200,R0				;STRIP PARITY BIT
	INC	ADDR2				;ADVANCE PROC ADR PTR
	DEC	BCOUNT				;DEC ACTIVE CHAR COUNT
	DEC	CNT2				;DEC PROC CHAR COUNT
	BNE	5$				;END OF	REC. BUFFER ?
	MOV	#BUFA,ADDR2			;YES, RESET PROC ADR PTR
	MOV	#1000,CNT2			;RESET PROC CHAR COUNT
5$:	.TTYOUT					;PRINT IT
3$:	TST	BCOUNT				;DONE ?
	BNE	1$				;NO, AGAIN
	MOV	(SP)+,R0
9$:	RTS	PC
;*****************************************************
TTSPEC:	BIS	#50000,@#JSW			;SET TO	SPECIAL	MODE 
	RTS	PC
TTNORM:	BIC	#50000,@#JSW			;SET TO	NORMAL
	RTS	PC
;*****************************************************
PHELP:	.PRINT	#MHELP				;PRINT INSTRUCTIONS
	RTS	PC
;******************************************************
;INTERRUPT SERVICE ROUTINE
RINT:	INC	BCOUNT				;INC ACTIVE CHAR COUNT
	MOVB	@RBUF,@ADDR			;MOVE TO RING BUFFER
	INC	ADDR				;ADVANCE ADR POINTER
	DEC	CNT				;DEC RING BUFFER CHAR CNT
	BNE	9$				;END OF	BUFFER ?
	MOV	#BUFA,ADDR			;YES, RESET POINTERS
	MOV	#1000,CNT
9$:	RTI
;*****************************************************
	.EVEN
RCSR:	.WORD	DCSR				;DL11 STATUS REGISTER  
RBUF:	.WORD	DCSR + 2			;DL11 RECEIVE BUFFER ADDRESS
XCSR:	.WORD	DCSR + 4			;DL11 TRANSMIT STATUS ADDRESS
XBUF:	.WORD	DCSR + 6			;DL11 TRANSMIT BUFFER ADDRESS
RVEC:	.WORD	DVEC				;VECTOR
RVEC2:	.WORD	DVEC + 2			;VECTOR	+ 2
PARFLG:	.WORD	0				;-1 NONE
						;0  EVEN
						;1  ODD	  
ECHO:	.WORD	0				;ECHO  
INPNT:	.WORD	0				;RECEIVE BUFFER	POINTER
INBLK:	.WORD	0				;RECEIVE BLOCK COUNT
INCHR:	.WORD	0				;RECEIVE CHAR COUNT
ADDR:	.WORD	0				;RING BUFFER ADR PTR
CNT:	.WORD	0				;RING BUFFER CHAR COUNT
ADDR2:	.WORD	0				;PROCESS ADR PTR
CNT2:	.WORD	0				;PROCESS CHAR COUNT
BCOUNT:	.WORD	0				;ACTIVE	CHAR COUNT 
SENDLF:	.WORD	0				;SEND <LF>'S
AREA:	.BLKW	10
SAVED:	.WORD	0
FILL:	.WORD	1				;NUMBER	OF FILLS
FILL1:	.WORD	0				;FILL CHARACTER	COUNT
CHECKC:	.WORD	0				;USED BY SCCA
SWITCH:	.WORD	0				;SWITCH	FOR CONTROL
SAVESP:	.WORD	0				;USED TO SAVE STACK
MHELP:	.ASCII	<CR><LF>"Help For Connect"<CR><LF>
	.ASCII	"^]	?	Help "<CR><LF>
	.ASCII	"^]	L	Toggle Send <LF>"<CR><LF>
	.ASCII	"^]	B	Send Break"<CR><LF>
	.ASCII	"^]	C	Return To Local	Mode"<CR><LF>
	.ASCIZ	"^]	^]	Send ^] To Host"
	.EVEN
BUFA:	.BLKB	1000				;RING BUFFER
;
;
;	PARITY BIT TABLE
;
PARTAB:	
;			OCTAL 0 - 7
	.BYTE	0
	.BYTE	1
	.BYTE	1
	.BYTE	0
	.BYTE	1
	.BYTE	0
	.BYTE	0
	.BYTE	1
;			10 - 17
	.BYTE	1
	.BYTE	0
	.BYTE	0
	.BYTE	1
	.BYTE	0
	.BYTE	1
	.BYTE	1
	.BYTE	0
;			20 - 27
	.BYTE	1
	.BYTE	0
	.BYTE	0
	.BYTE	1
	.BYTE	0
	.BYTE	1
	.BYTE	1
	.BYTE	0
;			30 - 37
	.BYTE	0
	.BYTE	1
	.BYTE	1
	.BYTE	0
	.BYTE	1
	.BYTE	0
	.BYTE	0
	.BYTE	1
;			40 - 47
	.BYTE	1
	.BYTE	0
	.BYTE	0
	.BYTE	1
	.BYTE	0
	.BYTE	1
	.BYTE	1
	.BYTE	0
;			50 - 57
	.BYTE	0
	.BYTE	1
	.BYTE	1
	.BYTE	0
	.BYTE	1
	.BYTE	0
	.BYTE	0
	.BYTE	1
;			60 - 67
	.BYTE	0
	.BYTE	1
	.BYTE	1
	.BYTE	0
	.BYTE	1
	.BYTE	0
	.BYTE	0
	.BYTE	1
;			70 - 77
	.BYTE	1
	.BYTE	0
	.BYTE	0
	.BYTE	1
	.BYTE	0
	.BYTE	1
	.BYTE	1
	.BYTE	0
;			100 - 107
	.BYTE	1
	.BYTE	0
	.BYTE	0
	.BYTE	1
	.BYTE	0
	.BYTE	1
	.BYTE	1
	.BYTE	0
;			110 - 117
	.BYTE	0
	.BYTE	1
	.BYTE	1
	.BYTE	0
	.BYTE	1
	.BYTE	0
	.BYTE	0
	.BYTE	1
;			120 - 127
	.BYTE	0
	.BYTE	1
	.BYTE	1
	.BYTE	0
	.BYTE	1
	.BYTE	0
	.BYTE	0
	.BYTE	1
;			130 - 137
	.BYTE	1
	.BYTE	0
	.BYTE	0
	.BYTE	1
	.BYTE	0
	.BYTE	1
	.BYTE	1
	.BYTE	0
;			140 - 147
	.BYTE	0
	.BYTE	1
	.BYTE	1
	.BYTE	0
	.BYTE	1
	.BYTE	0
	.BYTE	0
	.BYTE	1
;			150 - 157
	.BYTE	1
	.BYTE	0
	.BYTE	0
	.BYTE	1
	.BYTE	0
	.BYTE	1
	.BYTE	1
	.BYTE	0
;			160 - 167
	.BYTE	1
	.BYTE	0
	.BYTE	0
	.BYTE	1
	.BYTE	0
	.BYTE	1
	.BYTE	1
	.BYTE	0
;			170 - 177
	.BYTE	0
	.BYTE	1
	.BYTE	1
	.BYTE	0
	.BYTE	1
	.BYTE	0
	.BYTE	0	
	.BYTE	1
}
