@Part(PROKERMIT,root="NUSER")

@PageHeading(Even,Left="Page @ref(page)",Right="@b<PRO/Kermit>")
@PageHeading(Odd,Left="@b<PRO/Kermit>",Right="Page @ref(page)")
@Chapter<PRO/Kermit>
@label(-PROK)
@index[P/OS]
@Index[DEC Professional]
@index[PROFESSIONAL-350]
@Begin<Description,Leftmargin +12,Indent -12,spread 0>
@i(Program:)@\Stuart Hecht, David Stevens, Robert C. McQueen, Nick Bush,
Stevens Institute of Technology@*

@i(Documentation:)@\Robert C. McQueen, Stuart Hecht,
Stevens Institute of Technology

@i(Version:)@\1.0

@i(Date: )@\May 1984
@end<Description>
@i<PRO/Kermit Capabilities At A Glance:>
@begin<format,leftmargin +2>
@tabclear()@tabset(3.5inches,4.0inches)
Local operation:@\Yes
Remote operation:@\Yes
Transfers text files:@\Yes
Transfers binary files:@\Yes (with limitations)
Wildcard send:@\Yes
@q<^X/^Y> interruption:@\Yes
Filename collision avoidance:@\Unneeded
Can time out:@\Yes 
8th-bit prefixing:@\Yes
Repeat count prefixing:@\Yes
Alternate block checks:@\Yes
Terminal emulation:@\Yes, uses Pro firmware (VT102)
Communication settings:@\Yes; local echo, parity, baud rate
Transmit BREAK:@\Yes
IBM communication:@\Yes
Transaction logging:@\No
Session logging (raw download):@\No
Raw upload:@\No
Act as server:@\Yes
Talk to server:@\Yes
Advanced commands for servers:@\Yes
Local file management:@\Yes; Full P/OS services
Handle file attributes:@\No
Command/init files:@\No
Printer control:@\No
@end<format>

@Chapter<Digital Professional-350 KERMIT>
@Index[PROFESSIONAL-350]
@Index[DEC Professional]
@Index[P/OS]
PRO/Kermit is a program that implements the KERMIT file transfer protocol for
the Digital Professional 350 under the P/OS operating system.  This
section will describe the things you
should know about the P/OS file system in order to make effective use of
KERMIT, and then it will describe PRO/Kermit.

@Section<The P/OS File System>

The features of the P/OS file system of greatest interest to KERMIT users are
the form of the file specifications.

@Subheading<P/OS File Specifications>

P/OS file specifications are of the form
@example(DEVICE:[DIRECTORY]FILENAME.TYPE;VERSION)
where DEVICE is name of the disk drive, DIRECTORY is up to 9 alphanumeric
characters enclosed in square brackets, FILENAME is up to 9 alphanumeric
characters,
TYPE is three alphanumeric characters and VERSION is a decimal number.
DEVICE, DIRECTORY and VERSION may be omitted.
The DEVICE and DIRECTORY names when omitted will default to the user's
current (default) disk and a directory.  Then VERSION when omitted will
default to the highest version of the file.  Thus
@q<FILENAME.TYPE> is normally sufficient to specify a file.

The DEVICE, DIRECTORY, FILENAME and TYPE fields may contain alphabetic or
numeric characters.  There are no embedded or trailing spaces in these
fields.  Other characters may not be included within the P/OS environment.
The fields of the file specification are set off from one another by the
punctuation indicated above.

The DEVICE name specifies the device upon which the file is resident.
The DEVICE name can be BIGDISK, BIGVOLUME, DISKETTE1, DISKETTE2, or
the volume name of a currently inserted diskette.  The directory name
identifies an area on the device.  PRO/Kermit may or may not send the
device, directory or generation to the remote Kermit.  The exact
functioning of PRO/Kermit depends on the setting of the File Naming
option in the File Parameters menu.  Normally PRO/Kermit will only send
the file name and type.

The file name is a unique identifier for the file.  The type, also called
the "extension", is an indicator which, by convention, tells what kind
of file we have.  For instance @Q<FOO.MAC> is the source of an assembler
program named FOO; @q<FOO.OBJ> might be the relocatable object module produced
by assembling @q<FOO.MAC>; @q<FOO.TSK> could be an executable program
produced by task building @q<FOO.OBJ>, and so on.

@index<Wildcard>
P/OS allows a group of files to be specified in a single file specification
by including the special "wildcard" characters,"@q<*>" and "@q<%>".
A "@q<*>"" matches any string of characters from the current position
to the end of the FILENAME or TYPE fields, including no characters at all.
The "@q<%>" will match a single character in either the
FILENAME or TYPE fields.
Here are some examples: @q<*.BAS>@\All files of type @q<BAS> (all PRO/BASIC
source files) in the current directory.

@q<FOO.*>@\Files of all types with name @q<FOO>.
	
@q<F*.*>@\All files whose names start with F.

@q<*F*.*>@\All files whose names contain an F.

@q<F%X*.*>@\All files whose names start with F and contain an X in 
the third position.

@q<%.*>@\All files whose names are exactly one character long.
@End(Description)
Wildcard notation is used on many computer systems in similar ways, and it is
the mechanism most commonly used to instruct KERMIT to send a group of files.

The PRO/Kermit user must bear in mind that other (non-@|P/OS) systems use
different wildcard characters; for instance MS-DOS KERMIT uses ? instead of
the %
as the single character wildcard.  When using PRO/Kermit to request a wildcard
file group from a KERMIT-86 server, the P/OS "%" must be replaced by MS DOS
"?" characters.

@Subheading<Text Files and Binary Files>

The file system used by P/OS provides for a large number of attributes to
be associated with each file.  These attributes provide some indication of
whether the file is a text file, or is some other type of non-text data.
The two major attributes that affect Pro/Kermit are the record type and
record attribute.  The record type describes how logical records are stored
in the file.  Records may be of some fixed length (specified by another
attribute), or variable length (specified within each record), or stream
(implying no real record divisions).  The record attributes describe
how the breaks between records are to be treated.  For example, a record
attribute of implied carriage return means that any program reading the
file with intentions of printing it out should add a carriage return/line
feed sequence between each record.  Other attributes include FORTRAN
carriage control and print file format.

The "standard" method of storing text in a file under P/OS is to store
one line of text per record (variable length records),
with a carriage return/line feed sequence
implied by the end of the record (implied carriage return).
This is the method Pro/Kermit uses to store files it receives when
using file type text.

There is no standard format for storing binary files.  Basically, any
record format with no record attributes are used for binary files.  Since
programs which work with binary files under P/OS expect to see some
particular format, more infomation is needed for transfer of binary files
than for transfer of text files.  The current version of Pro/Kermit
is not capable of transferring all types binary files which were created on
a P/OS system to another system and retrieving them intact, nor is
is capable of transferring all types binary files created on a P/OS system to
another P/OS, RSX-11M/M+, or VAX/VMS system intact.  However, certain
formats of binary files can be transferred, and binary files from some
other systems may be transferred to a Pro and recovered intact.

Binary files which are created on a Pro (or other Files-11 system)
with fixed 512 byte records (a fairly common format) can be transferred
using Pro/Kermit.  The only required action is to set the file type
to "fixed" in the receiving Pro/Kermit.  Binary files which have
variable length records can be transferred from one Pro to another
providing the maximum record length is less than 8192 bytes.
This requires that both the sending and receiving Pro/Kermit's
be set for file type block.

Using two programs supplied with Pro/Kermit, it is possible to
transfer almost any type of sequential file between Pro's, or
between a Pro and a VAX/VMS or RSX-11M/M+ system.  These two
programs (PROHEX and PRODEH) will convert the binary files to text
(using a variation on Intel hex format).  The resulting text file
can be transferred like any other, and finally "dehexified" reproducing
the original file, with the major attributes intact.  Unfortunately,
the text files text to be about twice the size of the original binary
files, so the transfers take a bit longer.  On the plus side, the
text versions of the files can be transferred to any system
with a Kermit and still retrieved intact.  They can also be transferred
over 7-bit data paths without any problems.
The bootstrap procedure (described below), makes use of hexified versions
of the binary files which make up Pro/Kermit.

@section<Program Operation>

PRO/Kermit is different from most of the Kermit implementations in that it is
menu driven.  P/OS has a menu based command interface with callable routines
to display menus.  PRO/Kermit utilizes these routines to provide an interface
that is compatible with P/OS.

PRO/Kermit is run from the menu that you install it in.  You select the Kermit
application and the press the DO or RETURN key.  After you have done that the
PRO/Kermit main menu, figure @ref(Mainmenu), will appear on the screen.
After the menu has been displayed you can select the command you wish to
execute by positioning the pointer before the command and pressing the RETURN
or DO key.

At any point you may press the HELP key to get help on the current menu that
you are in.  Additionally you can position the pointer to an item that can be
selected and press the HELP key to receive help on that item.

@Section(PRO/Kermit Terminal Emulation)

PRO/Kermit provides its own terminal emulation.  It does not rely on any other
software package to provide the terminal emulator.  When in terminal emulation
mode PRO/Kermit will respond to the Professional escape sequences.  Terminal
emulation mode is entered from the main menu connect command.  The following
functions keys are currently supported in terminal emulation mode.

@Begin(Description,leftmargin +8,indent -8)

BREAK@\Send a break to the remote computer system.

MAIN SCREEN@\Return to the PRO/Kermit main menu.

EXIT@\Return to the PRO/Kermit main menu.

HELP@\Print a short help message.

@End(Description)

Additionally you can set an escape character specifing the "@b<Escape>
Character" in the Terminal emulation menu, figure @ref(TERMMENU).  The default
for the escape character is ^\ (Control backslash).  The escape character
prefixes the following set of single character commands.  If you want to type
the escape character at the remote system, then you must type two escape
characters.

@Begin(Description,leftmargin +8,indent -8)

B@\Send a break

C@\Close the connection.

S@\Type a short status display.

?@\Display a short help message.

@End(Description)

@Section(PRO/Kermit Commands)

This section describes the PRO/Kermit commands, in detail where they differ
from the "ideal" KERMIT, briefly where they coincide.

@Subheading<Main menu>

@Begin(Description)
The main menu, as seen in figure @ref(Mainmenu), is the first menu that is
displayed.  The user can select a function from this menu or from the Remote
Kermit commands menus.  The remote Kermit command menus are accessed by
pressing the ADDTNL OPTIONS key.
@end(Description)

@Begin(Description,leftmargin +8,indent -8)

The commands that are available in the main menu are:

BYE@\Generic LOGOUT command and exit to P/OS

CONNECT@\Enter the terminal emulation mode.

GET@\Get a file from the remote server Kermit.

RECEIVE@\Receive a file from the remote system.

SEND@\Send a file or a group of files to the remote host.  The user will be
prompted with a menu of files that can be sent to the remote kermit.  The
user can press the ADDTNL OPTIONS key and change the directory, or tye in
a full wildcarded file specification.

ENTER@\Enter server mode.

Parameters@\Enters the Parameter Setting menu (figure @ref(SETMENU)).

STATUS@\Causes the various counters to be displayed.

P/OS@\Enters the P/OS Services menu (figure @ref(POSMENU)).

@End(Description)

@Begin(Description)
Three of the functions keys are also valid in the main menu.  These function
keys are:
@End(Description)

@Begin(Description,leftmargin +8,indent -8)

ADDTNL OPTIONS@\This key will cause the first of two remote kermit command
menus to be displayed.  The menu that this displays is show by figure
@ref(REMMENU1).

EXIT@\This key will cause PRO/Kermit to exit to P/OS.

MAIN SCREEN@\This key will also cause PRO/Kermit to exit to P/OS.

@End(Description)

@begin(Figure)
************************ PRO/Kermit          Version 1.0 *******************
*                                                                          *
*  Press MAIN SCREEN or EXIT to return to P/OS main menu                   *
*  Press HELP for help information                                         *
*  Press ADDTNL OPTIONS for Remote Kermit commands                         *
*                                                                          *
*            ->                                                            *
*                  @b<Bye> - Logout server Kermit and exit to P/OS             *
*                  @b<Connect> to host computer                                *
*                  @b<Get> a file from a server Kermit                         *
*                  @b<Receive> a file from host                                *
*                  @b<Send> a file to host                                     *
*                  @b<Enter> server mode                                       *
*                  Set @b<parameters>                                          *
*                  @b<Status>                                                  *
*                  @b<P/OS> Services                                           *
*                                                                          *
*                                                                          *
****************************************************************************
Make a choice and press DO:
@Caption(Main menu)
@Tag(MAINMENU)
@end(Figure)
@Subheading<Remote commands menus>

@Begin(Description,leftmargin +8,indent -8)
There are two menus that provide access to the remote Kermit commands.  The
first menu, @ref(REMMENU1), provides the following commands:

@b<Type> remote file@\Implementing the "REMOTE TYPE" command.  You
will be prompted to type in
the remote file specification to type.

@b<Directory> of remote files@\Implementing the "REMOTE DIRECTORY" command.
You will be prompted for the directory name.

@b<Disk> usage@\Implementing the "REMOTE DISK-USAGE" command.  You will be
prompted for the disk area.

@b<Delete> remote file@\Implementing the "REMOTE DELETE" command.  You will
be prompted for the remote file specification(s) to delete.

@b<Change> working directory@\Implementing the "REMOTE CWD" command.  You
will be prompted for the
working directory to change to and the password that may be required to access
that directory.

@b<Status> of Server Kermit@\This command implements the "REMOTE STATUS"
generic command.

@b<Help> on commands the Server Kermit supports@\This command implements the
"REMOTE HELP" generic command.

@b<Logout> Server Kermit@\This command implements the "REMOTE LOGOUT" generic
command.

@b<Finish> using Server Kermit@\This menu item implements the "REMOTE FINISH"
generic command.

Perform a command on Server's @b<Host>@\This command implements the "REMOTE
HOST" generic command.  The user will be prompted for the command string to
send to the host system.

@End(Description)

@begin(Figure)
***************************** Remote Kermit Commands ***********************
*                                                                          *
*  Press MAIN SCREEN to return to the main menu                            *
*  Press EXIT to return to the previous menu                               *
*  Press ADDTNL OPTIONS for additional Remote Kermit commands              *
*                                                                          *
*            ->                                                            *
*                  @b<Type> remote file                                        *
*                  @b<Directory> of remote files                               *
*                  @b<Disk> usage                                              *
*                  @b<Delete> remote file                                      *
*                  @b<Change> working directory                                *
*                  @b<Status> of Server Kermit                                 *
*                  @b<Help> on commands the Server Kermit supports             *
*                  @b<Logout> Server Kermit                                    *
*                  @b<Finish> using Server Kermit                              *
*                  Perform a command on Server's @b<Host>                      *
*                                                                          *
*                                                                          *
****************************************************************************
Make a choice and press DO:

@Caption(Remote Kermit Commands - Menu #1)
@Tag(REMMENU1)
@End(Figure)

The commands that can be found in the second remote commands menu are:

@Begin(Description,leftmargin +8,indent -8)

@b<Copy> remote files@\Implements the generic "REMOTE COPY" command.
Pro/Kermit will prompt for the two remote file specifications and then
will send the command to the remote server Kermit for execution.

@b<Rename> remote files@\Implements the generic "REMOTE RENAME" command.
Pro/Kermit will prompt for the two remote file specifications and then
will send the generic command to the remote server Kermit for execution.

@b<Who> is logged into the remote system@\Will ask for the information that
is to be passed to the remote server Kermit for this command.  The information
that you have to type in, if any, depends on the server Kermit implementation.

@end(Description)

@begin(Figure)
***************************** Remote Kermit Commands ***********************
*                                                                          *
*  Press MAIN SCREEN to return to the main menu                            *
*  Press EXIT to return to the previous menu                               *
*  Press ADDTNL OPTIONS to return to the main menu                         *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                ->                                                        *
*                      @b<Copy> remote files                                   *
*                      @b<Rename> remote files                                 *
*                      @b<Who> is logged into the remote system                *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
****************************************************************************
Make a choice and press DO:
@Caption(Remote Kermit commands - Menu #2)
@tag(REMMENU2)
@end(Figure)

@Subheading<Setting parameters>

The "Setting parameters" menu is entered into from the main menu.  This will
allow you to choose the type of parameters that you can set.  Entering this
menu is much the type the "SET" of a generic SET command.

@Begin(Description,leftmargin +8,indent -8)

@b<General> parameters@\This option will allow you to set general Pro/Kermit
parameters.  These parameters include the number of retries to attempt
when sending packets, eigtht bit quoting, the repeat character and the
state of the debugging flag.  The "General Parameters" menu, figure
@ref(GENMENU), will be displayed to allow you to set these parameters.

@b<Send> parameters@\Selection this option will cause the "Send Packet
Parameters"
menu to be displayed.  Selecting this option is equivalent to typing
the generic "SET SEND" command.  The "Send Packet Parameters" menu is show in
figure @ref(SENDMENU).

@b<Receive> parameters@\Selecting this option will cause the "Receive
Parameters" menu to be displayed.  The selection of the option is equivalent
to typing the "SET RECEIVE" generic command.  The "Receive Parameters" menu
is show in figure @ref(RECMENU).

@b<File> parameters@\This option will display the "File Parameters" menu.  This
allows the setting of the file disposition, file type and file specification
translation.  This menu is show in figure @ref(FILEMENU).

@b<Line> characteristics@\This option allows changing of some of the
communications port (XK0) parameters.  These parameters include the transmit
and receive speeds, parity and flow control.  The "Line Parameters" menu is
displayed when this option is selected.  This menu is show in figure
@ref(LINEMENU).

@b<Terminal> emulation@\The "Terminal Emulation Parameters" menu will be
displayed when this option is selected.  This will allow you to change
various terminal emulation parameters like the escape character, local
echo and others.  The menu is show in figure @ref(TERMMENU).

@End(Description)

@begin(Figure)
******************************* Parameter Setting **************************
*                                                                          *
*  Press EXIT to return to the previous menu                               *
*  Press MAIN SCREEN to return to the main menu                            *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                        ->                                                *
*                              @b<General> parameters                          *
*                              @b<Send> parameters                             *
*                              @b<Receive> parameters                          *
*                              @b<File> parameters                             *
*                              @b<Line> characteristics                        *
*                              @b<Terminal> emulation                          *
*                                                                          *
*                                                                          *
*                                                                          *
****************************************************************************
Make a choice and press DO:

@Caption(Parameter setting menu)
@tag(Setmenu)
@end(Figure)

@Subheading<General Parameters>

The following describes the general parameters that can be set.  These
parameters are set from the "General Parameters" menu, figure @ref(GENMENU).

@Begin(Description,leftmargin +8,indent -8)

@b<Block check> type@\

@b<Repeat> quoting character@\

@b<Eighth> bit quoting character@\

Retries for @b<initial> packet@\

Retries for @b<subsequent> packets@\

@b<Debugging>@\

@End(Description)

@begin(Figure)
******************************* General Parameters *************************
*                                                                          *
*  Press EXIT to return to the previous menu.                              *
*  Press MAIN SCREEN to return to the PRO/Kermit main menu                 *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*      ->                                                                  *
*            @b<Block check> type                1 character(s)                *
*            @b<Repeat> quoting character        ~ (176)                       *
*            @b<Eighth> bit quoting character    & (46)                        *
*            Retries for @b<initial> packet      5.                            *
*            Retries for @b<subsequent> packets  16.                           *
*            @b<Debugging>                       (ON/@b<OFF>)                      *
*                                                                          *
*                                                                          *
*                                                                          *
****************************************************************************
Make a choice and press DO:
@Caption(General parmaters menu)
@Tag(GENMENU)
@end(Figure)

@Subheading<Send Packet Parameters>

@Begin(Description,leftmargin +8,indent -8)

@b<End-of-Line>@\

@b<Packet-Length>@\

@b<Padding>@\

@b<Pad character>@\

@b<Timeout>@\

@b<Start of packet>@\

@b<Quote>@\

@End(Description)

@begin(Figure)
***************************** Send Packet Parameters ***********************
*                                                                          *
*  Press EXIT to return to the previous menu                               *
*  Press MAIN SCREEN to return to the PRO/Kermit main menu                 *
*                                                                          *
*                                                                          *
*                                                                          *
*                     ->                                                   *
*                           @b<End-of-Line>      ^M (15)                       *
*                           @b<Packet-Length>    80.                           *
*                           @b<Padding>          0.                            *
*                           @b<Pad character>    ^@ (0)                        *
*                           @b<Timeout>          15. Sec.                      *
*                           @b<Start of packet>  ^A (1)                        *
*                           @b<Quote>            # (43)                        *
*                                                                          *
*                                                                          *
*                                                                          *
****************************************************************************
Make selection and press DO:
@Caption(Send packet parameters menu)
@Tag(SENDMENU)
@end(Figure)

@Subheading<Receive Packet Parameters>

@Begin(Description,leftmargin +8,indent -8)

@b<End-of-Line>@\

@b<Packet-Length>@\

@b<Padding>@\

@b<Pad character>@\

@b<Timeout>@\

@b<Start of packet>@\

@b<Quote>@\

@End(Description)

@begin(Figure)
*************************** Receive Packet Parameters **********************
*                                                                          *
*  Press EXIT to return to the previous menu.                              *
*  Press MAIN SCREEN to return to PRO/Kermit's main menu.                  *
*                                                                          *
*                                                                          *
*                                                                          *
*                     ->                                                   *
*                           @b<End-of-Line>      ^M (15)                       *
*                           @b<Packet-Length>    80.                           *
*                           @b<Padding>          0.                            *
*                           @b<Pad character>    ^@ (0)                        *
*                           @b<Timeout>          15. Sec.                      *
*                           @b<Start of packet>  ^A (1)                        *
*                           @b<Quote>            # (43)                        *
*                                                                          *
*                                                                          *
*                                                                          *
****************************************************************************
Make a choice and press DO:
@Caption(Receive Packet Parameters menu)
@Tag(RECMENU)
@end(Figure)

@Subheading<File Parameters>

@Begin(Description,leftmargin +8,indent -8)

File @b<type>@\The default value is ASCII.

File @b<specification>@\The default value is NORMAL.

@b<Disposition> for incomplete received files@\The default value is DELETE.

@End(Description)

@begin(Figure)
******************************** File Parameters ***************************
*                                                                          *
*  Press EXIT to return to the previous menu.                              *
*  Press MAIN SCREEN to return to the PRO/Kermit main menu                 *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*      ->                                                                  *
*            File @b<type>                                  Ascii              *
*            File @b<specification>                         Normal             *
*            @b<Disposition> for incomplete received files  Delete             *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
****************************************************************************
Make a choice and press DO:
@Caption(File parameters menu)
@Tag(FILEMENU)
@end(Figure)

@Subheading<File mode>

@Begin(Description,leftmargin +8,indent -8)

@b<Ascii>@\

@b<Binary>@\

@b<Block>@\

@b<Fixed>@\

@End(Description)

@begin(Figure)
********************************* Set File mode ****************************
*                                                                          *
*  PRESS EXIT to return to previous menu                                   *
*  PRESS MAIN SCREEN to return to Kermit main menu                         *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                               ->                                         *
*                                     @b<Ascii>                                *
*                                     @b<Binary>                               *
*                                     @b<Block>                                *
*                                     @b<Fixed>                                *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
****************************************************************************
Make choice and press DO:
@Caption(File mode menu)
@Tag(FMODMENU)
@end(Figure)

@Subheading<File Specification Handling>

@Begin(Description,leftmargin +8,indent -8)

@b<Full> file specifications@\

@b<Normal> form file specifications@\

@b<Untranslated> file specifications@\

@End(Description)

@begin(Figure)
************************** File Specification Handling *********************
*                                                                          *
*  Press EXIT to return to the previous menu                               *
*  Press MAIN SCREEN to return to the main menu                            *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                  ->                                                      *
*                        @b<Full> file specifications                          *
*                        @b<Normal> form file specifications                   *
*                        @b<Untranslated> file specifications                  *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
****************************************************************************
Make a choice and press DO:
@Caption(File specification menu)
@Tag(FSPECMENU)
@end(Figure)

@Subheading<File Disposition>

@Begin(Description,leftmargin +8,indent -8)

@b<Keep> incompletely transfered files@\

@b<Delete> incompletely transfered files@\

@End(Description)

@begin(Figure)
******************************** File Disposition **************************
*                                                                          *
*  Press EXIT to return to the previous menu                               *
*  Press MAIN SCREEN to return to the PRO/Kermit main menu                 *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                ->                                                        *
*                      @b<Keep> incompletely transfered files                  *
*                      @b<Delete> incompletely transfered files                *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
****************************************************************************
Make a choice and press DO:
@Caption(File disposition menu)
@Tag(FDISPMENU)
@end(Figure)

@Subheading<Terminal Emulation Parameters>

@Begin(Description,leftmargin +8,indent -8)

@b<Local> echo@\The default is off.

@b<Turn around>@\The default character is Control-Q (Octal 21).

@b<Escape> Character@\The default character is Control-\ (Octal 34).

@b<IBM - Flag>@\The default is off.

Transparent @b<function> keys@\The default is off.

@b<7-Bit> character codes@\The default is on.

@End(Description)

@begin(Figure)
************************* Terminal Emulation Parameters ********************
*                                                                          *
*  Press EXIT to return to the previous menu                               *
*  Press MAIN SCREEN to the PRO/Kermit main menu                           *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*        ->                                                                *
*              @b<Local> echo                 (On/@b<Off>)                         *
*              @b<Turn around>                ^Q (21)                          *
*              @b<Escape> Character           ^\ (34)                          *
*              @b<IBM - Flag>                 (On/@b<Off>)                         *
*              Transparent @b<function> keys  (On/@b<Off>)                         *
*              @b<7-Bit> character codes      (@b<On>/Off)                         *
*                                                                          *
*                                                                          *
*                                                                          *
****************************************************************************
Make a selection and press DO:
@Caption(Terminal emulation menu)
@Tag(TERMMENU)
@end(Figure)

@subsection(Parity menu)

@index(SET PARITY)
Making a selection from the Parity menu, figure @ref(PARMENU),
is equivalent to issuing the "SET PARITY"
command to a generic Kermit.  If you were to select the @b<Space> option in
this menu it would be equivalent to issuing the generic command "SET PARITY
SPACE", or selecting @b<None> would be equivalent to "SET PARITY NONE".

@Begin(Description,leftmargin +8,indent -8)

@b<Even>@\

@b<None>@\This is the default.

@b<Mark>@\

@b<Odd>@\

@b<Space>@\

@End(Description)

@begin(Figure)
*********************************** Set Parity *****************************
*                                                                          *
*  Press EXIT to return to previous menu                                   *
*  Press MAIN SCREEN to return to Kermit main menu                         *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                               ->                                         *
*                                     @b<Even>                                 *
*                                     @b<None>                                 *
*                                     @b<Mark>                                 *
*                                     @b<Odd>                                  *
*                                     @b<Space>                                *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
****************************************************************************
Make a selection and press DO:
@Caption(Parity menu)
@Tag(PARMENU)
@end(Figure)

@Subheading<Set Line Characteristics>

@Begin(Description,leftmargin +8,indent -8)

@b<Receive> speed (baud)@\The default is 1200.

@b<Transmit> speed (baud)@\The default is 1200.

@b<Parity>@\The default is None.

@b<XON/XOFF> flow control@\The default is @b<ENABLED>.

@b<Modem> type@\The default is "No modem, hard-wired line".  This parameter
should @b<not> be changed even if you are using a modem.

@end(Description)

@begin(Figure)
**************************** Set Line Characteristics **********************
*                                                                          *
*  Press MAIN SCREEN to return to Kermit Main Menu                         *
*  Press EXIT to return to previous menu                                   *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*   ->                                                                     *
*         @b<Receive> speed (baud)      9600.                                  *
*         @b<Transmit> speed (baud)     9600.                                  *
*         @b<Parity>                    None                                   *
*         @b<XON/XOFF> flow control     (@b<ENABLED>,DISABLED)                     *
*         @b<Modem> type                No modem, hard-wired line              *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
****************************************************************************
Make a choice and press DO:
@Caption(Line parameters menu)
@Tag(LINEMENU)
@end(Figure)

@subheading<Setting - Line Characteristics>

@Begin(Description,leftmargin +8,indent -8)

Set @b<default> line characteristics@\

Set @b<current> line characteristics@\

@b<Reset> current line characteristics to defaults@\

@end(Description)

@begin(Figure)
****************************** Line Characteristics ************************
*                                                                          *
*  Press EXIT to return to the previous menu                               *
*  Press MAIN SCREEN to return to the Kermit Main Menu                     *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*           ->                                                             *
*                 Set @b<default> line characteristics                         *
*                 Set @b<current> line characteristics                         *
*                 @b<Reset> current line characteristics to defaults           *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
****************************************************************************
Make a choice and press DO:
@Caption(Line characteristics menu)
@Tag(LCHARMENU)
@end(Figure)

@subheading<Setting - Modem type>

@begin(Figure)
********************************* Set modem type ***************************
*                                                                          *
*  Press EXIT to return to the previous menu.                              *
*  Press MAIN SCREEN to return to the PRO/Kermit main menu.                *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                ->                                                        *
*                      @b<No modem>, hard-wired line                           *
*                      USFSK- 0..300 baud Bell @b<103J>                        *
*                      @b<CCITTV.21> - 0..300 baud European                    *
*                      CCITTV.23 @b<Mode 1> - 75/0..300 split                  *
*                      CCITTV.23 @b<Mode 2> - 75/0..1200 split                 *
*                      DPSK - 1200 baud Bell @b<212>                           *
*                                                                          *
*                                                                          *
*                                                                          *
****************************************************************************
Make a choice and press DO:
@Caption(Modem type menu)
@Tag(MODEMMENU)
@end(Figure)

@subheading<Setting - Block Check Characters>

The Block Check Characters menu, figure @ref(CHKMENU), will allow you to set
the check characters that are used in the messages that are sent and received.
This menu implements the generic command "SET BLOCK-CHECK".

@begin(Figure)
***************************** Block Check Characters ***********************
*                                                                          *
*  Press EXIT to return to the previous menu                               *
*  Press MAIN SCREEN to return to the PRO/Kermit main menu                 *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                       ->                                                 *
*                             @b<1> character checksum                         *
*                             @b<2> character checksum                         *
*                             @b<3> character CRC-CCITT                        *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
****************************************************************************
Make a choice and press DO:
@Caption(Packet checksum menu)
@Tag(CHKMENU)
@end(Figure)

@subheading<P/OS Services>

Pro/Kermit will allow you to enter into any of the normal P/OS services that
can be found in the P/OS Main Menu.  The P/OS Services menu, figure
@ref(POSMENU), lists the different services that are available.  The P/OS
Services menu will be displayed when you choose the "@b<P/OS> services"
from the Kermit Main menu, figure @ref(MAINMENU).

The P/OS services that are available are:

@begin(Description,leftmargin +8,indent -8)

@b<Disk>/diskette services@\This will enter the normal disk/diskette services.
You can initialize diskettes, install applications, copy diskettes and the
other various functions normally found in this menu.

@b<File> services@\Provides access to the normal file services on the
Professional-350.  This will allow you to delete, rename, copy files, purge
old versions of a file and the other functions associated with the file
services.

@b<Print> services@\Provides access to the P/OS print services.  This will
allow you to print files after you have transfered them.

@b<View> messages/status@\Will provide access to the message board and the
disk drive status information.

P/OS @b<setup>@\Displays the setup menu that you normally get when you have
pressed the SET-UP key when in the P/OS Main Menu.  This will allow you to
change the date/time of the machine, key click and other features.

@end(discription)

@begin(Figure)
********************************* P/OS Services ****************************
*                                                                          *
*                                                                          *
*  Press EXIT or MAIN SCREEN to return to the PRO/Kermit main menu.        *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                       ->                                                 *
*                             @b<Disk>/diskette services                       *
*                             @b<File> services                                *
*                             @b<Print> services                               *
*                             @b<View> Message/Status                          *
*                             P/OS @b<Set-Up>                                  *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
****************************************************************************
Make a choice and press DO:

@Caption(P/OS Services menu)
@tag(POSMENU)
@end(Figure)

@subheading<Transfer task active menu>

When Pro/Kermit is asked to perform a function that requires the communications
port (XK0:), it will first determine if it is currently inuse.  (It could be
left inuse by pressing the MAIN SCREEN key when a transfer is active.)  If the
port is active the menu show in figure @ref(ACTMENU) will be displayed.

When this menu is displayed you have three choices:

@begin(enumerate)
You can press either the MAIN SCREEN or EXIT key to return to P/OS.

You can choose the @b<Abort> option, which will cause the currently active
transfer to be aborted.

You can choose the @b<Resume> option, which will resume typing the transfer
information for the active transfer.  Once the currently active transfer
completes the operation that you requested before the menu was displayed
will be started.
@end(enumerate)

@begin(Figure)
*********************** PRO/Kermit transfer task is active *****************
*                                                                          *
*                                                                          *
*  Press MAIN SCREEN or EXIT to return to P/OS                             *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                   ->                                                     *
*                         @b<Abort> file transfer task                         *
*                         @b<Resume> transfer status typeout                   *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
*                                                                          *
****************************************************************************
Make a choice and press DO:
@Caption(Active transfer menu)
@Tag(ACTVMENU)
@end(Figure)

@section<Installation>

There are two different ways to install PRO/Kermit.  The first and the
easiest, is to obtain a version on a floppy that can be directly installed
on your machine.  The more difficult way is to downline load PRO/Kermit from
a host system.

@Subheading<From a floppy>

If you have obtained a floppy with PRO/Kermit you can install it using
the Disk/Diskette services from the P/OS main menu.  The following steps will
allow you to install PRO/Kermit on your machine.

@begin(enumerate)
You begin the installation by inserting the PRO/Kermit floppy into either
of the floppy drives on the PRO-350.

After the floppy has been inserted into the drive select "@b<Disk>/diskette
services" from the P/OS main menu.

The "Disk/Diskette Services Menu" should now be displayed on the screen.
Select the "@b<Install> application" entry from the menu.  You will be notified
that P/OS is locating the application.

If you have a good floppy P/OS will list the applications that can be installed
on your machine the "Application Installation Menu" should be displayed.
The application from the floppy should be "PRO/Kermit
version 1.0".  You should select this application from the menu.

The "Application Group Menu" will now be displayed on the screen.  You should
position the arrow to the group that you would like PRO/Kermit installed in and
press the DO key.

The "Application Group/Name Change Form" will now be displayed on the screen.
This form will allow you to change the name of the group or the name of the
application that you are installing.  If you do not want to change the name you
can just press DO and the PRO/Kermit installation will start.  Otherwise you
can modify the names as you wish and the press DO to start the PRO/Kermit
installation.

If you have enough disk space on your machine PRO/Kermit should install
with no problems.  Once it is installed you can run it from the menu that
you have installed it in.
@end(enumerate)

@Subheading<From a hexified version>

The following will take about two hours at 1200 baud.  Much of the time
will be spent waiting for the computer so this will be a good time to read
the PRO/Kermit documentation or a good novel.  You will be needed at
various times throughout the process so don't stray too far from the
computer. 

Note that this procedure assumes that you do not have any communications
program available on your Pro, and therefore do not have any other
method of getting the files to your Pro.  It is also assumed that you
do not have any way to change the default parameters for the communications
port.  This requires that the bootstrap be done at 1200 baud, eight-bit
characters, one stop bit and no parity.

The procedure to bootstrap PRO/Kermit to the Professional is as follows: 
@begin(enumerate)
First make sure that the 'Caps Lock' light is on on the Professional's
keyboard.  This will prevent any problems with case sensitive input. 

On the Professional choose the "@b<Disk>/diskette services" option from the
Professional's Main Menu.  Insert a blank diskette in drive one and choose
"@b<Initialize> diskette".  Select "@b<DISKETTE1>" from the menu and then
enter 'KERMIT' for the volume name.  Now choose "@b<Create> directory" and
create two directories.  One called 'KERMIT' and one called 'ZZKERMIT' on
the floppy (This is done by pressing the ADDITIONAL OPTIONS key and
choosing "@b<Create> a directory on a different volume" and then selecting
the KERMIT volume). When this is done choose "@b<Specify> new current
directory" and select KERMIT on the KERMIT volume (the floppy). 

Next press MAIN SCREEN to return to the Main Menu and choose "@b<PRO/BASIC
Version 1.2>".  In Basic type in the Basic loader program (leave out the
REMs so that the program will execute faster).  Once this is done type
'SAVE LOAD'. 

Call and login to the mainframe on which PRO/Kermit resides. If you have
PRO/BASIC V1.2 or later and have a 1200 baud line (the default baud rate
when PRO/BASIC starts then you can type in the terminal emulator program
given at the end of this document (don't forget to type 'NEW' and also save
it using the command 'SAVE PROTERM').  If you do not have version 1.2 or
later of PRO/BASIC, you will not be able to use the basic terminal emulator.
You will also need to bootstrap Pro/Kermit over the line printer port
rather than the communcations port.  This is because earlier versions
of PRO/BASIC were not capable of performing I/O to the communcations
port.

Tell the host not to echo characters. If the loader program will be using
the printer port then set the line speed on the host to not more then 1200
baud (reset your terminal if necessary).  The commands to do this for a
DEC10 are: 
@example(SET TTY NOECHO)
@example(SET TTY SPEED 1200)
Next compile and execute PROBOOT.FOR on the host.
When this executes it will ask you
for a file name.  Respond with the name 'PROLOAD.HEX'.  This will be used
along with LOAD.BAS on the Professional to create the LOAD.TSK program.
Once PROBOOT is executing on the mainframe, give control back to the
Professional (if you are using a terminal emulator on the Pro) or
connect the modem or hard-wired line to the printer
port or communications port depending on which you have decided to use.

If you have chosen to use the printer port there are a few things you
will need to do.  You will need a special cable to connect the printer
port on the Professional to a modem or hard-wired line.  The normal
printer cable provides a female RS-232 25 pin D connector which
is a DCE (data communications equipment) interface.  This is intended
to connect to a DTE (data terminal equipment) interface, which is
what is provided on a printer.  Since the communications port (and
most terminals) also provide DTE interfaces, while modems provide
DCE interfaces, a null modem must be provided between the printer
cable and the modem or hard-wired line.  It is also possible
to construct a cable which plugs directly into the printer port
connector on the back of the Professional which can connect to
a modem or hard-wired line.  See the technical manual on the
Professional for the pin configuration of the printer port connector.

The Professional must be told
the speed that the printer port should operate at.  If you have the
PRO/Tool kit you can enter it and type: 
@example(SET TERM TT2:/SPEED=1200/NOECHO)
If you do not have the PRO/Tool kit but you have version 2.0 of P/OS or
later you can go into print services and choose '@b<Set> printer
characteristics' and set the printer type to 'Other' and press Additional
options and set the baud rate to the correct value (if you use print
services to set the baud rate make sure that you print a file that contains
at least a carriage return (but not much more) or else the baud rate will
not actually be set.  It is only set when a file is printed). 
If you do not have either the tool kit of P/OS 2.0, you will have to
run the bootstrap process at 4800 baud.  This is not very reliable,
since the PRO/BASIC program cannot always keep up with the data.

Next enter PRO/BASIC and type 'RUN LOAD' on the Professional. This will
create a file called LOAD.TSK that will do all the rest of the work. It
will first type out around seven lines of the alphabet from A to Y.  This
tells you that the program is really doing something.  When the BASIC program
finishes press the EXIT key to return to the Main Menu. 

Connect to the Main Frame host and press a few returns.  This will get you
out of the fortran program (if pressing return does not work try pressing
control-C a few times).  Now execute PROBOOT.FOR again.  This time when it
asks you for a file name respond with the name 'PROKRM.HEX'. This will be
used along with LOAD.TSK on the Professional to load the rest of the files
that are needed to run PRO/Kermit 

Next enter either PRO/DCL or the PRO/Tool kit and type:
@example(Copy/CONTiguous LOAD.TSK LOAD.TSK)
This will create an executable task image.  At this point you may either
leave the modem connected to the printer port (if it was hooked up to it
before) or connect the modem to the communications port (the communications
port works slightly better and can operate at any speed your line can
handle), it does not matter.  If you use the communications port the
program will ask you if the port is set correctly.  If it is set correctly
then press 'Y' and the return key, if not press 'N' and the return key and
then choose the baud rate that your host is using. 

Now type 'Run LOAD.TSK' from PRO/DCL or the PRO/Tool kit.  It will ask you
if you are using the communications port or the printer port (or a disk
file which you are not). If you have the modem hooked up to the printer
port press a '2' and press the return key otherwise you have the modem
hooked up to the communications port and should press '1' and the return
key. 

At this point the computer starts to do a lot of work.  It will create
every file you need.  You will see many 'Y' on the screen.  Each 'Y' means
that a line was read in.  Each 'N' means that a line was rejected and must
be resent.  This happens more often on a noisy line.  A 'U' means that
LOAD.TSK does not recognize a command sent to it from the host.  This
should never happen but probably will not cause a problem if it does occur.
You will also see about nine file names come up on the screen.  These are
the files that are being created. 

When LOAD.TSK finishes you will have a copy of PRO/Kermit on your floppy
diskette.  Now press the MAIN SCREEN key to return to the Main Menu. From
here follow the instructions to install PRO/Kermit from a floppy. 

Do not forget that you are still logged in on the host and must log out. 
This can be done through the connect command in PRO/Kermit or the same way
that you used to log in. 
@end(enumerate)

The basic program for the PRO-350 using the printer port is as follows:
(The program should be typed in with all capital letters!)

@begin(example)
10 REM LOADER program for PRO/Kermit for printer port
20 HEX$="123456789ABCDEF"
30 OAD=0\FLAG%=0\TOT%=0
40 TOT1%=0\CTR%=0\NM%=-1
100 OPEN "LP:" FOR INPUT AS FILE #2%
110 OPEN "LP:" FOR OUTPUT AS FILE #3%
170 GOTO 200
180 INPUT #2%,A$\ GOTO 210
190 PRINT "N";\ PRINT #3,"N"\ INPUT #2%,A$\ GOTO 210
200 PRINT #3,"Y"\ INPUT #2%,A$
210 IF A$="" THEN FLAG%=FLAG%+1%\ IF FLAG%>4% THEN 1100 ELSE 180
220 FLAG%=0
230 IF MID$(A$,1%,1%)<>":" THEN A$=MID$(A$,2%,LEN(A$))\ GOTO 210
240 H$=MID$(A$,2%,2%)\ GOSUB 1200\LN%=H\ REM LENGTH (NUMBER OF WORDS OF DATA)
250 REM FIND CHECKSUM OF ALL 8-BIT PAIRS
260 CHKSUM%=LN%
270 FOR L1%=4% TO (LN%+5%)*2% STEP 2%\H$=MID$(A$,L1%,2%)\ GOSUB 1200
280 CHKSUM%=CHKSUM%+H
290 NEXT L1%
300 CHKSUM%=CHKSUM%-256%*INT(CHKSUM%/256)
310 IF CHKSUM%<>0% THEN 190
320 IF MID$(A$,2%,6%)="000000" THEN 1100
330 H$=MID$(A$,8%,2%)\ IF H$<>"FC" THEN 380
340 H$=MID$(A$,10%,4%)\ GOSUB 1200\TOT1%=H*256%
350 DIM #1%,ARR%(TOT1%)
360 OPEN "LOAD.TSK" FOR OUTPUT AS FILE #1%, VIRTUAL 
370 GOTO 490
380 GOSUB 1200\ IF H<>0 THEN 200\ REM CHECK FIELD TYPE
390 IF TOT1%=0 THEN PRINT "No length field, can not create file"\ GOTO 1300
400 H$=MID$(A$,4%,4%)\ GOSUB 1200\OAD1=H\ REM ADDRESS TO LOAD AT
410 REM UNPACK ANY COMPRESSED NULLS
420 L%=0%\ FOR LP=OAD TO OAD1-1\ GOSUB 1000\ NEXT LP
430 OAD=OAD1
440 REM GET DATA AS 8-BIT VALUES AND WRITE TO DISK (REPEAT LN% TIMES)
450 FOR L1%=10% TO LN%*2%+9% STEP 2%
460 H$=MID$(A$,L1%,2%)\ GOSUB 1200\L%=H\ GOSUB 1000
470 OAD=OAD+1
480 NEXT L1%
490 PRINT CHR$(CTR%+65%);\CTR%=CTR%+1%\ IF CTR%>24% THEN CTR%=0%\ PRINT 
500 GOTO 200
510 STOP 
990 REM WRITE - PUT THE DATA INTO THE TASK FILE
1000 IF NM%=-1 THEN NM%=L%\ RETURN 
1010 N=NM%+L%*256
1020 IF N>32767 THEN N=N-65536
1030 NB%=N
1040 ARR%(TOT%)=NB%
1050 NM%=-1\TOT%=TOT%+1%
1060 RETURN 
1090 REM FINISHED - CLOSE FILE
1100 PRINT \ PRINT \ PRINT "TASK FILE WRITTEN."
1110 CLOSE 
1120 GOTO 1300
1190 REM HEX-DEC
1200 H=0
1210 FOR LP%=1% TO LEN(H$)
1220 H=H*16+POS(HEX$,MID$(H$,LP%,1%),1%)
1230 NEXT LP%
1240 RETURN 
1300 END 
@end(example)

The BASIC program for loading Pro/Kermit
using the communications port if you have PRO/BASIC V1.2 or later:

@begin(example)
10 REM LOADER program for PRO/Kermit using the communications port
20 HEX$="123456789ABCDEF"
30 OAD=0\FLAG%=0\TOT%=0
40 TOT1%=0\CTR%=0\NM%=-1
100 OPEN "XK:" AS FILE #2%
110 REM 
170 GOTO 200
180 REM 
190 PRINT "N";\ PRINT #2,"N"+CHR$(13)+CHR$(10)\ GOTO 210
200 PRINT #2,"Y"+CHR$(13)+CHR$(10)
205 IF POS(Z$,CHR$(13),0)<>0 THEN 208
206 LINPUT #2%,X$\Z$=MID$(Z$+X$,POS(Z$+X$,":",0),LEN(Z$+X$))\ GOTO 205
208 A$=MID$(Z$,1,POS(Z$,CHR$(13),0))\Z$=MID$(Z$,LEN(A$)+1,LEN(Z$))
209 IF POS(A$,":",0)=0 THEN 205
210 IF A$="" THEN FLAG%=FLAG%+1%\ IF FLAG%>4% THEN 1100 ELSE 205
220 FLAG%=0
230 IF MID$(A$,1%,1%)<>":" THEN A$=MID$(A$,2%,LEN(A$))\ GOTO 210
240 H$=MID$(A$,2%,2%)\ GOSUB 1200\LN%=H\ REM LENGTH (NUMBER OF WORDS OF DATA)
250 REM FIND CHECKSUM OF ALL 8-BIT PAIRS
260 CHKSUM%=LN%
270 FOR L1%=4% TO (LN%+5%)*2% STEP 2%\H$=MID$(A$,L1%,2%)\ GOSUB 1200
280 CHKSUM%=CHKSUM%+H
290 NEXT L1%
300 CHKSUM%=CHKSUM%-256%*INT(CHKSUM%/256)
310 IF CHKSUM%<>0% THEN 190
320 IF MID$(A$,2%,6%)="000000" THEN 1100
330 H$=MID$(A$,8%,2%)\ IF H$<>"FC" THEN 380
340 H$=MID$(A$,10%,4%)\ GOSUB 1200\TOT1%=H*256%
350 DIM #1%,ARR%(TOT1%)
360 OPEN "LOAD.TSK" FOR OUTPUT AS FILE #1%, VIRTUAL 
370 GOTO 490
380 GOSUB 1200\ IF H<>0 THEN 200\ REM CHECK FIELD TYPE
390 IF TOT1%=0 THEN PRINT "No length field, can not create file"\ GOTO 1300
400 H$=MID$(A$,4%,4%)\ GOSUB 1200\OAD1=H\ REM ADDRESS TO LOAD AT
410 REM UNPACK ANY COMPRESSED NULLS
420 L%=0%\ FOR LP=OAD TO OAD1-1\ GOSUB 1000\ NEXT LP
430 OAD=OAD1
440 REM GET DATA AS 8-BIT VALUES AND WRITE TO DISK (REPEAT LN% TIMES)
450 FOR L1%=10% TO LN%*2%+9% STEP 2%
460 H$=MID$(A$,L1%,2%)\ GOSUB 1200\L%=H\ GOSUB 1000
470 OAD=OAD+1
480 NEXT L1%
490 PRINT CHR$(CTR%+65%);\CTR%=CTR%+1%\ IF CTR%>24% THEN CTR%=0%\ PRINT 
500 GOTO 200
510 STOP 
990 REM WRITE - PUT THE DATA INTO THE TASK FILE
1000 IF NM%=-1 THEN NM%=L%\ RETURN 
1010 N=NM%+L%*256
1020 IF N>32767 THEN N=N-65536
1030 NB%=N
1040 ARR%(TOT%)=NB%
1050 NM%=-1\TOT%=TOT%+1%
1060 RETURN 
1090 REM FINISHED - CLOSE FILE
1100 PRINT \ PRINT \ PRINT "TASK FILE WRITTEN."
1110 CLOSE 
1120 GOTO 1300
1190 REM HEX-DEC
1200 H=0
1210 FOR LP%=1% TO LEN(H$)
1220 H=H*16+POS(HEX$,MID$(H$,LP%,1%),1%)
1230 NEXT LP%
1240 RETURN 
1300 END 
@end(example)

The terminal emulator program that can be used if you have PRO/BASIC V1.2 
or later is:

@begin(example)
10 REM TERMINAL EMULATOR FOR PRO/BASIC V1.2 OR LATER USING COMMUNICATIONS PORT
20 REM 
30 ESC$=CHR$(27)\CLEAR$=ESC$+"[H"+ESC$+"[J"
40 BIGT$=ESC$+"#3"\BIGB$=ESC$+"#4"
50 SAVE$=ESC$+"7"\UP$=ESC$+"[3A"\REST$=ESC$+"8"
60 INT$=CHR$(171)
70 REM For better performance you can change the values of SPC, MAXLIN & BREAK$
80 SPC=12
90 BREAK$=CHR$(13)+ESC$+" "+CHR$(9)\BRLEN%=LEN(BREAK$)
100 MAXLIN=65
110 CTR=0
120 PRINT CLEAR$
130 PRINT BIGT$;" type ";INT$;" to send a control-C "
140 PRINT BIGB$;" type ";INT$;" to send a control-C "
150 OPEN 'XK:' AS FILE #1
160 LINPUT #1,A$
170 IF LEN(A$)=0 THEN 300
180 A=999
190 FOR LP%=1 TO BRLEN%
200 B=POS(A$,MID$(BREAK$,LP%,1%),SPC)
210 IF B<>0 AND B<A THEN A=B
220 NEXT LP%
230 IF CTR+LEN(MID$(A$,1,A))>MAXLIN THEN A=1\ GOTO 260
240 IF A=999 THEN PRINT A$;\CTR=CTR+LEN(A$)\ GOTO 300
250 PRINT MID$(A$,1,A-1);
260 PRINT SAVE$;UP$\ PRINT REST$;
270 PRINT MID$(A$,A,1);\A$=MID$(A$,A+1,LEN(A$))
280 CTR=0
290 GOTO 170
300 CALL INKEY (A$)
310 IF LEN(A$)=0 THEN 160
320 IF A$=INT$ THEN A$=CHR$(3)
330 IF ASCII(A$)=155 THEN A$=CHR$(27)
340 IF ASCII(A$)=143 THEN A$=CHR$(27)+'['
350 PRINT #1,A$
360 GOTO 300
370 END
@end(example)
