*COMDECK  CDKCBTZ  CONVERT BLANKS TO ZEROES IN A WORD.
 BTZ      CTEXT  CDKCBTZ - CONVERT BLANKS TO ZEROES IN A WORD.
 BTZ      SPACE  4,10 
          IF     -DEF,QUAL$,1 
          QUAL   CDKCBTZ
          BASE   D
 BTZ      SPACE  4,10 
***       BTZ - CONVERT BLANKS TO ZEROES IN A WORD. 
* 
*         G. M. TOWNSEND.    83/08/22.  CODE BASED ON *COMCZTB*.
* 
*         BTZ CONVERTS ALL BLANKS IN A WORD TO 00 CHARACTERS. 
 BTZ      SPACE  4,10 
***       BTZ CONVERTS ALL BLANKS IN A WORD TO 00 CHARACTERS. 
* 
*         ENTRY  (X1) = WORD TO BE CONVERTED. 
*                (B1) = 1.
* 
*         EXIT   (X6) = CONVERTED WORD. 
*                (X7) = FINAL CHARACTER MASK. 
* 
*         USES   X - 3, 6, 7. 
*                B - NONE.
*                A - 3. 
* 
*         CALLS  NONE.
  
  
 BTZ>     SUBR               ENTRY/EXIT 
          SA3    BTZA 
          BX7    X1-X3       CONVERT BLANKS TO 00, OTHERS TO MISC 
          SA3    A3+B1
          BX6    X3*X7       REMOVE UPPER BIT FROM ALL CHARACTERS 
          BX7    -X3*X7      ISOLATE UPPER BITS 
          IX6    X6+X3       ANY NON-ZERO CHARACTER PRODUCES CARRY
          BX6    X6+X7       MERGE UPPER BITS AND CARRIES 
          BX7    -X3*X6      ALL NON-ZERO CHARACTERS = 40B
          BX6    X7 
          LX7    -5 
          IX7    X6-X7
          BX7    X6+X7       NOW HAVE MASK
          BX6    X7*X1       CLEAR SPACES FROM ORIGINAL WORD
          EQ     BTZ>        AND RETURN 
  
 BTZA     CON    10H
          CON    37373737373737373737B
 BTZ      SPACE  4,10 
          BASE   *
 QUAL$    IF     -DEF,QUAL$ 
          QUAL   *
 BTZ>     EQU    /CDKCBTZ/BTZ>
 QUAL$    ENDIF 
 BTZ      ENDX
*COMDECK  CDKCMFS  MOVE FORTRAN STRING. 
 MFS      CTEXT  CDKCMFS - MOVE FORTRAN STRING. 
 MFS      SPACE  4,10 
          IF     -DEF,QUAL$,1 
          QUAL   CDKCMFS
          BASE   D
 MFS      SPACE  4,10 
***       MFS - MOVE FORTRAN STRING.
* 
*         G. M. TOWNSEND.    83/05/31.
* 
*         MFS MOVES A (POSSIBLY UNALIGNED) FTN5 CHARACTER STRING
*         INTO A WORD-ALIGNED BUFFER. 
 MFS      SPACE  4,10 
***       MFS MOVES A FTN5 CHARACTER STRING INTO A BUFFER.  THIS IS 
*         PARTICULARLY USEFUL FOR SUBROUTINES WHICH NEED THEIR DATA 
*         WORD-ALIGNED.  IF THE STRING IS TOO LONG FOR THE BUFFER, IT 
*         IS TRUNCATED;  IF TOO SHORT, IT IS PADDED WITH ZEROES.
* 
*         MFS ALSO WORKS FOR FTN4 OR FTN5 HOLLERITH STRINGS (CHARACTERS 
*         STORED IN VARIABLES OF OTHER TYPES);  SINCE SUCH STRINGS
*         HAVE NO ASSOCIATED LENGTH THEY WILL BE COPIED UNTIL THE 
*         BUFFER IS FILLED. 
* 
*         STRINGS MUST BE IN CM (NOT ECS/LCM) AND MUST NOT EXCEED 
*         777777B CHARACTERS IN LENGTH. 
* 
*         ENTRY  (X1) = APLIST ENTRY SPECIFYING STRING IN CM
*                            (SEE FTN5 REFERENCE MANUAL) OR ADDRESS 
*                            OF HOLLERITH STRING. 
*                (B1) = 1.
*                (B6) = FWA OF OUTPUT BUFFER. 
*                (B7) = SIZE OF OUTPUT BUFFER, IN WORDS.
* 
*         EXIT   (B6) = LWA+1 OF BUFFER.
* 
*         USES   X - 1, 2, 6, 7.
*                B - 3, 4, 5, 6, 7. 
*                A - 2, 6.
* 
*         CALLS  NONE.
  
  
 MFS>     SUBR               ENTRY/EXIT 
          SA2    X1          (A2/X2) = CURRENT INPUT WORD 
          MX7    -6          (X7) = ONE-CHARACTER MASK
          AX1    24 
          BX6    -X1+X7      -(BEGINNING CHAR POSITION) 
          AX1    6
          SB3    X1          (B3) = NUMBER OF CHARS LEFT (0 = UNKNOWN). 
          SB4    X6+10       (B4) = NUMBER OF CHARS LEFT IN X2
          IX1    X6+X6       -2 * BCP 
          IX1    X6+X1       -3 * BCP 
          LX1    1           -6 * BCP (0 TO -54)
          SB5    X1 
          AX2    B5          POSITION X2 TO FIRST INPUT CHARACTER 
          MX6    0           (X6) = OUTPUT WORD IN PROGRESS 
          SB5    54          (B5) = SHIFT COUNT FOR STUFFING OUTPUT 
          NZ     B3,MFS2     IF INPUT CHAR COUNT PROVIDED 
          SB3    -1          NO, USE HUGE COUNT 
          EQ     MFS2        JOIN MAIN LOOP 
  
 MFS1     SA2    A2+1        GET NEXT INPUT WORD
          SB4    10          INDICATE 10 CHARS AVAILABLE
 MFS2     ZR     B3,MFS4     IF INPUT STRING EXHAUSTED
          ZR     B4,MFS1     IF NEED TO LOAD NEW INPUT WORD 
 MFS3     LX2    6           NO, POSITION TO NEXT CHARACTER 
          SB3    B3-B1       COUNT CHARACTER FROM STRING
          BX1    -X7*X2      ISOLATE IT 
          SB4    B4-B1       COUNT CHARACTER FROM X2
          LX1    B5          POSITION IT
          SB5    B5-6        ADJUST SHIFT COUNT FOR NEXT TIME 
          BX6    X6+X1       ADD INTO OUTPUT WORD 
          PL     B5,MFS2     IF OUTPUT WORD NOT FULL
          SA6    B6          YES, SAVE OUTPUT WORD
          SB7    B7-B1       COUNT IT 
          SB6    B6+B1       BUMP STORE ADDRESS 
          SB5    54          RESET SHIFT COUNT
          MX6    0           CLEAR OUTPUT WORD
          GT     B7,MFS2     IF OUTPUT BUFFER NOT FULL
          EQ     MFS>        IF FULL, RETURN
  
 MFS4     MX2    0           USE ZEROES FOR REMAINING CHARACTERS
          SB4    B0          INDICATE HUGE NUMBER LEFT
          EQ     MFS3        REJOIN LOOP
 MFS      SPACE  4,10 
          BASE   *
 QUAL$    IF     -DEF,QUAL$ 
          QUAL   *
 MFS>     EQU    /CDKCMFS/MFS>
 QUAL$    ENDIF 
 MFS      ENDX
*COMDECK  CDKCMVC            MOVE CHARACTERS. 
 MVC      CTEXT  CDKCMVC - CM STRING MOVE.
 MVC      SPACE  4,10 
          IF     -DEF,QUAL$,1 
          QUAL   CDKCMVC
          BASE   D
 MVC      SPACE  4,10 
***       MVC - MOVE CHARACTER STRING.
* 
*         R. O. ANDERSON, 
*         W. R. SEARS        75/05/21.
* 
*         R. O. ANDERSON.    80/07/03.  HANDLE CHAR OFFSETS .GT. 9. 
* 
*         MVC MOVES CHARACTER STRINGS.
 MVC      SPACE  4,10 
***       MVC MOVES STRINGS FROM ONE LOCATION TO ANOTHER ON WHAT
*         APPEARS TO BE A CHARACTER BY CHARACTER BASIS.  MVC DOES NOT 
*         CHANGE CHARACTERS IN THE DESTINATION AREA THAT LIE BEYOND THE 
*         SPACE COVERED BY THE STRING THAT WAS MOVED. 
* 
*         ENTRY  (A1) = SOURCE ADDRESS. 
*                (A2) = DESTINATION ADDRESS.
*                (B1) = 1.
*                (B2) = SOURCE CHARACTER OFFSET (0 TO 131071).
*                (B3) = DESTINATION CHARACTER OFFSET (0 TO 131071). 
*                (B4) = NUMBER OF CHARACTERS TO MOVE (0 TO 131071). 
* 
*         EXIT   STRING MOVED.
* 
*         USES   X - 1, 2, 3, 4, 5, 6, 7. 
*                B - 2, 3, 4, 5.
*                A - 1, 2, 3, 4, 6, 7.
  
  
 MVC.CSIZ EQU    6           BITS PER CHARACTER 
 MVC.CPW  EQU    60/MVC.CSIZ CHARACTERS PER WORD
  
  
 MVC4     BX7    X2          SET UP 
          SA2    A2-B1       FOR FIRST
          BX6    X2          ITERATION
          SA6    A2          OF LOOP
 MVC5     BX5    -X3*X1      -123456789 
          BX2    X4*X7       ABC------- 
          SA1    A1+B1       KLMNOPQRST 
          BX7    X3*X1       K--------- 
          BX7    X5+X7       K123456789 
          LX7    B2,X7       89K1234567 
          BX6    -X4*X7      ---1234567 
          BX6    X6+X2       ABC1234567 
          SB4    B4-MVC.CPW  DECREMENT CHARACTERS LEFT
          LE     B4,MVC6     IF DONE
          SA6    A6+B1       STORE THIS WORD
          EQ     MVC5        LOOP TILL DONE 
  
 MVC6     SA2    MVCA+MVC.CPW-1+B4  GET PROPER EDIT MASK
          SB3    B3-60       SET UP RIGHT CIRCULAR SHIFT OF MASK
          LX2    -B3,X2      ---******- 
          BX1    X4+X2       *********- 
          BX3    X4*X2       ---------- 
          BX7    X4*X7       890------- 
          SA2    A6+B1       ABCDEFGHIJ 
          SA4    A2+B1       KLMNOPQRST 
          BX2    -X1*X2      ---------J 
          BX4    -X3*X4      KLMNOPQRST 
          BX6    X1*X6       ABC123456- 
          BX7    X3*X7       ---------
          BX6    X6+X2       ABC123456J 
          BX7    X7+X4       KLMNOPQRST 
          SA6    A2          UPDATE 
          SA7    A4          LAST WORDS 
 MVC>     SUBR               ENTRY/EXIT 
          LE     B4,MVC>     QUIT IF NOTHING TO DO
          SX6    MVC.CSIZ    X6 = BITS PER CHARACTER
 MVC0     SB2    B2-10       COMPUTE SOURCE WORD ADDRESS
          MI     B2,MVC0A    IF WORD ADDRESS OK 
          SA1    A1+B1       ADVANCE 1 WORD 
          EQ     MVC0 
  
 MVC0A    SB2    B2+10       COMPUTE CORRECTED SOURCE OFFSET
          MX5    1           FOR MASK GENERATION
          SB5    B2          SAVE SOURCE OFFSET FOR LATER 
 MVC0B    SB3    B3-10       COMPUTE DESTINATION WORD ADDRESS 
          MI     B3,MVC0C    IF WORD ADDRESS OK 
          SA2    A2+B1       ADVANCE 1 WORD 
          EQ     MVC0B
  
 MVC0C    SB3    B3+10       COMPUTE CORRECTED DESTINATION OFFSET 
          SX7    B2          CONVERT
          IX7    X7*X6       SOURCE OFFSET
          SB2    X7          TO BITS
          SX7    B3          CONVERT
          IX7    X7*X6       DESTINATION OFFSET 
          SB3    X7          TO BITS
          AX3    X5,B2       BUILD SOURCE AND 
          AX4    X5,B3       DESTINATION MASKS
          LX5    B1,X3       COMPENSATE 
          BX3    X5*X3       FOR
          LX5    B1,X4       EXTRA
          BX4    X5*X4       BIT
          SX6    A1          GET FWA OF SOURCE AREA 
          SB2    B2-B3       B2 IS OFFSET DIFFERENCE
          PL     B2,MVC1     SKIP IF POSITIVE 
          SB2    B2+60       ELSE MAKE IT POSITIVE
 MVC1     SX7    A2          GET DESTINATION FWA
          IX5    X6-X7       SEE IF FWA SOURCE .GE. FWA DEST. 
          PL     X5,MVC4     IF SO
          SX5    B5+B4       GET CHARACTER OFFSET OF LWA SOURCE 
          SX7    MVC.CPW     COMPUTE
          MX6    -1          CHARACTERS PER WORD
          IX6    X6+X7       MINUS ONE
          IX5    X5+X6       X5 = OFFSET + ROUNDING VALUE 
*          IX7    X5/X7,B5    WORD OFFSET OF LWA + 1 SOURCE 
          IX7    X5/X7       WORD OFFSET OF LWA + 1 SOURCE
          SX6    A1          COMPUTE LWA + 1
          IX5    X6+X7       OF SOURCE
          SX6    A2          SEE IF LWA + 1 SOURCE
          IX6    X6-X5       .LE. FWA DESTINATION 
          PL     X6,MVC4     IF SO
          SA1    X5-1        A1 = LWA SOURCE
          SX6    A2          COMPUTE
          IX5    X6+X7       LWA + 1 DESTINATION
          SA2    X5-1        A2 = LWA DESTINATION 
          SX7    MVC.CPW     COMPUTE
          SX6    B4          REMAINDER OF 
          PX6    X6,B0         INTEGER DIVIDE 
          PX7    X7,B0
          NX7    X7,B0
          FX5    X6/X7
          UX6,B5 X6          RESTORE REGISTERS
          LX6    X6,B5
          UX7,B5 X7 
          LX7    X7,B5
          UX5,B5 X5 
          LX5    X5,B5
          IX5    X5*X7       NUMBER OF CHARACTERS / CHARS PER WORD
          IX5    X6-X5       THEN GET 
          IX5    X5-X7       INDEX INTO MASK TABLE
          SB5    MVCA+MVC.CPW-1+X5  B5 = POINTER TO MASK
          BX6    X3          SAVE 
          SA6    MVCB        BOTH 
          BX7    X4          MASKS
          SA7    A6+B1       FOR LATER
          LX6    X1,B2       ^!+"*/[]() 
          BX5    X4*X6       ^!+------- 
          BX6    X3*X1       +--------- 
          SA1    A1-B1       0123456789 
          BX1    -X3*X1      -123456789 
          BX6    X6+X1       +123456789 
          LX7    X6,B2       89+1234567 
          BX6    X4*X7       89+------- 
          SA1    A1+B1       +"*/[]()^! 
          LX1    X1,B2       ^!+"*/[]() 
          BX1    -X4*X1      ---"*/[]() 
          BX6    X6+X1       89+"*/[]() 
          SA3    B5          GET THE EDIT MASK
          SB5    B3-60       GET MASK ROTATION VALUE
          LX3    -B5,X3      **-******* 
          BX1    X4+X3       ********** 
          BX3    X4*X3       **-------- 
          SA4    A2+B1       %%%%%%%%%% 
          BX4    -X3*X4      --%%%%%%%% 
          BX5    X3*X5       ^!-------- 
          BX5    X5+X4       ^!%%%%%%%% 
          BX2    -X1*X2      ---------- 
          BX4    X1*X6       89+"*/[]() 
          BX6    X5          ^!%%%%%%%% 
          SA6    A4          UPDATE LAST WORD IN DEST. AREA 
          BX6    X4+X2       89+"*/[]() 
          SA6    A2          UPDATE THE NEXT TO LAST WORD 
          CX1    X1          SEE
          CX3    X3          HOW MANY 
          IX3    X3+X1       CHARACTERS 
          SX1    MVC.CSIZ    WERE 
*          IX3    X3/X1,B5    USED
          IX3    X3/X1       USED     
          SB5    X3          AND DECREMENT
          SB4    B4-B5       THE TOTAL
          LE     B4,MVC>     IF DONE
          SA1    A1-B1       0123456789 
          SA3    MVCB        RECOVER
          SA4    A3+B1       MASKS
 MVC2     BX5    X3*X1       0--------- 
          BX2    -X4*X7      ---1234567 
          SA1    A1-B1       ABCDEFGHIJ 
          BX7    -X3*X1      -BCDEFGHIJ 
          BX7    X7+X5       0BCDEFGHIJ 
          LX7    B2,X7       IJ0BCDEFGH 
          BX6    X4*X7       IJ0------- 
          BX6    X6+X2       IJ01234567 
          SB4    B4-MVC.CPW  DECREMENT CHARACTERS LEFT
          LE     B4,MVC3     IF DONE
          SA6    A6-B1       STORE THIS WORD
          EQ     MVC2        LOOP TILL DONE 
  
 MVC3     BX6    -X4*X6      ---BCDEFGH 
          SA1    A6-B1       KLMNOPQRST 
          BX1    X4*X1       KLM------- 
          BX6    X1+X6       KLMBCDEFGH 
          SA6    A1          STORE LAST WORD
          EQ     MVC>        RETURN 
  
 MVCA     VFD    MVC.CSIZ/-0,*P/0  MASK TABLE 
 .MVCIF   IFGT   MVC.CPW,2
 .MVCSET  SET    MVC.CSIZ 
 .MVC1UP  DUP    MVC.CPW-2
 .MVCSET  SET    .MVCSET+MVC.CSIZ 
          VFD    .MVCSET/-0,*P/0
 .MVC1UP  ENDD
 .MVCIF   ENDIF 
          DATA   -0 
  
 MVCB     BSS    2           TO SAVE MASKS
 MVC      SPACE  4,10 
          BASE   *
 QUAL$    IF     -DEF,QUAL$ 
          QUAL   *
 MVC>     EQU    /CDKCMVC/MVC>
 QUAL$    ENDIF 
 MVC      ENDX
*COMDECK  CDKCSCS  SELECT CHARACTER SET.
 SCS      CTEXT  CDKCSCS - SELECT CHARACTER SET.
 SCS      SPACE  4,10 
          IF     -DEF,QUAL$,1 
          QUAL   CDKCSCS
          BASE   D
 SCS      SPACE  4,10 
***       SCS - SELECT CHARACTER SET. 
* 
*         G. M. TOWNSEND.    81/02/17.
* 
*         SCS DETERMINES THE CHARACTER SET OF A FILE BY INSPECTING THE
*         FIRST BUFFER FULL OF DATA.
 SCS      SPACE  4,10 
***       SCS LOOKS AT A PORTION OF A FILE TO DETERMINE WHETHER IT IS 
*         DISPLAY CODE OR 7-IN-12 ASCII.  IT DOES THIS BY SEEING IF 
*         THERE ARE ZERO BITS WHERE THEY SHOULD BE FOR AN ASCII FILE; 
*         IF NOT, THE FILE IS ASSUMED TO BE IN DISPLAY CODE.  THE 
*         ALGORITHM IS NOT FOOLPROOF -- IT CAN FALSELY DIAGNOSE A FILE
*         AS ASCII IF IT CONTAINS ONLY THE DISPLAY CODE CHARACTERS
*         A, 5, AND 6 (ALSO *:* IN 64-CHARACTER SET) IN ODD-NUMBERED
*         COLUMNS.  DESPITE THIS, THE METHOD WORKS WELL IN PRACTICE.
* 
*         SCS LOOKS AT ALL THE DATA IN A CIRCULAR BUFFER, AS INDICATED
*         BY THE FET.  THE CALLER SHOULD FIRST ISSUE A READ, THEN CALL
*         SCS.
* 
*         ENTRY  (X2) = FET ADDRESS.
*                (B1) = 1.
* 
*         EXIT   (X6) = 1 IF DISPLAY CODE.
*                (X6) = 0 IF BUFFER IS EMPTY. 
*                (X6) = -1 IF NOS 812 ASCII.    
*                (X6) = -2 IF UT 812 ASCII. 
* 
*         USES   X - 1, 3, 6. 
*                B - 2, 3, 4, 5.
*                A - 1, 3.
  
  
 SCS>     SUBR               ENTRY/EXIT 
          RECALL X2          WAIT FOR READ TO FINISH
          SA1    X2+B1
          SB2    X1          (B2) = FIRST 
          SA1    A1+B1
          SB3    X1          (B3) = IN
          SA1    A1+B1
          SB4    X1          (B4) = OUT 
          SA1    A1+B1
          SB5    X1          (B5) = LIMIT 
          SX6    B0 
          EQ     B3,B4,SCS>  IF EMPTY BUFFER, RETURN
          SA3    SCSA        (X3) = MASK
          SX6    B1          ASSUME DISPLAY CODE
 SCS1     SA1    B4          FETCH WORD 
          BX1    -X3*X1 
          ZR     X1,SCS2     IF OK ASCII SO FAR, CHECK MORE 
          SA1      B4              CHECK AGAINST UT 812 ASCII 
          SA3      SCSB 
          BX1      -X3*X1 
          NZ       X1,SCS>         IF DISPLAY CODE, RETURN
SCS2      SB4      B4+B1           BUMP POINTER 
          EQ     B4,B3,SCS3  IF NO MORE IN BUFFER 
          LT     B4,B5,SCS1  IF NOT YET TO LIMIT
          SB4    B2          GO BACK TO FIRST 
          NE     B4,B3,SCS1  IF MORE TO CHECK 
 SCS3     SX6    -B1         INDICATE ASCII     
          SA1      SCSA 
          BX1      X1-X3
          ZR       X1,SCS>         IF NOS 812 ASCII 
          SX6      -2              INDICATE UT 812 ASCII  
          EQ     SCS>        RETURN 
  
SCSA      DATA   41774177417741774177B  MASK FOR BITS IN ASCII CHARS
SCSB      DATA   43774377437743774377B  MASK FOR UT 812 CHARS       
 SCS      SPACE  4,10 
          BASE   *
 QUAL$    IF     -DEF,QUAL$ 
          QUAL   *
 SCS>     EQU    /CDKCSCS/SCS>
 QUAL$    ENDIF 
 SCS      ENDX
*COMDECK  CDKCSXT            CONVERT CHARACTERS, SIXBIT TO TWELVEBIT. 
 SXT      CTEXT  CDKCSXT - SIXBIT TO TWELVE BIT CHARACTER MAPPING.
 SXT      SPACE  4,10 
          IF     -DEF,QUAL$,1 
          QUAL   CDKCSXT
          BASE   D
 SXT      SPACE  4,10 
***       SXT - SIXBIT TO TWELVE BIT CHARACTER MAPPING. 
* 
*         R. O. ANDERSON.    75/01/27.
* 
*         SXT CONVERTS A 6-BIT CHARACTER SET INTO A 12-BIT CHARACTER
*         SET.
 SXT      SPACE  4,10 
***       SXT PERFORMS A CHARACTER MAPPING OPERATION USING A CONVERSION 
*         TABLE OF 1 CHARACTER PER WORD, RIGHT JUSTIFIED, BINARY ZERO 
*         FILLED.  THE TABLE IS ASSUMED TO BE LONG ENOUGH TO ALLOW
*         MAPPING OF ANY CHARACTER ENCOUNTERED IN THE INPUT STRING. 
* 
*         ENTRY  (B1) = 1.
*                (B2) = ADDRESS OF INPUT STRING.
*                (B3) = LENGTH OF INPUT STRING, IN WORDS. 
*                (B4) = ADDRESS OF OUTPUT STRING. 
*                (B5) = ADDRESS OF CONVERSION TABLE.
* 
*         EXIT   STRING CONVERTED.
* 
*         USES   X - 1, 2, 6, 7.
*                B - NONE.
*                A - 1, 2, 6. 
  
  
  
 SXT>     SUBR               ENTRY/EXIT 
          SX6    B3          SAVE INPUT 
          SA6    SXTA        STRING LENGTH
          SX6    B4          SAVE OUTPUT
          SA6    A6+B1       START ADDRESS
          SB3    B2+B3       COMPUTE LWA + 1 OF INPUT AREA
          MX7    -6          SET UP A ONE BYTE MASK 
 SXT1     SA1    B2          READ UP THE NEXT WORD TO CONVERT 
          MX6    0           CLEAR ASSEMBLY REGISTER
 .SXT     DUP    5
          LX1    6           GET ONE CHARACTER
          BX2    -X7*X1      IN X2
          SA2    B5+X2       GET REPLACEMENT
          LX6    12          MAKE ROOM FOR NEW CHARACTER
          BX6    X6+X2       ADD IN NEW CHARACTER 
 .SXT     ENDD
          SA6    B4          STORE OUTPUT WORD
          MX6    0           CLEAR ASSEMBLY REGISTER
 .SXT     DUP    5
          LX1    6           GET ONE CHARACTER
          BX2    -X7*X1      IN X2
          SA2    B5+X2       GET REPLACEMENT
          LX6    12          MAKE ROOM FOR NEW CHARACTER
          BX6    X6+X2       ADD IN NEW CHARACTER 
 .SXT     ENDD
          SA6    A6+B1       STORE OUTPUT WORD
          SB2    B2+B1       INCREMENT IN POINTER 
          SB4    A6+B1       INCREMENT OUT POINTER
          LT     B2,B3,SXT1  LOOP TILL DONE 
          SA1    SXTA        RECOVER INPUT
          SB3    X1          STRING LENGTH
          SA1    A1+B1       RECOVER OUTPUT 
          SB4    X1          START ADDRESS
          SB2    B2-B3       RESTORE INPUT STARTING ADDRESS 
          EQ     SXT>        RETURN 
  
 SXTA     BSS    2           TO SAVE LENGTH AND OUT START ADDR
 SXT      SPACE  4,10 
          BASE   *
 QUAL$    IF     -DEF,QUAL$ 
          QUAL   *
 SXT>     EQU    /CDKCSXT/SXT>
 QUAL$    ENDIF 
 SXT      ENDX
*COMDECK  CDKCTXS            CONVERT CHARACTERS, TWELVEBIT TO SIXBIT. 
 TXS      CTEXT  CDKCTXS - TWELVE BIT TO SIXBIT CHARACTER MAPPING.
 TXS      SPACE  4,10 
          IF     -DEF,QUAL$,1 
          QUAL   CDKCTXS
          BASE   D
 TXS      SPACE  4,10 
***       TXS - TWELVE BIT TO SIXBIT CHARACTER MAPPING. 
* 
*         R. O. ANDERSON.    75/01/27.
* 
*         TXS CONVERTS A 12-BIT CHARACTER SET INTO A 6-BIT CHARACTER
*         SET.
 TXS      SPACE  4,10 
***       TXS PERFORMS A CHARACTER MAPPING OPERATION USING A CONVERSION 
*         TABLE OF 1 CHARACTER PER WORD, RIGHT JUSTIFIED, BINARY ZERO 
*         FILLED.  THE TABLE IS ASSUMED TO BE LONG ENOUGH TO ALLOW
*         MAPPING OF ANY CHARACTER ENCOUNTERED IN THE INPUT STRING. 
* 
*         ENTRY  (B1) = 1.
*                (B2) = ADDRESS OF INPUT STRING.
*                (B3) = LENGTH OF INPUT STRING, IN WORDS. 
*                (B4) = ADDRESS OF OUTPUT STRING. 
*                (B5) = ADDRESS OF CONVERSION TABLE.
* 
*         EXIT   STRING CONVERTED.
* 
*         USES   X - 1, 2, 6, 7.
*                B - NONE.
*                A - 1, 2, 6. 
  
  
  
 TXS>     SUBR               ENTRY/EXIT 
          SX6    B3          SAVE INPUT 
          SA6    TXSA        STRING LENGTH
          SX6    B4          SAVE OUTPUT
          SA6    A6+B1       START ADDRESS
          SB3    B2+B3       COMPUTE LWA + 1 OF INPUT AREA
          MX7    -12         SET UP A ONE BYTE MASK 
 TXS1     SA1    B2          READ UP THE NEXT WORD TO CONVERT 
          MX6    0           CLEAR ASSEMBLY REGISTER
 .TXS     DUP    5
          LX1    12          GET ONE CHARACTER
          BX2    -X7*X1      IN X2
          SA2    B5+X2       GET REPLACEMENT
          LX6    6           MAKE ROOM FOR NEW CHARACTER
          BX6    X6+X2       ADD IN NEW CHARACTER 
 .TXS     ENDD
          SB2    B2+B1       INCREMENT IN POINTER 
          GE     B2,B3,TXS3  STORE WORD IF INPUT LENGTH ODD 
          SA1    B2          ELSE GET NEXT WORD AND CONTINUE
 .TXS     DUP    5
          LX1    12          GET ONE CHARACTER
          BX2    -X7*X1      IN X2
          SA2    B5+X2       GET REPLACEMENT
          LX6    6           MAKE ROOM FOR NEW CHARACTER
          BX6    X6+X2       ADD IN NEW CHARACTER 
 .TXS     ENDD
          SA6    B4          STORE OUTPUT WORD
          SB2    B2+B1       INCREMENT IN POINTER 
          SB4    B4+B1       INCREMENT OUT POINTER
          LT     B2,B3,TXS1  LOOP TILL DONE 
 TXS2     SA1    TXSA        RECOVER INPUT
          SB3    X1          STRING LENGTH
          SA1    A1+B1       RECOVER OUTPUT 
          SB4    X1          START ADDRESS
          SB2    B2-B3       RESTORE INPUT STARTING ADDRESS 
          EQ     TXS>        RETURN 
  
 TXS3     LX6    30          POSITION PARTIAL WORD
          SA6    B4          SAVE IT
          EQ     TXS2        TO COMPLETE EXIT 
  
 TXSA     BSS    2           TO SAVE LENGTH AND OUT START ADDR
 TXS      SPACE  4,10 
          BASE   *
 QUAL$    IF     -DEF,QUAL$ 
          QUAL   *
 TXS>     EQU    /CDKCTXS/TXS>
 QUAL$    ENDIF 
 TXS      ENDX
*COMDECK  CDKCVFN            VALIDATE FILE NAME.
 VFN      CTEXT  CDKCVFN - VALIDATE FILE NAME.
 VFN      SPACE  4,10 
          IF     -DEF,QUAL$,1 
          QUAL   CDKCVFN
          BASE   D
 VFN      SPACE  4,10 
***       VFN - VALIDATE FILE NAME. 
* 
*         G. M. TOWNSEND.    78/02/02.
* 
*         VFN CHECKS THAT A STRING IS A LEGAL FILE NAME.
 VFN      SPACE  4,10 
***       ENTRY  (X1) = FILE NAME, L FORMAT.
*                (B1) = 1.
* 
*         EXIT   (X1) = 0 IF LEGAL. 
* 
*         USES   X - 1, 2, 6. 
*                B - 2. 
*                A - NONE.
  
  
 VFN>     SUBR               ENTRY/EXIT 
          MI     X1,VFN>     IF NEGATIVE, RETURN IMMEDIATELY
          BX2    X1 
          AX2    54 
          SX2    X2-1R0 
          PL     X2,VFN>     IF FIRST CHAR NUMERIC, RETURN
          SB2    7           (B2) = CHARACTER COUNTER 
          MX2    -6          (X2) = CHARACTER MASK
 VFN1     LX1    6
          BX6    -X2*X1      (X6) = CHARACTER 
          ZR     X6,VFN>     IF ZERO CHARACTER, RETURN
          SX6    X6-1R9-1 
          PL     X6,VFN>     IF ILLEGAL CHARACTER, RETURN 
          BX1    X2*X1       CLEAR OUT LAST CHAR, IT IS LEGAL 
          SB2    B2-B1
          NZ     B2,VFN1     IF MORE CHARACTERS TO TEST 
          EQ     VFN>        RETURN 
 VFN      SPACE  4,10 
          BASE   *
 QUAL$    IF     -DEF,QUAL$ 
          QUAL   *
 VFN>     EQU    /CDKCVFN/VFN>
 QUAL$    ENDIF 
 VFN      ENDX
*DECK REL 
          IDENT  CPU.BTZ
          ENTRY  BTZ> 
 BTZ      TITLE  BTZ - CONVERT BLANKS TO ZEROES IN A WORD.
          COMMENT CONVERT BLANKS TO ZEROES IN A WORD. 
*CALL     CDKCBTZ 
          END 
          IDENT  CPU.MFS
          ENTRY  MFS> 
 MFS      TITLE  MFS - MOVE FORTRAN STRING. 
          COMMENT MOVE FORTRAN STRING.
*CALL     CDKCMFS 
          END 
          IDENT  CPU.MVC
          ENTRY  MVC> 
 MVC      TITLE  MVC - MOVE CHARACTERS. 
          COMMENT MOVE CHARACTERS.
*CALL     CDKCMVC 
          END 
          IDENT  CPU.SCS
          ENTRY  SCS> 
 SCS      TITLE  SCS - SELECT CHARACTER SET.
          COMMENT SELECT CHARACTER SET. 
*CALL     CDKCSCS 
          END 
          IDENT  CPU.SXT
          ENTRY  SXT> 
 SXT      TITLE  SXT - CONVERT CHARACTERS, SIXBIT TO TWELVEBIT. 
          COMMENT CONVERT CHARACTERS, SIXBIT TO TWELVEBIT.
*CALL     CDKCSXT 
          END 
          IDENT  CPU.TXS
          ENTRY  TXS> 
 TXS      TITLE  TXS - CONVERT CHARACTERS, TWELVEBIT TO SIXBIT. 
          COMMENT CONVERT CHARACTERS, TWELVEBIT TO SIXBIT.
*CALL     CDKCTXS 
          END 
          IDENT  CPU.VFN
          ENTRY  VFN> 
          SST 
 VFN      TITLE  VFN - VALIDATE FILE NAME.
          COMMENT VALIDATE FILE NAME. 
*CALL     CDKCVFN 
          END 
*DECK MACREL
          IDENT  MACREL 
          ENTRY    MACREL.,MACREL=,MACWAL=
          SST 
          B1=1
          LIST   F
          TITLE  MACREL - SYSTEM MACRO INTERFACE ROUTINES.
          COMMENT  SYSTEM MACRO INTERFACE ROUTINES. 
 MACREL   SPACE  4,10 
***       MACREL - SYSTEM MACRO INTERFACE ROUTINES. 
* 
*         T. R. RAMSEY.      76/08/08.
* 
*         COPYRIGHT CONTROL DATA CORPORATION. 1976. 
 MACREL   SPACE  4,10 
***              MACREL IS A COLLECTION OF RELOCATABLE MODULES THAT 
*         PROVIDE THE INTERFACE BETWEEN HIGHER LEVEL LANGUAGE MODULES 
*         AND THE SYSTEM MACROS.
* 
*         FORTRAN CALLING SEQUENCES ARE SHOWN IN EACH MODULE ALONG WITH 
*         OTHER PERTINENT INFORMATION, E.G., ENTRY, EXIT. 
          TITLE  MACREL - SYSTEM MACRO INTERFACE ROUTINES.
 MACREL   SPACE  4,10 
**               MACREL MODULES TRANSLATE PARAMETERS IN HIGHER LEVEL
*         LANGUAGE CALLING SEQUENCES INTO MACRO CALLING SEQUENCES.
*         FORTRAN CALLING SEQUENCES MENTIONED ARE EQUIVALENT TO 
*         COBOL (ENTER USING), SYMPL, ETC.
* 
*         ENTRY  FORTRAN *CALL* AND FUNCTION REFERENCE CALLING
*                SEQUENCES USE THE ACTUAL PARAMETER LIST, CALL BY 
*                REFERENCE CALLING SEQUENCE WHERE - 
*                 (A1)      = FWA OF APLIST 
*                ((A1))     # FIRST PARAMETER 
*                ((A1+1))   # SECOND PARAMETER
*                  .          . 
*                  .          . 
*                  .          . 
*                ((A1+N))   # N-TH PARAMETER
*                ((A1+N+1)) = 0 (ZERO)  (NOMINALLY)  (UN-NEEDED HEREIN) 
*                 (X1)      # FIRST PARAMETER 
* 
*         EXIT   FOR *CALL*, TYPICALLY NONE, BUT SEE INDIVIDUAL MODULES.
*                FOR FUNCTION REFERENCES, 
*                (X6) = FUNCTION RESULT 
*                (X7) = SECOND WORD OF TWO WORD RESULT, E.G., COMPLEX 
* 
*         USES   PRESERVES A0 
* 
*         CALLS  MACREL. IF MACRO UNDEFINED OR NOT CODED YET
*                MACREL= IF ARGUMENT ERROR
* 
*         NEEDS  EACH MODULE CONTAINS A CALL TO A MACRO WHOSE NAME IS 
*                THE SAME AS THE MODULE (EXCEPT WHERE NOTED).  THESE
*                MACROS ARE DEFINED IN SYSTEXT (KRONOS NOS) AND CPUTEXT 
*                (SCOPE NOS/BE) AND ALSO IN JETTEXT.  JETTEXT IS THE
*                PREFERRED SYSTEM TEXT. 
* 
*         NOTE   B1 IS SET TO ONE UPON ENTRY TO EACH MODULE 
* 
*         OTHER  MACREL IS A COLLECTION OF RELOCATABLE MODULES COMBINED 
*                INTO ONE *UPDATE* DECK ENTITY NAMED MACREL.  THE 
*                MODULES ARE ARRANGED IN THE SAME ORDER AS THE MACROS 
*                IN JETTEXT.
 MACREL.  SPACE  4,10 
**        MACREL. - UNDEFINED MACRO PROCESSOR.
* 
*         ENTRY  (X1) = MACRO NAME IN 0L FORMAT 
* 
*         EXIT   DOES NOT EXIT
* 
*         USES   A6  B1  X6 
* 
*         CALLS  NONE 
* 
*         NEEDS  MACROS ABORT, MESSAGE
  
  
 MACREL.  SUBR               ENTRY/EXIT 
          SB1    1
          BX6    X1 
          SA6    MACA+3 
          MESSAGE  MACA,,RCL
          ABORT 
          EQ       MACREL.
  
 MACA     DATA   C* MACREL - UNDEFINED MACRO -   FILL-IN.*
 MACREL=  SPACE  4,10 
**        MACREL= - ILLEGAL ARGUMENT PROCESSOR. 
* 
*         ENTRY  (X1) = MACRO NAME IN 0L FORMAT 
*                (X2) = ILLEGAL ARGUMENT
* 
*         EXIT   DOES NOT EXIT
* 
*         USES   A6  B1  X0,X1,X2,X6
* 
*         CALLS  ZTB= 
* 
*         NEEDS  MACROS ABORT, MESSAGE
  
  
 MACREL=  SUBR               ENTRY/EXIT 
          SB1    1
          BX0    X2          SAVE SECOND ARGUMENT 
          LX1    -6 
          SX2    1R-
          BX1    X1+X2
          RJ     =XZTB= 
          BX1    X0 
          SA6    MACB 
          RJ     =XZTB= 
          SA6    MACB+3 
          MESSAGE  MACB,,RCL
          ABORT  ,ND
          EQ       MACREL=
  
 MACB     DATA   C* FILL-IN - ILLEGAL ARGUMENT  >FILL-IT-IN<.*
 MACWAL=  SPACE  4,10 
**        MACWAL= - WORD ALIGN A 10 OR LESS CHARACTER PARAMETER.
* 
*         ENTRY  (X1) = FTN/FTN5 ARGUMENT LIST ITEM.
* 
*         EXIT   (X2) = VALUE FROM ARGUMENT LIST, LEFT JUSTIFIED, WITH
*                SPACE FILL, UNLESS VALUE WAS 0B OR ALL SPACES, IN
*                WHICH CASE, 0B RETURNED. 
* 
*         USES   A2,A3,A6  B1,B3,B4,B5,B6,B7  X1,X2,X3,X6,X7
* 
*         CALLS  MFS>, ZTB=.
  
  
 MACWAL=  SUBR               ENTRY/EXIT 
          SB1    1
          SB6    MACC        WHERE MFS CAN STASH THE RESULT 
          SB7    B1          LENGTH OF MFS BUFFER 
          RJ     =XMFS>      MOVE THE OPTION
          SA2    MACC        GET THE RESULT 
          ZR     X2,MACWAL=  IF NOTHING SPECIFIED, RETURN BINARY ZERO 
          BX1    X2          FOR ZTB
          RJ     =XZTB=      BLANK OUT THE 00B CHARACTERS 
          SA2    MACD        SPACES 
          BX2    X2-X6
          ZR     X2,MACWAL=  MAP SPACES TO ZERO FOR FTN5
          BX2    X6          FOR MOST OF OUR CALLERS, THIS IS BEST
          EQ     MACWAL=     RETURN 
  
 MACC     BSS    1           BUFFER FOR MFS 
 MACD     DATA   10H
  
          END 
          IDENT  EXCST
          ENTRY  EXCST
          SST 
          SYSCOM B1 
 EXCST    TITLE  EXCST - EXECUTE CONTROL STATEMENT FOR FTN. 
          COMMENT (FTN) EXECUTE CONTROL STATEMENT.
 EXCST    SPACE  4,10 
*****     EXCST - EXECUTE CONTROL STATEMENT FOR FTN.
* 
*         R. O. ANDERSON.    83/10/31.
* 
*         ALLOW FTN PROGRAM TO EXECUTE A CONTROL STATEMENT. 
 EXCST    SPACE  4,10 
***       EXCST ALLOWS AN FTN PROGRAM TO EXECUTE A CONTROL
*         STATEMENT AT TERMINATION. 
* 
*         CALL EXCST(STRING)
* 
*         ENTRY  *STRING* IS A HOLLERITH STRING (FTN4), INCLUDING 
*                A LINE TERMINATOR, OR A CHARACTER VARIABLE (FTN5). 
*                IN EITHER CASE, THE MAXIMUM LENGTH IS 80 CHARACTERS. 
* 
*         EXIT   DOES NOT RETURN. 
* 
*         CALLS  MFS>, SYS=.
  
  
 EXCST    SUBR     =               ENTRY (ONLY) 
          SB1      1               ALWAYS   
          SB6      CCDR            WHERE TO PUT THE IMAGE 
          SB7      8               MAXIMUM BUFFER LENGTH  
          RJ       =XMFS>          MOVE THE STRING
          SYSTEM   PCC,R,CCDR      EXECUTE IMAGE (DOES NOT RETURN)  
          ENDRUN                   IN CASE WE DID A 1AJ COMMAND 
  
          END 
          IDENT  CLOSE
          ENTRY    CLOSE
          SST 
          B1=1
          TITLE  CLOSE - CLOSE FILE.
          COMMENT   CLOSE FILE. 
 CLOSE    SPACE  4,10 
***       CLOSE - CLOSE FILE. 
* 
*         CALL CLOSE (FILE,OPTION)
* 
*         ENTRY  (FILE) = FIRST WORD OF THE FET 
*                (OPTION) = A HOLLERITH STRING OR CHARACTER VARIABLE
*                           WITH ANY OF THE FOLLOWING VALUES. 
*                         = 0 OR BLANKS, CLOSE WITH REWIND
*                         = ^NR^, CLOSE WITHOUT REWIND
*                         = ^REEL^, CLOSE REEL WITH REWIND
*                         = ^REELNR^, CLOSE REEL WITHOUT REWIND 
*                         = ^REELUN^, CLOSE REEL WITH REWIND, UNLOAD
*                         = ^RETURN^, CLOSE WITH REWIND, RETURN 
*                         = ^REWIND^, CLOSE WITH REWIND 
*                         = ^UNLOAD^, CLOSE WITH REWIND, UNLOAD 
* 
*         EXIT   TO ARGUMENT-ERROR PROCESSOR IF OPTION IS UNRECOGNIZED
*         ELSE   NONE 
  
  
 CLOSE    SUBR    
          SB1    1
          SA1    A1+B1       POINT TO OPTION
          RJ     =XMACWAL=   WORD ALIGN OPTION
          SA1    A1-B1       RESET X1 TO BE FET ADDRESS 
          ZR,X2  CLO1 
          SA3    =0HNR
          BX4    X2-X3
          ZR,X4  CLO2        IF NR
          SA3    =0HREEL
          BX4    X2-X3
          ZR,X4  CLO3        IF REEL
          SA3    =0HREELNR
          BX4    X2-X3
          ZR,X4  CLO4        IF REELNR
          SA3    =0HREELUN
          BX4    X2-X3
          ZR,X4  CLO5        IF REELUN
          SA3    =0HRETURN
          BX4    X2-X3
          ZR,X4  CLO6        IF RETURN
          SA3    =0HREWIND
          BX4    X2-X3
          ZR,X4  CLO7        IF REWIND
          SA3    =0HUNLOAD
          BX4    X2-X3
          ZR,X4  CLO8        IF UNLOAD
          SA1    =0LCLOSE 
          RJ     =XMACREL=   DIAGNOSE ILLEGAL ARGUMENT
          EQ     CLOSE      
  
 CLO1     CLOSE  X1 
          EQ     CLOSE      
  
 CLO2     CLOSE  X1,NR
          EQ     CLOSE      
  
 CLO3     CLOSER X1 
          EQ     CLOSE      
  
 CLO4     CLOSER X1,NR
          EQ     CLOSE      
  
 CLO5     CLOSER X1,UNLOAD
          EQ     CLOSE      
  
 CLO6     CLOSE  X1,RETURN
          EQ     CLOSE      
  
 CLO7     CLOSE  X1 
          EQ     CLOSE      
  
 CLO8     CLOSE  X1,UNLOAD
          EQ     CLOSE      
  
          END 
          IDENT  OPEN 
          ENTRY  OPEN 
          SST 
          B1=1
          TITLE  OPEN - OPEN FILE FOR PROCESSING. 
          COMMENT   OPEN FILE FOR PROCESSING. 
 OPEN     SPACE  4,10 
***       OPEN - OPEN FILE FOR PROCESSING.
* 
*         CALL OPEN (FILE,OPTION) 
* 
*         ENTRY  (FILE) = FIRST WORD OF THE FET 
*                (OPTION) = A HOLLERITH STRING OR CHARACTER VARIABLE
*                           WITH ANY OF THE FOLLOWING VALUES. 
*                         = 0 OR BLANKS, SAME AS ^ALTER^
*                         = ^ALTER^, OPEN WITH REWIND FOR I-O 
*                         = ^ALTERNR^, OPEN FOR I-O 
*                         = ^NR^, OPEN
*                         = ^READ^, OPEN WITH REWIND FOR INPUT
*                         = ^READNR^, OPEN FOR INPUT
*                         = ^REEL^, OPEN REEL WITH REWIND 
*                         = ^REELNR^, OPEN REEL 
*                         = ^WRITE^, OPEN WITH REWIND FOR OUTPUT
*                         = ^WRITENR^, OPEN FOR OUTPUT
* 
*         EXIT   TO ARGUMENT-ERROR PROCESSOR IF OPTION IS UNRECOGNIZED
*         ELSE   NONE 
  
  
 OPEN     SUBR    
          SB1    1
          SA1    A1+B1       POINT TO OPTION
          RJ     =XMACWAL=   WORD ALIGN OPTION
          SA1    A1-B1       RESET X1 TO BE FET ADDRESS 
          ZR,X2  OPE1 
          SA3    =0HALTER 
          SA4    =0HALTERNR 
          SA5    =0HNR
          BX3    X2-X3
          BX4    X2-X4
          ZR,X3  OPE2        IF ALTER 
          BX5    X2-X5
          ZR,X4  OPE3        IF ALTERNR 
          ZR,X5  OPE4        IF NR
          SA3    =0HREAD
          SA4    =0HREADNR
          SA5    =0HREEL
          BX3    X2-X3
          BX4    X2-X4
          ZR,X3  OPE5        IF READ
          BX5    X2-X5
          ZR,X4  OPE6        IF READNR
          ZR,X5  OPE7        IF REEL
          SA3    =0HREELNR
          SA4    =0HWRITE 
          SA5    =0HWRITENR 
          BX3    X2-X3
          BX4    X2-X4
          ZR,X3  OPE8        IF REELNR
          BX5    X2-X5
          ZR,X4  OPE9        IF WRITE 
          ZR,X5  OPE10       IF WRITENR 
          SA1    =0LOPEN
          RJ     =XMACREL=   DIAGNOSE ILLEGAL ARGUMENT
          EQ     OPEN       
  
 OPE1     OPEN   X1 
          EQ     OPEN       
  
 OPE2     OPEN   X1,ALTER 
          EQ     OPEN       
  
 OPE3     OPEN   X1,ALTERNR 
          EQ     OPEN       
  
 OPE4     OPEN   X1,NR
          EQ     OPEN       
  
 OPE5     OPEN   X1,READ
          EQ     OPEN       
  
 OPE6     OPEN   X1,READNR
          EQ     OPEN       
  
 OPE7     OPEN   X1,REEL
          EQ     OPEN       
  
 OPE8     OPEN   X1,REELNR
          EQ     OPEN       
  
 OPE9     OPEN   X1,WRITE 
          EQ     OPEN       
  
 OPE10    OPEN   X1,WRITENR 
          EQ     OPEN       
  
          END 
          IDENT  READ 
          ENTRY  READ 
          SST 
          B1=1
          TITLE  READ - READ FILE TO CIO BUFFER.
          COMMENT   READ FILE TO CIO BUFFER.
 READ     SPACE  4,10 
***       READ - READ FILE TO CIO BUFFER. 
* 
*         CALL READ (FILE)
* 
*         ENTRY  (FILE) = FIRST WORD OF THE FET 
  
  
 READ     SUBR    
          SB1    1
          READ   X1 
          EQ     READ       
  
          END 
          IDENT  WRITER 
          ENTRY  WRITER     
          SST 
          B1=1
          TITLE  WRITER - WRITE END OF RECORD.
          COMMENT   WRITE END OF RECORD.
 WRITER   SPACE  4,10 
***       WRITER - WRITE END OF RECORD. 
* 
*         CALL WRITER (FILE,LEVEL)
* 
*         ENTRY  (FILE) = FIRST WORD OF THE FET 
*                (LEVEL) = RECORD LEVEL 
  
  
 WRITER   SUBR    
          SB1    1
          SA3    A1+B1       ADDRESS OF LEVEL 
          SA3    X3          LEVEL
          WRITER X1,X3
          EQ     WRITER     
  
          END 
          IDENT  READC
          ENTRY  READC
          SST 
          B1=1
          TITLE  READC - READ CODED LINE IN *C* FORMAT. 
          COMMENT   READ CODED LINE IN *C* FORMAT.
 READC    SPACE  4,10 
***       READC - READ CODED LINE IN *C* FORMAT.
* 
*         CALL READC (FILE,BUF,N,STATUS)
* 
*         TRANSFERS DATA UNTIL THE END OF LINE BYTE (0000) IS SENSED. 
* 
*         ENTRY  (FILE) = FIRST WORD OF THE FET 
*                (BUF) = FIRST WORD OF THE WORKING BUFFER 
*                (N) = WORD COUNT OF THE WORKING BUFFER 
* 
*         EXIT   (STATUS) = 0, TRANSFER COMPLETE
*                         = -1, END-OF-FILE DETECTED ON FILE
*                         = -2, END-OF-INFORMATION DETECTED ON FILE 
*                         = LWA, END-OF-RECORD DETECTED ON FILE BEFORE
*                                TRANSFER WAS COMPLETE
*                     LWA = ADDRESS + 1 OF LAST WORD TRANSFERRED TO 
*                           WORKING BUFFER
  
  
 READC    SUBR    
          SB1    1
          SA3    A1+B1       FWA OF WORKING BUFFER
          SA4    A3+B1       ADDRESS OF WORD COUNT
          SA5    A4+B1       (X5) = ADDRESS OF STATUS WORD
          BX6      X5 
          SA4    X4          WORD COUNT 
          READC  X1,X3,X4   
          BX6    X1 
          SA6    X5 
          EQ     READC      
  
          END 
          IDENT  READW
          ENTRY  READW
          SST 
          B1=1
          TITLE  READW - READ DATA TO WORKING BUFFER. 
          COMMENT   READ DATA TO WORKING BUFFER.
 READW    SPACE  4,10 
***       READW - READ DATA TO WORKING BUFFER.
* 
*         CALL READW (FILE,BUF,N,STATUS)
* 
*         ENTRY  (FILE) = FIRST WORD OF THE FET 
*                (BUF) = FIRST WORD OF THE WORKING BUFFER 
*                (N) = WORD COUNT OF THE WORKING BUFFER 
* 
*         EXIT   (STATUS) = 0, TRANSFER COMPLETE
*                         = -1, END-OF-FILE DETECTED ON FILE
*                         = -2, END-OF-INFORMATION DETECTED ON FILE 
*                         = LWA, END-OF-RECORD DETECTED ON FILE BEFORE
*                                TRANSFER WAS COMPLETE
*                     LWA = ADDRESS + 1 OF LAST WORD TRANSFERRED TO 
*                           WORKING BUFFER
  
  
 READW    SUBR    
          SB1    1
          SA3    A1+B1       FWA OF WORKING BUFFER
          SA4    A3+B1       ADDRESS OF WORD COUNT
          SA5    A4+B1       (X5) = ADDRESS OF STATUS WORD
          SA4    X4          WORD COUNT 
          READW  X1,X3,X4 
          BX6    X1 
          SA6    X5 
          EQ     READW      
  
          END 
          IDENT  WRITEW 
          ENTRY  WRITEW 
          SST 
          B1=1
          TITLE  WRITEW - WRITE DATA FROM WORKING BUFFER. 
          COMMENT   WRITE DATA FROM WORKING BUFFER. 
 WRITEW   SPACE  4,10 
***       WRITEW - WRITE DATA FROM WORKING BUFFER.
* 
*         CALL WRITEW (FILE,BUF,N)
* 
*         ENTRY  (FILE) = FIRST WORD OF THE FET 
*                (BUF) = FIRST WORD OF THE WORKING BUFFER 
*                (N) = WORD COUNT OF THE WORKING BUFFER 
  
  
 WRITEW   SUBR    
          SB1    1
          SA3    A1+B1       FWA OF WORKING BUFFER
          SA4    A3+B1       ADDRESS OF WORD COUNT
          SA4    X4          WORD COUNT 
          WRITEW X1,X3,X4 
          EQ     WRITEW     
  
          END 
          IDENT  MTR
          SST   
          B1=1  
 MTR      TITLE  MTR - ISSUE MONITOR CALLS FROM FTN.    
          COMMENT      ISSUE MONITOR CALLS FROM FTN.    
 MTR      SPACE  4,10     
*****     MTR - ISSUE MONITOR CALLS FROM FTN.   
*     
*         B. L. TRUMBO.     78-AUG-31 
*     
*         MTR ALLOWS MONITOR CALLS TO BE ISSUED FROM AN FTN PROGRAM,
*         EITHER AS A 60-BIT REQUEST, OR IN THE SAME FORMAT AS    
*         THE *SYSTEM* MACRO. 
 MTR      SPACE  4,10     
***       MTR - ISSUE MONITOR CALLS FROM FTN.   
*     
*         CALL MTR (PPCALL) 
*         CALL MTR (PPNAME,RECALL)  
*         CALL MTR (PPNAME,RECALL,ARG)
*         CALL MTR (PPNAME,RECALL,ARG1,ARG2)  
*     
*         ENTRY  *PPCALL* IS A 60-BIT (INTEGER) QUANTITY, AND IS  
*                  ISSUED AS A MONITOR CALL WITHOUT MODIFICATION.   
*                *PPNAME* IS THE NAME OF THE PP ROUTINE TO BE CALLED, 
*                  LEFT JUSTIFIED.  ONLY THE UPPER 18 BITS ARE USED.
*                *RECALL* IS EITHER ZERO OR NON-ZERO.  IF IT IS ZERO, 
*                  NO RECALL BIT IS INSERTED.   
*                *ARG* IS AN ARGUMENT TO BE PASSED TO THE PP ROUTINE
*                  CALLED.  THE LOWER 36 BITS ARE PASSED AS THE LOWER 
*                  36 BITS OF THE RA+1 CALL.  
*                *ARG1* IS AN ARGUMENT TO BE PASSED TO THE PP ROUTINE 
*                  CALLED.  THE LOWER 18 BITS ARE PASSED AS THE LOWER 
*                  18 BITS OF THE RA+1 CALL.  
*                *ARG2* IS AN ARGUMENT TO BE PASSED TO THE PP ROUTINE 
*                  CALLED.  THE LOWER 18 BITS ARE PASSED AS BITS 18 
*                  THRU 35 OF THE RA+1 CALL.  
*     
*         EXIT   ALL INPUT ARGUMENTS PRESERVED, MONITOR CALL ISSUED.
*                IF RECALL BIT WAS SET IN CALL, RA+1 WILL BE CLEAR. 
*     
*         USES   A1,A2,A3,A4,   A6  
*                B1 
*                X1,X2,X3,X4,   X6,X7 
*     
*         CALLS  SYS=.    
 MTR      SPACE  4,10     
 MTR2     BX4    -X6*X4      STRIP *ARG* TO 36 BITS, ASSUMING NO *ARG2*     
          LX3    40D         POSITION RECALL BIT
          BX2    X2+X4       COMBINE PP NAME AND ARG(S)   
          BX2    X2+X3       OR IN RECALL BIT   
 MTR1     BX6    X2 
          SYSTEM             ISSUE THE MONITOR CALL IN X6 
      
 MTR      SUBR   =           ENTRY/EXIT 
          SB1    1           11TH COMMANDMENT   
          SA2    X1          PICK UP PP NAME  
          SA1    A1+B1       PICK UP ADDRESS OF *RECALL* ARG
          ZR     X1,MTR1     IF ONLY ONE ARG, ISSUE IT AS IS
          MX7    18 
          SA3    X1          PICK UP *RECALL* ARG 
          MX4    0           ASSUME ZERO *ARG*  
          CX3    X3          CONVERT *RECALL* TO A BIT  
          SA1    A1+B1       PICK UP ADDRESS OF *ARG*   
          CX3    X3 
          BX2    X7*X2       STRIP PP NAME DOWN TO 3 CHARS
          CX3    X3 
          MX6    -36D        MASK FOR USE AT MTR2 
          CX3    X3          NOW HAVE ONLY ONE RECALL BIT 
          ZR     X1,MTR2     IF NO *ARG* SUPPLIED, USE ZERO 
          SA4    X1          IF *ARG* SUPPLIED, USE IT  
          SA1    A1+B1       PICK UP ADDRESS OF *ARG2*  
          ZR     X1,MTR2     IF NO *ARG2*     
          SA1    X1 
          MX7    -18D     
          BX4    -X7*X4      STRIP *ARG1* DOWN TO 18 BITS 
          BX1    -X7*X1      STRIP *ARG2* DOWN TO 18 BITS 
          LX1    18D
          BX4    X4+X1       X4 CONTAINS COMPOSITE ARG  
          EQ     MTR2     
      
          END   
          IDENT  ENDRUN     
          ENTRY    ENDRUN 
          SST 
          B1=1
          LIST   F
          TITLE  ENDRUN - END CENTRAL PROGRAM.  
          COMMENT   ENDRUN. 
 ENDRUN   SPACE  4,10 
***       ENDRUN - END CENTRAL PROGRAM. 
* 
*         CALL ENDRUN 
* 
*         ENTRY  NONE 
* 
*         EXIT   DOES NOT EXIT
  
  
 ENDRUN   SUBR    
          SB1    1
          ENDRUN
  
          END 
          IDENT  RECALL 
          ENTRY  RECALL 
          SST 
          B1=1
          LIST   F
          TITLE  RECALL - PLACE PROGRAM IN RECALL STATUS. 
          COMMENT   PLACE PROGRAM IN RECALL STATUS. 
 RECALL   SPACE  4,10 
***       RECALL - PLACE PROGRAM IN RECALL STATUS.
* 
*         CALL RECALL (STATUS)
* 
*         ENTRY  (STATUS) = 0, ONE SYSTEM PERIODIC RECALL IS ISSUED 
*                         = OTHER, PROGRAM IS RECALLED WHEN BIT 0 IS SET
* 
*         EXIT   NONE IF (STATUS) =0
*         ELSE   BIT 0 OF STATUS IS SET 
  
  
 RECALL   SUBR    
          SB1    1
          SA2    X1          STATUS WORD
          ZR,X2  REC1        IF SINGLE RECALL 
          RECALL X1          ELSE, AUTO-RECALL
          EQ     RECALL     
  
 REC1     RECALL
          EQ     RECALL     
  
          END 
          IDENT  RTIME
          ENTRY  RTIME
          SST 
          B1=1
          LIST   F
          TITLE  RTIME - OBTAIN REAL TIME CLOCK READING.
          COMMENT   OBTAIN REAL TIME CLOCK READING. 
 RTIME    SPACE  4,10 
***       RTIME - OBTAIN REAL TIME CLOCK READING. 
* 
*         CALL RTIME (STATUS) 
* 
*         ENTRY  NONE 
* 
*         EXIT   (STATUS) = RESPONSE
*         KRONOS RESPONSE - 
**T       24/ SECONDS,36/ MILLISECONDS
* 
*         SCOPE RESPONSE -
**T       24/ JUNK,24/ SECONDS,12/ QM 
* 
*         TIME IS SYSTEM SOFTWARE CLOCK TIME SINCE DEADSTART
*         QM = 1/4096 OF A SECOND 
  
  
 RTIME    SUBR    
          SB1    1
          BX5    X1 
          RTIME  X1 
          SA1    X5 
          BX6    X1          RETURN RESPONSE AS FUNCTION RESULT 
          EQ     RTIME      
  
          END 
          IDENT  MOVECH 
          ENTRY  MOVECH 
          SST 
          SYSCOM B1 
 MOVECH   TITLE  MOVECH - MVC> INTERFACE FOR FTN. 
          COMMENT (FTN) MOVE CHARACTER STRINGS. 
 MOVECH   SPACE  4,10 
*****     MOVECH - MVC> INTERFACE FOR FTN.
* 
*         R. O. ANDERSON.     02/17/76. 
* 
*         FTN INTERFACE TO THE CHARACTER MOVE SUBROUTINE. 
 MOVECH   SPACE  4,10 
***       MOVECH - MOVE CHARACTER STRINGS.
* 
*         MOVECH SOURCE,OFFSETS,DESTINATION,OFFSETD,NCHARS
* 
*         MOVES *NCHARS* FROM *SOURCE* TO *DESTINATION*.
* 
*         ENTRY  *SOURCE* = THE ADDRESS OF THE FIRST WORD OF THE
*                           SOURCE STRING.
*                *OFFSETS* = THE CHARACTER OFFSET (0 - 131071) INTO 
*                            *SOURCE*.
*                *DESTINATION* = THE ADDRESS OF THE FIRST WORD OF 
*                                THE DESTINATION AREA.
*                *OFFSETD* = THE CHARACTER OFFSET (0 - 131071) INTO 
*                            *DESTINATION*. 
*                *NCHARS* = THE NUMBER OF CHARACTERS TO MOVE. 
*                (B1) = 1.
* 
*         EXIT   THE STRING HAS BEEN MOVED. 
* 
*         USES   X - 1, 2, 3, 4, 5, 6, 7. 
*                B - 2, 3, 4, 5.
*                A - 1, 2, 3, 4, 5, 6, 7. 
* 
*         CALLS  MVC>.
  
  
          PURGMAC MOVECH
 MOVECH   MACRO  SOURCE,OFFSETS,DEST,OFFSETD,NCHARS 
          R=     A1,SOURCE
          R=     B2,OFFSETS 
          R=     A2,DEST
          R=     B3,OFFSETD 
          R=     B4,NCHARS
          RJ     =XMVC> 
          ENDM
 MOVECH   SPACE  4,10 
***       MOVECH PROVIDES AN FTN CALLABLE INTERFACE TO THE UNIVERSITY 
*         OR ARIZONA CHARACTER STRING MOVE SUBROUTINE.
* 
*         CALL MOVECH(SRC,BCPS,DEST,BCPD,NCHR)
* 
*         ENTRY  *SRC*  IS THE VARIABLE OR ARRAY CONTAINING THE FIRST 
*                       CHARACTER OF THE SOURCE STRING. 
*                *BCPS* IS THE BEGINNING CHARACTER POSITION FOR THE 
*                       STRING STARTING IN *SRC* (0 - 131071).
*                *DEST* IS THE VARIABLE OR ARRAY CONTAINING THE FIRST 
*                       CHARACTER OF THE DESTINATION STRING.
*                *BCPD* IS THE BEGINNING CHARACTER POSITION FOR THE 
*                       STRING STARTING IN *DEST* (0 - 131071). 
*                *NCHR* IS THE NUMBER OF CHARACTERS TO MOVE.
* 
*         EXIT   MOVECH WILL RETURN AFTER MOVEING *SRC* TO *DEST*.
* 
*         CALLS  MVC>.
  
  
 MOVECH   SUBR               ENTRY/EXIT 
          SB1    1           AND B1 SHALL BE 1
          BX2    X1 
          MX0    -6          ALSO USED BELOW
          AX2    24 
          BX2    -X0*X2 
          SB2    X2          GET CHARACTER VARIABLE OFFSET OR ZERO
          SA2    A1+B1
          SA1    X1          (A1) = ADDRESS OF SOURCE STRING
          SA3    A2+B1
          SA2    X2 
          SB2    B2+X2       (B2) = BCP OF SOURCE STRING
          SA2    X3          (A2) = ADDRESS OF DESTINATION STRING 
          AX3    24 
          BX3    -X0*X3 
          SB3    X3          GET CHARACTER VARIABLE OFFSET OR ZERO
          SA3    A3+B1
          SA4    X3 
          SB3    B3+X4       (B3) = BCP OF DESTINATION STRING 
          SA3    A3+B1
          SA4    X3 
          SB4    X4          (B4) = NUMBER OF CHARACTERS TO MOVE
          MOVECH A1,B2,A2,B3,B4  MOVE THE STRINGS 
          EQ     MOVECH      RETURN 
  
          END 
          IDENT    XCON 
          ENTRY    XCON 
          SST 
          SYSCOM   B1 
XCON      TITLE    XCON - CONNECT/DISCONNECT TERMINAL FILES.
XCON      SPACE    4,10 
**        XCON - CONNECT A FILE TO A TERMINAL.
* 
*         CALL XCON(FET,CODE) 
* 
*         ENTRY    (FET) = FET ADDRESS
*                  (CODE) = <0, DISCONNECT (RETURN) FILE  
*                            0, DPC CONNECT 
*                            1, 128 CHARACTER ASCII CONNECT 
*                            2, 256 CHARACTER ASCII CONNECT 
* 
*         EXIT     FILE CONNECTED TO THE TERMINAL 
* 
XCON      SUBR     =
          SB1      1
          SX2      X1              (X2) = FET ADDRESS 
          SA1      A1+B1
          SA1      X1 
          BX3      X1              (X3) = FUNCTION CODE 
          NG       X3,XCON2        IF ONLY DISCONNECT 
          STATUS   X2              CHECK IF LOCAL 
          MX0      11 
          LX0      1
          SA4      X2              GET FET+0
          BX4      -X0*X4 
          ZR       X4,XCON3        IF NOT LOCAL 
XCON1     OPEN     X2,NR,R         CHECK DEVICE TYPE      
          SA4      X2              CLEAR ALL BUT FN+COMPLETE
          MX0      43 
          LX0      1
          BX6      X0*X4
          SA6      X2 
          SA4      X2+B1           CHECK FOR CT DEVICE    
          AX4      48 
          SX4      X4-2RCT-774000B
          ZR       X4,=XXCON       IF ALREADY CT DEVICE, RETURN 
XCON2     EVICT    X2,R            RETURN LOCAL COPY      
          NG       X3,=XXCON       IF ONLY DISCONNECT, RETURN       
XCON3     SA1      X2              SET FILENAME FOR ASSIGN
          MX0      48       
          BX6      X0*X1    
          SA6      XCONB
          SX3      B1             SET COMPLETE  
          BX6      X6+X3    
          SA6      X2 
          SX4      X2              SAVE FET ADDRESS 
          SYSTEM   PCC,AR,XCONA    CREATE THE CT FILE 
          SX2      X4 
XCON4     SA1      X2              GET FET+0
          MX0      43              KEEP FN+COMPLETE 
          LX0      1
          BX1      X0*X1
          MX7      1               ASCII BIT MASK 
          LX7      43 
          NZ       X3,XCON5        IF NOT DPC CHAR SET    
          BX6      X1              STORE FET+0
          SA6      X2 
          SA1      X2+B1           CLEAR ASCII BIT
          BX6      -X7*X1 
          SA6      A1 
          EQ       =XXCON 
XCON5     SA4      X2+B1           SET ASCII BIT IN FET+1 
          BX6      X4+X7
          SB3      X3 
          SB3      B3-B1    
          NZ       B3,XCON6        IF 256 CHAR ASCII      
          SA6      A4 
          BX6      X1              SET FET+0  
          SA6      X2 
          EQ       =XXCON 
XCON6     SB3      B3-B1    
          NZ       B3,=XXCON       IF INVALID MODE
          SA6      A4 
          BX6      X1+X3           SET ODD BIT FOR 256 CHAR ASCII   
          SA6      X2              SET FET+0
          EQ       =XXCON   
  
XCONA     DATA     H*.ASSIGN,CT,*     
XCONB     DATA     0
          END 
          IDENT  XSCS 
          ENTRY  XSCS 
          SST 
          B1=1
 XSCS     TITLE  XSCS - SCS INTERFACE FOR FTN.
          COMMENT (FTN) SENSE CHARACTER SET.
 XSCS     SPACE  4,10 
*****     XSCS - SCS INTERFACE FOR FTN. 
* 
*         S. H. JAY          83/02/04.
* 
*         FTN INTERFACE TO THE SENSE CHARACTER SET ROUTINE. 
 XSCS     SPACE  4,10 
***       XSCS PROVIDES AN FTN CALLABLE LINK TO THE UNIVERSITY
*         OF ARIZONA SENSE CHARACTER SET SUBROUTINE.
* 
*         N = XSCS(FET) 
* 
*         ENTRY  *FET* IS ARRAY CONTAINING AN FET.  A READ SHOULD 
*                BE DONE ON THIS FET BEFORE CALLING XSCS. 
* 
*         EXIT   *N* = 1 FOR DISPLAY CODE,
*                      0 IF BUFFER EMPTY, 
*                      -1 IF ASCII. 
* 
*         CALLS  SCS> 
  
  
 XSCS     SUBR               ENTRY/EXIT 
          SB1    1
          SX2    X1          (X2) = FET ADDRESS 
          RJ     =XSCS> 
          EQ     XSCS        RETURN 
  
          END 
          IDENT  XSXT 
          ENTRY  XSXT 
          SYSCOM B1 
 XSXT     TITLE  XSXT - SXT> INTERFACE FOR FTN. 
          COMMENT (FTN) CONVERT SIXBIT TO TWELVEBIT.
 XSXT     SPACE  4,10 
*****     XSXT - SXT> INTERFACE FOR FTN.
* 
*         R. O. ANDERSON.     02/17/76. 
* 
*         L. N. SHIPP.       80/05/09.  FIX MCS PARAMETER TYPO. 
* 
*         FTN INTERFACE TO THE SIXBIT TO TWELVEBIT CHARACTER CONVERSION 
*         ROUTINE.
 MCS      SPACE  4,10 
***       MCS - MAP CHARACTER SETS INTO OTHER CHARACTER SETS. 
* 
*         MCS    IN=,INLEN=,INBS=,OUT=,OUTBS=,TABLE=
* 
*         CONVERTS THE CHARACTERS IN *IN* VIA *TABLE* PLACING THEM
*         IN *OUT*. 
* 
*         ENTRY  *IN=* THE ADDRESS OF THE FIRST WORD OF THE INPUT 
*                      CHARACTER STRING.
*                *INLEN=* THE LENGTH OF THE INPUT STRING IN WORDS.
*                *INBS=* THE BYTE SIZE (6 OR 12) OF THE INPUT CHARS.
*                *OUT=* THE ADDRESS OF THE FIRST WORD OF THE OUTPUT 
*                       CHARACTER STRING BUFFER. IF *OUTBS* IS .LE. 
*                       *INBS*, *OUT* AND *IN* MAY POINT TO THE SAME
*                       AREA. 
*                *OUTBS=* THE BYTE SIZE (6 OR 12) OF THE OUTPUT CHARS.
*                *TABLE=* THE ADDRESS OF THE CHARACTER SET MAPPING
*                         TABLE.  THIS TABLE HAS 1 ENTRY PER WORD,
*                         RIGHT JUSTIFIED WITH BINARY ZERO FILL.
*                (B1) = 1.
* 
*         EXIT   THE CHARACTERS HAVE BEEN MAPPED. 
* 
*         USES   X - 1, 2, 6, 7.
*                B - 2, 3, 4, 5.
*                A - 1, 2, 6. 
* 
*         CALLS  SXS>, SXT>, TXS>, OR TXT>. 
  
  
          PURGMAC MCS 
 MCS      MACROE IN,INLEN,OUT,INBS,OUTBS,TABLE
          R=     B2,IN
          R=     B3,INLEN 
          R=     B4,OUT 
          R=     B5,TABLE 
          IFEQ   INBS,6,2 
 ^%S"MCS1 MICRO  1,, S
          SKIP   4
          IFEQ   INBS,12D,2 
 ^%S"MCS1 MICRO  1,, T
          SKIP   1
          ERR    INPUT BYTE SIZE MUST BE 6 OR 12. 
          IFEQ   OUTBS,6,2
 ^%S"MCS2 MICRO  1,, S
          SKIP   4
          IFEQ   OUTBS,12D,2
 ^%S"MCS2 MICRO  1,, T
          SKIP   1
          ERR    OUTPUT BYTE SIZE MUST BE 6 OR 12.
          RJ     =X'^%S"MCS1'X'^%S"MCS2'> 
          ENDM
 XSXT     SPACE  4,10 
***       XSXT PROVIDES AN FTN CALLABLE LINK TO THE UNIVERSITY OF 
*         ARIZONA SIXBIT TO TWELVEBIT CHARACTER CONVERSION ROUTINE. 
* 
*         CALL XSXT(IN,LEN,OUT,TBL) 
* 
*         ENTRY  *IN*   IS A VARIABLE OR ARRAY CONTAINING THE 
*                       CHARACTERS TO BE CONVERTED (10 PER WORD). 
*                *LEN*  IS THE WORD LENGTH OF THE ARRAY *IN*. 
*                *OUT*  IS THE VARIABLE OR ARRAY TO RECEIVE THE 
*                       CONVERTED CHARACTERS (5 PER WORD).
*                *TBL*  IS AN ARRAY CONTAINING THE CONVERSION TABLE.
*                       THIS TABLE CONTAINS 1 CHARACTER PER WORD, 
*                       RIGHT JUSTIFIED, WITH BINARY ZERO FILL. 
* 
*         EXIT   XSXT WILL RETURN AFTER DOING THE CONVERSION. 
* 
*         CALLS  SXT>.
  
  
 XSXT     SUBR               ENTRY/EXIT 
          SB1    1           AND B1 SHALL BE 1
          SB2    X1          (B2) = INPUT AREA ADDRESS
          SA1    A1+B1
          SA2    X1 
          SB3    X2          (B3) = WORD LENGTH OF INPUT
          SA1    A1+B1
          SB4    X1          (B4) = OUTPUT AREA ADDRESS 
          SA1    A1+B1
          SB5    X1          (B5) = CONVERSION TABLE ADDRESS
          MCS    IN=B2,INLEN=B3,OUT=B4,TABLE=B5,INBS=6,OUTBS=12 
          EQ     XSXT        RETURN 
  
          END 
          IDENT  XTXS 
          ENTRY  XTXS 
          SYSCOM B1 
 XTXS     TITLE  XTXS - TXS> INTERFACE FOR FTN. 
          COMMENT (FTN) CONVERT TWELVEBIT TO SIXBIT.
 XTXS     SPACE  4,10 
*****     XTXS - TXS> INTERFACE FOR FTN.
* 
*         R. O. ANDERSON.     02/17/76. 
* 
*         L. N. SHIPP.       80/05/09.  FIX MCS PARAMETER TYPO. 
* 
*         FTN INTERFACE TO THE TWELVEBIT TO SIXBIT CHARACTER CONVERSION 
*         ROUTINE.
 MCS      SPACE  4,10 
***       MCS - MAP CHARACTER SETS INTO OTHER CHARACTER SETS. 
* 
*         MCS    IN=,INLEN=,INBS=,OUT=,OUTBS=,TABLE=
* 
*         CONVERTS THE CHARACTERS IN *IN* VIA *TABLE* PLACING THEM
*         IN *OUT*. 
* 
*         ENTRY  *IN=* THE ADDRESS OF THE FIRST WORD OF THE INPUT 
*                      CHARACTER STRING.
*                *INLEN=* THE LENGTH OF THE INPUT STRING IN WORDS.
*                *INBS=* THE BYTE SIZE (6 OR 12) OF THE INPUT CHARS.
*                *OUT=* THE ADDRESS OF THE FIRST WORD OF THE OUTPUT 
*                       CHARACTER STRING BUFFER. IF *OUTBS* IS .LE. 
*                       *INBS*, *OUT* AND *IN* MAY POINT TO THE SAME
*                       AREA. 
*                *OUTBS=* THE BYTE SIZE (6 OR 12) OF THE OUTPUT CHARS.
*                *TABLE=* THE ADDRESS OF THE CHARACTER SET MAPPING
*                         TABLE.  THIS TABLE HAS 1 ENTRY PER WORD,
*                         RIGHT JUSTIFIED WITH BINARY ZERO FILL.
*                (B1) = 1.
* 
*         EXIT   THE CHARACTERS HAVE BEEN MAPPED. 
* 
*         USES   X - 1, 2, 6, 7.
*                B - 2, 3, 4, 5.
*                A - 1, 2, 6. 
* 
*         CALLS  SXS>, SXT>, TXS>, OR TXT>. 
  
  
          PURGMAC MCS 
 MCS      MACROE IN,INLEN,OUT,INBS,OUTBS,TABLE
          R=     B2,IN
          R=     B3,INLEN 
          R=     B4,OUT 
          R=     B5,TABLE 
          IFEQ   INBS,6,2 
 ^%S"MCS1 MICRO  1,, S
          SKIP   4
          IFEQ   INBS,12D,2 
 ^%S"MCS1 MICRO  1,, T
          SKIP   1
          ERR    INPUT BYTE SIZE MUST BE 6 OR 12. 
          IFEQ   OUTBS,6,2
 ^%S"MCS2 MICRO  1,, S
          SKIP   4
          IFEQ   OUTBS,12D,2
 ^%S"MCS2 MICRO  1,, T
          SKIP   1
          ERR    OUTPUT BYTE SIZE MUST BE 6 OR 12.
          RJ     =X'^%S"MCS1'X'^%S"MCS2'> 
          ENDM
 XTXS     SPACE  4,10 
***       XTXS PROVIDES AN FTN CALLABLE LINK TO THE UNIVERSITY OF 
*         ARIZONA TWELVEBIT TO SIXBIT CHARACTER CONVERSION ROUTINE. 
* 
*         CALL XTXS(IN,LEN,OUT,TBL) 
* 
*         ENTRY  *IN*   IS A VARIABLE OR ARRAY CONTAINING THE 
*                       CHARACTERS TO BE CONVERTED (5 PER WORD).
*                *LEN*  IS THE WORD LENGTH OF THE ARRAY *IN*. 
*                *OUT*  IS THE VARIABLE OR ARRAY TO RECEIVE THE 
*                       CONVERTED CHARACTERS (10 PER WORD). 
*                *TBL*  IS AN ARRAY CONTAINING THE CONVERSION TABLE.
*                       THIS TABLE CONTAINS 1 CHARACTER PER WORD, 
*                       RIGHT JUSTIFIED, WITH BINARY ZERO FILL. 
* 
*         EXIT   XTXS WILL RETURN AFTER DOING THE CONVERSION. 
* 
*         CALLS  TXS>.
  
  
 XTXS     SUBR               ENTRY/EXIT 
          SB1    1           AND B1 SHALL BE 1
          SB2    X1          (B2) = INPUT AREA ADDRESS
          SA1    A1+B1
          SA2    X1 
          SB3    X2          (B3) = WORD LENGTH OF INPUT
          SA1    A1+B1
          SB4    X1          (B4) = OUTPUT AREA ADDRESS 
          SA1    A1+B1
          SB5    X1          (B5) = CONVERSION TABLE ADDRESS
          MCS    IN=B2,INLEN=B3,OUT=B4,TABLE=B5,INBS=12,OUTBS=6 
          EQ     XTXS        RETURN 
  
          END 
          IDENT  XVFN 
          ENTRY  XVFN 
          SST 
          SYSCOM B1 
          TITLE  XVFN - VALIDATE FILE NAME. 
          COMMENT (FTN) VALIDATE FILE NAME. 
 XVFN     SPACE  4,10 
***       XVFN - VALIDATE FILE NAME.
* 
*         ANS = XVFN (LFN)
* 
*         ENTRY  *LFN* = LOGICAL FILE NAME.  TRAILING SPACES WILL BE
*                        DELETED BEFORE NAME IS VALIDATED.
* 
*         EXIT *ANS* = 0 IF FILE NAME IS VALID. 
  
  
 XVFN     SUBR               ENTRY/EXIT 
          SB1    1
          SB6    XVFNA
          SB7    B1 
          RJ     =XMFS>      WORD ALIGN THE LFN 
          SA1    XVFNA
          RJ     =XBTZ>      CONVERT BLANKS TO 00B
          BX1    X6 
          RJ     =XVFN>      CHECK OUT THE NAME 
          BX6    X1          SET FUNCTION VALUE 
          EQ     XVFNX       RETURN 
  
 XVFNA    BSS    1
  
          END 
          IDENT  RETFILE
          SST 
          ENTRY  RETFILE,UNLFILE
          SYSCOM B1 
 RETFILE  TITLE  RETFILE - RETURN/UNLOAD A FILE.
          COMMENT RETURN/UNLOAD A FILE. 
          SPACE  4,10 
***       RETFILE - RETURN/UNLOAD A FILE. 
* 
*         CALL RETFILE(LFN) 
*         CALL UNLFILE(LFN) 
* 
*         ENTRY  LFN = A HOLLERITH STRING OR A CHARACTER STRING 
*                      CONTAINING THE NAME OF THE FILE TO BE RETURNED 
*                      (RETFILE) OR UNLOADED (UNLFILE).  SPACES ARE 
*                      REMOVED FROM LFN BEFORE PROCESSING.
* 
*         EXIT   FILE IS GONE.
 RETFILE  SPACE  4,10 
**        RETFILE - CLOSE/RETURN A FILE.
  
  
 RETFILE  SUBR               ENTRY/EXIT 
          SB1    1           B1=1 
          RJ     SFF         SET FILE NAME IN FET 
          CLOSE  RETFILEA,UNLOAD,RCL
          EQ     RETFILEX    RETURN 
 UNLFILE  SPACE  4,10 
**        UNLFILE - CLOSE/UNLOAD A FILE.
  
  
 UNLFILE  SUBR               ENTRY/EXIT 
          SB1    1           B1=1 
          RJ     SFF         SET FILE NAME IN FET 
          CLOSE  RETFILEA,UNLOAD,RCL
          EQ     UNLFILEX    RETURN 
 SFF      SPACE  4,10 
**        SFF - SET FILE NAME IN FET. 
* 
*         ENTRY  (X1) = FTN PARAMETER POINTER FOR LFN.
* 
*         EXIT   (RETFILEA) CONTAINS LFN + COMPLETE BIT.
* 
*         USES   X - 1, 2, 6, 7.
*                B - 2, 3, 4, 5, 6, 7.
*                A - 2, 6.
* 
*         CALLS  BTZ>, MACWAL=. 
  
  
 SFF      SUBR               ENTRY/EXIT 
          RJ     =XMACWAL=   GET THE FILE NAME
          BX1    X2 
          RJ     =XBTZ>      DELETE ANY SPACES
          SA1    RETFILEA 
          SX1    B1 
          BX6    X6+X1       ADD COMPLETE BIT 
          SA6    RETFILEA    STASH IN FET 
          EQ     SFFX        RETURN 
  
 RETFILEA VFD    42/**,18/1 
          CON    100B        FIRST
          CON    100B        IN 
          CON    100B        OUT
          CON    101B        LIMIT
  
          END 
