.ENABLE SUBSTITUTION
.IF P1 NE "" .GOTO INTIAL
.;BLDLAB - BUILD LABORATORY DATA ACQUISITION PROGRAMS
.OPEN TI:
.ENABLE DATA

 This command file is used to build various data acquisition programs.
 It is invoked by issuing :
  
	@BLDLAB [Fortran File] [Option]		(Do not use extensions)
  
 If a Fortran file is not given, the command file will ask for one.
  
 The Options available are :
  
	M=[Name]	Build the given macro file and include in task
	OL=[Name]	Include the given Object Library in Task Build
	/N		Do not include another routine
  
 If no option is given then you will be asked for one.
   
.DISABLE DATA
.CLOSE TI:

.INTIAL:
.SETS FTN ""
.SETS MAC ""
.SETS OLB ""
.SETS MACS ""
.SETS OLBS ""
.SETS ME "M="					!ME is M=  (M Equals)
.SETS OE "OL="					!OE is OL= (Ol Equals)
.SETS SN "/N"					!SN is /N  (Slash N)
.SETF LABWRK

.; Given a Fortran file name?
.IF P1 EQ "" .GOTO GETNAM			!No, well go get one
.SETS FTN P1
.GOTO TSTFIL

.GETNAM:
.; Get the Fortran file's name :
.ASKS FTN Enter the Fortran name

.TSTFIL:
.; See if the file exists :
.TESTFILE 'FTN'.FTN				!Is 'FTN' there?
.IF <FILERR> NE 1 .GOTO MISFTN			!No, then we have problems


.; Decode the second option :
.SETS PARM P2
.IF PARM EQ "" .GOTO DECIDE
.IF ME EQ PARM[1:2] .GOTO USEMAC
.IF OE EQ PARM[1:3] .GOTO USEOLB
.IF SN EQ PARM[1:2] .GOTO BLDFTN
;Undefined Switch - 'PARM'

.DECIDE:
.; Let the user make a decision about what to use :
.OPEN TI:
.ENABLE DATA
 Do you want to :
       A) Build with an object library
       B) Build with a macro utility file (like LABWORK.MAC)
       C) None of the above
.DISABLE DATA
.CLOSE TI:
.ASKS OPTION Enter Option
.IF OPTION EQ "A" .GOTO GETOLB
.IF OPTION EQ "B" .GOTO GETMAC
.IF OPTION EQ "C" .GOTO BLDFTN
; !!! PLEASE ENTER A, B, or C !!!
.GOTO DECIDE

.GETOLB:
.ASKS OLB Enter the name of the Object Library
.GOTO TSTOLB

.GETMAC:
.ASKS MAC Enter the name of the macro file
.GOTO TSTMAC

.USEMAC:
.; Set up for use of a macro file:
.TEST PARM
.SETN LEN <STRLEN>
.SETS MAC PARM[3:LEN]
.TSTMAC:
.;Is 'MAC'.MAC there?
.TESTFILE 'MAC'.MAC
.IF <FILERR> NE 1 .GOTO MISMAC			!No, then we have problems
.SETS MACS ",'MAC'"
.SETT LABWRK
.GOTO BLDFTN

.USEOLB:
.;Set up for use of an Object Library:
.TEST PARM
.SETN LEN <STRLEN>
.SETS OLB PARM[4:LEN]
.TSTOLB:
.;Is 'OLB'.OLB there?
.TESTFILE 'OLB'.OLB
.IF <FILERR> NE 1 .GOTO MISOLB			!No, then we have problems
.SETS OLBS ",'OLB'/LB"
.SETF LABWRK

.BLDFTN:
.; Build the object file(s) :
PIP 'FTN'.OBJ;*/DE/NM,'FTN'.LST;*
F77 'FTN','FTN'/-SP='FTN'/NOCK/NOTR
.IF <EXSTAT> NE 1 .GOTO FTNERR			!Oops
.IFF LABWRK .GOTO COMPIL
PIP 'MAC'.OBJ;*/DE/NM,'MAC'.LST;*
MAC 'MAC','MAC'/-SP='MAC'
.IF <EXSTAT> NE 1 .GOTO MACERR			!Oops

.COMPIL:
.; Do the task building :
.OPEN 'FTN'.BLD
.ENABLE DATA
'FTN'/PR:0/-CP,'FTN'/-SP='FTN''MACS''OLBS'
/
@LB:[1,54]LNK2KCOM
PRI=150
//
.DISABLE DATA
.CLOSE
PIP 'FTN'.TSK;*/DE/NM,'FTN'.MAP;*
TKB @'FTN'.BLD
.IF <EXSTAT> NE 1 .GOTO BLDERR
PIP 'FTN'.BLD;*/DE/NM
.EXIT

.; ERROR MESSAGES :

.MISFTN:
;'FTN'.FTN IS MISSING!!
.EXIT

.MISOLB:
;'OLB'.OLB IS MISSING!!
.EXIT

.MISMAC:
;'MAC'.MAC IS MISSING!!
.EXIT

.FTNERR:
;ERROR ON FORTRAN BUILD OF 'FTN'
.EXIT

.MACERR:
;ERROR ON MACRO BUILD OF 'MAC'
.EXIT

.BLDERR:
;TASK BUILD ERROR
.EXIT
