@Part(CMSMIT,root="USER")
@Chapter<IBM VM/CMS KERMIT>
@Begin<Description,Leftmargin +12,Indent -12,spread 0>
@i(Author:)@\Daphne Tzoar, Columbia University

@i(Version:)@\( @i<unnumbered> )

@i(Date: )@\February 1983
@end<Description>

@Index[IBM]@Index[VM/CMS]@Index[Timeout]
 Written in IBM 370 assembly language to run under VM/CMS on IBM 370-@|series
mainframes (System/370, 303x, 43xx, 308x, ...).  These are half duplex systems;
the communication line must "turn around" before any data can be sent to it.
The fact that a packet has been received from the IBM system is no guarantee
that it is ready for a reply.  Thus any Kermit talking to this system must wait
for the line turnaround character (XON) before transmitting the next character.

IBM systems talk to their terminals through a communications front end (IBM
3705, 3725, COMTEN 3670, etc).  These front ends generally insist on using the
8th bit of each character for parity.  This means that binary files (files
containing other than ordinary letters, digits, punctuation, carriage returns,
tabs, and so forth) can @i<not> be correctly sent or received by these systems
with Kermit (protocol version 1).

The IBM system under VM/CMS is unable to interrupt a read on its "console".
This means that the IBM version of Kermit cannot timeout.  The only way to
"timeout" CMS Kermit is from the other side -- typing a carriage return to the
micro's Kermit causing it to retransmit its last packet, or an automatic
timeout as provided by Kermit-20.  For this reason, CMS Kermit waits ten
seconds before sending its first packet when sending files from VM/CMS.  
This gives the user sufficient time to return to the local Kermit and issue
the Receive command.  Otherwise, a protocol deadlock would arise requiring
manual intervention by the user.

Also, VM/CMS stores files as records rather byte streams.  VM/CMS Kermit has to
worry about assembling incoming data packets into records and stripping CRLFs
from incoming lines, and also appending CRLFs to -- and stripping trailing
blanks from -- outgoing records.

The VM/CMS file specification is in the form
@example<FILENAME FILETYPE FILEMODE>
(abbreviated FN FT FM).  FM is equivalent to a device specification on DEC or
microcomputer systems (@w<@q[FN FT FM]> would translate to @q<FM:FN.FT>).
FILENAME and FILETYPE are at most 8 characters in length, each, and FILEMODE at
most 2.  When FILEMODE is omitted from a filespec, the user's own disk is
assumed.  Kermit-CMS sends only FILENAME and FILETYPE, and converts the
intervening blank to a period for compatibility with most other operating
systems.  Kermit-CMS Commands:
@begin<description,leftmargin +8,indent -8>
@Index[SEND]
SEND @i<fn ft> [@i<fm>]@\Send the specified file(s), using @q<*> or @q<%> as
the wildcard characters (@q<*> will match any number of characters while @q<%>
matches only one).  Kermit-CMS assumes the file is located on the A disk, and
sets the filemode to A1.  If, however, the file is located on a different disk,
the filemode must be cited.  Also, note that if you use @q<*> for the filemode,
Kermit-CMS will send only the first file that matches.  Examples:
@begin<quotation>
The command @q<SEND CEN SPSS> will send CEN SPSS A1.  To send the same
file located on your B disk, you must specify: @q<SEND CEN SPSS B>.
@q<SEND * FORTRAN> will send all fortran files on your A disk.
@q<SEND ABC% EXEC> will send all exec files with a four letter filename 
beginning with ABC. If you have the file PLOT SAS on your A disk and your B
disk, @q<@w(SEND PLOT SAS *)> will send PLOT SAS A1.
@end<quotation>

@Index[RECEIVE]
 RECEIVE [@i<fn ft> [@i<fm>]]@\ Receive the file(s) sent from the
other Kermit.  If a file specification is not included, Kermit-CMS will use the
name(s) provided by the other Kermit.  Use the file specification to indicate a
different filename or a disk other than the A disk (in this case, the file name
and type must also be supplied or @w(@q<= = FM>) can be used.)  Examples:
 @begin<Quotation>
 To receive files using the filename(s) sent by the micro, use:
@q<RECEIVE>.  To save a file under a different name, specify:
@q<RECEIVE ABC FORTRAN>.  To save the file under the same name but on the
B disk, specify: @q<RECEIVE ABC FORTRAN B>, or @q<RECEIVE @w(= = B)>.
 @End<Quotation>

@Index[SET]
SET @i<parameter> @i<value>@\Set the parameter to the specified value.
Legal Set commands are:
 @begin<description,leftmargin +8,indent -8>
@index[RECFM]
RECFM @i<option>@\Denotes the record format to be used when creating the
file.  Only fixed and variable length records are allowed, where
variable is the default.  Indicate the desired record format by either
an F (fixed) or a V (variable).

@index[LRECL]
LRECL @i<decimal-number>@\Indicates the logical record length.  The default is
80, and the maximum allowed is 256.

@index[Quote]
QUOTE @i<decimal-number>@\The ASCII value of the control prefix character you
wish to use in place of the default (@q<#>).  It must be a single, printable
character from among the following: 33-62, 96, or 123-126 (decimal).

@index[End-Of-Line (EOL)]
END @i<decimal-number>@\Indicates the ASCII value of the end-@|of-@|line
character you choose to send.  The default is CR (ASCII 13 decimal), but can be
set to any two digit number between 00 and 31 (decimal).

@index[Packet-Length]
PAC @i<decimal-number>@\Allows the user to specify the packet size the micro
should use when sending to Kermit-CMS.  The range is 26-94, where
94 is the default.
 @end<description>

@index[SHOW]
SHOW @i<parameter>@\Displays the current value of any variable that can
be changed via the SET command.

STATUS@\Returns the status of the previous execution of Kermit-CMS.
Therefore, STATUS will either display the message "Kermit completed
successfully", or the last error encountered prior to aborting.

CMS@\Issues a CMS command from within Kermit-CMS.

CP@\Issues a CP command from within Kermit-CMS.

@q<?>@\Lists all legal Kermit-CMS commands.
 @end<description>

This is a list of other salient facts about Kermit-CMS:
 @begin<enumerate>
 The commands are supplied with a help option, so a question mark can
be typed to get the appropriate format or a list of options.  The
question mark, however, must be followed by a carriage return;
Kermit-CMS will respond and display the prompt again.  For instance,
@q<SET ?> will list all valid options for the SET command.

When receiving files, if the record format is fixed, any record longer
than the logical record length will be truncated.  If the record format
is variable, the record length can be as high as 256.  For sending
files, the maximum record length is 256.

Before connecting to the IBM mainframe from other systems (like the various
microcomputer and PC Kermits, DEC-20 Kermit, etc), you should set the IBM flag
ON so that echoing, parity, and handshaking can be done the way the IBM system
likes.

Note that "(" and ")" act as word separators on the input line.  Therefore, if
you try to set the quote character to "(*" or "*(", for example, only the first
character will be used.

Since some Kermits do not send an error packet when they "abort",
Kermit-CMS does not always know the micro has stopped sending it information.
Therefore, when you connect back to the IBM, Kermit-CMS may still be
sending packets (they will appear on the screen).  The user must hit a
carriage return until Kermit-CMS has sent the maximum number of
packets allowed and aborts.  The error message, however, will not
indicate that communication stopped because the micro aborted, but
rather that no start of header character was found.

The minimum send packet size Kermit-CMS will allow is 26.  This is necessary to
avoid an error while sending the filename or an error packet.  If the micro
tries to set the value to be less than 26, Kermit-CMS will immediately abort
with an error of "Bad send-packet size."

While the IBM's communication front end processor translates all incoming
characters from ASCII terminals to EBCDIC, Kermit-CMS translates the
data it reads back to ASCII (characters not representable in ASCII are replaced
by a null).  Not only is it easier to work with ASCII characters, but it makes
things more consistent throughout the many versions of Kermit.  When the
packets are sent to the micro, Kermit-CMS converts all data back to EBCDIC.
The ASCII to EBCDIC translation table can be found in the Appendix.

If a transfer becomes stuck, you can CONNECT back to the CMS system and type a
lot of carriage returns -- each one will cause KERMIT-CMS to retransmit the
current packet, until the retransmission limit is reached, and you will be back
at "KERMIT-CMS>" command level.

Kermit-CMS supplies the micro and the user with numerous error messages.  If
the execution must be abnormally terminated, an error packet is sent to the
micro before Kermit-CMS stops.  The same message can be retrieved via the
STATUS command when Kermit-CMS returns and displays the prompt.  If Kermit-CMS
aborted because the maximum amount of retries was exceeded (20 on
initialization packets and 5 on others), the error message will display the
most recent error (i.e.@ the last NAK Kermit-CMS encountered).  If execution
stops because the micro gave up, the error message will convey that to the
user, but it is the micro's responsibility to pinpoint the error.  The messages
Kermit-CMS gives are as follows:
 @begin<description,leftmargin +4,indent -4,spread 0>
 "Bad send-packet size"@\ Sent when the micro attempts to set its
receive buffer size to a value that is less than 26 (the minimum that
Kermit-CMS will accept) or larger than 94, the maximum.  It will also
occur if Kermit-CMS tries to send a packet that is larger than the
maximum specified.

"Bad message number"@\This and the following messages flag inconsistencies in a
Kermit packet.

"Illegal packet type" -- This can be caused by sending server commands.

"Unrecognized State"@\

"No SOH encountered"@\

"Bad Checksum"@\

"Bad character count"@\

"Micro sent a NAK"

"Lost a packet"

"Micro aborted"@\The micro abnormally terminated the transfer.

"Illegal file name"@\ When receiving the name of the file from the
micro, Kermit-CMS expects it to be in the format 'filename.filetype'.
If the filename, filetype, or dot is missing, Kermit-CMS will reject
(NAK) the packet.  Also, if either the filename or filetype exceeds
eight characters, it will be truncated.

"Invalid lrecl"@\ Kermit-CMS will abort on any file-system error it
encounters when reading from the file it is to send.  It can only send
files with variable or fixed length record formats, therefore, Wylbur
Edit or Packed format files will cause an error.

"Permanent I/O error"@\ This signifies a permanent I/O error that
occured when reading from an existing file.  Execution is aborted
immediately.

"Disk is read-only"@\Attempt to write on a read-@|only disk.

"Recfm conflict"@\ If a filename conflict arises, Kermit-CMS will
append the received file to the existing one, provided the record
formats of the two are the same.  Otherwise, this error will cause a
halt of the execution.

"Disk is full"@\ Refers to any error regarding limitations on a user's
storage space.  Most likely, it signifies that the receiving disk is
full, but the error can also mean that the maximum number of files
allowed has been reached, or virtual storage capacity has been
exceeded, and so on.

"Err allocating space"@\ Kermit-CMS keeps a table of all files it has sent
to the micro, allocating extra space if more than ten files are sent at one
time.  If there is an error obtaining more space, Kermit-CMS will abort with
this error.  
 @End<Description>
 @End<Enumerate>

Work on VM/CMS Kermit continues.  Planned future enhancements include:
@begin<enumerate>
8-bit quoting, to allow binary files to pass through communication front
ends that insist on using the 8th bit for parity.

Ability to act as a Kermit Server.

Ability to SET LINE, so that Kermit-CMS can be used as a local
Kermit, connecting to a remote host over another communication port.
@end<enumerate>

