

@Appendix<The ASCII Character Set>
@index[ASCII]@index[EBCDIC]
@ux<ASCII Code (ANSI X3.4-1968)>

@label<-ascii>
There are 128 characters in the ASCII (American national Standard Code
for Information Interchange) "alphabet".  The characters are listed in
order of ASCII value; the columns are labeled as follows:
@begin<description,spread 0>
Bit@\Even parity bit for ASCII character.

ASCII Dec@\Decimal (base 10) representation.

ASCII Oct@\Octal (base 8) representation.

ASCII Hex@\Hexadecimal (base 16) representation.

EBCDIC Hex@\EBCDIC hexadecimal equivalent for Kermit translate tables.

Char@\Name or graphical representation of character.

Remark@\Description of character.
 @end<description>

@begin<text,need 8>
The first group consists of nonprintable 'control' characters:

@begin<verbatim,Group>
@Index(Control Characters)@Index(XON/XOFF)@Index[Parity]

     .....ASCII.... EBCDIC
@u<Bit  Dec   Oct  Hex  Hex    Char  Remarks>
 0   000   000   00   00    NUL   ^@@, Null, Idle
 1   001   001   01   01    SOH   ^A, Start of heading
 1   002   002   02   02    STX   ^B, Start of text
 0   003   003   03   03    ETX   ^C, End of text
 1   004   004   04   37    EOT   ^D, End of transmission
 0   005   005   05   2D    ENQ   ^E, Enquiry
 0   006   006   06   2E    ACK   ^F, Acknowledge
 1   007   007   07   2F    BEL   ^G, Bell, beep, or fleep
 1   008   010   08   16    BS    ^H, Backspace
 0   009   011   09   05    HT    ^I, Horizontal tab
 0   010   012   0A   25    LF    ^J, Line feed
 1   011   013   0B   0B    VT    ^K, Vertical tab
 0   012   014   0C   0C    FF    ^L, Form feed (top of page)
 1   013   015   0D   0D    CR    ^M, Carriage return
 1   014   016   0E   0E    SO    ^N, Shift out
 0   015   017   0F   0F    SI    ^O, Shift in
 1   016   020   10   10    DLE   ^P, Data link escape
 0   017   021   11   11    DC1   ^Q, Device control 1, XON
 0   018   022   12   12    DC2   ^R, Device control 2
 1   019   023   13   13    DC3   ^S, Device control 3, XOFF
 0   020   024   14   3C    DC4   ^T, Device control 4
 1   021   025   15   3D    NAK   ^U, Negative acknowledge
 1   022   026   16   32    SYN   ^V, Synchronous idle
 0   023   027   17   26    ETB   ^W, End of transmission block
 0   024   030   18   18    CAN   ^X, Cancel
 1   025   031   19   19    EM    ^Y, End of medium
 1   026   032   1A   3F    SUB   ^Z, Substitute
 0   027   033   1B   27    ESC   ^[, Escape, prefix, altmode
 1   028   034   1C   1C    FS    ^\, File separator
 0   029   035   1D   1D    GS    ^], Group separator
 0   030   036   1E   1E    RS    ^^, Record separator
 1   031   037   1F   1F    US    ^_, Unit separator
 @End<Verbatim>
 @End<Text>
 The last four are usually associated with the
control version of backslash, right square bracket, uparrow (or
circumflex), and underscore, respectively, but some terminals do not
transmit these control characters.

@begin<text,need 8>
The following characters are printable:

@Begin<Verbatim,Group>
@R<First, some punctuation characters.>

     .....ASCII.... EBCDIC
@u<Bit  Dec   Oct  Hex  Hex    Char  Remarks>
 1   032   040   20   40    SP    Space, blank
 0   033   041   21   5A    !     Exclamation mark
 0   034   042   22   7F    "     Doublequote
 1   035   043   23   7B    #     Number sign, pound sign
 0   036   044   24   5B    $     Dollar sign
 1   037   045   25   6C    %     Percent sign
 1   038   046   26   50    &     Ampersand
 0   039   047   27   7D    '     Apostrophe, accent acute
 0   040   050   28   4D    (     Left parenthesis
 1   041   051   29   5D    )     Right parenthesis
 1   042   052   2A   5C    *     Asterisk, star
 0   043   053   2B   4E    +     Plus sign
 1   044   054   2C   6B    ,     Comma
 0   045   055   2D   60    -     Dash, hyphen, minus sign
 0   046   056   2E   4B    .     Period, dot
 1   047   057   2F   61    /     Slash
@end<verbatim>
@end<text>

@Begin<Verbatim,Group>
@R<Numeric characters:>

     .....ASCII.... EBCDIC
@u<Bit  Dec   Oct  Hex  Hex    Char  Remarks>
 0   048   060   30   F0    0     Zero
 1   049   061   31   F1    1     One
 1   050   062   32   F2    2     Two
 0   051   063   33   F3    3     Three
 1   052   064   34   F4    4     Four
 0   053   065   35   F5    5     Five
 0   054   066   36   F6    6     Six
 1   055   067   37   F7    7     Seven
 1   056   070   38   F8    8     Eight
 0   057   071   39   F9    9     Nine
@End<Verbatim>

@Begin<Verbatim,Group>
@R<More punctuation characters:>

     .....ASCII.... EBCDIC
@u<Bit  Dec   Oct  Hex  Hex    Char  Remarks>
 0   058   072   3A   7A    :     Colon
 1   059   073   3B   5E    ;     Semicolon
 0   060   074   3C   4C    <     Left angle bracket
 1   061   075   3D   7E    =     Equal sign
 1   062   076   3E   6E    >     Right angle bracket
 0   063   077   3F   6F    ?     Question mark
 1   064   100   40   7C    @@     "At" sign
@End<Verbatim>

@Begin<Verbatim,Group>
@R<Upper-case alphabetic characters (letters):>

     .....ASCII.... EBCDIC
@u<Bit  Dec   Oct  Hex  Hex    Char  Remarks>
 0   065   101   41   C1    A
 0   066   102   42   C2    B
 1   067   103   43   C3    C
 0   068   104   44   C4    D
 1   069   105   45   C5    E
 1   070   106   46   C6    F
 0   071   107   47   C7    G
 0   072   110   48   C8    H
 1   073   111   49   C9    I
 1   074   112   4A   D1    J
 0   075   113   4B   D2    K
 1   076   114   4C   D3    L
 0   077   115   4D   D4    M
 0   078   116   4E   D5    N
 1   079   117   4F   D6    O
 0   080   120   50   D7    P
 1   081   121   51   D8    Q
 1   082   122   52   D9    R
 0   083   123   53   E2    S
 1   084   124   54   E3    T
 0   085   125   55   E4    U
 0   086   126   56   E5    V
 1   087   127   57   E6    W
 1   088   130   58   E7    X
 0   089   131   59   E8    Y
 0   090   132   5A   E9    Z
@End<Verbatim>

@Begin<Verbatim,Group>
@R<More punctuation characters:>

     .....ASCII.... EBCDIC
@u<Bit  Dec   Oct  Hex  Hex    Char  Remarks>
 1   091   133   5B   AD    [     Left square bracket
 0   092   134   5C   E0    \     Backslash
 1   093   135   5D   BD    ]     Right square bracket
 1   094   136   5E   5F    ^     Circumflex, up arrow
 0   095   137   5F   6D    _     Underscore, left arrow
 0   096   140   60   79    `     Accent grave
@End<Verbatim>

@Begin<Verbatim,Group>
@R<Lower-case alphabetic characters (letters):>

     .....ASCII.... EBCDIC
@u<Bit  Dec   Oct  Hex  Hex    Char  Remarks>
 1   097   141   61   81    a
 1   098   142   62   82    b
 0   099   143   63   83    c
 1   100   144   64   84    d
 0   101   145   65   85    e
 0   102   146   66   86    f
 1   103   147   67   87    g
 1   104   150   68   88    h
 0   105   151   69   89    i
 0   106   152   6A   91    j
 1   107   153   6B   92    k
 0   108   154   6C   93    l
 1   109   155   6D   94    m
 1   110   156   6E   95    n
 0   111   157   6F   96    o
 1   112   160   70   97    p
 0   113   161   71   98    q
 0   114   162   72   99    r
 1   115   163   73   A2    s
 0   116   164   74   A3    t
 1   117   165   75   A4    u
 1   118   166   76   A5    v
 0   119   167   77   A6    w
 0   120   170   78   A7    x
 1   121   171   79   A8    y
 1   122   172   7A   A9    z
@End<Verbatim>

@Begin<Verbatim,Group>
@R<More punctuation characters:>

     .....ASCII.... EBCDIC
@u<Bit  Dec   Oct  Hex  Hex    Char  Remarks>
 0   123   173   7B   C0     {    Left brace (curly bracket)
 1   124   174   7C   4F     |    Vertical bar
 0   125   175   7D   D0     }    Right brace (curly bracket)
 0   126   176   7E   7E     ~    Tilde

@End<Verbatim>

@Begin<Verbatim,Group>
@R<Finally, one more nonprintable character:>

 0    127   177  7F   07    DEL   Delete, rubout
@End<Verbatim>
