c-----------------------------------------------------------------------
c
c	Mischy month making subroutine
c
c	part of Mitch Wyle's DTC program
c
c	Inputs: 
c		ib	-	begining day of the week
c		il	-	length of month in days
c		xoff	-	offset for x coordinate
c		xspa	-	number of spaces to skip between numbers
c		yspa	-	number of lines to skip between lines
C		Ird     -       Bold day if > 0
c
c	Output:
c		display screen (see below)
c
c-----------------------------------------------------------------------
c
	OPTIONS/NOI4
	SUBROUTINE mischy(ib,il,xoff,xspa,YOFF,yspa,Ird)

c
c	Declarations:
c

	Character*1	Cesc	!       Escape
	Character*4	Cbold	!
	Character*4	Cnorm	!
	integer	ib		!	begining day of the week
	integer il		!	length of month in days
	integer ix		!	x coordinate of where to put day
	integer iy		!	y coordinate of where to put day
	integer ip		!	the day of the week for date in hand
	integer xoff		!	x offset
	INTEGER YOFF
	integer xspa		!	number of spaces between numbers
	integer yspa		!	number of lines to skip between lines
	Integer Ird		!       Day to bold if > 0
	DATA	Cesc	/27/
c
c	Initialize:
c
	
	Cbold=Cesc//'[1m'	!
	Cnorm=Cesc//'[0m'	!
	iterm = 6		!	Output terminal unit number
	iy = 4 + YOFF
	ip = ib - 1
C	If (yspa .ne. 0) iy = 12
c
c	Now write month out to screen, one day at a time:
c

	Do 5 i=1,il

	    ip = ip + 1			!	increment day number
	    If ( ip .gt. 7 ) then	!	is it Sunday again?
		ip = 1			!	reset day to Sunday.
		iy = iy + 1 + yspa	!	move down one line
	    End If
	    ix = (3+xspa) * ip - 2 + xoff
	    call dtcat(ix,iy)		!	position cursor
	    IF(Ird.NE.i)	THEN 
	      write(iterm,1) i		!	write day number to screen
1	      format('+',i2)
	    ELSE
	      write(Iterm,2) Cbold,I,Cnorm
2	      FORMAT('+',A,I2,A)
	    END IF

5	Continue
	
	return
	end
