/*
 * RSX11M V4.0 System Definition Headers for C.
 *
 * Structures and definitions for 'gtsk' function.
 * See the RSX-11M V4.0 Exec Reference Manual sec. 5.3.39
 *
 * INCLUDE CX.H PRIOR TO INCLUDING THIS FILE
 *
 * Bob Denny
 * 19-Oct-82
 */
struct	tparbf	{
		rad50   g_tstn[2];	/* RAD50 task name */
		rad50   g_tspn[2];	/* RAD50 part. name */
		word	g_udf1;		/* Undefined */
		word	g_udf2;		/* Undefined */
		word	g_tspr;		/* Task run priority */
		byte	g_tspc;		/* UIC member code */
		byte	g_tsgc;		/* UIC group code */
		word	g_tsnl;		/* Number of luns */
		word	g_udf3;		/* Undefined */
		word	g_udf4;		/* Undefined */
		address	g_tsva;		/* SST vector addr. */
		word	g_tsvl;		/* SST vector length */
		word	g_tsts;		/* Task window 0 size */
		word	g_tssy;		/* Oper. system code */
		word	g_tsdu;		/* Protection UIC */
		};

/*
 * Operating system codes
 */
#define  S_11D    0                    /* RSX-11D */
#define  S_11M    1                    /* RSX-11M */
#define  S_11S    2                    /* RSX-11S */
#define  S_IAS    3                    /* IAS */
#define  S_RSTS   4                    /* RSTS/RSX */
#define  S_VMS    5                    /* VMS/AME */
#define  S_11MP   6                    /* RSX-11M Plus */
#define  S_RTSJ   7                    /* RSX/RT-11 SJ */
#define  S_RTFB   010                  /* RSX/RT-11 FB */
#define  S_POS    011                  /* P/OS (Professional 350) */
