/*
 * GCCI data structures and symbolics
 *
 * INCLUDE CX.H PRIOR TO INCLUDING THIS FILE
 *
 * Bob Denny
 * 20-Oct-82
 */

/*
 * Command buffer
 */
struct cmdbuf  {
               char g_ccdv[2];         /* Device name of issuing terminal */
               byte g_ccct;            /* Number of characters ?? */
               byte g_ccun;            /* Issuing terminal unit no. */
               word g_cccl;            /* No. of characters in command */
               byte g_ccfl;            /* Flags (see below) */
               char g_cctc;            /* Command terminator character */
               char g_ccbf[80];        /* Command buffer */
               };

/*
 * Information buffer
 */
struct cmibuf  {
               word g_ccw2;            /* U.CW2 of issuing terminal */
               rad50 g_ccpt[2];        /* Name of parent task */
               struct ocb *g_ccoa;     /* OCB address */
               word g_ccpu;            /* Login UIC of issuing terminal */
               word g_cccu;            /* Current UIC of issuing terminal */
               struct cmdbuf *g_ccca;  /* Address of command if not de-Q'ed */
               };

/*
 * Action to take if no command buffer present
 */
#define GC_CCS 0                       /* Return with carry set */
#define GC_CEX 1                       /* Force CLI to exit */
#define GC_CST 2                       /* Force CLI to stop */
#define GC_CND 0200                    /* Copy command w/o dequeueing */
