/*
 * C U . H 	header file for cux program
 */

/*
 * README
 *
 * To tailor the program, 
 * comment/uncomment the following define statements.
 *
 * UNIX defines a program tailored to the UNIX operating system.
 * The use of 'put' requires stty and cat on the remote system.
 *
 * VAXVMS defines the version tailored to the VAX/VMS operating
 * system. This version should also work for RSX-RSX communication
 * if copy is supported.
 *
 * GENERIC defines a version not tailored to a specific operating
 * system. 'put' and 'take' are not implemented in this version.
 *
 * HELP includes an on-line help command (^Wh).
 *
 * PORTNUM can be used to identify the second port that is
 * attached to the modem. If not defined, the program will ask
 * for the same.
 *
 * PROTOCOL recognizes xon-xoff received from the host. 
 */
/* #define HELP	1 */			/* provide help text */
/* #define 	PROTOCOL 1 */		/* recognize xon-off from host */
/* #define	GENERIC	1 */		/* define for generic version */
/* #define	UNIX	1 */		/* define unix version	*/
/* #define 	VAXVMS	1 */		/* define for VAX/VMS version */
#define	CYBERNET 1 			/* CDC cybernet & NOS */
#define PORTNUM 011			/* number of second port */
#ifdef	CYBERNET
#ifndef	GENERIC
#define GENERIC
#endif
#endif

/*
 * constants
 */
#ifdef	CYBERNET
#define	QUEUE_SIZE	1500		/* port queue size */
#else
#define	QUEUE_SIZE	500		/* port queue size */
#endif
#define	TT_SIZE		200		/* size of tty queue		*/
#define	LOW_SIZE	200		/* queue getting low size	*/
#define	BUFF_SIZE	133		/* file buffer size		*/
#define	AST_MASK	0200		/* save seven bit character	*/
#define	LUN		7		/* logical unit assigned to tt:	*/
#define	TTYLUN		6		/* terminal logical unit	*/

#define	ON		TRUE
#define	OFF		FALSE

/* 
 * Terminal Driver Special I/O Function codes 
 */
#define		IO_ATA     776
#define		IO_WAL     264
#define    	IO_DET     1024
#define    	IO_KIL     10

/*
 * flags
 */
extern	char	exit_flag;		/* exit main loop if true	*/
extern	char	pt_overflow;		/* true if queue over flow	*/
extern	char	tt_overflow;		/* terminal queue overflow 	*/
extern	char	suspend;		/* true if host output suspeneded */
extern	char	echo_flag;		/* on if echo desired		*/
extern	char	file_open;		/* on foe redirected i/o	*/
extern	char	recv_file_open;		/* on for redirected input	*/
extern 	char	cmd_flag;		/* on if building a command	*/
extern	char	host_off;		/* on if host manually suspended*/
extern	int	x_file_open;		/* true if transfer documet open*/
extern	int	abort_x;		/* on to abort transmission	*/
extern	int	cmd_sent;		/* on if command enroute	*/
extern	int	port_data;		/* on if port_queue receiving	*/
#ifndef GENERIC
extern	char	auto_recv;		/* on if auto receive from host	*/
extern	char	auto_x;			/* on if auto transfer to host	*/
#endif

extern	char	xon;			/* x-on character		*/
extern	char	xoff;			/* x-off character		*/

/*
 * port buffer parameters
 */
extern	int	port_num;		/* tt: number of host port	*/
extern	char	*pt_front; 		/* front of queue		*/
extern	char	*pt_rear; 		/* rear of queue		*/
extern	int	pt_count; 		/* queue free count		*/
extern	char	pt_queue[QUEUE_SIZE]; /* port character queue		*/
extern	char	*pt_char;		/* character address		*/
extern	char	*pt_name;		/* name of port attached to modem */
extern	int	devpar[6];		/* for qio			*/

/*
 * tty buffer parameters
 */
extern	char	*tt_front; 		/* front of queue		*/
extern	char	*tt_rear; 		/* rear of queue		*/
extern	int	tt_count; 		/* queue free count		*/
extern	char	tt_queue[TT_SIZE];	/* tty character queue		*/
extern	char	*tt_char;
extern	int	ttypar[6];		/* for qio's to terminal	*/

/*
 * misc...
 */
extern	char	buff[BUFF_SIZE + 1];	/* file buffer			*/
extern	char	*buff_ptr;		/* buff count(size)		*/
extern	char	cmd_buf[80];		/* general purpose buffer	*/
extern	FILE	*rcvfd;			/* receive file descriptor	*/
extern	FILE	*xfd;			/* transmit file iov		*/
