/*
 * C U 3
 *          escape
 */

#include <stdio.h>
#include "cu.h"
typedef unsigned rad50;
typedef unsigned word;

extern 	tt_enqueue();		/* terminal ast handler	*/

rad50	tsknam[2];        	/* 2 word RAD50 task name */
char 	*task = "MCR...";	/* ascii task name	*/

escape()
/*
 * Temporarily escape inorder to spawn command to local system.
 */
{
	char *s;		/* pointer to command line */
	word status; 		/* Returned DSW */
	int cmdlen;		/* command length */
	extern char *scget();	/* wizard screen i/o primitive	*/

	/*
	 * detach terminal from program
	 */
	qiow (IO_KIL, TTYLUN, 4, 0, 0, 0);
	qiow (IO_DET, TTYLUN, 4, 0, 0, 0);

	/*
	 * convert ascii task name to rad50
	 */
	ascr50(6, task, &tsknam[0]);

	/*
	 * spawn commands to local executive until empty line entered.
	 */
	do {
		s = scget(cmd_buf, 80, "\r! ");	/* get command line */
		if ((cmdlen = strlen(s)) > 0){	/* if not empty line */
			status = spwn(tsknam, 0, 2, 0, 0, cmd_buf, cmdlen);
			wtse(2);		/* wait for task completion */
		}
	} while (cmdlen > 0 && status == 1);

	/*
	 * reattach terminal and specify AST srevice handler
	 */
	ttypar[0] = &tt_enqueue;		/* ast service handler	*/
	if (qiow(IO_ATA, TTYLUN, 4, NULL, NULL, ttypar) < 0){
		printf("\rcux: can't attach tty\n");
		exit_flag = ON;			/* force exit */
	}
}
