/*
 *  C U 4. C
 *
 */
#include <stdio.h>
#include "cu.h"

#define NARG	3		/* number of arguments to parse */

char	*vect[NARG];		/* command argument vector */

#ifndef	GENERIC

take_or_put()
/*
 * take or put file to the remote file system. 
 */
{
	register int argc;		/* command argument count */
	register char	*s;		/* local pointer */

	s = scget(buff, 80, "\r%");	/* read command */
	/*
	 * parse input command line into component parts and
	 * call appropriate transfer routine.
	 *
	 * command line looks like: command file1 [file2]
	 */
	argc = vector(buff, &vect);	/* parse command */
	if (argc == 0)
		printf("\rcux: 'take' or 'put' expected\n");
	else if (argc == 1)
		printf("\rcux: missing file name\n");
	else if (strcmp(vect[0], "take") == 0 || strcmp(vect[0], "TAKE") == 0)
		take(vect[1], (argc == 3) ? vect[2] : vect[1]);
	else if (strcmp(vect[0], "put") == 0 || strcmp(vect[0], "PUT") == 0)
		put(vect[1], (argc == 3) ? vect[2] : vect[1]);
	else printf("\rcux: %s command not found\n", vect[0]);
}

vector(text, argv)
char *text;				/* command line to parse */
char ***argv;				/* address of argument vector */
/*
 * Parse the command line text. Return pointers to 
 * at most NARG component arguments.
 */
{
	register int argc;		/* argument count */
	register char *p;		/* local pointer */

	argc = 0;			/* init argument count */
	p = text;			/* init pointer to start of text */
	while (*p != EOS && argc < NARG){
		/*
		 * skip over whitespace and newline
 		 */
		while (isspace(*p) || *p == '\n')
			p++;
		*argv++ = p;		/* point to start of argument */
		if (*p != EOS){
			argc++;		/* step argument count */
			/*
			 * scan off argument
			 */
			while (isprint(*p) && !isspace(*p))
				p++;
			if (*p != EOS)	/* terminate with EOS */
				*p++ = EOS;
		}
	}
	return(argc);
}


put(from, to)
char *from;				/* local file name */
char *to;				/* name to take on host system */
/*
 * Copy file 'from' (on local system) to file 'to' on host system.
 */
{
	extern	char *concat();		/* string function		*/

	/* 
	 * open file with given name
	 */
	if ((xfd = fopen(from, "r")) == NULL)
		printf("\rcux: can't open %s\n", from);
	else {
		/*
		 * generate command to transfer document
		 * to host(remote) system. 
		 */
#ifdef	VAXVMS
		concat (cmd_buf, "copy tt: ", to, "\r", 0);
#endif
#ifdef	UNIX
		concat (cmd_buf, "stty -echo;cat >", to, ";stty echo;\r", 0);
#endif
		send_cmd ();		/* dispatch command */
		cmd_sent = ON;		/* signal command sent */
		echo_flag = ON;		/* default  local echo */
		/* x_file_open = ON; */	/* signal file open */
		auto_x = ON;		/* signal auto transfer	*/
	}
}

take(from, to)
char *from;				/* file name on remote system */
char *to;				/* name on local system */
{
/*
 * Copy the file 'from' on the remote file system to the file 'to'
 * on the local file system. 
 */
	extern	char *concat();		/* string function */

	/* 
	 * open a file with the same name as on host system. 
	 * If can't get local name.
	 */
	if ((rcvfd = fopen(to, "w")) == NULL)
		printf("\rcux: can't open %s\n", to);
	else {
		/* 
		 * generate command for host transfer
		 */
#ifdef	VAXVMS
		concat(cmd_buf, "copy ", from, " tt: \r", 0);
#endif
#ifdef	UNIX
		concat(cmd_buf, "cat ", from, "\r", 0);
#endif
		send_cmd();		/* send command to host	*/
		cmd_sent = ON;		/* signal command enroute */
		auto_recv = ON;		/* signal auto transfer */
		buff_ptr = buff; 	/* init file buffer */
	}
}
#endif
