-h- cprnt.c	Thu Jan 19 15:24:29 1984	CPRNT.C;2
/*)LIBRARY
*/
/*
 *	*******************
 *	*  C P R N T . C  *
 *	*******************
 *
 * C-callable interface to P/OS callable print services
 *
 * Bob Denny  02-Jan-84
 *
 * Edits:
 */

extern cprnt();

p$cprnt(req, file, stat)
unsigned req;				/* Request code */
char *file;				/* File name */
int *stat;				/* --> 2-word status block */
   {
   unsigned req_array[75];		/* 75-word request/scratch array */
   unsigned flen;			/* File name length */

   req_array[0] = req;			/* Fill in request code */
   if(req == 1)				/* If "print file" requested */
      flen = strlen(file);		/* Get filename length */
   else					/* For other requests ... */
      file = flen = 0;			/* ... force file & length = 0 */

   call(cprnt, 4, stat, req_array, file, &flen);  /* Call print service */
   
   return(stat[0]);			/* Return 1st status word */
   }
-h- ctexlib.doc	Thu Jan 19 15:24:29 1984	CTEXLIB.DOC;1



			CTEX Interface Library for DECUS C
			==================================

	This document contains a brief description of the interface library
	for accessing CTEX functions from DECUS C.  The library is called
	CTEX.OLB and is located in the usual P/OS development library
	directory (e.g., [001005] on the PRO).  The interface maps fairly
	closely to the equivalent given in the toolkit manual, except for
	the parameters and other things as explicitly noted.

	Many of the routines in this library require the calling program be
	linked against the POSRES cluster library, and in some cases, the 
	RMSRES library as well.  Consult toolkit documentation for linking
	requirements.

	Sorry, but for now there are no "H" files for status values, and
	no "fancy" documentation.  This library was done in a big hurry
	as a midnight hack.

	PLEASE NOTE:	When passing 'null' strings, do NOT pass a NULL,
			rather, pass "".

	Bob Denny	02-Jan-84


	P$CPRNT - Callable print services
	---------------------------------
	unsigned req;			/* Request code */
	char *file;			/* File name or "" */
	int *stat;			/* --> 2-word status block */
	p$cprnt(req, file, stat);
	

	P$DMENU - Display dynamic menu
	------------------------------
	char *action;		/* --> buffer to receive action str */
	int maxlen;		/* Size of action string buffer */
	int addopt;		/* TRUE = enable additional opt's */
	char *msg1;		/* Message for line 23 or "" */
	char *msg2;		/* Message for line 24 or "" */
	int *stat;		/* --> 2 word status block */
	p$dmenu(action, maxlen, addopt, msg1, msg2, stat);


	P$DPACK - Pack dynamic single-choice menu
	-----------------------------------------
	char *fid;			/* Field ID */
	char *buf;			/* Field 'value' buffer */
	char *keyw;			/* "DFLT", "KEYWnn" or "" */
	int p1, p2;			/* Parameter(s) for above */
	int clear;			/* TRUE = clear dynamic buffer */
	int stat[2];			/* 2-word status */
	p$dpack(fid, buf, keyw, p1, p2, clear, stat);




			CTEX Interface Library for DECUS C
			==================================


	P$FATLER - Fatal error
	----------------------
	char *msg;			/* Message */
	p$fatler(msg);


	P$GETKEY - Get keystroke
	------------------------
	int stat[2];			/* 2-word status block */
	p$getkey(stat);


	P$HCLOSE - Close current help frame file
	----------------------------------------
	int stat[2];			/* 2-word status block */
	p$hclose(stat);


	P$HELP - Display help frame
	---------------------------
	char *frame;			/* Frame ID */
	int stat[2];			/* 2-word status block */
	p$help(frame, stat);


	P$HFILE - Open help file
	------------------------
	char *file;			/* Help frame file name */
	char *frame;			/* Default frame ID */
	int stat[2];			/* 2-word status block */
	p$hfile(file, frame, stat);


	P$HFRAME - Display help frame & set new default
	-----------------------------------------------
	char *frame;			/* Frame ID */
	int stat[2];			/* 2-word status block */
	p$hframe(frame, stat);


	P$MCLOSE - Close current menu frame file
	----------------------------------------
	int stat[2];			/* 2-word status block */
	p$mclose(stat);




			CTEX Interface Library for DECUS C
			==================================


	P$MENU - Display single-choice menu frame
	-----------------------------------------
	char *action;			/* --> buffer for action string */
	int maxlen;			/* Maximum action string length */
	int addopt;			/* TRUE = enable add'tl options */
	char *msg1;			/* Message for line 23 or "" */
	char *msg2;			/* Message for line 24 or "" */
	int stat[2];			/* 2-word status block */
	p$menu(action, maxlen, addopt, msg1, msg2, stat);


	P$MFILE - Open menu frame file
	------------------------------
	char *file;			/* Name of menu file */
	int stat[2];			/* 2-word status block */
	p$mfile(file, stat);


	P$MFRAME - Load static menu frame
	---------------------------------
	char *frame;			/* Frame ID */
	char *gblact;			/* Buffer for global action str */
	int maxlen;			/* Size of gblact buffer */
	int stat[2];			/* 2-word status block */
	p$mframe(frame, gblact, maxlen, stat);


	P$MMENU - Pack multiple-choice menu frame
	-----------------------------------------
	char *optstr;			/* Array of fixed-length opt strs */
	int optlen;			/* Fixed length of option strings */
	int nopts;			/* Number of options */
	int lim;			/* Limit to number of selections */
	int *sels;			/* Returned array of sel'd opt's */
	int addopt;			/* TRUE = enable additional opt's */
	char *msg1;			/* Message for line 23 or "" */
	char *msg2;			/* Message for line 24 or "" */
	int *stat;			/* --> 2 word status block */
	p$mmenu(optstr, optlen, nopts, lim, sels, addopt, msg1, msg2, stat);


	P$MPACK - Pack multiple-choice menu
	-----------------------------------
	char *fid;			/* Field ID */
	char *buf;			/* Field 'value' buffer */
	int clear;			/* TRUE = clear dynamic buffer */
	int stat[2];			/* 2-word status */
	p$mpack(fid, buf, clear, stat);




			CTEX Interface Library for DECUS C
			==================================


	P$MUNPK - Unpack menu buffer
	----------------------------
	char *fid;			/* Field ID */
	char *buf;			/* Field 'value' buffer */
	int maxl;			/* Value buffer size */
	char *keyw;			/* "DFLT", "KEYWnn" or "" */
	int *p1, *p2;			/* Parameter(s) for above */
	int stat[2];			/* 2-word status */
	p$munpk(fid, buf, maxl, keyw, p1, p2, stat);


	P$MSGBRD - Post message on message board
	----------------------------------------
	char *msg;			/* Message to post */
	int stat[2];			/* 2-word status */
	p$msgbrd(msg, stat);


	P$NEWFIL - New File Specification Menu
	--------------------------------------
	char name[50];			/* Receives specified file name */
	char *defext;			/* Default extension (R/W) */
	char *text1;			/* Text at top of menu or "" */
	char *msg1;			/* Text for line 23 or "" */
	int stat[2];			/* 2-word status block */
	p$newfil(name, defext, text1, msg1, stat);


	P$OLDFIL - File Selection Menu
	------------------------------
	#define NCHOICES xxx
	char *wspec;			/* Wild file specification */
	int nchoice = xxx;		/* Max allowed to select */
	char fspecs[NCHOICES][50];	/* Array of 50-byte spec bufs */
	char *text1;			/* Text at top of menu or "" */
	char *msg1;			/* Text for line 23 or "" */
	char *msg2;			/* Text for line 24 "" */
	int stat[2];			/* 2-word status block */
	p$oldfil(wspec, nchoice, fspecs, text1, msg1, msg2, stat);


	P$WTRES - Wait for 'resume' key
	-------------------------------
	p$wtres();
-h- dmenu.c	Thu Jan 19 15:24:29 1984	DMENU.C;2
/*)LIBRARY
*/
/*
 * P$DMENU - Display dynamic menu
 */
extern dmenu();

p$dmenu(action, maxlen, addopt, msg1, msg2, stat)
char *action;                           /* --> buffer to receive action str */
int maxlen;                             /* Size of action string buffer */
int addopt;                             /* TRUE = enable additional opt's */
char *msg1;                             /* Message for line 23 or NULL */
char *msg2;                             /* Message for line 24 or NULL */
int *stat;                              /* --> 2 word status block */
   {
   int actlen, m1len, m2len;

   m1len = strlen(msg1);
   m2len = strlen(msg2);
   call(dmenu, 10, stat, action, &maxlen, &actlen, 0, &addopt,
         msg1, &m1len, msg2, &m2len);
   action[actlen] = '\0';
   return(stat[0]);
   }
-h- dpack.c	Thu Jan 19 15:24:29 1984	DPACK.C;2
/*)LIBRARY
*/
/*
 * P$DPACK - Pack dynamic single choice menu
 *
 * Restricted access: handles only one field, thus requires
 * multiple calls.  Also, doesn't support both 'DFLT' and 'KEYWnn'
 * fields in the same call.
 */
extern dpack();

p$dpack(fid, buf, keyw, p1, p2, clear, stat)
char *fid;                             /* Field ID */
char *buf;                             /* Field 'value' buffer */
char *keyw;                            /* "DFLT" or "KEYWnn" */
int p1, p2;                            /* Parameter(s) for above */
int clear;                             /* TRUE = clear dynamic buffer */
int stat[2];                           /* 2-word status */
   {
   int fidl, keyl, bufl;

   fidl = strlen(fid);
   bufl = strlen(buf);
   keyl = strlen(keyw);
   call(dpack, (clear) ? 10 : 9, stat, fid, &fidl, buf, &bufl,
      keyw, &keyl, &p1, &p2, "CLRB");
   return(stat[0]);
   }

-h- fatler.c	Thu Jan 19 15:24:29 1984	FATLER.C;2
/*)LIBRARY
*/
/*
 * P$FATLER - Fatal error CTEX-style
 */
extern fatler();

p$fatler(msg)
char *msg;
   {
   int mlen;
   
   mlen = strlen(msg);
   call(fatler, 2, msg, &mlen);
   }
-h- getkey.c	Thu Jan 19 15:24:29 1984	GETKEY.C;2
/*)LIBRARY
*/
/*
 * P$GETKEY - Get keystroke & decode
 *
 * POSRES.H contains definitions for status/keycodes
 */
extern getkey();

p$getkey(stat)
int *stat;
   {
   call(getkey, 1, stat);
   return(stat[0]);
   }
-h- hclose.c	Thu Jan 19 15:24:29 1984	HCLOSE.C;2
/*)LIBRARY
*/
/*
 * P$HCLOSE - Close help file
 */
extern hclose();

p$hclose(stat)
int *stat;
   {
   call(hclose, 1, stat);
   return(stat[0]);
   }
-h- help.c	Thu Jan 19 15:24:29 1984	HELP.C;2
/*)LIBRARY
*/
/*
 * P$HELP - Display default help frame
 */
extern help();

p$help(frame, stat)
char *frame;                            /* New default frame ID or NULL */
int *stat;                              /* 2-word status block */
   {
   int frlen;
   
   frlen = strlen(frame);
   call(help, 3, stat, frame, &frlen);
   return(stat[0]);
   }
-h- hfile.c	Thu Jan 19 15:24:29 1984	HFILE.C;2
/*)LIBRARY
*/
/*
 * HFILE - Open help file
 */
extern hfile();

p$hfile(file, frame, stat)
char *file;                             /* Help file name */
char *frame;                            /* Default frame ID */
int *stat;                              /* 2-word status block */
   {
   int flen, frlen;
   
   flen = strlen(file);
   frlen = strlen(frame);
   call(hfile, 5, stat, file, &flen, frame, &frlen);
   return(stat[0]);
   }
-h- hframe.c	Thu Jan 19 15:24:29 1984	HFRAME.C;2
/*)LIBRARY
*/
/*
 * HFRAME - Display help frame
 */
extern hframe();

p$hframe(frame, stat)
char *frame;                            /* Frame ID */
int *stat;                              /* 2-word status block */
   {
   int frlen;
   
   frlen = strlen(frame);
   call(hframe, 3, stat, frame, &frlen);
   return(stat[0]);
   }
-h- mclose.c	Thu Jan 19 15:24:29 1984	MCLOSE.C;2
/*)LIBRARY
*/
/*
 * P$MCLOSE - Close menu file
 */
extern mclose();

p$mclose(stat)
int *stat;
   {
   call(mclose, 1, stat);
   return(stat[0]);
   }
-h- menu.c	Thu Jan 19 15:24:29 1984	MENU.C;2
/*)LIBRARY
*/
/*
 * P$MENU - Show single choice menu
 */
extern menu();

p$menu(action, maxlen, addopt, msg1, msg2, stat)
char *action;                           /* --> buffer to receive action str */
int maxlen;                             /* Size of action string buffer */
int addopt;                             /* TRUE = enable additional opt's */
char *msg1;                             /* Message for line 23 or NULL */
char *msg2;                             /* Message for line 24 or NULL */
int *stat;                              /* --> 2 word status block */
   {
   int actlen, m1len, m2len;
   
   m1len = strlen(msg1);
   m2len = strlen(msg2);
   call(menu, 10, stat, action, &maxlen, &actlen, 0, &addopt, 
         msg1, &m1len, msg2, &m2len);
   action[actlen] = '\0';
   return(stat[0]);
   }
-h- mfile.c	Thu Jan 19 15:24:29 1984	MFILE.C;2
/*)LIBRARY
*/
/*
 * P$MFILE - Open menu file
 */
extern mfile();
   
p$mfile(file, stat)
char *file;
int *stat;
   {
   int flen;

   flen = strlen(file);
   call(mfile, 3, stat, file ,&flen);
   return(stat[0]);
   }
-h- mframe.c	Thu Jan 19 15:24:29 1984	MFRAME.C;2
/*)LIBRARY
*/
/*
 * MFRAME - Read menu frame
 */
extern mframe();

p$mframe(frame, gblact, maxlen, stat)
char *frame;                            /* Frame ID string */
char *gblact;                           /* Global action string buffer addr */
int maxlen;                             /* Size of global action buffer */
int *stat;                              /* Returned 2-word status */
   {
   int flen;
   int size;
   
   flen = strlen(frame);
   call(mframe, 6, stat, frame, &flen, gblact, &maxlen, &size);
   gblact[size] = '\0';
   return(stat[0]);
   }
-h- mmenu.c	Thu Jan 19 15:24:29 1984	MMENU.C;2
/*)LIBRARY
*/
/*
 * P$MMENU - Show multiple choice menu frame
 */
extern mmenu();

p$mmenu(optstr, optlen, nopts, lim, sels, addopt, msg1, msg2, stat)
char *optstr;                          /* Array of fixed-length option strs */
int optlen;                            /* Fixed length of option strings */
int nopts;                             /* Number of options */
int lim;                               /* Limit to number of selections */
int *sels;                             /* Returned array of selected options */
int addopt;                            /* TRUE = enable additional opt's */
char *msg1;                            /* Message for line 23 or NULL */
char *msg2;                            /* Message for line 24 or NULL */
int *stat;                             /* --> 2 word status block */
   {
   int i, nsel, m1len, m2len;

   m1len = strlen(msg1);
   m2len = strlen(msg2);
   for(i=0; i<lim; i++)
      sels[i] = -1;

   call(mmenu, 12, stat, optstr, &optlen, &nopts, &lim, &nsel, sels, &addopt,
         msg1, &m1len, msg2, &m2len);
   return(stat[0]);
   }
-h- mpack.c	Thu Jan 19 15:24:29 1984	MPACK.C;2
/*)LIBRARY
*/
/*
 * P$MPACK - Pack dynamic multiple choice menu
 *
 * Restricted access: handles only one field, thus requires
 * multiple calls.
 */
extern mpack();

p$mpack(fid, buf, clear, stat)
char *fid;                             /* Field ID */
char *buf;                             /* Field 'value' buffer */
int clear;                             /* TRUE = clear dynamic buffer */
int stat[2];                           /* 2-word status */
   {
   int fidl, bufl;

   fidl = strlen(fid);
   bufl = strlen(buf);
   call(mpack, (clear) ? 5 : 6, stat, fid, &fidl, buf, &bufl, "CLRB");
   return(stat[0]);
   }

-h- msgbrd.c	Thu Jan 19 15:24:29 1984	MSGBRD.C;2
/*)LIBRARY
*/
/*
 * P$MSGBRD - Send Message to Message/Status Board
 */
extern msgbrd();

p$msgbrd(msg, stat)
char *msg;
int *stat;
   {
   int mlen;
   
   mlen = strlen(msg);
   call(msgbrd, 3, stat, msg, &mlen);
   }
-h- munpk.c	Thu Jan 19 15:24:29 1984	MUNPK.C;2
/*)LIBRARY
*/
/*
 * P$MUNPK - Unpack menu buffer
 *
 * Restricted access: handles only one field, thus requires
 * multiple calls.  Also, doesn't support both 'DFLT' and 'KEYWnn'
 * fields in the same call.
 */
extern munpk();

p$munpk(fid, buf, maxl, keyw, p1, p2, stat)
char *fid;                             /* Field ID */
char *buf;                             /* Field 'value' buffer */
int maxl;                              /* Value buffer size */
char *keyw;                            /* "DFLT" or "KEYWnn" */
int *p1, *p2;                          /* Parameter(s) for above */
int stat[2];                           /* 2-word status */
   {
   int fidl, keyl, bufl;

   fidl = strlen(fid);
   keyl = strlen(keyw);

   call(munpk, 10, stat, fid, &fidl, buf, &maxl, &bufl, keyw, &keyl, p1, p2);
   buf[bufl] = '\0';
   return(stat[0]);
   }

-h- newfil.c	Thu Jan 19 15:24:29 1984	NEWFIL.C;3
/*)LIBRARY
*/
/*
 * P$NEWFIL - Create a file menu
 */
extern newfil();

p$newfil(name, type, text1, msg1, stat)
char *name;     /* In: default file name  Out: actual file specification */
char *type;     /* In: default file type  Out: new default file type  */
char *text1;    /* Text at top of form or NULL */
char *msg1;     /* Message on line 23 or NULL */
int *stat;      /* 2-word status block */
   {
   int namlen, typlen, t1len, m1len;
   
   namlen = strlen(name);
   typlen = strlen(type);
   t1len = strlen(text1);
   m1len = strlen(msg1);
   call(newfil, 11, stat, name, &namlen, &namlen, type, &typlen, &typlen,
         text1, &t1len, msg1, &m1len);
   if(stat[0] != 1)			/* If EXIT or MAIN SCREEN */
      namlen = typlen = 0;		/* Indicate null lengths */
   else
      {
      name[namlen] = '\0';
      type[typlen] = '\0';
      }
   return(stat[0]);
   }


-h- oldfil.c	Thu Jan 19 15:24:29 1984	OLDFIL.C;3
/*)LIBRARY
*/
/*
 * P$OLDFIL - Select a file menu
 */
extern oldfil();

p$oldfil(wspec, nchoice, fspecs, text1, msg1, msg2, stat)
char *wspec;            /* Wild file spec for selections */
int *nchoice;           /* In: Max number to select  Out: Number chosen */
char *fspecs;           /* Array of contiguous 50-byte filespec bufs */
char *text1;            /* Text at top of frame */
char *msg1;             /* Message on line 23 */
char *msg2;             /* Message on line 24 */
int *stat;              /* 2-word status block */
   {
   int i, wlen, t1len, m1len, m2len;
   int *sizes;
   
   if((sizes = malloc(*nchoice * sizeof(int))) == 0)
      {
      stat[1] = 0;
      return(stat[0] = -10);            /* No buffer space */
      }
   wlen = strlen(wspec);
   t1len = strlen(text1);
   m1len = strlen(msg1);
   m2len = strlen(msg2);
   call(oldfil, 12, stat, nchoice, fspecs, sizes, wspec, &wlen,
         text1, &t1len, msg1, &m1len, msg2, &m2len);
   if(stat[0] != 1)			/* If EXIT or MAIN SCREEN pressed */
      *nchoice = 0;			/* Indicate nothing chosen */
   else
      {
      for(i=0; i<*nchoice; i++)
         fspecs[(50 * i) + sizes[i]] = '\0';
      }
   free(sizes);
   return(stat[0]);
   }
-h- pfspool.inf	Thu Jan 19 15:24:29 1984	PFSPOOL.INF;1

PFSPOOL.MAC contains a replacement routine for the fspool() function
normally found in the C runtime libraries.  It is here because it is
an interface to CTEX print services, but it should be put into the
FCS and RMS C libraries as a replacement for FSPOOL.

-h- pfspool.mac	Thu Jan 19 15:24:29 1984	PFSPOOL.MAC;1
	.enabl	lc
	.title	fspool - Queue file for print (P/OS)
	.ident	"POS001"
	.nlist	bex,cnd,toc

;
;+
; index		fspool - Queue file for print (P/OS)
;
; Usage
;
;	fspool(fp);
;	FILE	*fp;	/* Open file IOV */
;
; Description
;
;	This function may be called in lieu of fclose() when it is
;	desired to send the file to the P/OS print services for printing.
;
;	Fspool() returns zero if the file was queued for printing by
;	P/OS, or an error code if the file could not be printed.  The
;	error codes returned are those issued by the P/OS "callable
;	print service", unless the 'file' was not really a file, in
;	which case fspool() returns -1 if the 'file' closes normally.
;
;	If the file was opened via the fwild()/fnext() services, the
;	internal buffers are not freed, allowing the program to call
;	fnext() for subsequent files.
;
;	WARNING - Uses over 200 bytes of stack to maintain re-entrancy.
;
; Internal
;
;	This routine is the replacement for FSPOOL for P/OS use.  Since
;	it requires making a call to a routine in the P/OS SYSLIB that
;	is not present in RSX-flavor SYSLIBs, there is no easy way to
;	make the difference transparent at run-time.  This module should
;	replace FSPOOL in P/OS libraries.  
;
; Bugs
;
;-

;
; Edits:
;
; POS001 02-Jan-84 RBD	Initial edit on P/OS
;

	.psect	c$code

fspool::
	jsr	r5,csv$			; Link environments
	clr	$$ferr			; No errors (yet)
	mov	C$PMTR(r5),r4		; R4 --> IOV
	bit	#VF$FIL,V$FLAG(r4)	; Is it a real file?
	bne	10$			; (yes)
	
;
; Non-files are handled nicely.  
; The call is converted into an fclose().
;
	clr	r0			; Signal normal close
	call	$$clos			; Close the 'file'
	br	100$

;
; Fill in an automatic buffer with the full filespec.
;
10$:	sub	#64.,sp			; Make a filename buffer
	mov	sp,r3			; r3 --> filename buffer
	mov	r3,-(sp)		; Push buffer address
	mov	r4,-(sp)		; Push IOV
	call	fgetname		; Get the full filename
	cmp	(sp)+,(sp)+		; Strip off arguments

;
; Close the file, preserving buffers if it's on an fwild/fnext
; roll.
;
	clr	r0			; R0 = zero means "real" close
	bit	#VF$WLD,V$WFLG(r4)	; File engaged in wildcarding?
	beq	20$			; (no)
	mov	r4,r0			; Yes, close fnext-style
20$:	call	$$clos

;
; Call P/OS print system to print the file
;
	mov	r5,-(sp)		; Save r5
	sub	#4,sp			; Make a status block
	mov	sp,r2			; r2 --> status
	sub	#<75.*2>,sp		; Make request array
	mov	sp,r1			; r1 --> request array
	mov	#1,(r1)			; Request "print file"
	mov	r1,-(sp)		; Save r1
	mov	r3,-(sp)		; Push filespec string address
	call	strlen			; r0 = length of filespec
	mov	(sp)+,r3		; (Not really necessary)
	mov	(sp),r1			; Restore r1
	mov	r0,(sp)			; sp --> length
	mov	sp,r0			; r0 --> length
;
; At this point:
;	r0 --> filespec length
;	r1 --> request array
;	r2 --> status block
;	r3 --> filespec
; Now we push a FORTRAN-style argument block
;
	mov	r0,-(sp)		; Push the address of the length
	mov	r3,-(sp)		; Push the filespec address
	mov	r1,-(sp)		; Push the request array address
	mov	r2,-(sp)		; Push the status block address
	mov	#4,-(sp)		; Push argument count
	mov	sp,r5			; R5 --> argument block

	call	cprnt			; Queue for printing

	tst	(sp)+			; Pop count
	mov	(sp)+,r2		; r2 --> status block
	add	#162.,sp		; Cut back stack
	mov	(sp)+,r5		; Restore frame pointer
;
; If it succeeded, return 0, else return 2nd status word.
;
	clr	r0			; Assume success
	tst	(r2)			; Well?
	bpl	100$			; (OK)
	mov	2(r2),r0		; Error, return status[1]

100$:	jmp	cret$

	.end
-h- readme.inf	Thu Jan 19 15:24:29 1984	README.INF;1

The following POSRES interface modules have not been tested:

	DMENU	DPACK	MPACK	NEWFIL	OLDFIL	

while PRSCSI and RDMSG have not even been written yet.


Note: The P/OS MSGBRD routine is not in POSRES;  it is in the system
      library (SYSLIB).  It was put into the POSRES interface library
      because the interface is identical to all other POSRES modules.

*** 02-Jan-83: ***

Added the P$CPRNT function, allowing C access to the P/OS callable
print services.  This, too, is not in POSRES.  This collection of 
routines is becoming a "CTEX services library", including POSRES
stuff, and other things available via SYSLIB.  Accordingly, I have
renamed the library CTEX.OLB and this directory [CTEXLIB].  Sorry
to have thrown you a curve, Tim, but now is the time to do it, before
too many command files have been written.

Have you tested any more of the routines???  Looks like DMENU works ...

Added PFSPOOL, which is a replacement fspool() for P/OS which queues the
file to the P/OS print server.  See info in PFSPOOL.INF.

-h- vmaktxl.com	Thu Jan 19 15:24:29 1984	VMAKTXL.COM;2
$! Vax compatibility command file built on Sat Jan 14 18:40:16 1984
$ was_verify = 'f$verify(1)'
$!
$! ** Compile CPRNT
$!
$ xcc CPRNT.C 
$ xas CPRNT.S -d
$!
$! ** Compile DMENU
$!
$ xcc DMENU.C 
$ xas DMENU.S -d
$!
$! ** Compile DPACK
$!
$ xcc DPACK.C 
$ xas DPACK.S -d
$!
$! ** Compile FATLER
$!
$ xcc FATLER.C 
$ xas FATLER.S -d
$!
$! ** Compile GETKEY
$!
$ xcc GETKEY.C 
$ xas GETKEY.S -d
$!
$! ** Compile HCLOSE
$!
$ xcc HCLOSE.C 
$ xas HCLOSE.S -d
$!
$! ** Compile HELP
$!
$ xcc HELP.C 
$ xas HELP.S -d
$!
$! ** Compile HFILE
$!
$ xcc HFILE.C 
$ xas HFILE.S -d
$!
$! ** Compile HFRAME
$!
$ xcc HFRAME.C 
$ xas HFRAME.S -d
$!
$! ** Compile MCLOSE
$!
$ xcc MCLOSE.C 
$ xas MCLOSE.S -d
$!
$! ** Compile MENU
$!
$ xcc MENU.C 
$ xas MENU.S -d
$!
$! ** Compile MFILE
$!
$ xcc MFILE.C 
$ xas MFILE.S -d
$!
$! ** Compile MFRAME
$!
$ xcc MFRAME.C 
$ xas MFRAME.S -d
$!
$! ** Compile MMENU
$!
$ xcc MMENU.C 
$ xas MMENU.S -d
$!
$! ** Compile MPACK
$!
$ xcc MPACK.C 
$ xas MPACK.S -d
$!
$! ** Compile MSGBRD
$!
$ xcc MSGBRD.C 
$ xas MSGBRD.S -d
$!
$! ** Compile MUNPK
$!
$ xcc MUNPK.C 
$ xas MUNPK.S -d
$!
$! ** Compile NEWFIL
$!
$ xcc NEWFIL.C 
$ xas NEWFIL.S -d
$!
$! ** Compile OLDFIL
$!
$ xcc OLDFIL.C 
$ xas OLDFIL.S -d
$!
$! ** Compile WTRES
$!
$ xcc WTRES.C 
$ xas WTRES.S -d
$ mcr lbr CTEX.OLB/CR=CPRNT.OBJ,DMENU.OBJ,DPACK.OBJ
$ mcr lbr CTEX.OLB=FATLER.OBJ,GETKEY.OBJ,HCLOSE.OBJ
$ mcr lbr CTEX.OLB=HELP.OBJ,HFILE.OBJ,HFRAME.OBJ
$ mcr lbr CTEX.OLB=MCLOSE.OBJ,MENU.OBJ,MFILE.OBJ
$ mcr lbr CTEX.OLB=MFRAME.OBJ,MMENU.OBJ,MPACK.OBJ
$ mcr lbr CTEX.OLB=MSGBRD.OBJ,MUNPK.OBJ,NEWFIL.OBJ
$ mcr lbr CTEX.OLB=OLDFIL.OBJ,WTRES.OBJ
$ delete CPRNT.OBJ;
$ delete DMENU.OBJ;
$ delete DPACK.OBJ;
$ delete FATLER.OBJ;
$ delete GETKEY.OBJ;
$ delete HCLOSE.OBJ;
$ delete HELP.OBJ;
$ delete HFILE.OBJ;
$ delete HFRAME.OBJ;
$ delete MCLOSE.OBJ;
$ delete MENU.OBJ;
$ delete MFILE.OBJ;
$ delete MFRAME.OBJ;
$ delete MMENU.OBJ;
$ delete MPACK.OBJ;
$ delete MSGBRD.OBJ;
$ delete MUNPK.OBJ;
$ delete NEWFIL.OBJ;
$ delete OLDFIL.OBJ;
$ delete WTRES.OBJ;
$ if .not. 'was_verify' then set noverify
-h- wtres.c	Thu Jan 19 15:24:29 1984	WTRES.C;2
/*)LIBRARY
*/
/*
 * P$WTRES - Wait for Resume Key.
 */
extern wtres();

p$wtres()
   {
   call(wtres, 0);
   }
