
#include "k.h"

/*
 *      s p a c k
 */

spack(type,num,len,data)
char type, *data;
int num, len;
{
        int i;
        char chksum, buffer[100];
        register char *bufp;

        /* initialize some parameters */

#if debug
        fprintf(stderr,"spack -- sending a packet with type %c\n",type);
#endif
        bufp = buffer;
        for (i=1; i<=pad; i++)                  /* issue necessary padding */
                write(remfd,&padchar,1);
        *bufp++ = SOH;                       /* packet marker, ASCII 1 (SOH) */
        chksum = tochar(len+3);                 /* initialize the checksum */
        *bufp++ = tochar(len+3);                /* send the character count */
        chksum = chksum + tochar(num);  /* init checksum */
        *bufp++ = tochar(num);                  /* packet number */
        chksum = chksum + type;
        *bufp++ = type;                                 /* packet type */

        /* loop for all data characters */
        for (i=0; i<len; i++)
        {
                *bufp++ = data[i];
                chksum = chksum+data[i];
        }
        chksum = (chksum + (chksum & 192) / 64) & 63;
        *bufp++ = tochar(chksum);               /* checksum */
        *bufp = eol;                        /* extra packet line terminator */
        write(remfd, buffer,bufp-buffer+1);     /* send it out */
}


/*
 *      r p a c k
 */

rpack(len,num,data)
int *len, *num;
char *data;
{
        int i, fld;
        char chksum, t, type;

        chksum = 0;                                /* initialize checksum */
        t = 0;                             /* initialize input char value */
        while (t != SOH)                         /* wait for packet header */
                read(remfd,&t,1);

        /* got one, loop for each field */
        for (fld=1; fld<=5; fld++)
        {
                if (fld != 5 || i != 0)         /* don't get char on */
						/* no data packets */
                {
                        read(remfd,&t,1);
                        if (t == SOH)
                                fld = 0;                /* resynch if SOH */
                }
               if (fld <= 3) chksum = chksum + t;    /* accumulate checksum */

                switch (fld)
                {
                        case 0: chksum = 0; break;         /* restart loop */
                        case 1: *len = unchar(t)-3; break;    /* char count */
                        case 2: *num = unchar(t); break;    /* packet number */
                        case 3: type = t; break;            /* packet type */
                        case 4: for (i=0; i<*len; i++)
                        {
                                if (i != 0)
                                {
                                        read(remfd,&t,1);
                                        if (t == SOH)       /* get a char */
                                        {
                                                fld = -1;
                                                break;
                                        }
                                }
                                chksum = chksum + t;     /* add to checksum */
                                data[i] = t;             /* normal character */
                        }

                        case 5: chksum = (chksum + (chksum & 192) / 64) & 63;
                                        break;
                }
        }

        /* check the checksum */
        if (chksum != unchar(t))
        {
                printf("Bad checksum: %c, should be %c\n",t,tochar(chksum));
                return(FALSE);
        }
#if debug
  fprintf(stderr,"rpack -- returning with packet type %c, n=%d, num=%d\n",
type,n,*num);
#endif
        return(type);                  /* return packet type */
}


/*
 *      b u f i l l
 */

bufill(buffer)
char buffer[];
{
        int i, t;

        i = 0;                              /* init data buffer pointer */
        while(read(fd,&t,1) > 0)            /* get the next character */
        {
                t = t & 0177;
                if (t<SP || t==DEL || t==quote)
                {
                        if (t=='\n')      /* if newline, squeeze CR in first */
                        {
                                buffer[i++] = quote;
                                buffer[i++] = ctl('\r');
                        }
                        buffer[i++] = quote;
                        if (t != quote) t=ctl(t);
                }
                buffer[i++] = t;
                if (i >= spsiz-8) return(i);
        }
        if (i==0) return(EOF);                 /* wind up here only on EOF */
        return(i);                   /* so the partial buffer isn't lost */
}

/*
 *      b u f e m p
 */

bufemp(buffer,fd,len)
char buffer[];
int fd, len;
{
        int i, t;

        for (i=0; i<len; i++)
        {
                t = buffer[i];
                if (t == MYQUOTE)              /* handle quoted characters */
                {
                        t = buffer[++i];       /* get the quoted character */
                        if (t != MYQUOTE) t = ctl(t);  /* de-controlify char */
                }
                write(fd,&t,1);             /* put the char in the file */
        }
}


/*
 *      g e t f i l
 */

getfil(filenm)
char *filenm;
{
        if (filenm[0] == '\0')
                fd = creat(packet,0644);
        else
                fd = creat(filenm,0644);
}

/*
 *      g n x t f l
 */

gnxtfl()
{
/* length of file name string */
        file_name.dsc$w_length = strlen(filnam);

        if( (lib$find_file(&file_name,&result_name,&fabp)&1) !=1) return(EOF);
        namp = fabp->fab$l_nam;
        strncpy(namestr,namp->nam$l_name,namp->nam$b_name);
        strncpy(extstr,namp->nam$l_type,namp->nam$b_type);
        strcpy(filestr,namestr);
        strcat(filestr,extstr);
        return(1);
}
