@make<manual>
@begin[comment]
This is the source file, in FinalWord format, for the LC-Term
documentation.  FinalWord is supposed to be "Scribe-like", so you might
be able to run this through Scribe and have useful things happen.  I
haven't tried this.

FinalWord is a word processor (composed of two more-or-less independent
pieces: an editor and a postprocessing formatter), developed and
marketed by Mark of the Unicorn, Cambridge, Mass.  I highly recommend
it.

Scribe is a postprocessing text formatter developed by Brian Reid and
marketed by Unilogic, which I think is in Pittsburgh.  It's much more
powerful than FinalWord but only runs on machines that cost as much as a
small house.
@end[comment]
@style(chapters no)
@begin(center)
@b[ LC-Term ]

Copyright (C) 1984 by Larry Campbell

73 Concord St., Maynard, Mass. 01754 USA

@blankspace(2 lines)
This document reflects LC-Term version 2.14.
@blankspace(2 lines)
May 10, 1984
@end(center)
@section(LC-Term)
LC-Term is a program that provides sophisticated terminal emulation and file
transfer functions on a DEC Rainbow 100 running MS-DOS.  It requires
128K memory (192K or more for the PUSH function), and requires MS-DOS
version 2.05 or later.

LC-Term is unique among personal computer file transfer programs in that
it supports both of the popular public-domain file transfer protocols: 
KERMIT and XMODEM.  While XMODEM is more popular among microcomputer
users, and supported by most public bulletin board systems, KERMIT is
more frequently found on mainframes, and used for micro-to-mainframe
communications.  LC-Term supports both protocols, in one package.
@section(Running LC-Term)
Just type LCTERM to the MS-DOS command prompt.  There are a few command
switches that can be appended to the LCTERM command line:
@begin(description)
-t@\Bypass the top-level menu and go straight to terminal emulation.

-s<filespec>@\Open the file specified as a script, enter terminal
emulation (bypassing the top-level menu), and process the script.
@end(description)
@section(Menus)
LC-Term is menu-driven.  This makes it easy to use most of
LC-Term's features without reference to the documentation.  Because the
menus are intended to be self-explanatory (let me know if they're not),
I won't describe them in detail here.  I'll just briefly run over
keyboard usage and terminology.
@begin(quotation)
@center[Note]
At all times, the HELP key will remind you what the currently available
function keys are.  If you're ever unsure what options are available, press the
HELP key.
@end(quotation)
Whenever a menu is displayed on the screen, you may select items from
the menu by one of three methods.  You may use the up- and down-arrow
keys to step forwards or backwards through the menus;  you may enter the
menu item number from the number keys on the main part of the keyboard; 
or you may enter menu item numbers from the numeric keypad.  In all
cases you must press the DO key to activate the selected menu item.
@section(Terminal emulation)
In terminal emulation LC-Term emulates a DEC VT102 terminal, and will
identify itself as such in response to the terminal type inquiry escape
sequence.  (Actually, much of this emulation is handled by the Rainbow
firmware.)  During terminal emulation, the following function keys are
available:
@begin(description)
INTERRUPT@\Pressing this key causes an "auto-push".  LC-Term clears the
screen, displays the message "Type EXIT to return to LC-term...", and
loads and starts a copy of the MS-DOS command processor.  You may now
type any MS-DOS commands.  LC-Term is still resident, and suspended. 
When you give the EXIT command, which stops the command processor,
control is returned to LC-Term.  The screen and cursor are restored, and 
you reenter terminal emulation.  (Note:  this feature, and the PUSH item
available in LC-Term's top-level menu, require at least 192K of memory.)

EXIT@\Pressing this key causes LC-Term to exit to MS-DOS.

MAIN SCREEN@\Pressing this key causes LC-Term to display its main
menu.  You may select options from this menu, and may return to terminal
emulation by selecting item 1.
@end(description)
@section(File transfers)
LC-Term supports three flavors of file transfer:  raw, KERMIT, and
XMODEM.  Raw file transfers consist of simply logging terminal output to
a file, or of
taking terminal input from a file.  No error checking is performed. 
This is typically used to get a log of a terminal session, or to
transfer the source program for a file transfer protocol as part of
"bootstrapping" the protocol onto a machine that doesn't yet have it.
@subsection(KERMIT)
KERMIT is a file transfer protocol developed at Columbia University. 
Implementations exist for almost every computer I've ever heard of (all
available at a nominal cost directly from the Columbia computing
center).

LC-Term currently supports a simple subset of the KERMIT protocol.  It
supports one-character checksums only (no CRCs),
and no wildcard file transmission (wildcard reception
works if the sender supports it).  No server mode is available, but
LC-Term works fine when talking to a server (receive init is supported).
The KERMIT menu should be self-explanatory;  the
only nonobvious part is that to abort a transfer you press the ADDTNL
OPTIONS key (which asks for confirmation before aborting the transfer).

LC-Term supports 8th-bit quoting.  This is disabled by default (since it
reduces efficiency).  You should turn it on if the path between your
Rainbow and the KERMIT you're trying to talk to molests the 8th bit of
characters.  (You'll know this is the problem if you can transfer text
files just fine but binary files never succeed.)
@subsection(XMODEM)
XMODEM is the simplest form of the famous "Ward Christensen" protocol,
named after its inventor.  The XMODEM protocol supports single file
transfers only (no wildcarding) and LC-Term's XMODEM implementation
supports only single-character checksums:  no CRCs.
@section(Scripts)
Scripts are a powerful way of directing LC-Term to do some pretty
complicated things.  Scripts are very similar to raw file transmission. 
With one small (and powerful) exception, when you open a script file,
its contents are just sent down the communications line as if you had
typed them.  The powerful part is that you can embed script commands in
this text which cause LC-Term to do various useful things.
@subsection(Script command description)
Script commands begin with a sharp (#) sign.  If you want a sharp sign
to be sent, enter two sharp signs (##).  All other characters in the
file are sent as is.  A script command starts with a sharp sign and is
always followed by at least one character;  depending on the command
some of the following characters may be interpreted as part of the
command.  The command itself is interpreted by LC-Term and is not sent
to the remote host.  Case is significant:  "#a" and "#A" would be two
different commands.

@center(@b[Script commands])
@begin(Description)
#c'command'@\Execute the MS-DOS command 'command'.  This feature
requires at least 192K.

#e@\Exit from LC-Term.

#h@\Hang up the phone (drops DTR for three seconds).

#kc'nn'@\Set KERMIT retry count to nn.

#kg'filespec'@\Use KERMIT to get a file.

#ks'filespec'@\Use KERMIT to send a file.

#kt'nn'@\Set KERMIT timeout to nn seconds.

#kx@\Ask the remote KERMIT server to stop itself.

#k8+@\Enable 8th-bit quoting

#k8-@\Disable 8th-bit quoting

#lo'filespec'@\Open a log file.

#lc@\Close currently open log file.

#mr'filespec'@\Use XMODEM to receive a file.

#ms'filespec'@\Use XMODEM to send a file.

#p'prompt'@\Wait until the string 'prompt' has been sent by the remote
host before proceeding in the script file.

#w'nn'@\Wait nn seconds before proceeding.

@end(Description)

In commands that take string arguments (#ks, for instance) the first
character after the command is the @b(delimiter) character;  LC-Term
scans until it sees a second occurrence of the delimiter and the
characters scanned become the argument to the command.  For instance,
the following commands are all equivalent:  #p'$@#', #p|$@#|, #p\$@#\.
@subsection(Script usage)
Scripts can be quite powerful.  I have a script that:
@begin(itemize)
Dials a local phone number

Logs in

Connects over a DECNET network to an ARPANET host

Logs in to the ARPANET host

Runs the mail system

Copies all my new mail to a file

Leaves the mail system

Starts a KERMIT server

Uses a #kr command to transmit my mail to my Rainbow

Stops the remote KERMIT server

Logs out of both machines

Hangs up the phone
@end(itemize)

I can let this script run unattended (it frequently takes 30 to 40
minutes when the network is slow) and later read my mail at my leisure,
at Rainbow screen speeds.

Suggestion:  use the #p command heavily.  You need to use it when
talking to systems without typeahead (like Gandalf or MICOM switches),
but it's a good idea to use it even when not stricly necessary.
If you use #p liberally, and
something goes wrong in your script, you will probably get to a point
where the script is waiting for a prompt that will never come.  If you
hadn't
used the #p commands, the script file would blindly
continue on and perhaps do some damage.

Scripts are very patient.  If something goes wrong, they'll wait for the
prompt forever.  You can type commands to the remote host, and perhaps
fix the problem that hung the script file.  Note that if you don't close
the script file, it will proceed as soon as it sees the prompt it was
waiting for.  If you want to prevent this, use the "Raw text file
transfer" menu to close the script file.
@section(Ownership, copyright, author, etc.)
@subsection(Copyright)
LC-Term is copyrighted by the author, Larry Campbell.  It may be copied
without modification for noncommercial purposes only.  All copyright
notices must remain intact, and this document must accompany the
program.  Commercial
use of LC-Term is permitted only with my prior written permission.

As a
courtesy to me, and a service to other LC-Term users,
if you find it necessary to modify LC-Term, please send me your
modifications, so that all LC-Term users have the chance to benefit from
them.
@subsection(Reaching the author)
You may reach me at the address listed on the title page.  Those with
access to the ARPANET may reach me by ARPANET mail as
LCampbell@@DEC-MARLBORO.  Employees of Digital Equipment Corporation with
access to the Engineering Network may reach me at PBSVAX::CAMPBELL.

