@make(vmappendix)
@comment(this is the NEXTFST appendix, by Carl Kass, Dec. 22, 1980)
@comment<Copyright (C) 1980 Columbia University>
@case(device,diablo="@Typewheel(pica)")
@appendixname(name="NEXTFST SUBROUTINE")
@introduction
@;NEXTFST is an assembler language subroutine which permits an assembler
or high level language program to go through the list of files on the
currently accessed disks.  It permits wild card matching in fileid's
and returns pointers to the FST (File Status Table) and ADT (Active
Disk Table) for each file matching the passed fileid.  Return codes
are passed back indicating success of file id match.
@;@cmssyntax
The subroutine is called with three arguements: an 18 byte character
string, the file pattern, containing the filename, filetype, and
filemode to be searched for; a pointer which will be filled with the
address of the ADT of the matched file, and a pointer which will be
filled with the address of the FST of the matched file.  If there are
no files left which match the passed file pattern then a NULL
(X'FF000000') is placed in the two pointers.  The ADT and FST pointers
should not be changed between calls since they are used as locators
indicating where to start looking for the next FST on subsequent
calls.

The file matching pattern consists of three seperate fields: the
filename pattern, the filetype pattern, and the filemode pattern. Each
of the first two fields are 8 characters long, the third is 2
characters. In the pattern, the "*" matches any number of characters,
and the "%" matches any single character. In the filemode field, a
blank in the filemode letter position (first position) matches
filemode A, a blank in the filemode number matches any filemode
number. Only characters up to the first blank in the filename and
filetype fields are recognized, those following it are ignored. See
the examples section for examples of this matching.

When NEXTFST is invoked from PL/I, a declaration such as the following
one should be used:
@begin(example,group)
DECLARE NEXTFST ENTRY(CHAR(18),POINTER,POINTER) EXTERNAL
     OPTIONS(ASSEMBLER,INTER,RETCODE);
@END(EXAMPLE)
The return code passed back from NEXTFST may be inspected by the
PL/I builtin function, PLIRETV.

From assembler, use the standard OS calling conventions.
@;@cmsexamples
The file pattern
@;@begin(verbatim)
                 Filename Filetype FM
                +--------+--------+--+
                |ABC%    |*       |Z |
                +--------+--------+--+
@;@end(varbatim)
will match any file having a four letter filename starting with ABC on
the currently accessed Z-disk.
@;@drawline
The following PL/I program may be used to print a list of all the
files on the A-disk:
@;@begin(example,group)
LISTF:PROC OPTIONS(MAIN);
DECLARE NEXTFST ENTRY(CHAR(18),POINTER,POINTER) EXTERNAL
     OPTIONS(ASSEMBLER,INTER,RETCODE);
DCL FID CHAR(18) INIT('*       *       A%'),
    (ADTPTR,FSTPTR) POINTER INIT(NULL);
DCL (NULL,PLIRETV) BUILTIN;
DCL 1 FST BASED(FSTPTR),
     2 FN CHAR(8),
     2 FT CHAR(8);

CALL NEXTFST(FID,ADTPTR,FSTPTR);
DO WHILE(PLIRETV=0);
 PUT FILE(SYSPRINT) SKIP LIST(FN,FT);
 CALL NEXTFST(FID,ADTPTR,FSTPTR);
END;
RETURN;
END LISTF;
@END(EXAMPLE)

Note that the FST has the filename and filetype as its first two
doublewords.  For a complete description of the FST see the Data Areas
and Control Block Logic manual, SY20-0884.  @drawline This example
shows how a paramteter address block (PAB) would be set up in an
assembler program to call NEXTFST
@begin(example,group)
NEXTPAB DC      A(FILPAT)       ADDRESS OF FILE PATTERN
        DC      A(ADTADDR)      ADDRESS OF POINTER TO ADT
        DC      X'80',AL3(FSTADDR)  ADDRESS OF PTR TO FST
@END(EXAMPLE)
@;@vs1syntax
@;@na
@;@vs1examples
@;@na
@;@additionalinfo
The return codes and their meanings are as follows:
@begin(description,indentation -4,leftmargin +4,rightmargin +4,spacing
1,spread 0)
@ 0 - normal return, file found.

@ 4 - file not found or disk not accessed.

@ 8 - one, but not both of ADTPTR and FSTPTR was null (X'FF000000') when
NEXTFST was called.

12 - the passed ADTPTR is bad.

16 - the passed FSTPTR is bad; it is not pointing at one of the FST's
in the passed ADTPTR's FST hyperblocks.

20 - the ADTPTR is not pointing at a currently accessed disk.
@end(description)

No files should be added or erased from the disk which the ADTPTR is
pointing at between calls to NEXTFST. If either of these actions are
taken, then the FST returned by NEXTFST might not be the next one in
the list of FST's which match the passed pattern.

NEXTFST requires the WILD subroutine for execution. It must be
available when NEXTFST is loaded.

The FST may not contain the correct filemode letter, check the
returned ADT for that information. It does, however, contain the
correct file mode number.

@;@references
The following manual contains a description of the FST and ADT:
@i(IBM Virtual Machine Facility/370: Data Areas and Control Block
Logic,) Order number SY20-0884.
