@part(20KERMIT,root="USER")
@Chapter<DECSYSTEM-20 KERMIT>
@label<-k20>
@Index[TOPS-20]
@Index[DECSYSTEM-20]
@begin<description,leftmargin +12,indent -12,spread 0>
@i(Authors:)@\Frank da@ Cruz, Bill Catchings, Columbia University

@i(Language:)@\MACRO-20

@i(Version:)@\4(222)

@i(Date:)@\May 29, 1984
@end<description>

@subheading<KERMIT-20 Capabilities At A Glance:>
@begin<format,leftmargin +2,above 1,below 1>
@tabclear()@tabset(3.5inches,4.0inches)
Local operation:@\Yes
Remote operation:@\Yes
Transfers text files:@\Yes
Transfers binary files:@\Yes
Wildcard send:@\Yes
@q<^X/^Y> interruption:@\Yes
Filename collision avoidance:@\(Uses generation numbers)
Can time out:@\Yes 
8th-bit prefixing:@\Yes
Repeat count prefixing:@\Yes
Alternate block checks:@\Yes
Terminal emulation:@\Yes (transparent)
Communication settings:@\Yes; duplex, parity, handshake, flow
Transmit BREAK:@\Yes 
IBM communication:@\Yes
Transaction logging:@\Yes
Session logging:@\Yes
Raw transmit:@\No
Act as server:@\Yes
Talk to server:@\Yes
Advanced commands for servers:@\Yes
Local file management:@\Yes
Handle file attributes:@\No
Command/init files:@\Yes
@end<format>

KERMIT-20 is a program that implements the KERMIT file transfer protocol for
the Digital Equipment Corporation DECSYSTEM-20 mainframe computer.  It is
written in MACRO-20 assembly language and should run on any DEC-20 system
with version 4 of TOPS-20 or later.

This section will describe the things you should know about the DEC-20 file
system in order to make effective use of KERMIT, and then it will describe the
special features of the KERMIT-20 program.

@Section<The DEC-20 File System>

The features of the DEC-20 file system of greatest interest to KERMIT users are
the form of the file specifications, and the distinction between text and
binary files.

@Subheading<DEC-20 File Specifications>

DEC-20 file specifications are of the form
@example(DEVICE:<DIRECTORY>NAME.TYPE.GEN;ATTRIBUTES)
where the DIRECTORY, NAME, and TYPE may each be up to 39 characters in length,
GEN is a generation (version number), and various attributes are possible
(protection code, account, temporary, etc).  Generation and attributes are
normally omitted.  Device and directory, when omitted, default to the user's
own (or "connected") disk and directory.  Thus @q<NAME.TYPE> is normally
sufficient to specify a file, and only this information is sent along by
KERMIT-20 with an outgoing file.

The device, directory, name, and type fields may contain uppercase letters,
digits, and the special characters "@q<->" (dash), "@q<_>" (underscore), and
"@q<$>" (dollar sign).  There are no imbedded or trailing spaces.  Other
characters may be included by prefixing them (each) with a Control-V.  The
fields of the file specification are set off from one another by the
punctuation indicated above.

The device field specifies a physical or "logical" device upon which the file
is resident.  The directory field indicates the area on the device, for
instance the area belonging to the owner of the file.  KERMIT-20 does not
transmit the device or directory fields to the target system, and does not
attempt to honor device or directory fields that may appear in incoming file
names; for instance, it will not create new directories.

The name is the primary identifier for the file.  The type, also called the
"extension", is an indicator which, by convention, tells what kind of file we
have.  For instance @q<FOO.FOR> is the source of a Fortran program named FOO;
@q<FOO.REL> might be the relocatable object module produced by compiling
@q<FOO.FOR>; @q<FOO.EXE> could an executable program produced by LOADing
and SAVing @q<FOO.REL>, and so forth.

@index<Wildcard>
The DEC-20 allows a group of files to be specified in a single file
specification by including the special "wildcard" characters, "@q<*>" and
"@q<%>".  A "@q<*>" matches any string of characters, including no characters
at all; a "@q<%>" matches any single character.  Here are some examples:
@Begin(Description,spread 0.5,leftmargin +8, indent -8)
@q<*.FOR>@\All files of type @q<FOR> (all Fortran source files) in the
connected directory.
	
@q<FOO.*>@\Files of all types with name @q<FOO>.
	
@q<F*.*>@\All files whose names start with F.

@q<F*X*.*>@\All files whose names start with F and contain at least one X.

@q<%.*>@\All files whose names are exactly one character long.

@q<*.%%%*>@\All files whose types are at least three characters long.
@End(Description)
Wildcard notation is used on many computer systems in similar ways, and it is
the mechanism most commonly used to instruct KERMIT to send a group of files.

@Subheading<@ @ Text Files and Binary Files>

The DEC-20, like most computers, has a file system with its own peculiarities.
Like many other systems, the DEC-20 makes a distinction between @i<text files>
and @i<binary files>.  Text files are generally those composed only of printing
characters (letters, digits, and punctuation) and "carriage control" characters
(carriage return, line feed, form feed, tab).  Text files are designed to be
read by people.  Binary files are designed to be read by a computer program,
and may have any contents at all.  If you use the DEC-20 TYPE command to
display a text file on your terminal, the result will be intelligible.  If you
type a binary file on your terminal, you will probably see mainly gibberish.
You can not always tell a text file from a binary file by its name or directory
information, though in general files with types like @q<.TXT>, @q<.DOC>,
@q<.HLP> are textual (as are "source files" for computer programs like text
formatters and programming language compilers), and files with types like
@q<.EXE>, @q<.REL>, @q<.BIN> are binary.

The DEC-20 has an unusual word size, 36 bits.  It differs from most other
systems by storing text in 7-bit, rather than 8-bit, bytes.  Since text is
encoded in the 7-bit ASCII character set, this allows more efficient use of
storage.  However, the word size is not a multiple of the normal byte size.
The DEC-20 therefore stores five 7-bit characters per word, with one bit left
over. 
	
It is also possible to store files with other byte sizes.  The common layouts
of bytes within a word are:
@Begin(Description,leftmargin +8,indent -4,group)
@ 7@\Text Files: Five 7-bit bytes per word.
@Begin(Example,leftmargin +1)
+------+------+------+------+------++
|      |      |      |      |      ||
+------+------+------+------+------++
0      7      14     21     28     35
@End(Example)
Normally, bit 35 is unused and set to zero.  However, in EDIT (or SOS, or OTTO)
line-@|numbered files, bit 35 is set to 1 when the word contains a line number.
@End(Description)

@Begin(Description,leftmargin +8,indent -4,group)
@ 8@\"Foreign" binary files:  Four 8-bit bytes per word.
@Begin(Example,leftmargin +1)
+-------+-------+-------+-------+---+
|       |       |       |       |   |
+-------+-------+-------+-------+---+
0       8       16      24      32  35
@End(Example)
Bits 32-35 are unused.
@End(Description)

@Begin(Description,leftmargin +8,indent -4,group)
36@\"Native" binary files:  One 36-bit byte per word.
@Begin(Example,leftmargin +1)
+-----------------------------------+
|                                   |
+-----------------------------------+
0                                   35
@End(Example)
All bits are used.
@End(Description)
@Index[Word Size]@Index[Byte Size] The minimum unit of disk allocation on the
DEC-20 is a @i<page>, 512 36-bit words, or 2560 7-bit characters, or 2048 8-bit
bytes.  Any file that contains at least one bit of information occupies at
least a full page on the disk.  The directory information for a file includes
the number of pages occupied on the disk, the bytesize of the file, and the
number of bytes of that size which are in the file.  This information can be
seen by using the DEC-20 VDIRECTORY command, for instance
@Begin(Example)
@@vdir foo.*

   PS:<MY-DIRECTORY>
 Name     Protection    Pages Bytes(Size) Creation 
 FOO.COM.1;P774242          1 384(8)     27-Dec-83 
    MAC.1;P774242           1 152(7)     27-Dec-83 
   .REL.1;P774242           1 39(36)     27-Dec-83
   .EXE.1;P774242           2 1024(36)   27-Dec-83

 Total of 5 pages in 4 files
@End(Example)
In this example, @q<FOO.MAC> occupies 1 page, and is composed of 152 7-bit
bytes.  This file is textual (program source for the MACRO assembler), 152
characters long.  Programs which read text files (such as text editors, program
compilers, the TYPE command, etc) determine the end of a file from the
byte count specified in the directory.  KERMIT-20 determines the end of file in
the same way, so although @q<FOO.MAC> occupies an entire 2560-@|byte page of
storage, only the first 152 characters are transmitted.  Binary files, such
as @q<FOO.EXE> (an executable DEC-20 program), tend to occupy full pages.  In
this case too, KERMIT-20 uses the byte count to determine the end of file.

Why do you need to know all this?  In most cases, you don't.  It depends on
whether you are using the DEC-20 as your "home base".

@subheading<@ @ Using a Microcomputer to Archive DEC-20 Files>

Most computers (other than the DEC-10 and DEC-20) store characters in 8-bit
bytes.  Let's call any such system an 8-bit-@|byte system.  This discussion
applies to all 8-bit-@|byte systems, including all popular microcomputers,
minicomputers like the DEC PDP-11 and VAX, and mainframes like the IBM 370.
For simplicity, we'll focus on microcomputers.

KERMIT can send any "native" DEC-20 sequential file, text or binary, to an
8-bit-@|byte system and bring it back to the DEC-20 restored to its original
form.  If you are using a microcomputer to archive your DEC-20 files, you need
never concern yourself with details of byte size or file format.  The same
holds true between two DEC-20s, or a DEC-10 and a DEC-20.

@index<End Of File>@index<CP/M> There is, however, one special complication of
which you should be aware.  Certain microcomputer operating systems, notably
CP/M, do not have an entirely satisfactory way of indicating the end of file.
The file length is recorded in blocks rather than bytes.  For text files, the
end of file is marked within a block by inserting a Control-Z after the last
data character.  Binary files, however, might easily contain Control-Z
characters as data.  Therefore, in order not to lose data, these systems must
transmit binary files in complete blocks.  If the binary file is of foreign
origin (for instance, from a DEC-20), and it did not happen to fill up the last
block when it was transferred to the micro, then when that file is sent back to
the system of origin in "binary mode," junk will appear at the end (if it is
sent back in "text mode," it might be truncated by any data byte that happened
to correspond to Control-Z).  For DEC-20 programs in @q<.EXE> format, this
generally has no effect on the runnability or behavior of the program.  But for
other binary files, particularly internal format numerical data or relocatable
program object (@q<.REL>) files, the junk could have bad effects.  Extraneous
data at the end of a @q<.REL> file will generally cause LINK to fail to load
the file.

@subheading<@ @ Using the DEC-20 to Archive Microcomputer Files>

You can use KERMIT to send textual files from a microcomputer or any 8-bit
system to the DEC-20 with no special provisions, since KERMIT-20 stores
incoming characters in 7-bit bytes as text unless you explicitly instruct it
otherwise.  But KERMIT-20 has no automatic way of distinguishing an incoming
binary file from an incoming text file.@foot<Unless the incoming file has an
"ITS Binary Header"; see below.> Binary files from 8-bit-@|byte systems
generally contain significant data in the 8th bit, which would be lost if the
incoming characters were stored in 7-bit bytes, rendering the file useless when
sent back to the original system.  Thus if you want to use KERMIT to store
foreign 8-bit binary data on the DEC-20, you must tell it to store such files
with a bytesize of 8 rather than 7.  This can be the source of much confusion
and inconvenience.  In particular, you cannot use a "wildcard send" command to
send a mixture of text and binary files from an 8-bit-@|byte system to the
DEC-20; rather, you must send all text files with KERMIT-20's file bytesize set
to 7, and all 8-bit binary files with the bytesize set to 8.

Once you get the foreign binary file into the DEC-20, stored with the correct
bytesize (as @q<FOO.COM> is stored in the example above), you need take no
special measures to send it back to its system of origin.  This is because
KERMIT-20 honors the bytesize and byte count from the directory.  For instance,
if you told KERMIT-20 to @q<SEND FOO.*>, every file in the example above would
be transmitted in the correct manner, automatically.

@subheading<@ @ Files KERMIT-20 Cannot Handle>

The KERMIT protocol can only accommodate transfer of @i<sequential> files,
files which are a linear sequence of bytes (or words).

Some files on the DEC-20 are not sequential, and cannot be successfully sent or
received by KERMIT-20.  These include directory files, files with holes
(missing pages), ISAM files, and RMS files.  These files require external
information (kept in the DEC-20's file descriptor block and/or index table) in
order to be reconstructed; when sending files, KERMIT-20 presently transmits
only the file name and the contents of the file.  External control information
(file attributes) are not transmitted.

@Section<Program Operation>

Kermit-20's prompt is "@q(Kermit-20>)".
Kermit-20 will accept a single command on the Exec command line, like this:
@begin[example]
@@
@@@ux[kermit send foo.bar]

  @i(the file is sent)

@@
@End(Example)
or you can run the program interactively to issue several commands, like this:
@Begin(Example)
@@
@@@ux[kermit]

TOPS-20 KERMIT version 4(222)

Kermit-20>@ux[send foo.*]

  @i(files are sent)

Kermit-20>@ux[statistics]

  @i(performance statistics are printed)

Kermit-20>@ux[receive]

  @i(files are received)

Kermit-20>@ux[exit]
@@
@end[example]

@index<Help>
During interactive operation, you may use the TOPS-20 help ("?") and
@index<Recognition>recognition (ESC) features freely while typing commands.  A
question mark typed at any point in a command displays the options available at
that point; typing an ESC character causes the current keyword or filename to
be completed (or default value to be supplied), and a "guide word" in
parentheses to be typed, prompting you for the next field.  If you have not
typed sufficient characters to uniquely specify the keyword or filename (or if
there is no default value) then a beep will be sounded and you may continue
typing.

Command keywords may be abbreviated to their shortest prefix that sets them
apart from any other keyword valid in that field.

If you have a file called @q<KERMIT.INI> in your login directory, KERMIT-20
will execute an automatic TAKE command on it upon initial startup.
@q<KERMIT.INI> may contain any KERMIT-20 commands, for instance SET commands,
or DEFINEs for SET macros to configure KERMIT-20 to various systems or
communications media.

KERMIT-20 provides most of the commands possible for an "ideal" KERMIT program,
as described in the main part of the @i(KERMIT User Guide).  The following
sections will concentrate on system-@|dependent aspects of KERMIT-20.

@index<Interference>
@index<Message Interference>
KERMIT-20 disables terminal links, advice, and system messages in order to
minimize interference with data transfer (and restores these to their previous
value upon completion of a transfer).  However, certain messages cannot be
disabled by KERMIT because they are issued by KERMIT's superior controlling
process, the TOPS-20 EXEC.  These include mail notifications and alerts.
Before running KERMIT-20 to transfer files, you should SET NO MAIL-WATCH and
SET NO ALERT.

@Section<Remote and Local Operation>

KERMIT-20 normally runs in remote mode, with the user sitting at a PC.
But KERMIT-20 can also run in local mode.  Local operation of KERMIT-20 is
useful if the DEC-20 has an autodialer, or a hardwired connection to another
computer.  When in local mode, file transfer takes place over an
assigned TTY line, and KERMIT-20 is free to update your screen with status
information, and to listen to your keyboard for interrupt characters.
@Begin(Example,leftmargin +1,group)

@i<Local Operation of KERMIT-20:>

                       DEC-20                  (local)
                      +-------------------------------+
+----------+          |                               |          (remote)
| Terminal |----/ /---+-Your job's TTY                |         +--------+
+----+-----+          |                               |         |        |
     |                |        TTY assigned by KERMIT-+---/ /---+  Host  |
    You               |                               |         |        |
                      +-------------------------------+         +--------+
@End(Example)

KERMIT-20 enters local mode when you issue a SET LINE @i<n> command, where
@i<n> is the octal TTY number of any line other than your own controlling
terminal. 

@Section<KERMIT-20 Commands>

This section describes the KERMIT-20 commands, in detail where they differ from
the "ideal" KERMIT, briefly where they coincide.

@Heading<The SEND Command>
@Index[Initial Filespec]@Index[SEND]
Syntax: 

Sending a single file:
 @display(@q<SEND @i{nonwild-filespec1} (AS) [@i{filespec2}]>)

Sending multiple files:
 @display(@q<SEND @i{wild-filespec1} (INITIAL) [@i{filespec2}]>)

The SEND command causes a file or file group to be sent from the DEC-20 to the
other system.  There are two forms of the command, depending on whether
@i{filespec1} contains wildcard characters ("@q[*]" or "@q[%]").  KERMIT-20
automatically recognizes the two cases and issues the appropriate guide word,
(AS) or (INITIAL), depending on the form of @i{filespec1}.

@subheading<@ @ Sending a File Group>

If @i{filespec1} contains wildcard characters then all matching files will be
sent, in alphabetical order (according to the ASCII collating sequence) by
name.  If a file can't be opened for read access, it will be skipped.
@Index<Initial Filespec>The initial file in a wildcard group can be specified
with the optional @i{filespec2}.  This allows a previously interrupted wildcard
transfer from where it left off, or it can be used to skip some files that
would be transmitted first.

@subheading<@ @ Sending a Single File>

If @i{filespec1} does not contain any wildcard characters, then the single file
specified by @i{filespec1} will be sent.  Optionally, @i{filespec2} may be
used to specify the name under which the file will arrive at the target
system; @i{filespec2} is not parsed or validated in any way by KERMIT-20,
but lower case letters are raised to upper case, and leading
"whitespace" (blanks and tabs) are discarded.  If @i{filespec2} is not
specified, KERMIT-20 will send the file with its own name.@foot[Control-V's,
which are used to quote otherwise illegal characters in DEC-20 file
specifications, are stripped.]

@Subheading<@ @ SEND Command General Operation>

@Index<Normal Form for File Names>
Files will be sent with their DEC-20 filename and filetype (for instance
@q<FOO.BAR>, no device or directory field, no generation number or attributes).
If you expect to be sending files whose names contain characters that would be
illegal in filenames on the target system, and you know that the KERMIT on the
target system does not have the ability to convert incoming filenames, you can
issue the SET FILE NAMING NORMAL-FORM command to have KERMIT-20 replace suspect
characters by @q<X>'s.

Each file will be sent according to its bytesize and byte count from the
directory unless you specify otherwise using SET FILE BYTESIZE, or unless the
file has an "ITS Binary" header.  If the bytesize is 8, then four 8-bit bytes
will be sent from each DEC-20 36-bit word, and the low order four bits will be
skipped.  If other than 8, then five 7-bit bytes will be sent from each word,
with the 8th bit of the 5th character set to the value of the remaining bit
("bit 35") from the word.@foot<This is the same method used by the DEC-20 to
encode 36-bit data on "ANSI-ASCII" tapes.  It allows not only DEC-20 binary
files, but also the line-@|sequence-@|numbered files produced by EDIT, SOS, or
OTTO, which use bit 35 to distinguish line numbers from text, to be sent and
retrieved correctly.>

@Index<Parity>@Index<Eighth-Bit-Prefix>@Index<Binary Files>
@Index<Line Sequence Numbers>
If communication line parity is being used (see SET PARITY), KERMIT-20 will
request that the other KERMIT accept a special kind of prefix notation for
binary files.  This is an advanced feature, and not all KERMITs have it; if the
other KERMIT does not agree to use this feature, binary files cannot be sent
correctly.  This includes executable programs (like DEC-20 @q<.EXE> files, CP/M
@q<.COM> files), relocatable object modules (@q<.REL> files), as well as text
files with line sequence numbers.

@Index<Repeated Character Compression>
KERMIT-20 will also ask the other KERMIT whether it can handle a special prefix
encoding for repeated characters.  If it can, then files with long strings of
repeated characters will be transmitted very efficiently.  Columnar data,
highly indented text, and binary files are the major beneficiaries of this
technique.

If you're running KERMIT-20 locally, for instance dialing out from the DEC-20
to another system using an autodialer, you should have already run KERMIT on
the remote system and issued either a RECEIVE or a SERVER command.
Once you give KERMIT-20 the SEND command, the name of each file will be
displayed on your screen as the transfer begins; a "@q<.>" will be displayed
for every 5 data packets sucessfully sent, and a "@q<%>" for every
retransmission or timeout that occurs (you may also elect other typeout options
with the SET DEBUG command).  If the file is successfully transferred, you will
see "@q<[OK]>", otherwise there will be an error message.  When the specified
operation is complete, the program will sound a beep.
If you see many "@q<%>" characters, you are probably suffering from a noisy
connection.  You may be able to cut down on the retransmissions by using SET
SEND PACKET-LENGTH to decrease the packet length; this will reduce the
probability that a given packet will be corrupted by noise, and reduce the time
required to retransmit a corrupted packet.

During local operation, you can type Control-A@Index<Control-A> at any point
during the transfer to get a brief status report.
@index<Control-X>@index<Control-Z>@Index<Cancelling a File Transfer> You may
also type Control-X or Control-Z to interrupt the current file or file group.

@Heading<The RECEIVE Command>
@Index[RECEIVE]
Syntax:  @q<RECEIVE [@i{filespec}]>

The RECEIVE command tells KERMIT-20 to receive a file or file group from the
other system.  If only one file is being received, you may include the optional
@i{filespec} as the name to store the incoming file under; otherwise, the name
is taken from the incoming file header.  Even if the name in the header is not
a legal TOPS-20 file name, KERMIT-20 will store it under that name, in which
case you can refer to it later only by quoting each illegal character (spaces,
lowercase letters, control characters, etc) with Control-V@Index<Control-V>.
If for some reason an incoming filename simply cannot be converted to legal
form, the file will be saved as @q<-UNTRANSLATABLE-FILENAME-.KERMIT> (new
generation).  You may also use SET FILE NAMING NORMAL-FORM to have KERMIT-20
choose more conventional names for incoming files.

@index<DELETE>@index<UNDELETE>@index<Generation>
If an incoming file has the same name as an
existing file, KERMIT-20 just creates a new generation of the same name and
type, for instance @q<FOO.BAR.3, FOO.BAR.4>.  The oldest generation will be
automatically deleted, but you can still UNDELETE it.

Incoming files will all be stored with the prevailing bytesize, 7 by default,
which is appropriate for text files.  @Index<Binary Files> If you are asking
KERMIT-20 to receive binary files from a microcomputer or other 8-bit system,
you must first type SET FILE BYTESIZE 8.  Otherwise, the 8th bit of each byte
will be lost and the file will be useless when sent back to the system of
origin.

@Index<Parity>@Index<Eighth-Bit Prefix>@Index<Repeated Character Compression>
If you have SET PARITY, then 8th-bit prefixing will be requested.  If the other
side cannot do this, binary files cannot be transferred correctly.  In all
cases, KERMIT-20 will request the other KERMIT to compress repeated characters;
if the other side can do this (not all KERMITs know how) there may be a
significant improvement in transmission speed.

If an incoming file does not arrive in its entirety, KERMIT-20 will normally
discard it; it will not appear in your directory.  You may change this behavior
@Index<Incomplete File Disposition>
by using the command SET INCOMPLETE KEEP, which will cause as much of the file
as arrived to be saved in your directory. 

If you are running KERMIT-20 locally, you should already have issued a
SEND command @foot(@i<not> SERVER -- use the GET command to receive files from
a KERMIT server.) to the remote KERMIT, and then escaped back to DEC-20 Kermit.
As files arrive, their names will be displayed on your screen, along with
"@q<.>" and "@q<%>" characters to indicate the packet traffic; you can type
Control-A during the transfer for a brief status report.

@Index<Control-X>@Index<Control-Z>@Index<Cancelling a File Transfer>
If a file arrives that you don't really want, you can attempt to cancel it
by typing Control-X; this sends a cancellation request to the
remote Kermit.  If the remote Kermit understands this request (not all
implementations of Kermit support this feature), it will comply;
otherwise it will continue to send.  If a file group is being sent, you can
request the entire group be cancelled by typing Control-Z.

@Heading<The GET Command>

Syntax: @q<GET @i{remote-filespec}>

The GET command requests a remote KERMIT server to send the file or file group
specified by @i<remote-filespec>.  This command can be used only when KERMIT-20
is local, with a KERMIT server on the other end of the line specified by SET
LINE.  This means that you must have CONNECTed to the other system, logged in,
run KERMIT there, issued the SERVER command, and escaped back to the DEC-20.

The remote filespec is any string that can be a legal file specification for
the remote system; it is not parsed or validated locally.  As files arrive,
their names will be displayed on your screen, along with "@q<.>" and "@q<%>"
characters to indicate the packet traffic.  As in the RECEIVE command, you may
type Control-A to get a brief status report, ^X to request that the current
incoming file be cancelled, ^Z to request that the entire incoming batch be
cancelled.

If the remote KERMIT is not capable of server functions, then you will probably
get an error message back from it like "Illegal packet type".  In this case,
you must connect to the other Kermit, give a SEND command, escape back, and
give a RECEIVE command.

@Heading<The SERVER Command>
@Index<Server>

The SERVER command puts a remote KERMIT-20 in "server mode", so that it
receives all further commands in packets from the local KERMIT.  The KERMIT-20
server is capable (as of this writing) of executing many remote server
commands, including SEND, GET, FINISH, BYE, REMOTE DIRECTORY, REMOTE CWD,
REMOTE SPACE, REMOTE DELETE, REMOTE TYPE, REMOTE HELP.

@Index<Byte Size>
Any nonstandard parameters should be selected with SET commands before putting
KERMIT-20 into server mode, in particular the file bytesize.  The DEC-20 Kermit
server can send most files in the correct manner automatically, by recognizing
the DEC-20 file bytesize.  However, if you need to ask the DEC-20 KERMIT server
to receive binary files from an 8-bit-@|byte system (that is, from almost any
system that's not a DEC-10 or DEC-20) you must issue the SET FILE BYTESIZE 8
command before putting it into server mode, and then you must only send 8-bit
binary files.  You cannot send a mixture of text files and 8-bit binary files
to a KERMIT-20 server.

@Heading<Commands for Servers>

When running in local mode, KERMIT-20 allows you to give the full range of
commands to a remote KERMIT server, with no guarantee the that the remote
server can process them, since they are all optional features of the protocol.
Commands for servers include the standard @q<SEND>, @q<GET>, @q<BYE>,
and @q<FINISH> commands, as well as the @q<REMOTE> command, which has various
options.

Syntax: @q<REMOTE @i{command}>

Send the specified command to the remote server.  If the server does not
understand the command (all of these commands are optional features of the
KERMIT protocol), it will reply with a message like "Unknown KERMIT server
command".  If does understand, it will send the results back, and they will be
displayed on the screen.  The REMOTE commands are:
@begin<description>
CWD [@i<directory>]@\Change Working Directory.  If no directory name is
provided, the server will change to the default or home directory.  Otherwise,
you will be prompted for a password, and the server will attempt to change to
the specified directory.  The password is entered on a separate line, and does
not echo as you type it.  If access is not granted, the server will provide a
message to that effect.

DELETE @i<filespec>@\Delete the specified file or files.  The names of the
files that are deleted will appear on your screen.

DIRECTORY [@i<filespec>]@\The names of the files that match the given
file specification will be displayed on your screen, perhaps along with size
and date information for each file.  If no file specification
is given, all files from the current directory will be listed.

HELP@\Provide a list of the functions that are available from the server.

HOST [@i<command>]@\Pass the given command to the server's host command
processor, and display the resulting output on your screen.

SPACE@\Provide information about disk usage in the current directory, such as
the quota, the current storage, the amount of remaining free space.

TYPE @i<filespec>@\Display the contents of the specified file on your screen.
@end<description>

@Heading<The LOCAL Command>

Syntax: @q<LOCAL [@i{command}]>

Execute the specified command on the local system -- on the DEC-20 where
KERMIT-20 is running.  These commands provide some local file management
capability without having to leave the KERMIT-20 program.
@begin<description>
CWD [@i<directory>]@\Change working directory, or, in DEC-20 terminology,
CONNECT to the specified directory.

DELETE @i<filespec>@\Delete the specified file or files, but do not expunge
them. 

DIRECTORY [@i<filespec>]@\Provide a directory listing of the specified files.

RUN [@i<filespec>]@\Attempts to run the specified file, which must be in
"@q<.EXE>" format (@q<.EXE> is the default filetype), in an inferior fork.
Control returns to KERMIT-20 when the program terminates.  Once you have used
this command, you can restart the same program by issuing a RUN command with no
arguments.  If you RUN @q<SYSTEM:EXEC>, then you will be able to issue TOPS-20
commands without leaving KERMIT; you can get back to KERMIT from the EXEC by
typing the EXEC POP command.  You can also use the RUN command to supply new
functions to KERMIT by writing little programs in the language of your choice,
for instance to conduct a signon dialog with a remote system when dialing out.

SPACE@\Show how much space is used and remaining in the current directory.

TYPE@\Display the contents of the specified file or files at your terminal.
This works like the DEC-20 TYPE command, except that if a file has a bytesize
of 8, KERMIT-20 will do 8-bit input from it rather than 7-bit.  Also, the
DEC-20 Control-O command discards output only from the file currently being
displayed; if multiple files are being typed, then output will resume with the
next file.

@end<description>
The LOCAL commands may also be used without the "LOCAL" prefix.

@Heading<The CONNECT Command>

Syntax: @q<CONNECT [@i{number}]>

Establish a terminal connection to the system connected to the octal TTY
number specified here or in the most recent SET LINE command, using full
duplex echoing and no parity unless otherwise specified in previous SET
commands.  Get back to KERMIT-20 by typing the escape character followed by
the letter C.  The escape character is Control-Y by default.  When you type
the escape character, several single-@|character commands are possible:

@Begin(Description,leftmargin +6,indent -4, spread 0)
@q<C>@\Close the connection and return to KERMIT-20.

@q<S>@\Show status of the connection.

@q<P>@\Push to a new Exec.  POP from the Exec to get back to the connection.

@q<Q>@\If a session log is active, temporarily Quit logging.

@q<R>@\Resume logging to the session log.

@q<B>@\Send a simulated BREAK signal.

@q<?>@\List all the possible single-character arguments.

@q<^Y> (or whatever you have set the escape character to be)@\Typing the escape
 character twice sends one copy of it to the connected host.
@End(Description)
You can use the SET ESCAPE command to define a different escape character, and
SET PARITY, SET DUPLEX, SET HANDSHAKE to change those parameters.

KERMIT-20 accomplishes the connection by running the TTLINK program in a lower
fork.  If all you want to do connect to a remote host over a TTY line, without
file transfer, you can run TTLINK itself.  Note that the function for sending a
simulated BREAK can be dangerous.  See the description of the TTLINK program
below.

KERMIT-20 does not have any special autodialer interface.  It assumes that the
connection has already been made and the line assigned.  

@Heading<The HELP Command>

Syntax: @q<HELP [@i{topic} [@i{subtopic}]]> 

Typing HELP alone prints a brief summary of KERMIT-20 and its commands.
You can also type
@Begin(Example)
HELP @i<command>
@End(Example)
for any Kermit-20 command, e.g. "help send" or "help set parity" to get more
detailed information about a specific command.  Type
@Begin(Example)
HELP ?
@End(Example)
to see a list of the available help commands. 

@Heading<The TAKE Command>
Syntax: @q<TAKE @i{filespec}>

Execute KERMIT-20 commands from the specified file.  The file may contain
contain any valid KERMIT-20 commands, including other TAKE commands; command
files may be nested up to a depth of 20.

@Heading<The EXIT and QUIT Commands>
@Index<EXIT>@Index<CONTINUE>@Index<Control-C>
Syntax: @q<EXIT>

Exit from KERMIT-20.  You can CONTINUE the program from the TOPS-20 Exec,
provided you haven't run another program on top of it.  You can also exit from
KERMIT-20 by typing one or more control-C's, even if it's in the middle of
transferring a file.  KERMIT-20 will always restore your terminal to its
original condition, and you will be able to CONTINUE the program to get back
to "@q(KERMIT-20>)" command level with current settings intact.

@Index<QUIT>
@q<QUIT> is a synonym for EXIT.

@Heading<The SET Command>

Syntax: @q<SET @i{parameter} [@i{option} [@i{value}]]>

Establish or modify various parameters for file transfer or terminal
connection.  You can examine their values with the SHOW command.  The following
parameters may be SET:
@Begin(Description,spread 0.25)
BLOCK-CHECK@\Packet transmission error detection method

DEBUGGING@\Record or display state transitions or packets

DELAY@\How long to wait before starting to send

DUPLEX@\For terminal connection, FULL (remote echo) or HALF (local echo)

ESCAPE@\Character for terminal connection

FILE@\For setting file parameters like name conversion and byte size

FLOW-CONTROL@\For enabling or disabling XON/XOFF flow control

HANDSHAKE@\For turning around half duplex communication line

IBM@\For communicating with an IBM mainframe

INCOMPLETE@\What to do with an incomplete file

ITS-BINARY@\For recognizing a special 8-bit binary file format

LINE@\TTY line to use for terminal connection or file transfer

PARITY@\Character parity to use

PROMPT@\Change the program's command prompt

RECEIVE@\Various parameters for receiving files

RETRY@\How many times to retry a packet before giving up

SEND@\Various parameters for sending files

TVT-BINARY@\For negotiating binary mode over ARPANET connections
@End(Description)

The DEFINE command may be used to compose "macros" by combining SET commands.
Those SET commands which differ from the "ideal" KERMIT are now described in
detail.

@Subheading<SET DEBUG>
@Index<Debugging>
Syntax: @q<SET DEBUG @i{options}>

Record the packet traffic, either on your terminal or in a file.  Some
reasons for doing this would be to debug a version of KERMIT that you are
working on, to record a transaction in which an error occurred for evidence
when reporting bugs, or simply to vary the display you get when running
KERMIT-20 in local mode.  Options are:
@Begin(Description)
STATES@\Show Kermit state transitions and packet numbers (brief).

PACKETS@\Display each incoming and outgoing packet (lengthy).

OFF@\Don't display or record debugging information (this is the normal mode).
If debugging was in effect, turn it off and close any log file.
@End(Description)
The debugging information is recorded in the file specified by the most recent
LOG DEBUGGING command.

@Subheading<SET ESCAPE>
@Index<Escape Character for CONNECT>
@q<SET ESCAPE @i{octal-number}>

Specify the control character you want to use to "escape" from remote
connections back to KERMIT-20.  The default is 31 (Control-Y).  The number is
the octal value of the ASCII control character, 1 to 37, for instance 2 is
Control-B.  After you type the escape character, you must follow it by a
one of the single-@|character "arguments" described under the CONNECT command,
above.

@Subheading<SET EXPUNGE>
@Index<Expunging Deleted Files>
@q<SET EXPUNGE ON @i(or) OFF>

Tell whether you want a DELETE command (either the LOCAL DELETE command or a
REMOTE DELETE command sent to a KERMIT-20 server) to expunge files as it
deletes them.  On the DEC-20, a deleted file continues to take up space, and
may be "undeleted" at a later time in the same session.  To expunge a deleted
file means to remove it completely and irrevocably, freeing its space for
further use.  EXPUNGE is OFF by default; deleted files are not automatically
expunged.  SET EXPUNGE applies only to files that are deleted explicitly by
KERMIT-20, and not to files that are implicitly deleted when new generations of
existing files are created.

@Subheading<SET FILE>
Syntax: @q<SET FILE @i{parameter keyword}>

Establish file-related parameters:
@Begin(Description,leftmargin +8,indent -8)
BYTESIZE @i{keyword or number}@\@Index<Byte Size>Byte size for DEC-20 file
input/output.  The choices are SEVEN (7), EIGHT (8), and AUTO.
@Begin(Description,leftmargin +8,indent -8)
SEVEN@\(or 7) Always store or retrieve five 7-bit bytes per word.  When sending
a file, ignore the file bytesize and do 7-bit input from the file.  There would
be no reason to use this option except to explicitly force an 8-bit file to be
treated as a 7-bit file.

EIGHT@\(or 8) Always store or retrieve four 8-bit bytes per word.  When sending
a file, ignore the file bytesize and do 8-bit input from the file.  This
command is necessary when receiving binary files from 8-bit-@|byte systems,
such as most microcomputers.

AUTO@\Equivalent to SEVEN for incoming files, and for outgoing files means to
use EIGHT if the DEC-20 file bytesize (as shown by the Exec VDIR command) is 8,
otherwise use SEVEN.  The default is AUTO.
@End(Description)
The DEC-20 can send any mixture of file types in the correct way automatically,
but you @i<must> set the file bytesize to 8 for any incoming 8-bit binary
files, and to AUTO (i.e. 7) for any incoming text files or DEC-20 binary files.

@Index<Normal Form for File Names>
NAMING UNTRANSLATED @i<or> NORMAL-FORM@\If NORMAL-FORM the names of incoming or
outgoing files will be converted to contain only uppercase letters, digits, and
at most one period; any other characters will be translated to "@q<X>".  If
UNTRANSLATED, filenames will be sent and used literally.  UNTRANSLATED is the
default.
@End(Description)

@subheading<SET IBM>
@index<IBM>
Syntax: @q<SET IBM ON @i(or) OFF>

SET IBM is really a predefined SET macro rather than a "hardwired" SET command;
it can be redefined or undefined (see DEFINE); as distributed from Columbia,
KERMIT-20 defines IBM to be "parity mark, handshake XON, duplex half".

SET IBM should be used when running KERMIT-20 in local mode, connected to an
IBM or similar mainframe.  If you have redefined the SET IBM macro, then your
parameters will be used instead.

@Subheading<SET ITS-BINARY>
@Index<ITS-Binary Format>
Syntax: @q<SET ITS-BINARY ON @i<or> OFF>

Specify whether ITS-Binary file headers are to be recognized or ignored.  By
default, they are recognized.  ITS binary format is a way (devised at MIT) of
storing foreign 8-bit binary data on a 36-bit machine to allow automatic
recognition of these files when sending them out again, so that you don't have
to depend on the file byte size, or to issue explicit SET FILE BYTESIZE
commands to KERMIT.

An ITS format binary file contains the sixbit characters "DSK8" left-adjusted
in the first 36-bit word.  If ITS-BINARY is ON, then KERMIT-20 will send any
file starting with this "header word" using 8-bit input from the file even if
the file bytesize is not 8, and will not send the header word itself.
KERMIT-20 will also store any incoming file that begins with that header word
using 8-bit bytesize, again discarding the header word itself.  If ITS-BINARY
is OFF, then the header word, if any, will be sent or kept, and i/o will be
according to the setting of FILE BYTESIZE.

This facility is provided for compatibility with the file formats used on
certain public-@|access CP/M libraries. 

@Subheading<SET LINE>
Syntax: @q<SET LINE [@i(octal-number)]>

Specify the octal TTY number to use for file transfer or CONNECT.
If you issue this command, you will be running KERMIT-20 @i<locally>, and you
must log in to the remote system and run Kermit on that side in order to
transfer a file.  If you don't issue this command, KERMIT-20 assumes it is
running @i<remotely>, and does file transfer over its job's controlling
terminal line.  You can also select the line directly in the CONNECT command;
the command @example(CONNECT 12) is equivalent to
@begin<example>
SET LINE 12
CONNECT
@end<example>

If you type SET LINE with no number argument, you will deassign any previous
assigned line and revert to remote mode.

The SHOW LINE command will display the currently selected communication line
and its charactistics, including parity, duplex, handshake, flow control, the
speed if known, whether carrier is present (if it is a modem-@|controlled
line), and whether KERMIT-20 is in local or remote mode.

@subheading<SET RECEIVE>

In addition to the full complement of SET RECEIVE commands described in the
main part of the manual, you may also SET RECEIVE SERVER-TIMEOUT to a value
between 0 and 94.  This specifies the number of seconds between timeouts during
server command wait, 0 specifies that no timeouts should occur during server
command wait.  When a KERMIT server times out, it sends a NAK packet.  Some
systems cannot clear piled-@|up NAKs from their input buffers; if you're using
such a system to communicate with a KERMIT-20 server, and you expect to be
leaving the server idle for long periods of time, you should use this command
to turn off server command-@|wait timeouts.

@subheading<SET TVT-BINARY>

Syntax: @q<SET TVT-BINARY ON> @i<or> @q<OFF>

@index<ARPANET>@index<TAC Binary Mode>@index<TVT-Binary>
Only for users running KERMIT-20 on an ARPANET DEC-20, signed on to an ARPANET
virtual terminal (TVT) from another host or through an ARPANET TAC.
SET TVT ON causes KERMIT-20 to negotiate binary mode
(8-bit) communication with the ARPANET during file transfer.  Without this
command, file transfer through a TVT would not work in most cases.

TVT-BINARY is OFF by default.  If you normally use KERMIT-20 through the
ARPAnet, you can put the command SET TVT-BINARY ON into your @q<KERMIT.INI>
file.

@i<CAUTION>: This facility requires certain features in the Release 5 TOPS-20
ARPANET monitor, which may not be present in releases distributed by DEC.  See
the KERMIT-20 source code for details.

@heading<The DEFINE Command>

Syntax: @q<DEFINE @i<macroname> [@i<set-option> [, @i<set-option> [...]]]>

@Index<DEFINE>
The DEFINE command is available in KERMIT-20 for building "macros" of SET
commands.  The macro name can be any keyword-@|style character string, and the
set options are anything you would type after SET in a SET command; several set
options may be strung together, separated by commas.  Example:
@example<define notimeout send timeout 0, receive timeout 0>
Macro definitions may not include macro names.  You can list all your macros
and their definitions with the SHOW MACROS command.  You can list a particular
macro definition with HELP SET @i<macroname>.

@Heading<The SHOW Command>
@Index<SHOW>
Syntax: @q<SHOW> [@i<option>]

The SHOW command displays various information:
@Begin(Description,spread 0.5)
DAYTIME@\Current date, time, phase of moon.

DEBUGGING@\Debugging mode in effect, if any.

FILE-INFO@\Byte size for DEC-20 file i/o, incomplete file disposition.

LINE@\TTY line, parity, duplex, flow control, handshake, escape character, and
speed if known.  Note that before release 6.0 of TOPS-20, the DEC-20 does not
keep a record of the actual baud rate of a modem-@|controlled or "remote" TTY
line.

MACROS@\Definitions for SET macros.

PACKET-INFO@\For incoming and outbound packets.  Items under RECEIVE column
show parameters for packets KERMIT-20 expects to receive, under SEND shows
parameters for outgoing packets.

TIMING-INFO@\Delays, retries, server NAK intervals.

VERSION@\Program version of KERMIT-20.  This is also displayed when KERMIT-20
is initially started.

ALL@\(default) All of the above.
@End(Description)

@Heading<The STATISTICS Command>
Give statistics about the most recent file transfer.
For instance, here's what KERMIT-20 displayed after transmitting a short binary
file, using repeated-@|character compression:
@Begin(Example) 

 Maximum number of characters in packet:  80 received; 80 sent
 Number of characters transmitted in 2 seconds
        Sent:      34           Overhead:       34
        Received:  107          Overhead:       -408
  Total received:  141          Overhead:       -374
 Total characters transmitted per second:       70
 Effective data rate:   2570 baud
 Efficiency:            214.1667 per cent
 Interpacket pause in effect: 0 sec

 Timeouts: 0
 NAKs:     0
@End(Example)

Note that the data compression allowed the effective baud rate to exceed the
actual speed of the communication line, which in this case happened to be 1200
baud.  The efficiency is displayed only if the actual baud rate is known.

@Heading<The LOG Command>

Syntax: @q<LOG> [@i<option> [@i<filespec>]]

Log the specified option to the specified file:
@begin<description>
SESSION@\During CONNECT, log all characters that appear on the screen to the
specified file.  The TTLINK process does the actual logging.  The session log
can be temporarily turned off during the remote session by typing the escape
character followed by Q (for Quit logging), and turned on again by typing the
escape character followed by R (for Resume logging).  Default log is 
@q<SESSION.LOG> in the current directory.

TRANSACTIONS@\During file transfer, log the progress of each file.  The DEC-20
transaction log file looks like this:
@begin<example>

KERMIT-20 Transaction Log File, Monday, 27-February-1984

18:40:13: Opened Log: PS:<TIMREK>SAMPLE.LOG.1
18:40:31: -- Send Begins --
   8th bit prefixing: Off
   Block check type: 1
18:40:31: Opened File: PS:<SY.FDC>LOGIN.CMD.6
   Sending As "LOGIN.CMD"
   Sent: 547 7-bit bytes
18:40:34: Closed PS:<SY.FDC>LOGIN.CMD.6
18:40:34: Send Complete
18:40:50: -- Receive Begins --
   8th bit prefixing: Off
   Block check type: 1
18:40:50: Opened: PS:<TIMREK>AUTOEXEC.BAT.1
   Written: 186 7-bit bytes
18:40:51: Closed: PS:<TIMREK>AUTOEXEC.BAT.1
18:40:56: Closed Transaction Log

@end<example>
Transaction logging is recommended for long or unattended file transfers, so
that you don't have to watch the screen.  The log may be inspected after the
transfer is complete to see what files were transferred and what errors may
have occurred.  Default log is @q<TRANSACTION.LOG> in the current directory.

DEBUGGING@\Log STATES or PACKETS, as specified in the most recent SET DEBUGGING
command, to the specified file.  If log file not specified, then use TTY if
local, or @q<DEBUGGING.LOG> in the current directory if remote.  If no SET
DEBUGGING command was previously issued, log STATES to the specified file.
Also allow specification of bytesize for the log file, 7 (normal, default), or
8 (for debugging binary transfers when the parity bit is being used for data),
for instance
@example"LOG DEBUGGING BINARY.LOG 8"
A 7-bit log file can be typed, printed, or examined with a text editor or
searching program.  An 8-bit log file can only be examined with a system
utility like FILDDT.  When logging packets, each packet is preceded by a
timestamp, the current timeout interval (preceded by a slash), and "@q<R:>" or
"@q<S:>" to indicate data being received and sent, respectively.  Packet format
is described in the @i<KERMIT Protocol Manual>.

@end<description>
SESSION is the default option.  Thus the command "LOG" alone will cause CONNECT
sessions to be logged in @q<SESSION.LOG> in the current directory.

@section<The TTLINK Program>
@begin<description,leftmargin +12,indent -12,spread 0>
@i(Author:)@\Frank da@ Cruz, Columbia University

@i(Language:)@\MACRO-20

@i(Version:)@\2(23)

@i(Date:)@\March 13, 1984
@end<description>

KERMIT-20 accomplishes the CONNECT command by running a separate program called
TTLINK as an inferior process.  KERMIT constructs a command line based upon the
current settings for line number, parity, duplex, "IBM mode," session logging,
and so forth, and "feeds" this line to TTLINK.  Once started, the TTLINK
process can be restarted repeatedly, remembering its previous settings.

TTLINK has the following commands:
@begin<description,spread 0>
CONNECT (TO TTY) @i<octal-line-number> @i<optional-switches>

STATUS@\Display current line number, duplex, log file, and escape character.

HELP@\Print a help message.

EXIT@\If you continue, previous defaults are preserved.
@end<description>
Command line arguments are accepted.

Escape character arguments are:
@begin<description,spread 0,indent -8>
@i(blank)@\Nothing (null command)

C@\Close Connection, "escape" back to DEC-20

S@\Show Status of Connection

P@\PUSH to new Exec

Q@\Quit logging

R@\Resume logging

B@\Send a BREAK signal

?@\Help

@i(escape character itself)@\Send the escape character itself.
@end<description>

Initial defaults for CONNECT are FULL DUPLEX, escape character = CTRL-Y, and
PARITY NONE.  No initial default for line or logfile.  Defaults for subsequent
CONNECT commands become whatever was specified in the most recent CONNECT
command, so that you can escape back to the DEC-20 and reconnect easily.

@heading<The TTLINK CONNECT Command>

CONNECT (TO TTY) @i<octal-line-number> @i<optional-switches>

The CONNECT command connects you to the specified line, with the specified
options.  The options are specified as "switches," each preceded by a slash,
and followed by a colon and an argument.  The valid switches are:

@begin<description>
/DUPLEX:@\FULL or HALF.  If FULL, remote host echoes; if HALF, local host.

/PARITY:@\NONE, MARK, SPACE, EVEN, or ODD.

/LOGFILE:@\Name of file for logging transcript of remote session.

/ESCAPE:@i<n>@\Octal value of an ASCII control character to be used as
the escape character during CONNECT.  Examples: 1=CTRL-A, 34=CTRL-\.

/SPEED:@i<n>@\See below.

/BREAK-NULLS:@i<n>@\See below.
@end<description>

Examples:
@begin<example>
  connect 5                    @i(connect over TTY 5, using all defaults)
  conn 17/duplex:half          @i(connect over TTY 17, with local echo)   
  c 33/parity:even             @i(connect over TTY 33, sending even parity)   
  c 77/dup:h/par:mark/esc:37   @i(shows how switches may be combined)
@end<example>

During CONNECT, all characters that you type will be transmitted to the remote
system except for your escape character.  If you type your escape character,
TTLINK will wait for you to type a second character to specify the desired
action, as shown above.  The single-@|character commands may be either upper or
lower case.  If you type any character not on the list, TTLINK will beep at
you.

@heading<Sending a BREAK Signal>

@index<BREAK>
Sending a BREAK signal to the remote host can be a tricky business, because the
DEC-20 supplies no function to do this.  Therefore, TTLINK simulates a BREAK by
temporarily setting the speed of the line to 50 baud, sending several null
(@w<ASCII 0>) characters, and then setting the speed back to what it was.  But
TTLINK has no way of knowing what the speed was unless you tell it, because
TOPS-20 (prior to version 6.0) does not record the speed of a "remote"
(modem-@|controlled) line.  Therefore, if you intend to send a BREAK signal to
the remote host, you must use the following switch on the CONNECT command:

@begin<description>
/SPEED:@i<n>@\The argument is a decimal number which is the current
speed of the line, such as 300 or 1200.
@end<description>
If you omit this switch, TTLINK will not try to send a BREAK.

You may transmit a BREAK by typing the BREAK key on your terminal ONLY IF YOU
ARE DIRECTLY CONNECTED TO THE SYSTEM WHICH IS RUNNING TTLINK (if you are
connected through a network, the BREAK generated by your terminal will not get
through to TTLINK).  In any case, you can always tell TTLINK to send a BREAK by
typing your escape character followed by the letter B.

If you find that your BREAK signal is not recognized correctly on the remote
system, you may have to adjust the number of NULL characters that are sent; the
following CONNECT command switch allows you to do this.

/BREAK-NULLS:@i<n>

The default number of NULLs transmitted is 3.  If that is not enough, the
remote system may not react.  If that number is too high, the remote system may
sense two or more BREAKs.

@Section<Examples>

Here are a few examples of the use of KERMIT-20.  Text entered by the user is
underlined.

@Subheading<Remote Operation>

The following example shows use of KERMIT-20 as a server from an IBM PC.  In
this example, the user runs KERMIT on the PC, connects to the DEC-20, and
starts KERMIT-20 in server mode.  From that point on, the user need never
connect to the DEC-20 again.  In this example, the user gets a file from the
DEC-20, works on it locally at the PC, and then sends the results back to the
DEC-20.  Note that the user can leave and restart KERMIT on the PC as often as
desired.
@begin<example,leftmargin +1>
A>@ux<kermit>
Kermit-86>@ux<connect>
@@
@@@ux<kermit>
TOPS-20 KERMIT version 4(222)

Kermit-20>@ux<server>

 Kermit Server running on DEC-20 host.  Please type your escape sequence
 to return to your local machine.  Shut down the server by typing the
 Kermit BYE command on your local machine.
@ux<^[C>
Kermit-86>@ux<get foo.txt>
@display<@i(The transfer takes place.)>
Kermit-86>@ux<exit>
A>
A>@ux<edit foo.txt> ; (@i<or whatever>...)
A>
A>@ux<kermit>
Kermit-86>@ux<send foo.txt>
@display<@i(The transfer takes place.)>
Kermit-86>@ux<bye>
A>
@End(Example)

The next example shows the special procedure you would have to use in order to
send a mixture of text and binary files from a PC (or an 8-bit-@|byte system)
to the DEC-20.  Note that in this case, it's more convenient to avoid server
mode.
@Begin(Example,leftmargin +1)
Kermit-86>@ux<connect>
@@
@@@ux<kermit>
TOPS-20 KERMIT version 4(222)

Kermit-20>@ux<receive>
@ux<^]C>
Kermit-86>@ux<send *.txt>
@display<@i(Textual files are sent.)>

Kermit-86>@ux<connect>
Kermit-20>@ux<set file bytesize 8>
Kermit-20>@ux<receive>
@ux<^]C>
Kermit-86>@ux<send *.exe>
@display<@i(Binary files are sent.)>

Kermit-86>@ux<connect>
Kermit-20>@ux<exit>
@@@ux<logout>
@ux<^]C>
Kermit-86>@ux<exit>
A>
@End(Example)

@Subheading<Local Operation>

In this example, a program DIAL is used to direct an autodialer to call another
computer (a DECSYSTEM-10); once the connection is made, DIAL starts KERMIT with
an implicit CONNECT command for the appropriate communication line.  DIAL is
not part of KERMIT; if your system has an autodialer, there will be some
site-@|specific procedure for using it.
@Begin(Example,leftmargin +1)
@@@ux<dial>
Dial>@ux<dial stevens>
STEVENS, 1-(201) 555-1234, baud:1200
[confirm]
Dialing your number, please hold...
Your party is waiting on TTY11:.
@@
@@@u<kermit>
TOPS-20 KERMIT version 4(222)

Kermit-20>@ux<connect 11>
[TTLINK: Connecting to remote host over TTY11:, type <CTRL-Y>C to return]

CONNECTING TO HOST SYSTEM.
Stevens T/S 7.01A(10) 20:20:04 TTY41 system 1282
Connected to Node DN87S1(101) Line # 57

Please LOGIN or ATTACH

.@ux<log 10,35>
JOB 51 Stevens T/S 7.01A(10) TTY41
Password: 
20:20   15-Dec-83       Thur

.@ux<r new:kermit>

TOPS-10 KERMIT version 2(106)

Kermit-10>@ux<server>

[Kermit Server running on the DEC host.  Please type your escape sequence
 to return to your local machine.  Shut down the server by typing the 
 Kermit BYE command on your local machine.]
@ux<^YC>

[TTLINK: Connection Closed.  Back at DEC-20.]

Kermit-20>@ux<set file bytesize 8>
Kermit-20>@ux<get setdtr.cmd>
^A for status report, ^X to cancel file, ^Z to cancel batch.
SETDTR.CMD.7 @ux<^A>
 Receiving SETDTR.CMD.7, file bytesize 8
 (repeated character compression)
 At page 1
 Files: 0, packets: 1, chars: 66
 NAKs: 0, timeouts: 0
.[OK]
Kermit-20>bye
Job 51  User F DA CRUZ [10,35]
Logged-off TTY41  at 20:22:58  on 15-Dec-83
Runtime: 0:00:01, KCS:33, Connect time: 0:02:39
Disk Reads:72, Writes:4, Blocks saved:160
....
Hangup? @ux<y>
Click. Call duration was 193 seconds to area 201.
Dial>@ux<exit>
@End(Example)
Note the use of Control-A to get a status report during the transfer.

@section<Installation>

KERMIT-20 is built from a single MACRO-20 source file, @q<20KERMIT.MAC>.
It requires the standard DEC-@|distributed tools MONSYM, MACSYM, and CMD;
the following files should be in @q<SYS:> -- @q<MONSYM.UNV, MACSYM.UNV,
MACREL.REL, CMD.UNV, @r(and) CMD.REL.>
The program should work on all TOPS-20 systems as distributed, but many
customizations are possible.  The site manager may wish to change various
default parameters on a site-@|wide basis; this may be done simply by changing
the definitions of the desired symbols, under "subttl Definitions", and
reassembling.

The most notable site dependency is the definition of "SET IBM".  As
distributed from Columbia, KERMIT-20 defines "SET IBM" in a built-in SET macro
definition as "parity mark, duplex half, handshake xon".  This definition may
be found at MACTAB+1, near the end of the impure data section.  It may be
changed or deleted, and the program reassembled.

Sites that do not have ARPANET may wish to delete the TVT-BINARY entries from
SET command tables, SETABL and SETHLP.
