
#include "k.h"
/*#include <sgtty.h>*/
#define CTRLD	4

/*
 *	c o n n e c t  - establish a virtual terminal connection with
 *					the remote host.
 */

connect()
{
	int parent;
	char c, r = '\r';
	struct sgttyb locmode, remmode;

	gtty(0,&locmode);
	locmode.sg_flags |= RAW;
	locmode.sg_flags &= ~(ECHO|CRMOD);
	stty(0,&locmode);
	locmode.sg_flags &= ~RAW;
	locmode.sg_flags |= (ECHO|CRMOD);

	gtty(remfd,&remmode);
	remmode.sg_ispeed = B4800;
	remmode.sg_ospeed = B4800;
	remmode.sg_flags |= RAW|TANDEM;
	remmode.sg_flags &= ~(ECHO|CRMOD);
	stty(remfd,&remmode);

	parent = fork();

	if (parent)
	/* parent does writing to remote host */
	{
		printf("Kermit: virtual terminal connection established.\r\n");
		while (c != CTRLD)
		{
			read(0,&c,1);
			write(remfd,&c,1);
		}
		kill(parent,9);
		stty(0,&locmode);
		printf("Kermit: virtual terminal connection broken.\n");
		return;
	}
	else
	/* child does the reading from the remote host */
	{
		while(1)
		{
			read(remfd,&c,1);
			write(1,&c,1);
		}
	}
}
