DELETE VOCABULARY;
DEFINE DOMAIN VOCABULARY
USING NEW_VOCAB_REC ON NEWVOCAB.DAT;

DELETE NEW_VOCAB_REC;
DEFINE RECORD NEW_VOCAB_REC
01 DEFINITION.
   02 WORD PIC X(14).
   02 MEANING PIC X(80).
   02 KEEP PIC X(1).
;

DELETE PRINT_DICTIONARY;
DEFINE PROCEDURE PRINT_DICTIONARY
READY VOCABULARY
REPORT VOCABULARY WITH KEEP EQ "Y" SORTED BY WORD ON ENGLISH.DAT
SET REPORT_NAME ="ENGLISH VOCABULARY LIST"
SET COLUMNS_PAGE = 132
SET LINES_PAGE = 80
PRINT SKIP, WORD, MEANING USING X(100)
END_REPORT
FINISH VOCABULARY
END-PROCEDURE

DELETE TEST_ME;
DEFINE PROCEDURE TEST_ME
DECLARE VOCABULARY_TEST PIC X(720) EDIT_STRING IS T(80).
DECLARE TEST_CHOICES PIC X(240) EDIT_STRING IS T(80).
DECLARE L1 PIC X(80).
DECLARE L2 PIC X(80).
DECLARE L3 PIC X(80).
DECLARE L4 PIC X(80).
DECLARE L5 PIC X(80).
DECLARE L6 PIC X(80).
DECLARE L7 PIC X(80).
DECLARE L8 PIC X(80).
DECLARE L9 PIC X(80).
DECLARE L10 PIC X(80).
DECLARE L11 PIC X(80).
DECLARE L12 PIC X(80).
L1 =  "    This procedure permits the user to test himself on the contents of the"
L2 = "english vocabulary list that have not been previously designated with an"
L3 = "N during a KEEP or NOT KEEP operation.  The list contents are displayed"
L4 = "one entry at a time, allowing the user to take time to ponder the word or"
L5 = "meaning prior to asking for a display of the rest of the entry.  The user"
L6 = "is also given the option of keeping (K) or not keeping (N) the entry during"
L7 = "subsequent testing or printing of the list.  The list entries that are not"
L8 = "kept (N) are not actually thrown away but are kept in memory and may be"
L9 = "restored by invoking the procedure :TEST-WORD."
L10 = "    There are two ways to take the test. One with the words displayed"
L11 = "first and then the meanings and the second with the meanings displayed"
L12 = "first and then the word.  Type CTRL\Z any time to halt the session."
VOCABULARY_TEST = L1|L2|L3|L4|L5|L6|L7|L8|L9
PRINT VOCABULARY_TEST
SET ABORT
IF *."Y if you wish to take a vocabulary test, N if not" NE "Y" ABORT "OKAY"
READY VOCABULARY WRITE
TEST_CHOICES = L10|L11|L12
PRINT SKIP, TEST_CHOICES
IF *."W if you want word first, M if you want meaning first" EQ "W"
:WORD_TEST ELSE :TRY_ME
PRINT "TEST OVER"
FINISH VOCABULARY
END-PROCEDURE

DELETE TEST_WORD;
DEFINE PROCEDURE TEST_WORD
READY VOCABULARY WRITE
FOR VOCABULARY SORTED BY WORD
BEGIN
PRINT SKIP 2, WORD, MEANING USING X(50), KEEP
IF *."K or N to Keep or Not Keep" NE "N" MODIFY USING KEEP = "Y" ELSE MODIFY USING KEEP = "N"
PRINT SKIP 2
END
FINISH VOCABULARY
END-PROCEDURE

DELETE TRY_ME;
DEFINE PROCEDURE TRY_ME
FOR VOCABULARY WITH KEEP NE "N" SORTED BY WORD
BEGIN
PRINT SKIP 2, MEANING
PRINT SKIP 2
IF *."Y when you are ready" NE "Y" PRINT "continuing anyway"
PRINT SKIP 2,WORD
PRINT SKIP 2
IF *."K or N to KEEP or NOT KEEP" EQ "N" MODIFY USING KEEP = "N"
END
END-PROCEDURE

DELETE WORD_TEST;
DEFINE PROCEDURE WORD_TEST
FOR VOCABULARY WITH KEEP NE "N" AND WORD GE *."WORD YOU WISH TO START WITH" SORTED BY WORD
BEGIN
PRINT SKIP 2, WORD
PRINT SKIP 2
IF *."Y when you are ready" NE "Y" PRINT "continuing anyway"
PRINT SKIP 2, MEANING
PRINT SKIP 2
IF *."K or N to KEEP or NOT KEEP" EQ "N" MODIFY USING KEEP = "N"
END
END-PROCEDURE

