.ENABLE SUBSTITUTION
;
; MTREK.CMD
;
; This command file will preprocess, compile & build Multi-trek for
; your system. The following system tasks must be installed (or 
; available thru flying installs) with the expected names:
;
;   ...RAT -- the RATFIV preprocessor (if you want to preprocess the
;	      RATFIV source into FORTRAN
;   ...F77 -- the FORTRAN 77 compiler
;   ...MAC -- Macro-11 assembler
;   ...TKB -- taskbuilder
;
; The FORTRAN source is also distributed in this account, so it is not
; really necessary to preprocess the RATFIV unless you just want to.
;

.SETS CLI <CLI>
.IF CLI <> "MCR" SET MCR
;

.SETS RAT "!RAT"	!assume no preprocessing
.ASK RAT5 Do you want to preprocess the RATFIV source
.IFF RAT5 .GOTO SKIP
.SETS RAT "RAT"
.IFINS RAT .GOTO SKIP
;
; *** The RATFIV preprocessor is not installed. 
;     Please install it (as ...RAT) & rerun this command file
;     (or answer NO to the above question)
.EXIT
.SKIP:	;

.IFINS F77 .GOTO SKIP
;
; *** The Fortran 77 compiler is not installed.
;     Please install it (as ...F77) & rerun this command file
;
.EXIT
.SKIP:	;


; compile various utility routines
MAC STRMOV=STRMOV

'RAT' ATAN3.RAT >ATAN3.FTN
F77 ATAN3/-TR/-CK=ATAN3

'RAT' DIRDIS.RAT >DIRDIS.FTN
F77 DIRDIS/-TR/-CK=DIRDIS

;
; compile ship routines
'RAT' MTREK.RAT >MTREK.FTN
F77 MTREK/-TR/-CK=MTREK

'RAT' SCREEN.RAT >SCREEN.FTN
F77 SCREEN/-TR/-CK=SCREEN

'RAT' COMMANDS.RAT >COMMANDS.FTN
F77 COMMANDS/-TR/-CK=COMMANDS

'RAT' DRVMSG.RAT >DRVMSG.FTN
F77 DRVMSG/-TR/-CK=DRVMSG

'RAT' RUNMTR.RAT >RUNMTR.FTN
F77 RUNMTR/-TR/-CK=RUNMTR

'RAT' INPOUT.RAT >INPOUT.FTN
F77 INPOUT/-TR/-CK=INPOUT

'RAT' TAQIO.RAT >TAQIO.FTN
F77 TAQIO/-TR/-CK=TAQIO

'RAT' MESSGE.RAT >MESSGE.FTN
F77 MESSGE/-TR/-CK=MESSGE

'RAT' TERMINAL.RAT >TERMINAL.FTN
F77 TERMINAL/-TR/-CK=TERMINAL

'RAT' INTERS.RAT >INTERS.FTN
F77 INTERS/-TR/-CK=INTERS

;
; compile universe driver routines
'RAT' MTREKD.RAT >MTREKD.FTN
F77 MTREKD/-TR/-CK=MTREKD

'RAT' MSHIPS.RAT >MSHIPS.FTN
F77 MSHIPS/-TR/-CK=MSHIPS

'RAT' MTORPS.RAT >MTORPS.FTN
F77 MTORPS/-TR/-CK=MTORPS

'RAT' MHOMER.RAT >MHOMER.FTN
F77 MHOMER/-TR/-CK=MHOMER

'RAT' MANTI.RAT >MANTI.FTN
F77 MANTI/-TR/-CK=MANTI

'RAT' MHOLE.RAT >MHOLE.FTN
F77 MHOLE/-TR/-CK=MHOLE

'RAT' PHASER.RAT >PHASER.FTN
F77 PHASER/-TR/-CK=PHASER

'RAT' DAMAGE.RAT >DAMAGE.FTN
F77 DAMAGE/-TR/-CK=DAMAGE

;
; compile universe initializer
'RAT' MTREKINI.RAT >MTREKINI.FTN
F77 MTREKINI/-TR/-CK=MTREKINI


; compile robot ship
'RAT' ROBOT.RAT >ROBOT.FTN
F77 ROBOT/-TR/-CK=ROBOT

;
; compile global common
'RAT' TRKCOM.RAT >TRKCOM.FTN
F77 TRKCOM,TRKCOM/-SP=TRKCOM

;
; compile universe map maker
'RAT' MAP.RAT >MAP.FTN
F77 MAP/-TR/-CK=MAP

;
; Taskbuild the global common & tasks
TKB @TRKCOM.TKB		!global common
TKB @MTREKD.TKB		!universe driver
TKB @MTREK.TKB		!ship
TKB @MTREKINI.TKB	!universe initialization
TKB @ROBOT.TKB		!robot ship
TKB @MAP.TKB		!universe map maker
;
; All done!!
; Do @MTREKUP to install Multi-trek
;
.IF <CLI> <> CLI SET /CLI=TI:'CLI'

