@Comment{
	Document type definition for "VMAppendix".  A sectioned document 
	with no chapters.  It has no title page and no table of contents.
	It generates appendices for VM in the proscribed format.
}
@begin(Comment)
 CHANGE LOG.	
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
25-March-81: (US.JFA)
  1) Changed page footing to read "Technical Note."
27-March-81: (US.LERNER)
  1) Modified DrawLine to preserve tabs set in prior environment.
  2) Modified DrawLine to draw an underscore instead of a dash.
  3) Changed copyright notice.
31-March-81: (US.JFA)
  1) Modified pagefooting with the command @modify(ftg,fixed +10.3in)
     to prevent pagefooting from coming too close to the text
02-April-81: (US.LERNER)
  1) Modified the @t() to @ta(). The former is used to specify special
     characters on the X9700. However, the baseline is too low, and
     hence the @ta() uses the "script .35mm" to compensentate.
12-May-81: (US.LERNER)
     Received SCRIBE.3B
  1) Changed the @ta() back to @t, and removed @ta. 
  2) Changed the "titlefont0" references to "titlefont1" for 3B compatibility.

20-August-82: (US.JFA)
  1. Took out command to include the standard figure library, since
     it was producing  a table of contents. Modified standard
     figure library andd put it right in the mak file--it is 
     easier than making another library file. I did this only
     for x9700, so now all tables and figures won't print a table
     of contents.
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
@end(comment)
@marker(make,vmappendix,x9700)
@font(Helvetica 10)
@define(bodystyle,font bodyfont,spacing 1.5,spread 0.8)
@define(notestyle,font smallbodyfont,facecode r,spacing 1,spread 0.5)
@comment<@generate(outline,contents)>
@send(contents "@newpage(0)@set(page=1)@style(pagenumber <@i>)")
@style(DoubleSided)
@send(contents "@prefacesection(TABLE OF CONTENTS)")

@define	(hdx,leftmargin 0,indent 0,fill,spaces compact,above 1,below 0,
	  break,need 4,justification off)
@define(hd2,use hdx,font titlefont3,facecode r,above 0.4inch)
@define(hd2a=hd2,centered)
@define(hd3,use hdx,font titlefont1,facecode r,above 0.4inch)
@define(hd4,use hdx,font titlefont1,facecode r,above 0.3inch)
@define(tcx,leftmargin 5,indent -5,rightmargin 5,fill,spaces compact,
	above 0,spacing 1,below 0,break,spread 0)
@define(tc2=tcx,leftmargin 8,font titlefont1,facecode r)
@define(tc3=tcx,leftmargin 12,font titlefont1,facecode r)
@define(tc4=tcx,leftmargin 16,font titlefont1,facecode r)
@counter(section,titleenv hd2,contentsenv tc2,
	  numbered [@#@:.@1.],referenced [@#@:.@1],incrementedby use,announced)
@counter(appendix,titleenv hd2,contentsenv tc2,numbered [@i.],
	  incrementedby,referenced [@i],announced,alias section)
@counter(unnumbered,titleenv hd2,contentsenv tc2,announced,alias section)
@counter(subsection,within section,titleenv hd3,contentsenv tc3,
	  numbered [@#@:.@1.],incrementedby use,referenced [@#@:.@1])
@counter(paragraph,within subsection,titleenv hd4,contentsenv tc4,
	  numbered [@#@:.@1.],referenced [@#@:.@1],incrementedby use)

@counter(prefacesection,titleenv hd2a,alias section)

@equate(chapter=section)

@comment(the following for figures; removed figure lib to
get rid of table of contents see changelog for more info)

@Counter(FigureCounter,Table "FigureContents",ContentsEnv tc2,
	Within Chapter,Numbered <@@b[Figure@@ @#@:-@1:@@ @@ @@$]>,
	Referenced "@#@:-@1",Init 0)
@Define(Figure,Nofill,Spaces Kept,Use R,BlankLines kept,Float,
	Above 1,Below 1,Counter FigureCounter,NumberLocation LFL)
@Counter(TableCounter,Table "TableContents",ContentsEnv tc2,
	Within Chapter,Numbered <@@b[Table@@ @#@:-@1:@@ @@ @@$]>,
	Referenced "@#@:-@1",Init 0)
@Define(Table,Nofill,Spaces Kept,Use R,BlankLines kept,Float,
	Above 1,Below 1,Counter TableCounter,NumberLocation LFL)
@Define(FullPageFigure,Use Figure,FloatPage)
@Define(FullPageTable,Use Table,FloatPage)

@Case(GenericDevice,
Press "@Define(CaptionEnv=Center,FaceCode R,Spacing 1,Font BodyFont)",
GSI "@Define(CaptionEnv=Center,FaceCode R,Spacing 1,Font BodyFont)",
X9700 "@Define(CaptionEnv=Center,FaceCode R,Spacing 1,Font BodyFont)",
else "@Define(CaptionEnv=Center,FaceCode R,Spacing 1)"
)

@libraryfile(math)
@libraryfile(titlepage)

@define(fileexample,break,use notestyle,facecode f,crbreak,leftmargin 16,
        fill,blanklines kept,indent -10,spacing 1,spread 0,above 1,below 1)
@define(outputexample=verbatim,leftmargin 2)

@equate(sec=section,subsec=subsection,para=paragraph,
	subsubsec=paragraph,subsubsection=paragraph)
@begin(text,indent 1quad,leftmargin 1inch,topmargin 1inch,bottommargin 1inch,
	linewidth 6.5inches,
	use bodystyle,justification,facecode R,spaces compact)

@comment{cucca modifications}
@set(page=1)
@style(date="3/8/52")
@style(topmargin 1in,bottommargin 1in)
@modify(enumerate, above 1,below 1)
@MODIFY(itemize,above 1,below 1)
@MODIFY(example,above 1,below 1)
@MODIFY(description, above 1,below 1)


@form(drawline="
@begin<format,leftmargin 0,rightmargin 0>
@tabclear{}
@UX[@ @>@ ]
@end<format>")
@comment[ Draw a line across the page ]

@form(Appendixname={
@PageHeading(odd,immediate,right="@Ux[@C<@parm(name)>]",left="Revised: @value(date)")
@PAGEFOOTING(odd,immediate,Center="CUCCA User Services Technical Note",
		right="[@value(page)]")
@PageHeading(even,immediate,left="@Ux[@C<@parm(name)>]",right="Revised: @value(date)")
@PAGEFOOTING(even,immediate,Center="CUCCA User Services Technical Note",
		left="[@value(page)]")
@string(appname="@parm(name)")
})

@form{Introduction="@Section(Introduction)
@message( [Introduction Section]
)"}

@form{CMSSyntax="@Section(CMS Command Syntax and Options)
@message( [CMS Command Section]
)"}

@form{CMSExamples="@Section(Examples under CMS)
@message( [CMS Examples Section]
)"}

@form{VS1Syntax="@Section(VS1 JCL)
@message( [VS1 JCL Section]
)"}

@form{VS1Examples="@Section(Examples under VS1)
@message( [VS1 Examples Section]
)"}

@form{AdditionalInfo="@Section(Additional Information)
@message( [Additional Information Section]
)"}

@form{References="@Section(References)
@message( [Reference Section]
)"}

@form{NA="@heading(Not applicable)"}

@Marker(Make,VMAppendix,RobotTypewriter)
@Define(BodyStyle,Spacing 1,Spread 0.6)
@Define(TitleStyle,Spacing 1,Spread 0)
@Define(NoteStyle,Spacing 1,Spread 0.3)
@Typewheel(Pica)

@Define	(HDX,LeftMargin 0,Indent 0,Fill,Spaces compact,Above .5in,Below .4in,
	  break,Need 7,Justification Off)
@Define(Hd2,Use HdX,Use B,Above 0.4inch)
@Define(Hd2A=HD2,Centered)
@Define(Hd3,Use HdX,Above 0.4inch)
@Define(Hd4,Use HdX,Above 0.3inch)
@Define(TcX,LeftMargin 5,Indent -5,RightMargin 5,Fill,Spaces compact,
	Above 0,Spacing 1,Below 0,Break,Spread 0)
@Define(Tc2=TcX,LeftMargin 5)
@Define(Tc3=TcX,LeftMargin 10)
@Define(Tc4=TcX,LeftMargin 15)
@Counter(Section,TitleEnv HD2,ContentsEnv tc2,
	  Numbered [@#@:.@1.],Referenced [@#@:.@1],IncrementedBy Use,Announced)
@Counter(Appendix,TitleEnv HD2,ContentsEnv TC2,Numbered [@I.],
	  IncrementedBy,Referenced [@I],Announced,Alias Section)
@Counter(UnNumbered,TitleEnv HD2,ContentsEnv TC2,Announced,Alias Section)
@Counter(SubSection,Within Section,TitleEnv HD3,ContentsEnv tc3,
	  Numbered [@#@:.@1.],IncrementedBy Use,Referenced [@#@:.@1])
@Counter(Paragraph,Within SubSection,TitleEnv HD4,ContentsEnv tc4,
	  Numbered [@#@:.@1.],Referenced [@#@:.@1],IncrementedBy Use)

@Counter(PrefaceSection,TitleEnv HD2A,Alias Section)

@Equate(Chapter=Section)
@LibraryFile(Figures)
@LibraryFile(Math)
@LibraryFile(TitlePage)

@define(FileExample,Break,Use NoteStyle,FaceCode F,CRbreak,LeftMargin 16,
        Fill,BlankLines Kept,Indent -10,Spacing 1,Spread 0,Above 1,Below 1)
@Define(OutputExample=Verbatim,LeftMargin 2)

@Equate(Sec=Section,Subsec=SubSection,Para=Paragraph,
	SubSubSection=Paragraph)
@Begin(Text,Indent 2,Use BodyStyle,LeftMargin 1inch,TopMargin 1inch,
	BottomMargin 1inch,LineWidth 6.5inches,Justification,
	Spaces Compact,Font CharDef,FaceCode R)
@set(page=1)

@style(date="3/8/52")
@MODIFY(enumerate, above 1.5,below 1.5)
@MODIFY(itemize,above 1.5,below 1.5)
@MODIFY(example,above 1.5,below 1.5)
@MODIFY(description, above 1.5,below 1.5)


@form(drawline="
@begin<format,leftmargin 0,rightmargin 0>
@tabclear{}
@UX[@ @>@ ]
@end<format>")
@comment [ Draw a line across the page. ]  

@form(Appendixname={
@PageHeading(odd,immediate,right="@Ux[@C<@parm(name)>]",left="Revised: @value(date)")
@PAGEFOOTING(odd,immediate,Center="CUCCA User Services Technical Note",
		right="[@value(page)]")
@PageHeading(even,immediate,left="@Ux[@C<@parm(name)>]",right="Revised: @value(date)")
@PAGEFOOTING(even,immediate,Center="CUCCA User Services Technical Note",
		left="[@value(page)]")
@string(appname="@parm(name)")
})

@form{Introduction="@Section(Introduction)
@message( [Introduction Section]
)"}

@form{CMSSyntax="@Section(CMS Command Syntax and Options)
@message( [CMS Command Section]
)"}

@form{CMSExamples="@Section(Examples under CMS)
@message( [CMS Examples Section]
)"}

@form{VS1Syntax="@Section(VS1 JCL)
@message( [VS1 JCL Section]
)"}

@form{VS1Examples="@Section(Examples under VS1)
@message( [VS1 Examples Section]
)"}

@form{AdditionalInfo="@Section(Additional Information)
@message( [Additional Information Section]
)"}

@form{References="@Section(References)
@message( [Reference Section]
)"}

@form{NA="@heading(Not applicable)"}

@Marker(Make,VMAppendix,File,PagedFile,CRT)
@Define(BodyStyle,Spacing 1)
@Define(TitleStyle,Spacing 1)
@Define(NoteStyle,Spacing 1)

@Define	(HDX,LeftMargin 0,Indent 0,Fill,Spaces compact,Above 1,Below 1,
	  break,Need 7,Justification Off)
@Define(Hd2,Use HdX,Above 1)
@Define(Hd2A=HD2,Centered)
@Define(Hd3,Use HdX,Above 2)
@Define(Hd4,Use HdX,Above 1)
@Define(TcX,LeftMargin 5,Indent -5,RightMargin 5,Fill,Spaces compact,
	Above 0,Spacing 1,Below 0,Break,Spread 0)
@Define(Tc2=TcX,LeftMargin 5)
@Define(Tc3=TcX,LeftMargin 10)
@Define(Tc4=TcX,LeftMargin 15)
@Counter(Section,TitleEnv HD2,ContentsEnv tc2,
	  Numbered [@#@:.@1.],Referenced [@#@:.@1],IncrementedBy Use,Announced)
@Counter(Appendix,TitleEnv HD2,ContentsEnv TC2,Numbered [@I.],
	  IncrementedBy,Referenced [@I],Announced,Alias Section)
@Counter(UnNumbered,TitleEnv HD2,ContentsEnv TC2,Announced,Alias Section)
@Counter(SubSection,Within Section,TitleEnv HD3,ContentsEnv tc3,
	  Numbered [@#@:.@1.],IncrementedBy Use,Referenced [@#@:.@1])
@Counter(Paragraph,Within SubSection,TitleEnv HD4,ContentsEnv tc4,
	  Numbered [@#@:.@1.],Referenced [@#@:.@1],IncrementedBy Use)

@Counter(PrefaceSection,TitleEnv HD2A,Alias Section)

@Equate(Chapter=Section)
@LibraryFile(Figures)
@LibraryFile(Math)
@LibraryFile(TitlePage)

@GENERATE()
@define(FileExample,Break,Use NoteStyle,FaceCode F,CRbreak,LeftMargin 16,
        Fill,BlankLines Kept,Indent -10,Spacing 1,Spread 0,Above 1,Below 1)
@Define(OutputExample=Verbatim,LeftMargin 2)

@Equate(Sec=Section,Subsec=SubSection,Para=Paragraph,
	SubSubSection=Paragraph)
@Begin(Text,Indent 2,Spread 1,Use BodyStyle,LineWidth 7.9inches,
	Spaces Compact,
	Justification,Font CharDef,FaceCode R)
@set(page=1)

@style(date="3/8/52")
@MODIFY(enumerate, above 1,below 1)
@MODIFY(itemize,above 1,below 1)
@MODIFY(example,above 1,below 1)
@MODIFY(description, above 1,below 1)

@form(drawline="
@begin<format,leftmargin 0,rightmargin 0>
@tabclear{}
@UX[@ @>@ ]
@end<format>")
@comment [ Draw a line across the page. ]  

@form(Appendixname={
@PageHeading(odd,immediate,right="@Ux[@C<@parm(name)>]",left="Revised: @value(date)")
@PAGEFOOTING(odd,immediate,Center="CUCCA User Services Technical Note",
		right="[@value(page)]")
@PageHeading(even,immediate,left="@Ux[@C<@parm(name)>]",right="Revised: @value(date)")
@PAGEFOOTING(even,immediate,Center="CUCCA User Services Technical Note",
		left="[@value(page)]")
@string(appname="@parm(name)")
})

@form{Introduction="@Section(Introduction)
@message( [Introduction Section]
)"}

@form{CMSSyntax="@Section(CMS Command Syntax and Options)
@message( [CMS Command Section]
)"}

@form{CMSExamples="@Section(Examples under CMS)
@message( [CMS Examples Section]
)"}

@form{VS1Syntax="@Section(VS1 JCL)
@message( [VS1 JCL Section]
)"}

@form{VS1Examples="@Section(Examples under VS1)
@message( [VS1 Examples Section]
)"}

@form{AdditionalInfo="@Section(Additional Information)
@message( [Additional Information Section]
)"}

@form{References="@Section(Reference)
@message( [Reference Section]
)"}

@form{NA="@heading(Not applicable)"}

@Marker(Make,VMAppendix,LPT,X1200)
@Define(BodyStyle,Spacing 1)
@Define(TitleStyle,Spacing 1)
@Define(NoteStyle,Spacing 1)


@Define(HDX,LeftMargin 0,Indent 0,Fill,Spaces compact,Above 2,Below 2,
	  break,Need 7,Justification Off,Use B)
@Define(Hd2,Use HdX,Above 2)
@Define(Hd2A=HD2,Centered)
@Define(Hd3,Use HdX,Above 1,below 1)
@Define(Hd4,Use HdX,Above 1,below 1)
@Define(TcX,LeftMargin 5,Indent -5,RightMargin 5,Fill,Spaces compact,
	Above 0,Spacing 1,Below 0,Break,Spread 0)
@Define(Tc2=TcX,LeftMargin 5)
@Define(Tc3=TcX,LeftMargin 10)
@Define(Tc4=TcX,LeftMargin 15)
@Counter(Section,TitleEnv HD2,ContentsEnv tc2,
	  Numbered [@#@:.@1.],Referenced [@#@:.@1],IncrementedBy Use,Announced)
@Counter(Appendix,TitleEnv HD2,ContentsEnv TC2,Numbered [@I.],
	  IncrementedBy,Referenced [@I],Announced,Alias Section)
@Counter(UnNumbered,TitleEnv HD2,ContentsEnv TC2,Announced,Alias Section)
@Counter(SubSection,Within Section,TitleEnv HD3,ContentsEnv tc3,
	  Numbered [@#@:.@1.],IncrementedBy Use,Referenced [@#@:.@1])
@Counter(Paragraph,Within SubSection,TitleEnv HD4,ContentsEnv tc4,
	  Numbered [@#@:.@1.],Referenced [@#@:.@1],IncrementedBy Use)

@Counter(PrefaceSection,TitleEnv HD2A,Alias Section)

@Equate(Chapter=Section)
@LibraryFile(Figures)
@LibraryFile(Math)
@LibraryFile(TitlePage)

@GENERATE()
@define(FileExample,Break,Use NoteStyle,FaceCode F,CRbreak,LeftMargin 16,
        Fill,BlankLines Kept,Indent -10,Spacing 1,Spread 0,Above 1,Below 1)
@Define(OutputExample=Verbatim,LeftMargin 2)

@Equate(Sec=Section,Subsec=SubSection,Para=Paragraph,
	SubSubSection=Paragraph)
@Begin(Text,Indent 2,Spread 1,Use BodyStyle,LineWidth 6.5inches,Spaces Compact,
	Justification,Font CharDef,FaceCode R)

@comment{CUCCA modifications}
@set(page=1)
@style(date="3/8/52")
@style(TOPMARGIN 4,BOTTOMMARGIN 4)
@MODIFY(enumerate, above 1,below 1)
@MODIFY(itemize,above 1,below 1)
@MODIFY(example,above 1,below 1)
@MODIFY(description, above 1,below 1)
@MODIFY(FTG,FIXED +10.3IN)

@form(drawline="
@begin<format,leftmargin 0,rightmargin 0>
@tabclear{}
@UX[@ @>@ ]
@end<format>")
@comment [ Draw a line across the page. ]  

@form(Appendixname={
@PageHeading(odd,immediate,right="@Ux[@C<@parm(name)>]",left="Revised: @value(date)")
@PAGEFOOTING(odd,immediate,Center="CUCCA User Services Technical Note",
		right="[@value(page)]")
@PageHeading(even,immediate,left="@Ux[@C<@parm(name)>]",right="Revised: @value(date)")
@PAGEFOOTING(even,immediate,Center="CUCCA User Services Technical Note",
		left="[@value(page)]")
@string(appname="@parm(name)")
})

@form{Introduction="@Section(Introduction)
@message( [Introduction Section]
)"}

@form{CMSSyntax="@Section(CMS Command Syntax and Options)
@message( [CMS Command Section]
)"}

@form{CMSExamples="@Section(Examples under CMS)
@message( [CMS Examples Section]
)"}

@form{VS1Syntax="@Section(VS1 JCL)
@message( [VS1 JCL Section]
)"}

@form{VS1Examples="@Section(Examples under VS1)
@message( [VS1 Examples Section]
)"}

@form{AdditionalInfo="@Section(Additional Information)
@message( [Additional Information Section]
)"}

@form{References="@Section(References)
@message( [Reference Section]
)"}

@form{NA="@heading(Not applicable)"}

