-h- ID.TXT	Tue Aug 30 15:26:29 1983	VD3:[3,205]ID.TXT;1
THIS IS DECUS #11-413, ORC
-h- ORC.ODL	Tue Aug 30 15:26:29 1983	VD3:[3,205]ORC.ODL;10
;
; OVERLAY DESCRIPTION FOR ORC
;
	.ROOT	ORC/LB:ORCAM:ORCDAT:ORCID-*(RDCS,ORCI,MAIN)
RDCS:	.FCTR	ORC/LB:RDCSI
ORCI:	.FCTR	ORC/LB:ORCIO
MAIN:	.FCTR	ORC/LB:ORCSR-*(P1,P2,P3)
P1:	.FCTR	ORC/LB:ORCP1:RDOBJ:WRSCR
P2:	.FCTR	ORC/LB:ORCP2:ORCSUB:RDOBJ:WRSCR
P3:	.FCTR	ORC/LB:ORCP3:RDSCR:WRMAC
	.END
-h- ORC.TXT	Tue Aug 30 15:26:29 1983	VD3:[3,205]ORC.TXT;2
 
 
 
 
 
 
 
 
                          OBJECT TO MACRO CONVERSION (ORC)
 
                              Version: V01.1/3-AUG-79
				Rev B, 8/10/83 GCE
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
                          OBJECT TO MACRO CONVERSION (ORC)
 
 
        1. INTRODUCTION
 
           ORC  is  a  utility  which  converts  PDP-11  object  code  to
           MACRO-11. Its uses include:
 
           * checking code produced by compilers
           * on-line debugging of code produced by a compiler which  does
             not give an assembly listing (eg. CORAL).
 
           For  ORC  to  produce  sensible output, the object code should
           have data and instructions in separate program sections with D
           and I attributes respectively. The object code produced by the
           CORAL and F4P compilers satisfy this requirement.
           The F4P compiler produces its branch instructions after it has
           produced the  other  object  code  which  may  look  a  little
           strange, but is in fact correct MACRO-11 code.
           The  threaded  code  produced by the FORTRAN compiler (FOR) is
           not suitable for conversion to MACRO-11.
 
           The MACRO-11 code produced by ORC  can  be  assembled  in  the
           usual way to produce an assembly listing.
 
 
        2. USING ORC
 
           When  the  task is initiated it issues a prompt and receives a
           command line of the form:
 
               ORC>outputfilespec/switches=inputfilespec/switches
 
           The usual RSX-11 conventions for file specifications apply. No
           switches are allowed in the command line. If the extension  is
           not supplied in a file specification, it is assumed to be:
 
                     .OBJ for the input file
                     .MAC for the output file
 
           An  indirect  command  file  may  be  specified,  but indirect
           command files may not be nested.
 
           ORC converts the object code in the input file  into  MACRO-11
           and  writes  it to the output file. The MACRO-11 file can then
           be assembled in the usual way to produce an assembly listing.
 
           During processing, ORC allocates a  temporary  file  (ORC.TMP)
           under  the user's uic on the system device. If ORC is aborted,
           this file should be deleted.
 
           ORC uses in-core tables to store local symbols, labels, global
               The switches are two, and serve to allow the user to alter
           the I/D attributes of up to 8 .PSECTs each in the input file.
		/IN:name:name:name:name - Sets named .psects to I type
		/DA:name:name:name:name - Sets named .psects to D type
	This functionality is useful where the compiler left the default
	condition set, namely I attributes, and ORC disassembles loads of
	garbage (and often odd-address-bounded) instructions. It overrides
	the I/D attribute in the object file and forces it to be what you
	set. Up to 8 names may be given on the /IN switch and up to 8 may
	be given in the /DA switch. Switches may be on either side of the
	= sign. Another mod is that ORC will emit lowercase ASCII as
	comments now. It may however generate too many .ENABL LSB and
	.DSABL LSB lines. Edit them out if you must.

 
                                        -1-
 
 
                         OBJECT TO MACRO CONVERSION (ORC)
 
 
           symbols, and program section names. These can hold up to:
                     * 256 local symbols
                     * 512 local labels
                     * 100 global symbol definitions
                     * 26 program section names
 
           This should be enough for most object  files,  but  the  first
           three  of  these tables can be extended at task build time, if
           required.
 
           Local labels are used when referring to locations  within  the
           same  (instruction)  program  section. They are of the form n$
           where n is the location of the label.
           Example:
                   MOV     R0,R1
                   BEQ     6$
                   CLR     (R0)
           6$:     INC     R1
 
           Local symbols are used  when  referring  to  locations  within
           other  program sections, or within the same program section if
           it contains data. They are of the form xn, where x is a letter
           (A, B, C,...) defining  the  program  section  and  n  is  the
           location of the symbol within the program section.
           Example:
                   .PSECT  DATA,D
           C00000: .WORD   0
           C00002: .WORD   C00000
           ;
                   .PSECT  INSTR,I
                   MOV     #C00002,R0
 
           In  certain circumstances, ORC may reference symbols which are
           not defined. The positions of these symbols can be  determined
           from their names.
 
 
        3. ERROR MESSAGES
 
           ORC -- COMMAND I/O ERROR
                   An I/O error ocurred during input of the command line,
                   or  a bad indirect command file name was specified, or
                   indirect command files were nested.
 
           ORC -- SYNTAX ERROR
                   A syntax error was detected in the input line.
 
           ORC -- BAD INPUT FILE SPEC
           ORC -- BAD OUTPUT FILE SPEC
                   A switch was specified or 'wildcards' were used in the
                   file specification.
 
 
 
                                        -2-
 
 
                         OBJECT TO MACRO CONVERSION (ORC)
 
 
           ORC -- OPEN FAILURE ON xxxxxx FILE
           ORC -- I/O ERROR ON xxxxxx FILE
           ORC -- FAILED TO CLOSE xxxxxx FILE
                   These errors may be caused for a variety  of  reasons,
                   eg.  device offline, device full, privilege violation,
                   file does not exist. The message specifies whether the
                   error ocurred on the INPUT, OUTPUT or SCRATCH file.
 
           ORC -- PSECT TABLE OVERFLOW
                   Only 26. program sections are allowed  in  one  object
                   file,  including  the  absolute  (.  ABS.)  and  blank
                   PSECTs.
 
           ORC -- LABEL TABLE OVERFLOW
                   Only 512. local labels are allowed in one object file.
                   This number can be increased by  editing  the  command
                   file and rebuilding ORC.
 
           ORC -- LOCAL SYMBOL TABLE OVERFLOW
                   Only  256.  local  symbols  are  allowed in one object
                   file. This number can  be  increased  by  editing  the
                   command file and rebuilding ORC.
 
           ORC -- GLOBAL SYMBOL TABLE OVERFLOW
                   Only 100. global symbol definitions are allowed in one
                   object  file.  This number can be increased by editing
                   the command file and rebuilding ORC.
 
 
        4. GENERATING ORC
 
           The following files are contained in the distribution kit:
 
           * ORC.OLB - object file library
           * ORC.ODL - overlay descriptor file
           * ORCBLD.CMD - task builder command file
           * ORC.TXT - user document
           * MACRO-11 source files
 
           The object code uses instructions (such as SOB and ASH)  which
           are only supported on PDP-11/35 computers and upwards.
 
           To  build  ORC,  you  must  first  copy  ORC.OLB,  ORC.ODL and
           ORCBLD.CMD to the system disc.
 
           ORC requires an 8K partition to run in. If  you  do  not  have
           memory  management,  you will have to edit the command file to
           specify the partition in which ORC is to run.
           Example:
                   PAR=GEN:40000:40000
 
           If you want to increase  the  size  of  any  of  ORCs  in-core
 
 
                                        -3-
 
 
                         OBJECT TO MACRO CONVERSION (ORC)
 
 
           tables,  you will have to edit the command file and change the
           following options:
 
                   GBLDEF=LLLMAX:symbols
                   GBLDEF=LABMAX:labels
                   GBLDEF=GLOMAX:globals
                   EXTSCT=ORCSYM:symbols*4
                   EXTSCT=ORCLAB:labels*4
                   EXTSCT=ORCGLB:globals*10
 
           where all numbers are in octal.
 
           For example, the program as distributed allows for  256  local
           symbols,  512  labels  and  100  globals,  so the task builder
           options are:
 
                   GBLDEF=LLLMAX:400
                   GBLDEF=LABMAX:1000
                   GBLDEF=GLOMAX:144
                   EXTSCT=ORCSYM:2000
                   EXTSCT=ORCLAB:4000
                   EXTSCT=ORCGLB:1440
 
           If you increase these values, you will increase  the  size  of
           the  task  and must ensure that your partition is large enough
           to accommodate the task. For example, doubling the size of all
           three tables will add 7440 bytes (nearly 2K) to the task.
 
           The task is built by entering the command:
 
                   TKB @ORCBLD
 
           The task name is ...ORC, so that when it is installed, it  can
           be invoked by entering a command of the form:
 
                   ORC commandline
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
                                        -4-
 
 
                         OBJECT TO MACRO CONVERSION (ORC)
 
 
           APPENDIX
 
           Listing of task builder command file, ORCBLD.CMD
 
           ;
           ; COMMAND FILE TO BUILD ORC FROM THE OBJECT LIBRARY ORC.OLB
           ; ORC REQUIRES AN 8K PARTITION TO RUN IN.
           ; IF YOU DO NOT HAVE MEMORY MANAGEMENT, YOU SHOULD EDIT THE 'PAR'
           ; OPTION  TO SHOW THE START AND SIZE OF YOUR GEN PARTITION.
           ; TO BUILD ORC, TYPE:
           ;		>TKB @ORCBLD
           ;
           ORC,ORC=ORC/MP
           STACK=128
           UNITS=4
           ASG=TI:1:2
           ASG=SY:3:4
           TASK=...ORC
           PAR=GEN:0:40000
           GBLDEF=LLLMAX:400
           GBLDEF=LABMAX:1000
           GBLDEF=GLOMAX:144
           EXTSCT=ORCSYM:2000
           EXTSCT=ORCLAB:4000
           EXTSCT=ORCGLB:1440
           //
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
                                        -5-
 
-h- ORCAM.MAC	Tue Aug 30 15:26:29 1983	VD3:[3,205]ORCAM.MAC;26
	.TITLE ORCAM
	.IDENT /V01.1/
;
; ORCAM
;
; CONVERT OBJECT CODE TO MACRO-11
;
; THIS VERSION BY: D J DUNSTAN  25-OCT-78
; (THIS IS THE ORIGINAL AND BEST ORCAM)
;
; ISSUES PROMPT AND RECEIVES COMMAND LINE OF FORM
;	ORC>DK1:OUTFILE[.MAC]=DK1:INFILE[.OBJ]
;
; PASS 1 PROCESSES GSD RECORDS
;	READS ENTRIES FROM .OBJ INTO OBJLIN
;	WRITES INTERMEDIATE CODE TO .TMP FROM MACPS
; PASS 2 PROCESSES TXT/RLD RECORDS
;	SAME PROCEDURE AS FOR PASS 1
; PASS 3 PUTS IN THE LABELS
;	READS ENTRIES FROM .TMP INTO MACPS
;	WRITES MACRO CODE TO .MAC FROM MACLIN
;
; THE FOLLOWING LUNS ARE USED:
;	1 - COMMAND INTERFACE (TI:)
;	2 - ERROR MESSAGES (TI:)
;	3 - OBJECT FILE/MACRO FILE (SY:)
;	    (NOT OPEN SIMULTANEOUSLY)
;	4 - SCRATCH FILE (SY:)
;
; CONDITIONAL ASSEMBLY VARIABLES:
; O$$FLP DEFINED - SUPPORT FOR TREATMENT OF GLOBAL NAME "$$$$$X==."
;		   (ANY RAD50 X) AS INDICATOR TO CHANGE PSECT TYPE
;		   FROM I TO D OR VICE VERSA
;		   (NEED O$$FLP IN ORCSUB AS WELL)
;
;
; ORCAM TOP LEVEL
;
ORC:	JSR	PC,INIT$	; INITIALISATION
	JSR	PC,RD$CSI	; GET COMMAND LINE
	JSR	PC,OP$SCR	; OPEN SCRATCH FILE
	BCS	ORC		; ERROR - RESTART ORC
;
10$:	JSR	PC,OP$OBJ	; OPEN INPUT FILE
	BCC	25$
20$:
	JSR	PC,CL$SCR	; ERROR - DELETE SCRATCH FILE
	BR	ORC		; AND RESTART ORC
;
25$:
	JSR	PC,ORCP1	; PASS 1 - PROCESS GSD RECORDS
	BCC	40$
30$:
	JSR	PC,CL$OBJ	; ERROR - CLOSE OBJECT FILE
	BR	20$		;  AND SCRATCH FILE
40$:
	JSR	PC,CL$OBJ	; CLOSE OBJECT FILE
	JSR	PC,OP$OB2	; AND OPEN FOR PASS 2
;
	JSR	PC,ORCP2	; PASS 2 - PROCESS TEXT
	BCS	30$		; ERROR - CLOSE OBJECT AND SCRATCH FILES
	JSR	PC,CL$OBJ	; CLOSE INPUT FILE
	JSR	PC,CLO$CR	; CLOSE SCRATCH AND REOPEN
	JSR	PC,OP$MAC	; OPEN MACRO FILE
	BCS	20$		; ERROR - DELETE SCRATCH FILE
;
	JSR	PC,ORCP3	; PASS 3 - INSERT LABELS
	JSR	PC,CL$MAC
	BR	ORC
;
;
; PROCEDURE TO OUTPUT ERROR MESSAGE TO LUN 2
; (CALLED INTERNALLY BY I/O ROUTINES)
;
	.MCALL	QIOW$,DIR$
;
MOCALL::MOV	MESNO,R1
	MOV	#QIOWLB,R0
	MOV	(R1)+,Q.IOPL+2(R0)
	MOV	R1,Q.IOPL(R0)
	DIR$	R0
	SEC
	RTS	PC
;
	.PSECT	ORCDAT,D
MESNO::	.WORD	0
QIOWLB:	QIOW$	IO.WLB,2,1,,,,<0,0,40>
;
	.END	ORC
-h- ORCASM.CMD	Tue Aug 30 15:26:29 1983	VD3:[3,205]ORCASM.CMD;2
ORCAM=ORCAM.MAC
ORCDAT=ORCDAT.MAC
ORCID=ORCID.MAC
ORCIO=ORCIO.MAC
ORCP1=ORCP1.MAC
ORCP2=ORCP2.MAC
ORCP3=ORCP3.MAC
ORCSR=ORCSR.MAC
ORCSUB=ORCSUB.MAC
RDCSI=RDCSI.MAC
RDOBJ=RDOBJ.MAC
RDSCR=RDSCR.MAC
WRMAC=WRMAC.MAC
WRSCR=WRSCR.MAC
-h- ORCBLD.CMD	Tue Aug 30 15:26:29 1983	VD3:[3,205]ORCBLD.CMD;15
;
; COMMAND FILE TO BUILD ORC FROM THE OBJECT LIBRARY ORC.OLB
; TO BUILD ORC, TYPE:
;		>TKB @ORCBLD
;
ORC/CP/-FP=ORC/MP
UNITS=4
ASG=TI:1:2
ASG=SY:3:4
TASK=...ORC
GBLDEF=LLLMAX:1000
GBLDEF=LABMAX:2000
GBLDEF=GLOMAX:310
EXTSCT=ORCSYM:4000
EXTSCT=ORCLAB:10000
EXTSCT=ORCGLB:3100
//
-h- ORCDAT.MAC	Tue Aug 30 15:26:29 1983	VD3:[3,205]ORCDAT.MAC;17
	.TITLE	ORCDATA
	.IDENT	/V01.2/
	.NLIST	BEX
;
; ORCAM DATA AREAS
;
	.PSECT	ORCDAT,D
MACPS::	.WORD	0		; MACRO LINE - PSECT NO
MACLC::	.WORD	0		; MACRO LINE - LOCATION COUNTER
MACLIN::.BLKB	80.		; MACRO LINE - TEXT
MACLEN::.WORD	0		; POINTER PAST END OF LINE
OBJLIN::.BLKB	200		; OBJECT CODE RECORD 1
OBJLEN::.WORD	0		; POINTER PAST END
OBLIN2::.BLKB	200		; OBJECT CODE RECORD 2
OBLEN2::.WORD	0		; POINTER PAST END
DIFLAG::.WORD	0		; 0 = INSTRUCTION / 1 = DATA
NXTLC::	.WORD	0		; LC OF NEXT INSTRUCTION
CURINS::.WORD	0		; CURRENT INSTRUCTION
LOADAD::.WORD	0		; LOAD ADDRESS OF OBJECT RECORD
PSNUM::	.WORD	0		; CURRENT PSECT NUMBER
OLDPS::	.WORD	0		; OLD VALUE OF MACPS
OLDLC::	.WORD	0		; OLD VALUE OF MACLC
LSB::	.WORD	0		; LOCAL SYMBOL BLOCK DEFINED
BLKB::	.WORD	0		; BLKB PROCESSING FLAG
OCOBUF::.BLKW	3		; OCTAL CONVERSION BUFFER
INCRLD::.BYTE	4,6,4,6,10,10,10,4,2,6,0,6,10,10,60
CCS::	.ASCII	/NZVC/
INVOPL::.ASCII	<11><11><11>/; OPERATOR NOT RECOGNISED/
ASCLIN::.ASCII	<11><11>*; .ASCII  /*
BYTXT::	.ASCII	/.BYTE   /
WOTXT::	.ASCII	/.WORD   /
ENLSB::	.ASCII	<11>/.ENABL/<11>/LSB/
DSLSB::	.ASCII	<11>/.DSABL/<11>/LSB/
;
	.EVEN
XFR::	.BLKW	3		; TRANSFER ADDRESS
;
; TABLES
; LOCAL SYMBOL/LABEL/GLOBAL TABLE SIZES ARE DEFINED AT TASK BUILD TIME
;
	.PSECT	ORCSYM,D
LLLABS::.WORD	0		; LOCAL SYMBOL TABLE
;
	.PSECT	ORCLAB,D
LABELS::.WORD	0		; LOCAL LABEL TABLE
;
	.PSECT	ORCGLB,D
GLOBS::	.WORD	0		; GLOBAL SYMBOL TABLE
;
PSEMAX==26.			; MAXIMUM NUMBER OF PSECTS
	.PSECT	ORCPSE,D
PSECTS::.WORD	0		; PSECT TABLE
	.BLKW	4*PSEMAX
;
	.PSECT	ORCDAT
	.IF DF	O$$FLP
FLIPS::	.WORD	0		; TABLE OF I/D FLIPS
	.BLKW	2*10.		; PSECT NO/OFFSET
	.ENDC	; DF O$$FLP
;
; OVERFLOW HANDLING DATA
;
$OVSTS::.WORD	0
OV$LLL==1
OV$LAB==2
OV$GLO==4
OV$PSE==8.
;
; OPCODE TABLES
;
	.MACRO	OP,XCODE,XMNEM
	.WORD	XCODE
	.ASCII	/XMNEM/
	.ENDM	OP
;
OPTAB1::.WORD	5
	OP	10000,<MOV   >
	OP	20000,<CMP   >
	OP	30000,<BIT   >
	OP	40000,<BIC   >
	OP	50000,<BIS   >
OPTAB2::.WORD	2
	OP	060000,<ADD   >
	OP	160000,<SUB   >
OPTAB3::.WORD	4
	OP	70000,<MUL   >
	OP	71000,<DIV   >
	OP	72000,<ASH   >
	OP	73000,<ASHC  >
OPTABX::.WORD	2
	OP	4000,<JSR   >
	OP	74000,<XOR   >
OPTABY::.WORD	1
	OP	77000,<SOB   >
OPTAB4::.WORD	15.
	OP	400,<BR    >
	OP	1000,<BNE   >
	OP	1400,<BEQ   >
	OP	2000,<BGE   >
	OP	2400,<BLT   >
	OP	3000,<BGT   >
	OP	3400,<BLE   >
	OP	100000,<BPL   >
	OP	100400,<BMI   >
	OP	101000,<BHI   >
	OP	101400,<BLOS  >
	OP	102000,<BVC   >
	OP	102400,<BVS   >
	OP	103000,<BCC   >
	OP	103400,<BCS   >
OPTABZ::.WORD	2
	OP	104000,<EMT   >
	OP	104400,<TRAP  >
OPTAB5::.WORD	12.
	OP	5000,<CLR   >
	OP	5100,<COM   >
	OP	5200,<INC   >
	OP	5300,<DEC   >
	OP	5400,<NEG   >
	OP	5500,<ADC   >
	OP	5600,<SBC   >
	OP	5700,<TST   >
	OP	6000,<ROR   >
	OP	6100,<ROL   >
	OP	6200,<ASR   >
	OP	6300,<ASL   >
OPTAB6::.WORD	14.
	OP	100,<JMP   >
	OP	300,<SWAB  >
	OP	6500,<MFPI  >
	OP	6600,<MTPI  >
	OP	6700,<SXT   >
	OP	106500,<MFPD  >
	OP	106600,<MTPD  >
	OP	170100,<LDFPS >
	OP	170200,<STFPS >
	OP	170300,<STST  >
	OP	170400,<CLRF  >
	OP	170500,<TSTF  >
	OP	170600,<ABSF  >
	OP	170700,<NEGF  >
OPTABP::.WORD	1
	OP	6400,<MARK  >
OPTAB7::.WORD	5
	OP	200,<RTS   >
	OP	75000,<FADD  >
	OP	75010,<FSUB  >
	OP	75020,<FMUL  >
	OP	75030,<FDIV  >
OPTABQ::.WORD	1
	OP	230,<SPL   >
OPTAB8::.WORD	13.
	OP	0,<HALT  >
	OP	1,<WAIT  >
	OP	2,<RTI   >
	OP	3,<BPT   >
	OP	4,<IOT   >
	OP	5,<RESET >
	OP	6,<RTT   >
	OP	240,<NOP   >
	OP	170000,<CFCC  >
	OP	170001,<SETF  >
	OP	170002,<SETI  >
	OP	170011,<SETD  >
	OP	170012,<SETL  >
OPTAB9::.WORD	14.
	OP	171000,<MULF  >
	OP	171400,<MODF  >
	OP	172000,<ADDF  >
	OP	172400,<LDF   >
	OP	173000,<SUBF  >
	OP	173400,<CMPF  >
	OP	174000,<STF   >
	OP	174400,<DIVF  >
	OP	175000,<STEXP >
	OP	175400,<STCFI >
	OP	176000,<STCFD >
	OP	176400,<LDEXP >
	OP	177000,<LDCIF >
	OP	177400,<LDCDF >
;
;
;
; FILE DATA SPACES
;
	.MCALL	FDBDF$,FDAT$A,FDOP$A,NMBLK$,FSRSZ$
;
OBJFDB::FDBDF$			; DEFINE INPUT (.OBJ) FILE FDB
	FDAT$A	R.VAR
	FDOP$A	3,CSDSPT,OBJFNB
OBJFNB:	NMBLK$	,OBJ,,SY,0
;
MACFDB::FDBDF$			; DEFINE OUTPUT (.MAC) FILE FDB
	FDAT$A	R.VAR,FD.CR
	FDOP$A	3,CSDSPT,MACFNB
MACFNB:	NMBLK$	,MAC,,SY,0
;
SCRFDB::FDBDF$			; DEFINE SCRATCH FILE FDB
	FDAT$A	R.VAR,FD.CR
	FDOP$A	4,SCRDSP
SCRDSP:	.WORD	0,0,0,0,7,SCRNAM
SCRNAM:	.ASCII	/ORC.TMP/
	.EVEN
;
; ALLOW TWO FILES TO BE OPEN AT ONCE
;
	FSRSZ$	2,,ORCDAT
;
; HEADER LINE FOR MACRO FILE
;
HEADER::.ASCII	/; XXXXXX  OBJECT TO MACRO CONVERSION  /
HEADID::.ASCII	/XXXXXX  DD-MMM-YY HH:MM/
HDRSIZ==.-HEADER
	.EVEN
;
LNCNT::	.WORD	0		; SET TO 1 IF HEADER TO BE OUTPUT
EOF::	.WORD	0		; SET IF EOF DETECTED
;
; COMMAND STRING DATA
;
	.MCALL	GCMLB$,CSI$,CSI$SW,CSI$SV,CSI$ND
	CSI$
CSIBLK::.BLKB	C.SIZE
CSDSPT == CSIBLK+C.DSDS
GCLBLK::GCMLB$	1,ORC,GCLBUF
GCLBUF::.BLKB	82.		; INPUT LINE BUFFER
	.EVEN
;SWITCH TABLE: ALLOW USER TO SPECIFY UP TO 8 PSECTS TO
;BE FORCED TO HAVE INSTRUCTION ATTRIBUTES AND UP TO 8
; WHICH MAY BE FORCED TO HAVE DATA ATTRIBUTES. THIS MAY
; AID IN PRODUCING USABLE DISASSEMBLIES OF OBJECTS CREATED
; BY COMPILERS NOT RELIABLY SEPARATING THESE.
; (GCE01)
SWITCH::	.WORD 0
SW.IN==1
SW.OUT==2
SWTBL::
	CSI$SW IN,SW.IN,SWITCH,,,INTBL
	CSI$SW DA,SW.OUT,SWITCH,,,DATBL
	CSI$ND
INTBL:
	CSI$SV ASCII,IP1,6
	CSI$SV ASCII,IP2,6
	CSI$SV ASCII,IP3,6
	CSI$SV ASCII,IP4,6
	CSI$SV ASCII,IP5,6
	CSI$SV ASCII,IP6,6
	CSI$SV ASCII,IP7,6
	CSI$SV ASCII,IP8,6
DATBL:
	CSI$SV ASCII,DP1,6
	CSI$SV ASCII,DP2,6
	CSI$SV ASCII,DP3,6
	CSI$SV ASCII,DP4,6
	CSI$SV ASCII,DP5,6
	CSI$SV ASCII,DP6,6
	CSI$SV ASCII,DP7,6
	CSI$SV ASCII,DP8,6
	CSI$ND
;ASCII SWITCH VALUES FOR PSECTS OF I OR D TYPES
IP1::	.BLKB 6
IP2::	.BLKB 6
IP3::	.BLKB 6
IP4::	.BLKB 6
IP5::	.BLKB 6
IP6::	.BLKB 6
IP7::	.BLKB 6
IP8::	.BLKB 6
DP1::	.BLKB 6
DP2::	.BLKB 6
DP3::	.BLKB 6
DP4::	.BLKB 6
DP5::	.BLKB 6
DP6::	.BLKB 6
DP7::	.BLKB 6
DP8::	.BLKB 6
;
;
; ERROR MESSAGES
;
	.MACRO ERR,XERRNO,XMES
XERRNO::.WORD	10$-XERRNO-2
	.BYTE	15
	.ASCII	*XMES*
10$:	.EVEN
	.ENDM	ERR
;
	ERR	ERR1,<ORC -- COMMAND I/O ERROR>
	ERR	ERR2,<ORC -- SYNTAX ERROR>
	ERR	ERR3,<ORC -- BAD INPUT FILE SPEC>
	ERR	ERR4,<ORC -- OPEN FAILURE ON INPUT FILE>
	ERR	ERR5,<ORC -- I/O ERROR ON INPUT FILE>
	ERR	ERR6,<ORC -- FAILED TO CLOSE INPUT FILE>
	ERR	ERR7,<ORC -- BAD OUTPUT FILE SPEC>
	ERR	ERR8,<ORC -- OPEN FAILURE ON OUTPUT FILE>
	ERR	ERR9,<ORC -- I/O ERROR ON OUTPUT FILE>
	ERR	ERR10,<ORC -- FAILED TO CLOSE OUTPUT FILE>
	ERR	ERR11,<ORC -- OPEN FAILURE ON SCRATCH FILE>
	ERR	ERR12,<ORC -- I/O ERROR ON SCRATCH FILE>
	ERR	ERR13,<ORC -- FAILED TO CLOSE SCRATCH FILE>
	ERR	ERR14,<ORC -- GLOBAL SYMBOL TABLE OVERFLOW>
	ERR	ERR15,<ORC -- PSECT TABLE OVERFLOW>
	ERR	ERR16,<ORC -- LABEL TABLE OVERFLOW>
	ERR	ERR17,<ORC -- LOCAL SYMBOL TABLE OVERFLOW>
;
	.END
-h- ORCID.MAC	Tue Aug 30 15:26:29 1983	VD3:[3,205]ORCID.MAC;2
	.TITLE	ORCID ORCAM IDENTIFIER
	.IDENT	/V01.1/
;
; THIS MODULE CONTAINS THE ORCAM IDENTIFIER
;
; X01	23-OCT-78	ORIGINAL ORCAM
;			LOCAL SYMBOL BLOCKS DEFINED FOR I PSECTS
;
; X02	26-OCT-78	ALLOW CSECTS FOR FORTRAN FILES
;			VARIOUS CHANGES FOR F4P FILES
;			INCLUDE RELOCATION TYPES 3,12,14
;			GENERATE LABEL FOR TRANSFER ADDRESS
;
; X03	29-DEC-78	CORRECT BUG IN "GLOBAL(R0)"
;			INCLUDE COMPLEX RELOCATION
;			CORRECT OUTPUT FOR SPL AND MARK
;
; X04	 9-FEB-79	IMPROVE ERROR RECOVERY
;			CORRECT INCREL TO COPE WITH COMPLEX RELOCATION
;			CHANGE LOCAL SYMBOL FORMAT - ALLOW 25 PSECTS
; X04.1	13-MAR-79	CORRECT BUG WITH RLD RECORDS AT START OF FILE
; X04.2	21-MAR-79	PRINT ASCII CHARS ONLY IF IN RANGE 40-137
;			ALLOW I/D FLIPS (CONDITIONAL ASSEMBLY)
;
; V01    27-APR-79	MAKE INTTXT A SUBROUTINE
;			IMPROVE PROCESSING OF DATA PSECTS
;
; V01.1	24-MAY-79	IMPROVE CODE IN I/O ROUTINES
;			ALLOCATE TABLE SPACE AT TASK BUILD TIME
;			REORGANISE FOR OVERLAY TO FIT INTO 8K
;
	.PSECT	$ORCID,D
IDENT::	.ASCII	/V01.1 /
	.END
-h- ORCIO.MAC	Tue Aug 30 15:26:29 1983	VD3:[3,205]ORCIO.MAC;7
	.TITLE	ORCIO
	.IDENT	/V01.1/
;
; ORCAM - I/O ROUTINES FOR OPENING AND CLOSING FILES
;
; *************************************************************
;
; INIT$ - INITIALISE DATA FOR ORCAM
;
	.MCALL	FINIT$
;
INIT$::
	FINIT$			; INITIALISE FCS
;
	CLR	LLLABS		; CLEAR ALL TABLES
	CLR	LABELS
	CLR	GLOBS
	CLR	PSECTS
;
	.IF DF	O$$FLP
	CLR	FLIPS
	.ENDC	; DF O$$FLP
;
	CLR	$OVSTS		; CLEAR OVERFLOW STATUS
	CLR	LSB		; CLEAR LSB FLAG
	MOV	#-1,PSNUM	; INIT PSECT NUMBER
	MOV	#-1,XFR		; INIT TRANSFER ADDRESS
	RTS	PC
;
; **********************************************************
;
; OP$MAC - OPEN MACRO FILE
;
	.MCALL	DIR$,CSI$2,OPEN$W,GTIM$
;
OP$MAC::
	MOV	#HEADID,R0		; MOVE ORC IDENT INTO HEADER
	MOV	#IDENT,R2
	MOV	#6,R1
40$:	MOVB	(R2)+,(R0)+		; MOVE IDENTIFIER
	SOB	R1,40$
	ADD	#2,R0			; POINT TO DATE FIELD
	DIR$	#GTIM			; GET THE TIME AND DATE
	MOV	#TIMBUF,R1
	CMP	G.TIDA(R1),#10.
	BGE	10$
	MOVB	#' ,(R0)+
10$:
	JSR	PC,$DAT			; CONVERT DATE TO ASCII
	INC	R0			; INSERT A SPACE
	MOV	#2,R2
	JSR	PC,$TIM			; CONVERT TIME TO ASCII
	MOV	#1,LNCNT		; SHOW HEADER NOT YET OUTPUT
	MOV	#ERR7,MESNO
	CSI$2	#CSIBLK,OUTPUT,#SWTBL
	BCS	5$			; CS IF SEMANTIC ERROR
	BITB	#CS.WLD,C.STAT(R0)	; WILDCARDS SPECIFIED?
	BEQ	60$			; BRANCH IF NO
5$:	JMP	MOCALL			; OUTPUT ERROR MESSAGE
;
60$:	MOV	#ERR8,MESNO
	OPEN$W	#MACFDB
	BCS	5$
	RTS	PC
;
	.PSECT	ORCDAT,D
GTIM:	GTIM$	TIMBUF
TIMBUF:	.BLKW	8.
;
	.PSECT
;
; **********************************************************
;
; OP$OBJ - OPEN OBJECT FILE
;
	.MCALL	CSI$2,OPEN$R
;
	.ENABL	LSB
OP$OBJ::MOV	#ERR3,MESNO
	CSI$2	#CSIBLK,INPUT,#SWTBL
	BCS	10$
	BITB	#CS.WLD,C.STAT(R0)	; WILDCARDS SPECIFIED
	BNE	10$			; YES - ERROR
OP$OB2::MOV	#ERR4,MESNO
	OPEN$R	#OBJFDB
	BCC	20$
10$:	JMP	MOCALL
20$:	CLR	EOF		; CLEAR EOF AND C-BIT
	RTS	PC
	.DSABL	LSB
;
; **********************************************************
;
; OP$SCR - OPEN SCRATCH FILE
;
	.MCALL	OPEN$W
;
OP$SCR::MOV	#ERR11,MESNO
	OPEN$W	#SCRFDB
	BCC	10$
	JMP	MOCALL
10$:	RTS	PC
;
; **********************************************************
;
; CL$MAC - CLOSE MACRO FILE
;
	.MCALL	CLOSE$
;
;
CL$MAC::MOV	#ERR10,MESNO		; CLOSE
	CLOSE$	#MACFDB
	BCC	10$
	JMP	MOCALL
10$:	RTS	PC
;
; **********************************************************
;
; CL$OBJ - CLOSE THE OBJECT FILE
;
	.MCALL	CLOSE$
;
	.ENABL	LSB
CL$OBJ::MOV	#ERR6,MESNO
	CLOSE$	#OBJFDB
	BCS	30$
20$:	SEC
	MOV	#1,EOF
	BR	40$
30$:	JMP	MOCALL
40$:	RTS	PC
	.DSABL	LSB
;
; **********************************************************
;
; CLO$CR - CLOSE AND REOPEN SCRATCH FILE
;
	.MCALL	CLOSE$,OPEN$R
;
CLO$CR::MOV	#ERR13,MESNO
	CLOSE$	#SCRFDB
	BCS	10$
	MOV	#ERR11,MESNO
	OPEN$R	R0
	BCC	20$
10$:	JMP	MOCALL
20$:	RTS	PC
;
; **********************************************************
;
; CL$SCR - DELETE SCRATCH FILE
;
	.MCALL	DELET$
;
CL$SCR::MOV	#ERR13,MESNO		; CLOSE
	DELET$	#SCRFDB
	BCC	10$
	JMP	MOCALL
10$:	RTS	PC
;
	.END
-h- ORCP1.MAC	Tue Aug 30 15:26:29 1983	VD3:[3,205]ORCP1.MAC;6
	.TITLE ORCP1
	.IDENT /V01.1/
;
; ORCAM - PASS 1
;
; PROCESS GSD RECORDS
;	READS ENTRIES FROM .OBJ INTO OBJLIN
;	WRITES INTERMEDIATE CODE TO .TMP FROM MACPS
;
; DEFINE MACRO:
;
	.MACRO	FTAB
	JSR	PC,TAB8
	.ENDM	FTAB
;
;
;
ASCWK:	.BLKB 10
	.EVEN
ORCP1::
GETLIN:
	MOV	#OBJLIN,R1
	MOV	#OBJLEN,R2
	JSR	PC,RD$OBJ
	BCC	RDOK
	RTS	PC		; ERROR RETURN
;
RDOK:	MOV	#OBJLIN,R1
	MOV	(R1)+,R0	; GET RECORD TYPE
	ASL	R0
	JMP	@GSDREC-2(R0)
;
GSD:
	MOV	#MACLIN,R2
	CMP	R1,OBJLEN
	BGE	GETLIN
	MOVB	5(R1),R0
	ASL	R0
	JMP	@GSDTYP(R0)
TITLE:
	MOV	#HEADER+2,R0
	JSR	PC,R50ASC	; CONVERT TO ASCII IN HEADING
	CMP	(R1)+,(R1)+	; POINT TO NEXT GSD ITEM
	MOV	#-1,MACPS
	MOV	#-1,MACLC
	FTAB
	MOV	#".T,(R2)+
	MOV	#"IT,(R2)+
	MOV	#"LE,(R2)+
	MOV	#"  ,(R2)+
	MOV	#3,R0
	MOV	#HEADER+2,R3
10$:	MOV	(R3)+,(R2)+
	SOB	R0,10$
	JMP	OPGSDL
;
CSECT:
	TST	(R1)		; CHECK FOR A BLANK CSECT
	BNE	10$
	TST	2(R1)
	BNE	20$
	MOVB	#40,4(R1)	; IF YES - SET UP ATTRIBUTES
	BR	100$		; AND PROCESS AS PSECT
10$:	CMP	(R1),#127401	; CHECK FOR NAME ".ABS ."
	BNE	20$
	CMP	2(R1),#7624
	BNE	20$
	MOVB	#104,4(R1)	; IF YES - SET UP ATTRIBUTES
	BR	100$		; AND PROCESS AS PSECT
20$:	MOVB	#144,4(R1)	; OTHERWISE NAMED CSECT
100$:	BR	PSECT		; PROCESS THE PSECT
;
XFRADD:
	MOV	#XFR,R5
	MOV	(R1)+,(R5)+	; SAVE PSECT NAME
	MOV	(R1)+,(R5)+
	TST	(R1)+
	MOV	(R1)+,(R5)+	; AND OFFSET
	JMP	GSD
;
GSNAM:
	BIT	#10,4(R1)	; REFERENCE OR DEFINITION?
	BNE	5$
	ADD	#8.,R1		; IGNORE REFERENCES
	BR	20$
5$:
	.IF DF	O$$FLP
	CMP	(R1),#126423	; IS IT "$$$$$X" ?
	BNE	7$
	CMP	2(R1),#126371
	BLT	7$
	CMP	2(R1),#126437
	BGT	7$
	INC	FLIPS		; INSERT ENTRY IN FLIP TABLE
	MOV	FLIPS,R0
	ASH	#2,R0
	ADD	#FLIPS-2,R0
	MOV	PSECTS,(R0)+
	MOV	6(R1),(R0)
	ADD	#8.,R1
	BR	20$
7$:
	.ENDC	; DF O$$FLP
;
	CMP	GLOBS,#GLOMAX
	BGE	30$
	INC	GLOBS
	MOV	GLOBS,R0
	ASH	#3,R0
	ADD	#GLOBS-6,R0
	MOV	#4,R3
10$:	MOV	(R1)+,(R0)+
	SOB	R3,10$
	MOV	PSECTS,-4(R0)
20$:	JMP	GSD
;
30$:	BIT	#OV$GLO,$OVSTS	; GLOBAL
	BNE	STEPJ
	MOV	#ERR14,MESNO	; TELL USER
	JSR	PC,MOCALL
	BIS	#OV$GLO,$OVSTS
STEPJ:	JMP	STEP
;
PSECT:
	CMP	PSECTS,#PSEMAX
	BGE	20$
	INC	PSECTS
	MOV	PSECTS,R0
	ASH	#3,R0
	ADD	#PSECTS-6,R0
	MOV	#4,R3
10$:	MOV	(R1)+,(R0)+
	SOB	R3,10$
; CHECK THAT THIS IS NOT IN OUR LIST OF MODIFIABLE
; PSECTS AND FIX UP I/D BIT IF IT IS.
	TST	SWITCH
	BEQ	300$		;IF NOTHING SET INTO BUFFERS, NO TEST
	MOV	R0,-(SP)
	MOV	R1,-(SP)
	MOV	R2,-(SP)
	MOV	R3,-(SP)
	MOV	R4,-(SP)
	MOV	R5,-(SP)
	MOV	R0,R2
	SUB	#10,R2		;POINTER OUR PSECT ENTRY WITH R2
	CLR ASCWK
	CLR ASCWK+2
	CLR ASCWK+4
	MOV	#ASCWK,R0
	MOV	R2,R1		;GET NAME IN ASCII
	JSR	PC,R50ASC	;CONVERTS HERE
	MOVB	4(R2),R5
	BPL	280$	;BIT 7 WAS OFF IF PL
	BIC	#177600,R5	;CLR BIT 7 IF IT WAS SET
	BR	281$
280$:	BIS	#200,R5		;SET BIT 7 IF IT WAS CLR
281$:
	BITB	#200,4(R2)	;SEE IF I SPACE NOW (0) OR D SPACE (1)
	BEQ	150$		;IF EQ, I SPACE SO SEE IF WE LOOK AT D'S
	BIT	#SW.IN,SWITCH	;GOT ANY INSTRUCTION PSECTS TO TEST?
	BEQ	299$
	MOV	#IP1,R0
	BR	290$
150$:	BIT	#SW.OUT,SWITCH
	BEQ	299$
	MOV	#DP1,R0
290$:
;HERE LOOK THRU UP TO 8 6-BYTE BUFFERS TO SEE IF PSECTNAME IS THERE
; IF SO, SAVE BIT APPROPRIATELY
; (R5 HAS WHAT TO SAVE)
	JSR PC,330$
299$:	MOV	(SP)+,R5
	MOV	(SP)+,R4
	MOV	(SP)+,R3
	MOV	(SP)+,R2
	MOV	(SP)+,R1
	MOV	(SP)+,R0
300$:	JMP	GSD
; SEARCH SUBROUTINE
330$:	MOV	R0,-(SP)
	MOV	R3,-(SP)
; R0 IS AREA TO SEARCH
; R2 IS BASE OF SAVED PSECT AREA
; ASCWK HAS ASCII PSECT NAME (6 CHARS)
; NOTE WE AREN'T TOO CAREFUL ABOUT SPACES...
	MOV	#8.,R3
331$:	CMP	(R0),ASCWK
	BNE	332$
	CMP	2(R0),ASCWK+2
	BNE	332$
	CMP	4(R0),ASCWK+4
	BNE	332$
; WOW WE FOUND IT.
	MOVB	R5,4(R2)	;STORE DESIRED I/D FLAG
	BR	333$
332$:	ADD	#6,R0		;PASS THIS ENTRY IN CSI VALUE TABLE
	SOB	R3,331$
333$:	MOV	(SP)+,R3
	MOV	(SP)+,R0
	RTS	PC
;
20$:	BIT	#OV$PSE,$OVSTS	; PSECT
	BNE	STEP
	MOV	#ERR15,MESNO	; TELL USER
	JSR	PC,MOCALL
	BIS	#OV$PSE,$OVSTS
	BR	STEP
;
IDENT:
	MOV	#-1,MACPS
	MOV	#-1,MACLC
	FTAB
	MOV	#".I,(R2)+
	MOV	#"DE,(R2)+
	MOV	#"NT,(R2)+
	MOV	#"  ,(R2)+
	MOVB	#'/,(R2)+
	MOV	R2,R0
	JSR	PC,R50ASC	; CONVERT TO ASCII
	CMP	(R1)+,(R1)+	; POINT TO NEXT GSD ITEM
	MOV	R0,R2		; UPDATE MACRO LINE POINTER
	MOVB	#'/,(R2)+
OPGSDL:
	JSR	PC,WR$SCR
	MOVB	#';,MACLIN
	MOV	#MACLIN+1,R2
	JSR	PC,WR$SCR
	JMP	GSD
STEP:
	ADD	#8.,R1
	JMP	GSD
;
EOG:
	CLC			; SHOW SUCCESSFUL
	RTS	PC		; RETURN
;
;
	.PSECT	ORCDAT,D
	.NLIST	BEX
GSDREC:	.WORD	GSD,EOG,GETLIN,GETLIN,GETLIN,EOG
GSDTYP:	.WORD	TITLE,CSECT,STEP,XFRADD,GSNAM,PSECT,IDENT
;
	.END
-h- ORCP2.MAC	Tue Aug 30 15:26:29 1983	VD3:[3,205]ORCP2.MAC;3
	.TITLE ORCP2
	.IDENT /V01.1/
;
; ORCAM - PASS 2
;
; PASS 2 PROCESSES TXT/RLD RECORDS
;	READS ENTRIES FROM .OBJ INTO OBJLIN AND OBLIN2
;	WRITES INTERMEDIATE CODE TO .TMP FROM MACPS
;
; DEFINE MACRO:
;
	.MACRO	FTAB
	JSR	PC,TAB8
	.ENDM	FTAB
;
;
;
; *********************************
; * PASS 2 - PROCESS TEXT RECORDS *
; *********************************
;
ORCP2::
GETTXT:
	MOV	#OBLIN2,R1
	MOV	#OBLEN2,R2
	JSR	PC,RD$OBJ
	BCC	10$
	RTS	PC		; ERROR RETURN
;
10$:	MOV	#OBLIN2,R1
	MOV	(R1)+,R0	; GET RECORD TYPE
	ASL	R0
	JMP	@TXTREC-2(R0)
;
; RLD RECORD FOUND - SET UP A DUMMY TXT RECORD IN OBJLIN
; (ALWAYS GET AN RLD RECORD BEFORE A TXT RECORD)
; CALL INTTXT TO PROCESS TXT AND RLD RECORDS
; THIS ROUTINE DOES NOT RETURN UNTIL EOM SEEN
;
RLD:
	MOV	#OBJLIN,R1	; SET UP A DUMMY TXT RECORD
	MOV	#3,(R1)+
	MOV	R1,OBJLEN
	JSR	PC,INTTXT	; INTERPRET TEXT
;
EOM::
	MOV	#MACPS,R2
	MOV	#-1,(R2)
	MOV	(R2)+,(R2)+
	TST	LSB		; IN A LSB?
	BEQ	5$
	MOV	#DSLSB,R1
	MOV	#11.,R0
2$:	MOVB	(R1)+,(R2)+
	SOB	R0,2$
	JSR	PC,WR$SCR
	MOV	#MACLIN,R2
5$:	FTAB
	MOV	#".E,(R2)+	; MOV ".END" TEXT
	MOV	#"ND,(R2)+
	MOV	#XFR,R0		; POINT TO XFR ADDRESS
	CMP	(R0),#-1	; DEFINED?
	BEQ	100$		; IF NOT - FINISH
	CMP	4(R0),#1	; OFFSET EQUALS 000001?
	BEQ	100$		; IF SO - FINISHED
	MOV	4(R0),OCOBUF	; GET OFFSET
	JSR	PC,GETPS	; GET PSECT NO.
	JSR	PC,PLLL		; PLANT LOCAL SYMBOL
	ADD	#100,R0		; CONVERT PSECT NUMBER TO LETTER
	MOVB	#11,(R2)+	; INSERT A TAB
	MOVB	R0,(R2)+	; INSERT LETTER
	BIS	#100000,OCOBUF	; ENSURE 6 CHARACTERS
	JSR	PC,OCO
	MOV	#OCOBUF+1,R5
	DEC	R0
10$:	MOVB	(R5)+,(R2)+
	SOB	R0,10$
100$:	JSR	PC,WR$SCR	; WRITE
DONE:
	CLC			; SHOW SUCCESSFUL
	RTS	PC		; RETURN
;
	.PSECT	ORCDAT,D
	.NLIST	BEX
TXTREC:	.WORD	GETTXT,GETTXT,GETTXT,RLD,GETTXT,EOM
;
	.END
-h- ORCP3.MAC	Tue Aug 30 15:26:29 1983	VD3:[3,205]ORCP3.MAC;5
	.TITLE ORCP3
	.IDENT /V01.1/
;
; ORCAM - PASS 3
;
; PASS 3 PUTS IN THE LABELS
;	READS ENTRIES FROM .TMP INTO MACPS
;	WRITES MACRO CODE TO .MAC FROM MACLIN
;
;
; DEFINE MACRO:
;
	.MACRO	FTAB
	JSR	PC,TAB8
	.ENDM	FTAB
;
;
;
; ******************************
; * PASS 3 - PUT IN THE LABELS *
; ******************************
;
ORCP3::
	CLR	BLKB		; BLOCK BYTE PROCESSING FLAG
5$:	JSR	PC,RD$SCR
	BCC	8$
7$:	JMP	FINISH		; ERROR OR EOF - FINISH
8$:	MOV	GLOBS,R0	; CHECK FOR GLOBAL DEFS
	BEQ	140$		; THERE ARE NONE
	MOV	#GLOBS+2,R1
110$:	CMP	MACPS,4(R1)
	BNE	120$
	CMP	MACLC,6(R1)
	BEQ	130$
120$:	ADD	#8.,R1
	SOB	R0,110$
	BR	140$
130$:	JSR	PC,CKBLKB	; CHECK FOR BLKB PROCESSING
	MOV	R0,-(SP)
	MOV	R1,-(SP)
	MOV	#MACLIN,R0	; POINT TO MACRO LINE
	JSR	PC,R50ASC	; PUT ASCII NAME IN
	MOV	R0,R2		; MAKE R2 POINT TO MACRO LINE
135$:	CMPB	-(R2),#40
	BEQ	135$
	TSTB	(R2)+
	MOVB	#':,(R2)+
	MOVB	#':,(R2)+
	MOV	MACLEN,-(SP)
	MOV	#MACLIN+8.,MACLEN
	JSR	PC,WR$MAC
	MOV	(SP)+,MACLEN
	MOV	#MACLIN,R2	; CLEAR OUT LABEL
	FTAB
	MOV	(SP)+,R1	; RESTORE REGISTERS
	MOV	(SP)+,R0
	BR	120$
;
; CHECK FOR LESS LOCAL LABELS (IE. LOCAL SYMBOLS)
;
140$:	MOV	LLLABS,R0	; CHECK FOR LESS LOCAL LABELS
	BEQ	10$		; THERE ARE NONE

	MOV	#LLLABS+2,R1
150$:	CMP	MACPS,(R1)+	; CHECK PSECT NUMBER
	BNE	160$
	CMP	MACLC,(R1)	; CHECK LOCATION COUNTER
	BEQ	170$
160$:	TST	(R1)+		; NO MATCH - POINT TO NEXT ENTRY
	SOB	R0,150$		; AND TRY AGAIN
	BR	10$		; END OF TABLE
170$:	JSR	PC,CKBLKB	; CHECK FOR BLKB PROCESSING
	MOV	#MACLIN,R2	; POINT TO MACRO LINE
	MOV	MACPS,R0	; GET PSECT NUMBER
	ADD	#100,R0		; CONVERT TO A LETTER (A-Z)
	MOVB	R0,(R2)+	; INSERT IN LINE
	MOV	(R1),OCOBUF	; GET LOCATION COUNTER
	BIS	#100000,OCOBUF	; ENSURE 6 CHARACTERS
	JSR	PC,OCO		; CONVERT TO ASCII
	MOV	#OCOBUF+1,R1	; REMOVE INITIAL "1"
	DEC	R0
180$:	MOVB	(R1)+,(R2)+	; INSERT IN LINE
	SOB	R0,180$
	MOVB	#':,(R2)+	; INSERT COLON
;
; CHECK FOR LOCAL LABELS (IE. NNN$:)
;
10$:	MOV	LABELS,R0
	BEQ	100$		; IE NO LABELS EXIST
	MOV	#LABELS+2,R1
15$:	CMP	MACPS,(R1)+
	BNE	20$
	CMP	MACLC,(R1)
	BEQ	40$
20$:	TST	(R1)+
	SOB	R0,15$
	BR	100$		; NO MATCH
40$:	JSR	PC,CKBLKB	; CHECK FOR BLKB PROCESSING
	CMPB	#' ,MACLIN	; LOCAL LABEL FOUND - CHECK WHETHER
	BEQ	45$		;   WE ALREADY HAVE A LOCAL SYMBOL HERE
	MOV	MACLEN,-(SP)
	MOV	#MACLIN+7,MACLEN
	JSR	PC,WR$MAC	; WRITE OUT THE LOCAL SYMBOL FIRST
	MOV	(SP)+,MACLEN
	MOV	#MACLIN,R2	; CLEAR IT OUT OF THE LINE
	FTAB
45$:	MOV	MACLC,OCOBUF
	TST	OCOBUF
	BNE	50$
	INC	OCOBUF		; 0$ ISN'T VALID - SO MAKE IT 1$
50$:	JSR	PC,OCO
	MOV	#OCOBUF,R1
	MOV	#MACLIN,R2
70$:	MOVB	(R1)+,(R2)+
	SOB	R0,70$
	MOVB	#'$,(R2)+
	MOVB	#':,(R2)+
100$:
	TST	BLKB		; PROCESSING A BLKB?
	BNE	190$		; BRANCH IF YES
	MOV	#MACLIN+8.,R0	; CHECK IF THIS LINE IS .BLKB
	CMP	R0,MACLEN	; SHORT LINE?
	BGE	300$		; BRANCH IF YES
	CMP	(R0)+,#".B
	BNE	300$
	CMP	(R0)+,#"LK
	BNE	300$
	CMP	(R0)+,(R0)+	; YES - POINT TO SIZE OF BLOCK
	CLRB	@MACLEN		; TERMINATE NUMBER
	JSR	PC,$COTB	; CONVERT TO BINARY
	MOV	R1,R3		; SIZE IN R3
	MOV	R1,R5		; COPY IN R5
190$:	MOV	#1,R4		; STEP ON LC
	BIT	R4,MACLC
	BNE	200$		; - BY 1, IF IT IS ODD
	INC	R4		; - BY 2, OTHERWISE
200$:	SUB	R4,R3		; NO. OF BYTES LEFT
	BLE	300$		; BRANCH IF NONE
	MOV	#1,BLKB		; SHOW PROCESSING BLKB
	ADD	R4,MACLC	; SET UP NEW LC
	JMP	8$		; AND LOOK FOR LABELS
300$:
	CLR	BLKB
	JSR	PC,WR$MAC
	JMP	5$
;
FINISH:
	RTS	PC
;
;
; SUBROUTINE FOR PASS 3
;
;
;
; CKBLKB - CHECK FOR BLKB BEING PROCESSED
; ON ENTRY: R3 = NO. OF BYTES LEFT IN BLOCK
;	    R5 = TOTAL SIZE OF BLOCK
;
CKBLKB:
	TST	BLKB		; BLKB IN PROGRESS?

	BEQ	100$		; RETURN IF NOT
	MOV	R0,-(SP)	; SAVE REGISTERS
	MOV	R1,-(SP)
	MOV	R2,-(SP)
	SUB	R3,R5		; NO. OF BYTES BEFORE THIS LABEL
	MOV	R5,OCOBUF
	JSR	PC,OCO		; CONVERT TO ASCII
	MOV	#OCOBUF,R1
	MOV	#MACLIN+16.,R2
10$:	MOVB	(R1)+,(R2)+	; PUT INTO MACRO LINE
	SOB	R0,10$
	MOV	R2,MACLEN	; SET END OF LINE
	JSR	PC,WR$MAC	; OUTPUT THE LINE
	MOV	#MACLIN,R2
	FTAB			; CLEAR OUT LABELS
	MOV	R3,OCOBUF	; NO. OF BYTES LEFT
	JSR	PC,OCO		; CONVERT TO ASCII
	MOV	#OCOBUF,R1
	MOV	#MACLIN+16.,R2
20$:	MOVB	(R1)+,(R2)+	; PUT INTO MACRO LINE
	SOB	R0,20$
	MOV	R2,MACLEN	; SET END OF LINE
	CLR	BLKB
	MOV	(SP)+,R2	; RESTORE REGISTERS
	MOV	(SP)+,R1
	MOV	(SP)+,R0
100$:	RTS	PC
;
	.END
-h- ORCSR.MAC	Tue Aug 30 15:26:29 1983	VD3:[3,205]ORCSR.MAC;2
	.TITLE	ORCSR
	.IDENT	/V01.1/
;
; ORCAM - COMMON SUBROUTINES
;
; THIS FILE CONTAINS SUBROUTINES USED IN ALL THREE PASSES
; OF ORCAM:
;	OCO	CONVERT BINARY TO OCTAL
;	R50ASC	CONVERT RAD50 TO ASCII
;	TAB8	INSERT 8 SPACES IN OUTPUT LINE
;
; **********************************************************
;
; OCO - CONVERT BINARY TO OCTAL
; INPUT:  VALUE IS IN OCOBUF
; OUTPUT: STRING STARTS AT OCOBUF, LENGTH IN R0
;
OCO::	MOV	R1,-(SP)	; USE ONLY REGISTER R0
	MOV	R2,-(SP)
	MOV	R3,-(SP)
;
	MOV	#6,R0
	MOV	#OCOBUF,R1
	MOV	(R1),R3
	CLR	R2
	ASHC	#1,R2
5$:	TST	R2
	BNE	10$
	ASHC	#3,R2
	SOB	R0,5$
	MOVB	#60,(R1)	; ZERO
	INC	R0
	BR	100$
;
10$:	MOV	R0,-(SP)
15$:	ADD	#60,R2
	MOVB	R2,(R1)+
	CLR	R2
	ASHC	#3,R2
	SOB	R0,15$
	MOV	(SP)+,R0
;
100$:	MOV	(SP)+,R3
	MOV	(SP)+,R2
	MOV	(SP)+,R1
	RTS	PC
;
; R50ASC - CONVERT TWO RAD50 WORDS TO ASCII
; ON ENTRY: R0 -> OUTPUT BUFFER (ASCII)
;	    R1 -> INPUT BUFFER (RAD50)
; BOTH POINTERS ARE STEPPED ON THE APPROPRIATE AMOUNT
;
R50ASC::
	MOV	R2,-(SP)	; SAVE R2
	MOV	R3,-(SP)	; SAVE R3
	MOV	R1,R3		; SAVE R1 IN R3
	MOV	(R3)+,R1	; GET THE FIRST RAD50 WORD
	JSR	PC,$C5TA	; CONVERT TO ASCII
	MOV	(R3)+,R1	; GET THE SECOND RAD50 WORD
	JSR	PC,$C5TA	; CONVERT TO ASCII
	MOV	R3,R1		; RESTORE R1
	MOV	(SP)+,R3	; RESTORE OTHER REGISTERS
	MOV	(SP)+,R2
	RTS	PC
;
;
; MOVE 8 SPACES INTO OUTPUT LINE
;
TAB8::	MOV	#"  ,(R2)
	MOV	(R2)+,(R2)
	MOV	(R2)+,(R2)
	MOV	(R2)+,(R2)+
	RTS	PC
;
;
	.END
-h- ORCSUB.MAC	Tue Aug 30 15:26:29 1983	VD3:[3,205]ORCSUB.MAC;34
	.TITLE	ORCSUB ORCAM SUBROUTINES
	.IDENT	/V01/
;
; ORCAM SUBROUTINES
;
	.MACRO	FTAB
	JSR	PC,TAB8
	.ENDM	FTAB
;
; INTERPRET OPERAND IN R0
; R1 = CURRENT POSITION IN INPUT LINE
; R2 = CURRENT POSITION IN OUTPUT LINE
;
AMODE::
REG::
	MOV	R0,R4
	BIC	#70,R4		; ISOLATE
	ASH	#-2,R0
	BIC	#61,R0		; AND MO
	CMP	R4,#7
	BNE	5$
	MOVB	#'P,R3
	MOVB	#'C,R4
	JMP	@PCMODE(R0)
5$:	CMP	R4,#6
	BEQ	10$
	ADD	#60,R4
	MOVB	#'R,R3
	BR	20$
10$:	MOVB	#'S,R3
	MOVB	#'P,R4
20$:	JMP	@MODES(R0)
;
	.PSECT	ORCDAT,D
MODES:	.WORD	M0,M1,M2,M3,M4,M5,M6,M7
PCMODE:	.WORD	M0,M1,PCM2,PCM3,M4,M5,PCM6,PCM7
;
	.PSECT
M0:	MOVB	R3,(R2)+
	MOVB	R4,(R2)+
	BR	MDONE
MCOM:	MOVB	#'(,(R2)+
	MOVB	R3,(R2)+
	MOVB	R4,(R2)+
	MOVB	#'),(R2)+
	RTS	PC
M1:	JSR	PC,MCOM
	BR	MDONE
M2:	JSR	PC,MCOM
	MOVB	#'+,(R2)+
	BR	MDONE
M3:	MOVB	#'@,(R2)+
	BR	M2
M4:	MOVB	#'-,(R2)+
	BR	M1
M5:	MOVB	#'@,(R2)+
	BR	M4
M6:	CMP	R1,OBJLEN
	BLT	5$
	JSR	PC,NOMORE
5$:	MOV	(R1)+,OCOBUF
	JSR	PC,SRCHRD
	TST	R0
	BEQ	15$
	JSR	PC,OCO
	MOV	#OCOBUF,R5
10$:	MOVB	(R5)+,(R2)+
	SOB	R0,10$
15$:	ADD	#2,NXTLC
	BR	M1
M7:	MOVB	#'@,(R2)+
	BR	M6
;
PCM2:	MOVB	#'#,(R2)+
	CMP	R1,OBJLEN
	BLT	5$
	JSR	PC,NOMORE
5$:	MOV	(R1)+,OCOBUF
	JSR	PC,SRCHRD
	TST	R0
	BEQ	15$
	JSR	PC,OCO
	MOV	#OCOBUF,R5
10$:	MOVB	(R5)+,(R2)+
	SOB	R0,10$
15$:	ADD	#2,NXTLC
	BR	MDONE
PCM3:
	MOVB	#'@,(R2)+
	BR	PCM2
PCM6:	
	CMP	R1,OBJLEN
	BLT	5$
	JSR	PC,NOMORE
5$:	MOV	(R1)+,OCOBUF
	JSR	PC,SRCHRD
	ADD	#2,NXTLC
	ADD	NXTLC,OCOBUF
	TST	R0
	BEQ	10$
	JSR	PC,PLANTL
10$:	BR	MDONE
PCM7:
	MOVB	#'@,(R2)+
	BR	PCM6
MDONE:
	RTS	PC
;
;
;
; CHECK LOCATION COUNTER
;
CHKLC::
	MOV	R1,-(SP)	; SAVE REGISTERS
	MOV	R3,-(SP)
	MOV	#OBLIN2,R1
	CMP	(R1)+,#4	; RLD RE
	BNE	100$
10$:	CMP	R1,OBLEN2
	BGE	100$
20$:	MOVB	(R1),R3
	BIC	#177600,R3	; ISOLATE RLD TYPE
	CMP	R3,#10		; LC MODIFICATION ?
	BNE	30$
	JSR	PC,RLDLC	; YES - PROCESS MODIFICATION
30$:	JSR	PC,INCREL	; STEP ON TO NEXT RLD ENTRY
	BR	10$		; AND REPEAT
100$:	MOV	(SP)+,R3	; RESTORE REGISTERS
	MOV	(SP)+,R1
	RTS	PC
;
; PROCESS LC MODIFICATION
; ON ENTRY: R1 POINTS TO RLD ENTRY
;
RLDLC::
	MOV	#OCOBUF,R5
	MOV	2(R1),(R5)	; SET NEW LC
	SUB	MACLC,(R5)	; FIND THE DIFFERENCE
	JSR	PC,MODLC	; MODIFY LC
	MOV	PSNUM,MACPS	; RESTORE PS/LC
	MOV	2(R1),MACLC
	MOV	2(R1),NXTLC
	ADD	#2,NXTLC
	RTS	PC
;
; CHECK PSECT
;
CHKPS::
	MOV	R1,-(SP)	; SAVE REGISTERS
	MOV	R3,-(SP)
	MOV	#OBLIN2,R1
	CMP	(R1)+,#4
	BNE	100$
10$:	CMP	R1,OBLEN2
	BGE	80$
20$:	MOVB	(R1),R3
	BIC	#177600,R3	; ISOLATE RLD TYPE
	CMP	R3,#7		; PSECT DEFINITION?
	BEQ	70$
30$:	JSR	PC,INCREL	; INCREMENT REL POINTER
	BR	10$
70$:
	CMP	OBJLIN,#4	; OBJLIN
	BNE	75$		; NO
	CMP	#7,OBJLIN+2
	BNE	75$		; NO
	MOV	#OBJLIN+4,R1	; YES RE
	JSR	PC,RLDPS
	BR	100$		; NOW EX
75$:	TST	(R1)+		; POINT
	JSR	PC,RLDPS
80$:	MOV	#OBLIN2,R1
	MOV	#OBLEN2,R2
	JSR	PC,RD$OBJ	; READ A LINE
	BCC	90$
	JMP	EOM
90$:	MOV	#OBLIN2,R1
	CMP	(R1)+,#4	; IS IT RLD?
	BNE	100$
	CMP	(R1)+,#7	; IF SO,
	BNE	100$
	JSR	PC,RLDPS	; PROCES
100$:	MOV	(SP)+,R3
	MOV	(SP)+,R1
	RTS	PC
;
; GET INSTRUCTION
;
GETINS::CMP	R1,OBJLEN
	BLT	10$
	JSR	PC,CHKLC
	MOV	MACLC,OLDLC	; SAVE CURRENT LC
	MOV	MACPS,OLDPS	; AND PSECT NO.
	JSR	PC,CHKPS
	JSR	PC,NOMORE
	BCS	100$		; BRANCH IF EOM SEEN
	MOV	LOADAD,MACLC	; SET UP NEW LC FROM LOAD ADDRESS
	MOV	MACLC,NXTLC
	ADD	#2,NXTLC
	CMP	OLDPS,MACPS	; SAME PSECT AS BEFORE?
	BNE	10$
	CMP	OLDLC,MACLC	; IF SO - COMPARE OLD AND NEW LC'S
	BEQ	10$		; EQUAL - BRANCH
	MOV	#OCOBUF,R5	; NEED TO REDEFINE LC
	MOV	MACLC,(R5)
	SUB	OLDLC,(R5)	; HOW MUCH TO UPDATE BY
	MOV	MACLC,R4	; SAVE NEW LC
	MOV	OLDLC,MACLC	; SET OLD LC
	JSR	PC,MODLC	; MODIFY LC
	MOV	#MACPS,R2
	MOV	PSNUM,(R2)+	; RESET CURRENT PS
	MOV	R4,(R2)+	; AND LC
	MOV	R4,NXTLC
	ADD	#2,NXTLC
10$:	MOVB	(R1)+,CURINS
	MOVB	(R1)+,CURINS+1
	MOV	#MACLIN,R2
	FTAB
;
	.IF DF	O$$FLP
	MOV	FLIPS,R0	; CHECK FOR A FLIP
	BEQ	50$
	MOV	#FLIPS+2,R3
20$:	CMP	MACPS,(R3)+
	BNE	30$
	CMP	MACLC,(R3)
	BEQ	40$
30$:	TST	(R3)+
	SOB	R0,20$
	BR	50$
40$:	INC	DIFLAG		; FLIP DIFLAG
	BIC	#177776,DIFLAG
50$:
	.ENDC	; DF O$$FLP
;
	CLC
100$:	RTS	PC
;
; INCREL - INCREMENT RLD POINTER
; ON ENTRY: R1 POINTS TO RLD RECORD
;	    R3 IS RLD TYPE
;
INCREL::
	CMP	R3,#17		; COMPLEX REL?
	BEQ	10$
	MOVB	INCRLD-1(R3),R3
	ADD	R3,R1
	BR	100$
10$:	ADD	#2,R1		; STEP OVER RLD TYPE AND DISP
20$:	MOVB	(R1)+,R3	; STEP THROUGH RECORD
	CMP	R3,#12		; TERMINATOR?
	BEQ	100$		; YES - EXIT
	BLT	20$		; OPERATOR - NEXT BYTE
	CMP	R3,#13		; TERMINATOR?
	BEQ	100$		; YES - EXIT
	NEG	R3		; FETCH TYPE COMMAND - 16-20
	ADD	#22,R3		; CONVERT TO RANGE 2-4
	ADD	R3,R1		; STEP ON POINTER
	BR	20$		; NEXT BYTE
100$:	RTS	PC
;
; DEFINE MACRO TO SEARCH OP TABLE
;
	.MACRO	SEARCH,XOPTAB
	MOV	#XOPTAB,R3
	JSR	PC,SRCHOP
	.ENDM	SEARCH
;
; INTERPRET TEXT RECORDS
;
INTTXT::
	MOV	(R1)+,MACLC
	MOV	MACLC,LOADAD
	MOV	MACLC,NXTLC
GO:	ADD	#2,NXTLC
	JSR	PC,GETINS	; GET AN INSTRUCTION
	BCC	1$
	RTS	PC		; RETURN IF EOM SEEN
;
1$:
	TST	DIFLAG		; DATA OR INSTRUCTION?
	BEQ	2$
	JMP	DATAPS
2$:	MOV	CURINS,R0
	BIC	#107777,R0
	SEARCH	OPTAB1
	BCS	10$
	MOV	CURINS,R0
	JSR	PC,WB
5$:	MOV	CURINS,R0
	ASH	#-6,R0
	BIC	#177700,R0
	JSR	PC,AMODE	; PROCESS
6$:	MOVB	#',,(R2)+
7$:	MOV	CURINS,R0
	BIC	#177700,R0
	JSR	PC,AMODE	; PROCESS
	JMP	OPMACL
10$:	MOV	CURINS,R0
	BIC	#7777,R0
	SEARCH	OPTAB2
	BCC	5$
	MOV	CURINS,R0
	BIC	#777,R0
	SEARCH	OPTAB3
	BCS	30$
	MOV	CURINS,R0
	BIC	#177700,R0
	JSR	PC,AMODE
	MOVB	#',,(R2)+
	MOV	CURINS,R0
	ASH	#-6,R0
	BIC	#177770,R0
	JSR	PC,REG	
	JMP	OPMACL
;
30$:	MOV	CURINS,R0
	BIC	#777,R0
	SEARCH	OPTABX
	BCS	35$
	MOV	CURINS,R0
	ASH	#-6,R0
	BIC	#177770,R0
	JSR	PC,REG
	BR	6$
;
35$:	MOV	CURINS,R0
	BIC	#777,R0
	SEARCH	OPTABY
	BCS	40$
	MOV	CURINS,R0
	ASH	#-6,R0
	BIC	#177770,R0
	JSR	PC,REG
	MOVB	#',,(R2)+
	MOV	CURINS,R0
	BIC	#177700,R0
	NEG	R0
	JSR	PC,OFFSET
	JMP	OPMACL
;
40$:	MOV	CURINS,R0
	CLRB	R0
	SEARCH	OPTAB4
	BCS	45$
	MOVB	CURINS,R0
	JSR	PC,OFFSET
	JMP	OPMACL
;
45$:	MOV	CURINS,R0
	CLRB	R0
	SEARCH	OPTABZ
	BCS	50$
	CLR	OCOBUF
	MOVB	CURINS,OCOBUF
46$:	JSR	PC,OCO
	MOV	#OCOBUF,R5
48$:	MOVB	(R5)+,(R2)+
	SOB	R0,48$
	JMP	OPMACL
;
50$:	MOV	CURINS,R0
	BIC	#100077,R0
	SEARCH	OPTAB5
	BCS	60$
	MOV	CURINS,R0
	JSR	PC,WB
	JMP	7$
;
60$:	MOV	CURINS,R0
	BIC	#77,R0
	SEARCH	OPTAB6
	BCS	65$
	JMP	7$
;
65$:	MOV	CURINS,R0
	BIC	#77,R0
	SEARCH	OPTABP
	BCS	70$
	MOV	CURINS,OCOBUF
	BIC	#177700,OCOBUF
	BR	46$
;
70$:	MOV	CURINS,R0
	BIC	#7,R0
	SEARCH	OPTAB7
	BCS	75$
	MOV	CURINS,R0
	BIC	#177770,R0
	JSR	PC,REG
79$:	JMP	OPMACL
;
75$:	MOV	CURINS,R0
	BIC	#7,R0
	SEARCH	OPTABQ
	BCS	80$
	MOV	CURINS,OCOBUF
	BIC	#177770,OCOBUF
	BR	46$
;
80$:	MOV	CURINS,R0
	SEARCH	OPTAB8
	BCC	79$
;
CCODES:	MOV	CURINS,R0
	BMI	60$
	CMP	R0,#240
	BLE	INVOP
	CMP	R0,#300
	BGE	INVOP
	BIT	#20,R0
	BNE	10$
	MOVB	#'C,R3
	MOVB	#'L,R4
	BR	20$
10$:	MOVB	#'S,R3
	MOVB	#'E,R4
20$:	BIC	#177760,R0
	CMP	R0,#17
	BNE	30$
	MOVB	R3,(R2)+
	MOVB	#'C,(R2)+
	MOVB	#'C,(R2)+
	BR	OPMACL
30$:	MOV	R1,-(SP)	; SAVE R1
	CLR	OCOBUF		; USE OCOBUF AS FLAG
	MOV	#1,R1		; BIT TO BE TESTED
	MOV	#4,R5		; LOOP COUNTER
40$:	BIT	R1,R0
	BEQ	50$
	CMP	OCOBUF,#1
	BLT	45$
	BGT	44$
	MOVB	-(R2),-(SP)	; PUT THE INSTRUCTION ON THE STACK
	MOVB	-(R2),-(SP)
	MOVB	-(R2),-(SP)
	MOV	#".W,(R2)+
	MOV	#"OR,(R2)+
	MOV	#"D ,(R2)+
	MOV	#"  ,(R2)+
	MOVB	(SP)+,(R2)+	; NOW PUT IT BACK AGAIN
	MOVB	(SP)+,(R2)+
	MOVB	(SP)+,(R2)+
44$:	MOVB	#'!,(R2)+
45$:	MOVB	R3,(R2)+
	MOVB	R4,(R2)+
	MOVB	CCS-1(R5),(R2)+
	INC	OCOBUF
50$:	ASL	R1
	SOB	R5,40$
	MOV	(SP)+,R1	; RESTORE R1
	BR	OPMACL
60$:
;
;  NOT CC INSTRUCTION SO LOOK FOR FPP INS
;
	BIC	#377,R0
	SEARCH	OPTAB9
	BCS	INVOP
	MOV	CURINS,R0
	BIC	#377,R0		; CHECK
	MOV	#4,R3
	MOV	#FPPTRA,R4	; TRANSP
70$:	CMP	(R4)+,R0
	BEQ	SETFI		; TRANSP
	SOB	R3,70$
	MOV	CURINS,R0	; O/P SS
	BIC	#^C77,R0	; ISOLAT
	JSR	PC,AMODE
	MOVB	#',,(R2)+	; O/P ,
	MOVB	#'%,(R2)+	; PREFIX
				; TO DIF
	MOV	CURINS,R0
	ASH	#-6,R0		; GET RE
	BIC	#^C3,R0		; ISOLAT
	ADD	#60,R0
	MOVB	R0,(R2)+	; PUT RE
	BR	OPMACL		; OP INS
SETFI:
;
;  FPP INSTRUCTION IS SETF SO O/P OPERAND
;
	MOV	CURINS,R0
	ASH	#-6,R0
	BIC	#^C3,R0
	ADD	#60,R0
	MOVB	#'%,(R2)+
	MOVB	R0,(R2)+
	MOVB	#',,(R2)+
	MOV	CURINS,R0
	BIC	#^C77,R0
	JSR	PC,AMODE
	BR	OPMACL
INVOP:	MOV	CURINS,OCOBUF
	JSR	PC,OCO
	MOV	#OCOBUF,R5
	MOV	#6,R4
	SUB	R0,R4
	BEQ	7$
6$:	MOVB	#'0,(R2)+
	SOB	R4,6$
7$:	MOVB	(R5)+,(R2)+
	SOB	R0,7$
	MOV	#INVOPL,R3
	MOV	#28.,R0
10$:	MOVB	(R3)+,(R2)+
	SOB	R0,10$
;
OPMACL:	JSR	PC,WR$SCR
	MOV	NXTLC,MACLC
	JMP	GO
;
	.PSECT	ORCDAT,D
FPPTRA:	.WORD	174000
	.WORD	175000
	.WORD	175400
	.WORD	176000
;
	.PSECT
;
DATAPS::
	CMP	R1,OBJLEN	; CHECK FOR ONLY ONE BYTE LEFT TO DO
	BGT	5$		; BRANCH IF SO
	BIT	#1,MACLC	; IS LC ODD?
	BEQ	30$
5$:	DEC	R1		; REPOSITION POINTER
	MOV	#BYTXT,R4
	MOV	#8.,R0
10$:	MOVB	(R4)+,(R2)+	; ".BYTE"
	SOB	R0,10$
	JSR	PC,SDATRD	; CHECK FOR RELOCATION
	TST	R0
	BPL	20$		; YES - BRANCH
	CLR	OCOBUF
	MOVB	CURINS,OCOBUF
	JSR	PC,OCO		; OTHERWISE OUTPUT OCTAL NUMBER
	MOV	#OCOBUF,R5
15$:	MOVB	(R5)+,(R2)+
	SOB	R0,15$
	CMPB	CURINS,#40	; COULD IT BE ASCII?
	BLT	20$
	CMPB	CURINS,#176	;ALLOW FOR LOWERCASE (GCE01)
	BGT	20$
	MOV	#ASCLIN,R4	; IF SO, OUTPUT ASCII AS COMMENT
	MOV	#13.,R0
18$:	MOVB	(R4)+,(R2)+
	SOB	R0,18$
	MOVB	CURINS,(R2)+
	MOVB	#'/,(R2)+
20$:	DEC	NXTLC		; NXTLC
	BR	100$		; EXIT
;
30$:	MOV	#WOTXT,R4
	MOV	#8.,R0		; ASSUME ".WORD"
35$:	MOVB	(R4)+,(R2)+
	SOB	R0,35$
	JSR	PC,SDATRD	; CHECK FOR RELOCATION
	TST	R0
	BEQ	100$		; WORD RELOCATED
	BPL	50$		; BYTE RELOCATED
	INC	NXTLC		; NO RELOCATION -
	JSR	PC,SDATRD	; CHECK SECOND BYTE
	DEC	NXTLC
	TST	R0
	BMI	38$		; NO RELOCATION
	CLR	OCOBUF		; 2ND BYTE RELOCATED
	MOVB	CURINS,OCOBUF	; PUT OUT FIRST BYTE
	JSR	PC,OCO
	MOV	#OCOBUF,R5
	MOV	#MACLIN+16.,R2
36$:	MOVB	(R5)+,(R2)+
	SOB	R0,36$
	BR	50$		; NOW DO SECOND BYTE
;
38$:	MOV	CURINS,OCOBUF	; NO RELOCATION
	JSR	PC,OCO		; PUT OUT WORD
	MOV	#OCOBUF,R5
40$:	MOVB	(R5)+,(R2)+
	SOB	R0,40$
	MOV	CURINS,R0
	CMP	R0,#20040	; TWO SPACES?
	BEQ	44$		; YES - OUTPUT ASCII
	MOV	#2,R4		; CHECK FOR ASCII
41$:	CMPB	R0,#40
	BLT	42$
	CMPB	R0,#176	;GCE01 - ALLOW LC
	BLE	43$
42$:	CLRB	R0
	BISB	#40,R0		; CONVERT NON-ASCII CHARS TO SPACES
43$:	SWAB	R0		; TRY THE SECOND BYTE
	SOB	R4,41$
	CMP	R0,#20040	; IF SPACES
	BEQ	100$		; ... THEN NOT ASCII
44$:	MOV	R0,-(SP)	; SAVE ASCII CHARS
	MOV	#ASCLIN,R4	; PUT OUT ASCII COMMENT
	MOV	#13.,R0
45$:	MOVB	(R4)+,(R2)+
	SOB	R0,45$
	MOV	(SP)+,R0	; ASCII
	MOVB	R0,(R2)+
	SWAB	R0
	MOVB	R0,(R2)+
	MOVB	#'/,(R2)+
	BR	100$
50$:	MOV	#MACLIN+8.,R5
	MOV	#BYTXT,R4	; OVERWRITE WORD WITH BYTE
	MOV	#5,R0
55$:	MOVB	(R4)+,(R5)+
	SOB	R0,55$
	MOVB	#',,(R2)+	; COMMA
	INC	NXTLC
	JSR	PC,SDATRD	; CHECK
	DEC	NXTLC
	TST	R0
	BPL	100$
	CLR	OCOBUF
	MOVB	CURINS+1,OCOBUF	; NO REL
	JSR	PC,OCO
	MOV	#OCOBUF,R5
60$:	MOVB	(R5)+,(R2)+
	SOB	R0,60$
100$:
	JSR	PC,WR$SCR
	MOV	NXTLC,MACLC
	JMP	GO
;
;
; MODLC - MODIFY LOCATION COUNTER BY OUTPUTTING
;	.=.+NNNN IF INSTRUCTION OR IF NNNN IS NEGATIVE
;	.BLKB NNNN IF DATA AND NNNN POSITIVE
; ON ENTRY:    R5 -> OCOBUF WHICH CONTAINS OFFSET
; R0 IS CORRUPTED BY THIS ROUTINE
;
MODLC:
	MOV	#MACPS,R2	; OUTPUT LINE
	TST	DIFLAG		; INSTRUCTION?
	BEQ	45$		; BRANCH IF YES
	TST	(R5)		; OFFSET NEGATIVE?
	BMI	45$		; BRANCH IF YES
	CMP	(R2)+,(R2)+	; POINT TO TEXT PART OF LINE
	FTAB
	MOV	#".B,(R2)+	; DATA - USE BLKB
	MOV	#"LK,(R2)+
	MOV	#"B ,(R2)+
	MOV	#"  ,(R2)+
	BR	60$		; PUT IN VALUE
45$:	MOV	#-1,(R2)+
	MOV	#-1,(R2)+
	MOV	#".=,(R2)+	; INSTRUCTION
	TST	(R5)		; USE .=.+NNNN
	BMI	50$
	MOV	#".+,(R2)+
	BR	60$
50$:	MOV	#".-,(R2)+
	NEG	(R5)
60$:	JSR	PC,OCO		; CONVERT TO ASCII
65$:	MOVB	(R5)+,(R2)+	; MOVE INTO LINE
	SOB	R0,65$
	JSR	PC,WR$SCR	; OUTPUT LINE
	RTS	PC
;
; NOMORE - TXT LINE EXHAUSTED - GET SOME MORE
;
NOMORE::
	MOV	R2,-(SP)	; SAVE R2
	MOV	#OBJLIN,R1
	MOV	#OBLIN2,R2
	CMP	(R2),#3
	BNE	10$
	MOV	#101,R0		; LINE 2 IS TXT
5$:	MOV	(R2)+,(R1)+	; MOV LINE 2 INTO LINE 1
	SOB	R0,5$
	SUB	#202,-(R1)
	BR	100$		; GO TO GET NEW LINE 2
;
10$:	CMP	(R2),#6		; LINE 2 = EOM?
	BEQ	200$		; IF SO - FINISHED
20$:
	MOV	#OBJLIN,R1	; READ NEW LINE 1
	MOV	#OBJLEN,R2	;
	JSR	PC,RD$OBJ
	BCS	200$
	MOV	#OBJLIN,R1
	CMP	(R1),#3		; IS IT TXT?
	BEQ	100$
	CMP	(R1),#6		; IS IT EOM?
	BEQ	200$
	CMP	(R1),#4		; IS IT RLD?
	BNE	20$		; NO - READ ANOTHER RECORD
	TST	(R1)+		; POINT TO FIRST RLD ENTRY
30$:	CMP	R1,OBJLEN	; FINISHED PROCESSING?
	BGE	20$
	MOVB	(R1),R3		; GET RLD TYPE
	BIC	#177600,R3
	CMP	R3,#7		; LC DEFINITION?
	BNE	40$
	MOV	R1,-(SP)
	TST	(R1)+		; YES - POINT TO PSECT NAME
	JSR	PC,RLDPS	; PROCESS LC DEFINITION
	MOV	(SP)+,R1
	BR	50$
40$:	CMP	R3,#10		; LC MODIFICATION?
	BNE	50$		; NO OTHER TYPE ALLOWED
	JSR	PC,RLDLC	; PROCESS LC MODIFICATION
50$:	JSR	PC,INCREL	; STEP TO NEXT RLD ENTRY
	BR	30$		; AND REPEAT
100$:
	MOV	#OBLIN2,R1
	MOV	#OBLEN2,R2
	JSR	PC,RD$OBJ
	BCS	200$
	MOV	#OBJLIN+2,R1
	MOV	(R1)+,LOADAD
	CLC
	BR	300$
200$:
	SEC			; EOM SEEN
300$:
	MOV	(SP)+,R2	; RESTORE R2
	RTS	PC
;
;
OFFSET::ASL	R0		; R0 CON
	ADD	#2,R0
	ADD	MACLC,R0
	MOV	R0,OCOBUF
PLANTL:	CMP	LABELS,#LABMAX
	BGE	20$
	INC	LABELS
	MOV	LABELS,R0
	ASH	#2,R0
	MOV	MACPS,LABELS-2(R0)
	MOV	OCOBUF,LABELS(R0) ; SET LABEL
	TST	OCOBUF
	BNE	40$
	INC	OCOBUF		; 0$ NOT VALID - CALL IT 1$
40$:	JSR	PC,OCO
	MOV	#OCOBUF,R5
10$:	MOVB	(R5)+,(R2)+
	SOB	R0,10$
	MOVB	#'$,(R2)+
	RTS	PC
;
20$:
	BIT	#OV$LAB,$OVSTS	; LABEL
	BNE	30$
	MOV	#ERR16,MESNO	; TELL USER
	JSR	PC,MOCALL
	BIS	#OV$LAB,$OVSTS
30$:	CLR	OCOBUF
	BR	40$
;
;
; PROCESS PSECT DEFINITION
;
RLDPS::
	MOV	R3,-(SP)	; SAVE R3
	MOV	PSECTS,R3
	MOV	#PSECTS+2,R4
	MOV	PSNUM,R0	; GET PSECT NO.
	BEQ	5$		; BRANCH IF FIRST TIME THROUGH
	ASH	#3,R0
	MOV	MACLC,PSECTS(R0); SAVE CURRENT MACLC FOR PSECT
	MOV	PSNUM,R0	; SAVE CURRENT PSECT NO.
	CLR	PSNUM
5$:	INC	PSNUM
	CMP	(R1),(R4)+
	BNE	10$
	CMP	2(R1),(R4)
	BEQ	20$
10$:	ADD	#6,R4
	SOB	R3,5$
20$:	CMP	PSNUM,R0	; SAME PSECT AS BEFORE?
	BNE	21$		; IF SO - DON'T BOTHER WITH IT
	JMP	50$
21$:	MOV	#MACPS,R2
	MOV	#-1,(R2)+
	MOV	#-1,(R2)+
	TST	LSB		; IN LSB?
	BEQ	25$
	MOV	#DSLSB,R3
	MOV	#11.,R5
22$:	MOVB	(R3)+,(R2)+
	SOB	R5,22$
	JSR	PC,WR$SCR
	MOV	#MACLIN,R2
	CLR	LSB
25$:	MOVB	#';,(R2)+
	JSR	PC,WR$SCR	; PUT OUT SEMICOLON
	MOV	#MACLIN,R2
	FTAB
	MOV	#".P,(R2)+
	MOV	#"SE,(R2)+
	MOV	#"CT,(R2)+
	MOV	#"  ,(R2)+
	MOV	R1,-(SP)
	MOV	R2,R0
	JSR	PC,R50ASC	; CONVERT NAME TO ASCII
	MOV	R0,R2		; UPDATE MACRO LINE POINTER
	MOV	(SP)+,R1	; RESTORE OBJECT LINE POINTER
	TST	(R4)+
	TSTB	1(R4)
	BEQ	38$
	BIT	#200,(R4)
	BEQ	30$
	MOV	#",D,(R2)+
	BR	31$
30$:	MOV	#",I,(R2)+
31$:	BIT	#100,(R4)
	BEQ	32$
	MOV	#",G,(R2)+
	MOV	#"BL,(R2)+
	BR	33$
32$:	MOV	#",L,(R2)+
	MOV	#"CL,(R2)+
33$:	MOV	#",R,(R2)+
	BIT	#20,(R4)
	BEQ	34$
	MOV	#"O,,(R2)+
	BR	35$
34$:	MOV	#"W,,(R2)+
35$:	BIT	#4,(R4)
	BEQ	36$
	MOV	#"OV,(R2)+
	MOVB	#'R,(R2)+
	BR	37$
36$:	MOV	#"CO,(R2)+
	MOVB	#'N,(R2)+
37$:	CLRB	1(R4)
	MOV	PSNUM,OLDPS	; SET UP OLDPS=PSECT NO
	CLR	OLDLC		; PREVIOUS OFFSET = 0
	BR	40$
38$:	MOV	PSNUM,R0	; NOT A NEW PSECT -
	MOV	R0,OLDPS	; SET OLD PSECT NO.
	ASH	#3,R0
	MOV	PSECTS(R0),OLDLC ; SET OLD LC
40$:	JSR	PC,WR$SCR
	BIT	#200,(R4)
	BEQ	45$
	MOV	#1,DIFLAG
	BR	50$
45$:	CLR	DIFLAG
	MOV	#1,LSB		; SET UP A LSB
	MOV	#MACLIN,R2
	MOVB	#';,(R2)+
	JSR	PC,WR$SCR
	MOV	#MACLIN,R2
	MOV	#ENLSB,R3
	MOV	#11.,R5
46$:	MOVB	(R3)+,(R2)+
	SOB	R5,46$
	JSR	PC,WR$SCR
50$:	MOV	PSNUM,MACPS
	CMP	(R1)+,(R1)+
	MOV	(R1),MACLC
	MOV	(R1),NXTLC
	ADD	#2,NXTLC
	MOV	(SP)+,R3	; RESTORE R3
	RTS	PC
;
;
SDATRD::
	MOV	R1,-(SP)
	MOV	R3,-(SP)
	MOV	NXTLC,R0
	SUB	LOADAD,R0
	ADD	#2,R0		; CALCUL
	MOV	#OBLIN2,R1
	CMP	(R1)+,#4
	BNE	90$
10$:	CMP	R1,OBLEN2
	BGE	90$
20$:	MOVB	(R1),R3
	CMPB	1(R1),R0
	BEQ	40$
	BIC	#177600,R3
	JSR	PC,INCREL
	BR	10$
40$:	ADD	#2,R1
	CLR	R0		; ANSWER
	TST	R3
	BPL	45$		; WORD R
	INC	R0		; BYTE R
45$:	MOV	R0,-(SP)	; SAVE A
	BIC	#177600,R3
	ASL	R3
	JSR	PC,@RLDTYP-2(R3)
	MOV	(SP)+,R0	; RESTOR
	BR	100$
90$:	MOV	#-1,R0		; NO REL
100$:	MOV	(SP)+,R3	; RESTOR
	MOV	(SP)+,R1
	RTS	PC
;
; SRCHOP - SEARCH OP TABLE FOR OPCODE
; ON ENTRY: R0 = OPCODE
;	    R2 -> OUTPUT LINE
;	    R3 -> OP TABLE
; ON EXIT:  CC IF OP FOUND (INSERTED IN LINE)
;	    CS IF NOT FOUND
;
SRCHOP::MOV	(R3)+,R4	; GET NO OF CODES IN TABLE
10$:	CMP	(R3)+,R0	; COMPARE CODES
	BEQ	20$
	ADD	#6.,R3
	SOB	R4,10$
	SEC			; CODE NOT FOUND
	BR	30$
20$:	MOV	(R3)+,(R2)+	; MOVE MNEMONIC INTO LINE
	MOV	(R3)+,(R2)+
	MOV	(R3)+,(R2)+
	MOV	#"  ,(R2)+	; NEXT TAB POSITION
	CLC			; SHOW CODE FOUND
30$:	RTS	PC
;
;
;
SRCHRD::
	MOV	R1,-(SP)	; SAVE R
	MOV	R3,-(SP)
	MOV	NXTLC,R0
	SUB	LOADAD,R0	; GET DI
	ADD	#4,R0
	MOV	#OBLIN2,R1
	CMP	(R1)+,#4
	BNE	100$
10$:	CMP	R1,OBLEN2
	BGE	100$
20$:	MOVB	(R1),R3
	BIC	#177600,R3
	CMPB	1(R1),R0	; DISP S
	BNE	30$
	ADD	#2,R1		; NOTE: R1 MAY BE ODD
	ASL	R3
	JSR	PC,@RLDTYP-2(R3)
	BR	110$
30$:	JSR	PC,INCREL	; INCREMENT REL POINTER
	BR	10$
;
100$:	MOV	#1,R0
	BR	120$
110$:	CLR	R0
120$:	MOV	(SP)+,R3
	MOV	(SP)+,R1
	RTS	PC
;
;
RLDTYP:	.WORD	RLD1,RLD2,RLD3,RLD4,RLD5,RLD6,RLD7,RLD10
	.WORD	RLD11,RLD12,RLD13,RLD14,RLD15,RLD16,RLD17
;
RLD1:
	MOV	(R1),OCOBUF
	TST	DIFLAG
	BEQ	10$
	MOV	PSNUM,R0	; FOR DA
	BR	RLDX
10$:	JSR	PC,PLANTL	; FOR IN
	RTS	PC
RLD2:
RLD4:
	MOV	R1,-(SP)
	MOV	R2,R0
	JSR	PC,R50ASC	; CONVERT NAME TO ASCII
	MOV	R0,R2
	MOV	(SP)+,R1
10$:	CMPB	-(R2),#40	; SQUEEZE OUT THE SPACES
	BEQ	10$
	TSTB	(R2)+
	RTS	PC
RLD3:				;
	MOV	(R1),OCOBUF
	JSR	PC,OCO
	MOV	#OCOBUF,R5
10$:	MOVB	(R5)+,(R2)+
	SOB	R0,10$
	RTS	PC
RLD7:				; PSECT DEFINITION - DONE ELSEWHERE
RLD10:				; LC MOD - DONE ELSEWHERE
RLD11:				; PROGRAM LIMITS - IGNORED
RLD13:				; RLD TYPE 13 - UNUSED
	RTS	PC
	.ENABL	LSB
RLD5:
RLD6:
	JSR	PC,RLD4		; GET GL
	CMP	(R1)+,(R1)+	; POINT
	MOV	(R1),OCOBUF
	BEQ	30$
	BLT	RLDM
	MOVB	#'+,(R2)+
	BR	20$
RLDM:	MOVB	#'-,(R2)+
	NEG	OCOBUF
20$:	JSR	PC,OCO
	MOV	#OCOBUF,R5
25$:	MOVB	(R5)+,(R2)+
	SOB	R0,25$
30$:	RTS	PC
	.DSABL	LSB
RLD12:
RLD14:
	CLR	OCOBUF		; OFFSET = 0
	BR	RLDP		; REST IS LIKE TYPES 15/16
	RTS	PC
RLD15:
RLD16:
	MOV	4(R1),OCOBUF	; OFFSET
RLDP:
	MOV	R1,R0
	JSR	PC,GETPS	; GET IT
RLDX:
	MOV	OCOBUF,R3
	BPL	5$
	CLR	OCOBUF
5$:	BIC	#1,OCOBUF	; MAKE SURE ADDRESS IS EVEN
	JSR	PC,PLLL		; PLANT A LOCAL SYMBOL
	ADD	#100,R0		; CONVERT PSECT TO A LETTER
	MOVB	R0,(R2)+	; INSERT IN LINE
	BIS	#100000,OCOBUF	; ENSURE 6 CHARACTERS
	JSR	PC,OCO
	MOV	#OCOBUF+1,R5
	DEC	R0
10$:	MOVB	(R5)+,(R2)+
	SOB	R0,10$
	MOV	R3,OCOBUF
	BMI	RLDM
	BIT	#1,R3		; WAS IT AN ODD ADDRESS ?
	BEQ	20$
	MOVB	#'+,(R2)+	; NEED "+1"
	MOVB	#'1,(R2)+
20$:	RTS	PC
	.ENABL	LSB
RLD17:
	MOV	R4,-(SP)	; SAVE R4
	MOV	#CXSTK1,R4	; POINT TO COMPLEX STACK 1
10$:	MOVB	(R1)+,R0	; GET OPERATOR
	ASL	R0
	JMP	@CXOP(R0)	; PROCESS IT
CX0:
	BR	10$		; NO OP
CX1:
	CLR	(R4)+		; 0 = OPERATOR
	MOV	#'+,(R4)+	; NAME OF OPERATOR
20$:	MOV	#2,(R4)+	; NO. OF OPERANDS
	BR	10$
CX2:
	CLR	(R4)+		; SUBTRACT
	MOV	#'-,(R4)+
	BR	20$
CX3:
	CLR	(R4)+		; MULTIPLY
	MOV	#'*,(R4)+
	BR	20$
CX4:
	CLR	(R4)+		; DIVIDE
	MOV	#'/,(R4)+
	BR	20$
CX5:
	CLR	(R4)+		; LOGICAL AND
	MOV	#'&,(R4)+
	BR	20$
CX6:
	CLR	(R4)+		; LOGICAL OR
	MOV	#'!,(R4)+
	BR	20$
CX10:
	CLR	(R4)+		; NEGATE
	MOV	#'-,(R4)+
30$:	MOV	#1,(R4)+	; NO. OF OPERANDS
	BR	10$
CX11:
	CLR	(R4)+		; COMPLEMENT
	MOV	#"^C,(R4)+
	BR	30$
CX12:
CX13:
	BR	100$		; COMMAND TERMINATORS
CX16:
	MOV	#CXSTK2,R5	; USE AS WORKSPACE
	MOV	#4,R0
40$:	MOVB	(R1)+,(R5)+	; GET RAD50 NAME
	SOB	R0,40$
	MOV	R1,-(SP)
	MOV	#CXNAME,R0
	MOV	#CXSTK2,R1
	JSR	PC,R50ASC
	MOV	(SP)+,R1
	MOV	#CXNAME,R0	; PUT ON TO STACK 1
	MOV	(R0)+,(R4)+
	MOV	(R0)+,(R4)+
	MOV	(R0)+,(R4)+
	BR	10$
CX17:
	MOVB	(R1)+,R0	; GET PSECT NO.
	INC	R0
	MOVB	(R1)+,OCOBUF	; GET OFFSET
	MOVB	(R1)+,OCOBUF+1
	JSR	PC,PLLL		; PLANT LOCAL SYMBOL
	ADD	#100,R0		; CONVERT PSECT TO A LETTER
	MOVB	R0,(R4)+	; INSERT IN LINE
	BIS	#100000,OCOBUF	; ENSURE 6 CHARACTERS
	JSR	PC,OCO
	MOV	#OCOBUF+1,R5
	DEC	R0
50$:	MOVB	(R5)+,(R4)+
	SOB	R0,50$
	BR	10$
CX20:
	MOVB	(R1)+,OCOBUF
	MOVB	(R1)+,OCOBUF+1
	JSR	PC,OCO
	MOV	#6,R3
	MOV	#OCOBUF,R5
60$:	MOVB	(R5)+,(R4)+
	DEC	R3
	SOB	R0,60$
	TST	R3
	BEQ	10$
70$:	MOVB	#40,(R4)+	; PAD OUT WITH SPACES
	SOB	R3,70$
	BR	10$
100$:
	MOV	#1,-(SP)	; ONE OPERATOR TO REVERSE
	MOV	#CXSTK2,R5	; COMPLEX STACK 2
	JSR	PC,REVSTK	; REVERSE THE STACK
	TST	(SP)+		; LOSE PARAMETER
	JSR	PC,PRTITM	; PRINT THE COMPLEX ITEM
	MOV	(SP)+,R4	; RESTORE R4
	RTS	PC
	.DSABL	LSB
;
	.PSECT	ORCDAT,D
CXOP:	.WORD	CX0,CX1,CX2,CX3,CX4,CX5,CX6,CX0
	.WORD	CX10,CX11,CX12,CX13,CX0,CX0,CX16,CX17,CX20
CXSTK1:	.BLKB	20.*6
CXSTK2:	.BLKB	20.*6
CXNAME:	.BLKB	6
;
	.PSECT
;
; REVSTK - COPY STACK 1 TO STACK 2, CONVERTING FROM REVERSE POLISH
; TO FORWARD POLISH.
; R4 -> STACK 1, R5 -> STACK 2
;
REVSTK:
	MOV	-(R4),-(SP)	; GET AN ITEM OFF STACK 1
	MOV	-(R4),-(SP)
	MOV	-(R4),-(SP)
	BNE	10$		; BRANCH IF ITS AN OPERAND
	MOV	4(SP),-(SP)	; OPERATOR - GET NO. OF OPERANDS
	JSR	PC,REVSTK	; COPY THE OPERANDS FIRST
	TST	(SP)+
10$:	MOV	(SP)+,(R5)+	; NOW COPY THE ITEM
	MOV	(SP)+,(R5)+
	MOV	(SP)+,(R5)+
	DEC	2(SP)		; DEC ITEM COUNT
	BGT	REVSTK		; DO NEXT ITEM
	RTS	PC
;
; PRTITM - PRINT THE ITEM ON COMPLEX STACK 2
; R5 -> STACK 2, R2-> OUTPUT LINE
;
PRTITM:
	MOV	-(R5),-(SP)	; GET ITEM OFF STACK 2
	MOV	-(R5),-(SP)
	MOV	-(R5),-(SP)
	BEQ	100$		; BRANCH IF ITS AN OPERATOR
	MOV	#6,R0		; OPERAND - OUTPUT IT
	MOV	SP,R4
10$:	MOVB	(R4)+,(R2)+
	SOB	R0,10$
20$:	CMPB	-(R2),#40	; SQUEEZE OUT THE SPACES
	BEQ	20$
	TSTB	(R2)+
	ADD	#6,SP
	BR	900$		; FINISH
100$:
	CMP	4(SP),#2	; OPERATOR - HOW MANY OPERANDS?
	BNE	200$
	MOVB	#'<,(R2)+	; 2 OPERANDS
	JSR	PC,PRTITM	; OUTPUT FIRST OPERAND
	TST	(SP)+
	MOVB	(SP)+,(R2)+	; OUTPUT THE OPERATOR
	TST	(SP)+
	JSR	PC,PRTITM	; OUTPUT SECOND OPERAND
	MOVB	#'>,(R2)+
	BR	900$		; FINISH
200$:
	TST	(SP)+		; 1 OPERAND
	MOVB	(SP),(R2)+	; OUTPUT OPERATOR
	TSTB	1(SP)
	BEQ	210$
	MOVB	1(SP),(R2)+
210$:	CMP	(SP)+,(SP)+
	JSR	PC,PRTITM	; OUTPUT OPERAND
900$:
	RTS	PC
;
; GET THE PSECT NUMBER
; ON ENTRY: R0 -> PSECT NAME
; ON EXIT:  R0 = PSECT NUMBER
;
GETPS::
	MOV	R1,-(SP)	; SAVE R
	MOV	R2,-(SP)
	MOV	#PSECTS,R2
	MOV	(R2)+,R1
10$:	CMP	(R0),(R2)+
	BNE	20$
	CMP	2(R0),(R2)
	BEQ	40$
20$:	ADD	#6,R2
	SOB	R1,10$
40$:	MOV	PSECTS,R0
	INC	R0
	SUB	R1,R0
	MOV	(SP)+,R2
	MOV	(SP)+,R1
	RTS	PC
;
; PLANT A LOCAL SYMBOL
; ON ENTRY: R0 = PSECT NUMBER, OCOBUF = LOCATION COUNTER
;
PLLL::	
	MOV	R1,-(SP)
	CMP	LLLABS,#LLLMAX
	BGE	10$
	INC	LLLABS
	MOV	LLLABS,R1
	ASH	#2,R1
	MOV	R0,LLLABS-2(R1)
	MOV	OCOBUF,LLLABS(R1)
	BR	20$
;
10$:	BIT	#OV$LLL,$OVSTS	; LLLAB
	BNE	20$
	MOV	#ERR17,MESNO	; TELL USER
	JSR	PC,MOCALL
	BIS	#OV$LLL,$OVSTS
20$:	
	MOV	(SP)+,R1
	RTS	PC
;
; WORD OR BYTE CHECK
; IF TOP BIT OF INSTRUCTION (R0) IS SET - APPEND "B" TO OPCODE
;
WB::	TST	R0
	BPL	10$
	MOVB	#'B,-5(R2)
10$:	RTS	PC
;
;
	.END
-h- RDCSI.MAC	Tue Aug 30 15:26:29 1983	VD3:[3,205]RDCSI.MAC;4
	.TITLE	RDCSI	READ COMMAND STRING
	.IDENT	/V01.1/
;
; ORCAM - READ COMMAND STRING
;
	.MCALL	GCML$,RCML$,CSI$1
	.MCALL	EXIT$S
;
; RD$CSI - READ A COMMAND STRING
;
RD$CSI::GCML$	#GCLBLK		; ISSUE PROMPT AND READ LINE
	BCS	10$
	TST	G.CMLD(R0)	; NULL COMMAND?
	BEQ	RD$CSI		; YES - REPROMPT
	CSI$1	#CSIBLK,GCLBLK+G.CMLD+2,GCLBLK+G.CMLD
	BCS	50$		; CS IF ERROR
	BITB	#CS.EQU,C.STAT(R0) ; EQUALS SIGN IN COMMAND LINE?
	BEQ	50$		; ERROR IF NOT
	RTS	PC
;
10$:	CMPB	#GE.EOF,G.ERR(R0) ; CTRL/Z ENTERED?
	BNE	20$
	EXIT$S			; IF SO - TERMINATE ORC
;
20$:	MOV	#ERR1,MESNO	; OTHERWISE ERROR
30$:	RCML$	#GCLBLK		; COME BACK TO TOP LEVEL
40$:	JSR	PC,MOCALL	; ISSUE ERROR MESSAGE
	BR	RD$CSI
50$:	MOV	#ERR2,MESNO	; SYNTAX ERROR
	BR	40$
;
	.END
-h- RDOBJ.MAC	Tue Aug 30 15:26:29 1983	VD3:[3,205]RDOBJ.MAC;3
	.TITLE	RDOBJ
	.IDENT	/V01.1/
;
;
; RD$OBJ - READ A LINE FROM THE OBJECT FILE
; PARAMETERS:
;	R1	WHERE TO PUT LINE
;	R2	WHERE TO PUT POINTER-PAST-END
;
	.MCALL	GET$,CLOSE$
;
	.ENABL	LSB
RD$OBJ::
	TST	EOF
	BNE	20$
	MOV	#ERR5,MESNO
	GET$	#OBJFDB,R1,#200
	BCS	10$
	MOV	F.NRBD(R0),(R2)
	ADD	R1,(R2)
	CLC
	BR	40$
10$:	CMPB	#IE.EOF,F.ERR(R0)
	BNE	30$
	MOV	#ERR6,MESNO
	CLOSE$	#OBJFDB
	BCS	30$
20$:	SEC
	MOV	#1,EOF
	BR	40$
30$:	JMP	MOCALL
40$:	RTS	PC
	.DSABL	LSB
;
	.END
-h- RDSCR.MAC	Tue Aug 30 15:26:29 1983	VD3:[3,205]RDSCR.MAC;2
	.TITLE	RDSCR
	.IDENT	/V01.1/
;
; RD$SCR - READ A LINE FROM THE SCRATCH FILE
;
	.MCALL	GET$,DELET$
;
RD$SCR::MOV	#ERR12,MESNO
	GET$	#SCRFDB,#MACPS,#84.
	BCS	10$
	MOV	F.NRBD(R0),MACLEN
	ADD	#MACPS,MACLEN
	CLC
	BR	30$
10$:	CMPB	#IE.EOF,F.ERR(R0)
	BEQ	20$
	CALL	MOCALL
20$:	MOV	#ERR13,MESNO
	DELET$	#SCRFDB
	BCC	25$
	CALL	MOCALL
25$:	SEC
30$:	RTS	PC
;
	.END
-h- WRMAC.MAC	Tue Aug 30 15:26:29 1983	VD3:[3,205]WRMAC.MAC;2
	.TITLE	WRMAC
	.IDENT	/V01.1/
;
; WRMAC - WRITE TO MACRO FILE
;
	.MCALL	PUT$
;
	.PSECT	ORCDAT,D
SPACE:	.BYTE	40
	.EVEN
;
	.PSECT
WR$MAC::MOV	#ERR9,MESNO
	TST	LNCNT		; NEED TO OUTPUT HEADER?
	BEQ	4$			; NO
	CLR	LNCNT			; YES
	MOV	#MACFDB,R0		; RESET
	MOV	#HEADER,F.NRBD+2(R0)	; O
	MOV	#HDRSIZ,F.NRBD(R0)
	PUT$	R0
	BCS	5$			;(FAILE
	MOV	#SPACE,F.NRBD+2(R0)	; OU
	MOV	#1,F.NRBD(R0)
	PUT$	R0
	BCS	5$
	PUT$	R0
	BCS	5$
4$:	MOV	#MACFDB,R0
	MOV	#MACLIN,F.NRBD+2(R0)	; M
	MOV	MACLEN,F.NRBD(R0)
	SUB	#MACLIN,F.NRBD(R0)
	PUT$	R0
	BCC	6$
5$:	JMP	MOCALL			; TELL U
6$:	RTS	PC
;
	.END
-h- WRSCR.MAC	Tue Aug 30 15:26:29 1983	VD3:[3,205]WRSCR.MAC;2
	.TITLE	WRSCR
	.IDENT	/V01.1/
;
; WR$SCR - WRITES TEXT STARTING AT MACPS
;	   LENGTH IN R2 AFTER SUBSTRACTING
;
	.MCALL	PUT$
;
WR$SCR::MOV	#ERR12,MESNO
	SUB	#MACPS,R2
	PUT$	#SCRFDB,#MACPS,R2
	BCC	10$
	JMP	MOCALL
10$:	RTS	PC
;
	.END
