#-h- scratf           808  asc  17-dec-82 09:43:36  sventek (joseph sventek)
## scratf - get scratfch file name based on 'seed'
# This routine should append the process ID to 'seed' to generate
# a file name unique to the running process.
 
 subroutine scratf (seed, name)

 character seed(ARB), name(ARB), temp(PIDSIZE)
 integer i, j
 integer indexs

 string jobstr "job"
 
 call getpnm(temp)              # get process name
 if (indexs(temp, jobstr) != 1) # must uniqify the name
   {
   call trndev("TI", 0, name)   # find our TI: device name
   i = 1
   call stcopy(temp, 4, temp, i)        # copy last three chars from task name
   call chcopy(name(1), temp, i)        # first char of device name
   for (j=3; name(j) != ':'; j=j+1)     # copy device number
     call chcopy(name(j), temp, i)      # ...
   }
 call fgenr8(temp, seed, name)  # generate the file name

 return
 end
#-h- spawn           2260  asc  17-dec-82 09:43:38  sventek (joseph sventek)
# offsets into tcspwn descriptor
define(CMD_LENGTH,1)
define(CMD_ADDRESS,2)
define(CMD_TYPE,3)
define(ARG_LENGTH,4)
define(ARG_ADDRESS,5)

# values of CMD type field
define(TS_USE,0)
define(TS_DOT,1)
define(TS_DOL,2)
define(TS_INS,3)

integer function spawn(image, args, pid, wait)

character mcrlin(80), image(ARB), args(ARB), pid(ARB), wait
character argbuf(ARGBUFSIZE), outfil(FILENAMESIZE), errfil(FILENAMESIZE), c
character clower
integer mcr, spdesc(5), status
integer junk, opnout, opnerr, outmod, i
integer equal, length, tcspwn
integer indexs, filnfo, gtmode

string local "local"
string blkgtr " >"
string blkqmk " ?"

if (clower(wait) != WAIT)
  return(ERR)                           # no background processing yet
opnout = ERR
opnerr = ERR
outmod = ERR
call strcpy(image, mcrlin)
call fold(mcrlin)
if (equal(mcrlin, local) == YES)        # have a local command
  {
  call strcpy(args, mcrlin)
  mcr = YES
  spdesc(ARG_LENGTH) = 0
  spdesc(CMD_TYPE) = TS_DOL
  }
else
  {
  mcrlin(1) = ' '
  call strcpy(image, mcrlin(2))
  mcr = NO
  call strcpy(args, argbuf)
  outmod = gtmode(STDOUT)
  if (indexs(argbuf, blkgtr) == 0)      # no redirect, add it
    {
    if (filnfo(STDOUT, outfil, junk) == OK)
      {
      opnout = STDOUT
      call appred(STDOUT, '>', outfil, argbuf)
      }
    }
  i = indexs(argbuf, blkqmk)
  if (i != 0)
    {
    c = argbuf(i+2)
    if (c == ' ' | c == '@t' | c == EOS)
      i = 0
    }
  if (i == 0)                           # no redirect, add it
    {
    if (filnfo(ERROUT, errfil, junk) == OK)
      {
      opnerr = ERROUT
      call appred(ERROUT, '?', errfil, argbuf)
      }
    }
  spdesc(ARG_LENGTH) = length(argbuf)
  call getadr(spdesc(ARG_ADDRESS), argbuf)
  spdesc(CMD_TYPE) = TS_USE
  }
call upper(mcrlin)
spdesc(CMD_LENGTH) = length(mcrlin)
call getadr(spdesc(CMD_ADDRESS), mcrlin)
repeat
  {
  status = tcspwn(spdesc)
  switch (spdesc(CMD_TYPE))
    {
    case TS_DOL:        spdesc(CMD_TYPE) = TS_DOT
    case TS_DOT:        spdesc(CMD_TYPE) = TS_INS
    default:            mcr = NO
    }
  }
until (mcr == NO | status != ERR)
call sreset(opnout, outfil)
if (outmod != ERR)
  junk = stmode(STDOUT, outmod)
call sreset(opnerr, errfil)
if (status == EOF)
  status = CHILD_ABORTED
return(status)

end
