      SUBROUTINE SCALE2(VMAX,VMIN,SIZE,XMIND,DXD) 
 C 
 C     ORIGINAL PROGRAM BY C. E. COHN FOR THE SEL-840, MODIFIED 
 C     FOR THE PDP-11/34 BY J. MORMAN, SEPT., 1979. 
 C     MODIFIED BY P. MURPHY, FEB., 1981 FOR INCLUSION IN 
 C     THE FOURIER DATA ANALYSIS PROGRAM. 
 C 
 C     THIS SUBROUTINE CALCULATES SCALING FACTORS: XMIND AND DXD 
 C     REQUIRED TO SCALE DATA TO A MAXIMUM VALUE BETWEEN 0.0 AND 
 C     SIZE.  VARIABLES VMAX AND VMIN ARE THE EXTREMA OF THE DATA. 
 C     SCALING FACTORS ARE CHOSEN TO BE NIE NUMBERS. 
 C      
       REAL P(8) 
       DATA P/1.,2.,3.,4.,5.,6.,7.,8./ 
       R=VMAX-VMIN 
       RS = R/SIZE 
       IF(RS.EQ.0.0) RS=1.0 
       T = ALOG10 (RS) 
       IF (T) 11,12,13 
    11 JT = INT(T - 1.) 
       GO TO 14 
    12 JT = 0 
       GO TO 14 
    13 JT = T 
    14 H = RS/10.**JT 
       IF (H - 8.) 1,1,2 
     2 JT = JT + 1 
       H = H/10. 
     1 DO 3 I=1,8 
       IF (P(I) - H) 3,4,4 
     3 CONTINUE 
     4 DXD = P(I)*10.**JT 
       SD = SIZE*DXD 
       XM = (VMAX+VMIN - SD)/(2.*DXD) 
    15 XMIN = AINT(XM)*DXD 
       IF (VMIN - XMIND) 8,9,9 
     8 XM = XM - 1. 
       GO TO 15 
     9 IF (VMAX - XMIND - SD) 5,5,6 
     6 I = I + 1 
       IF (I - 8) 4,4,7 
     7 JT = JT + 1 
       H = H/10. 
       GO TO 1 
 5     RETURN 
       END 
