C     SUBROUTINE SCALE(X,N,S,XMIN,DX) TO SCALE ARBITRARY 
 C     VARIABLES TO UNITS OF INCHES WHICH CAN BE PLOTTED 
 C     USING SUBROUTINE PLOT. 
 C 
 C     MEMBER OF LIBRARY "PLTLIB", ADDED OCT., 1979 
 C 
 C     ORIGINAL PROGRAM BY C. E. COHN FOR THE SEL-840, MODIFIED 
 C     FOR THE PDP-11/34 BY J. MORMAN, SEPT., 1979. 
 C      
 C     THE ROUTINE IS USED BY THE STATEMENT     
 C                    CALL SCALE (X,N,S,XMIN,DX) 
 C     WHERE X IS THE NAME OF THE REAL ARRAY TO BE SCALED, 
 C     CONTAINING N MEMBERS. S IS THE RANGE OF THE PLOT IN 
 C     INCHES.  XMIN AND DX ARE QUANTITIES CALCULATED BY THE 
 C     SUBROUTINE -- XMIN IS THE VALUE OF X ASSOCIATED  WITH 
 C     THE ORIGIN OF THE GRAPH  AND  DX IS THE INCREMENT IN 
 C     X PER INCH OF THE GRAPH. 
 C 
 C     ***  AFTER EXIT FROM SCALE, THE ARRAY X HAS EACH ELEMENT 
 C     ***  REPLACED BY ITS COORDINATE IN INCHES.  IF THE ORIGINAL 
 C     ***  VALUES ARE NEEDED THEY MUST BE SAVED ELSEWHERE. 
 C 
       SUBROUTINE SCALE (X,N,S,XMIN,DX) 
       DIMENSION X(N),P(8) 
      DATA P/1.,2.,3.,4.,5.,6.,7.,8./ 
       B = X(1) 
       A = B 
       DO 10 I=2,N 
       T = X(I) 
       A = AMIN1 (A,T) 
    10 B = AMAX1 (B,T) 
       R = B - A 
       RS = R/S 
       T = ALOG10 (RS) 
       IF (T) 11,12,13 
    11 JT = INT(T - 1.) 
       GO TO 14 
    12 JT = 0. 
       GO TO 14 
    13 JT = T 
    14 H = RS/10.**JT 
       IF (H - 8.) 1,1,2 
     2 JT = JT + 1 
       H = H/10. 
     1 DO 3 I=1,8 
       IF (P(I) - H) 3,4,4 
     3 CONTINUE 
     4 DX = P(I)*10.**JT 
       SD = S*DX 
       XM = (B +A - SD)/(2.*DX) 
    15 XMIN = AINT(XM)*DX 
       IF (A - XMIN) 8,9,9 
     8 XM = XM - 1. 
       GO TO 15 
     9 IF (B - XMIN - SD) 5,5,6 
     6 I = I + 1 
       IF (I - 8) 4,4,7 
     7 JT = JT + 1 
       H = H/10. 
       GO TO 1 
     5 DO 20 I=1,N 
    20 X(I) = (X(I) - XMIN)/DX 
       RETURN 
       END 
