@Make(text)
@Style<Justification On, Hyphenation On, WidestBlank 1.4, Spacing 1,
        Spread 1, Indent 0, HyphenBreak Off, SingleSided>
@Define<Q,FaceCode R>
@Case<Device,
 Diablo="@TypeWheel(Titan 10)",
 Imprint10="@Style<FontFamily SmallRoman10,Spacing 1.4,SingleSided>",
 X9700="@Style<FontFamily Univers10>@define<Q,FaceCode U>"
 >
@Modify<Format,Above 1,Below 1>
@Define<Header,Above 1.5,Below 1,Use B>

@Heading(Columbia University Center for Computing Activities)
@MajorHeading(THE KERMIT FILE TRANSFER PROTOCOL)

@center(@i<January 1984>)
@blankspace(1.3)
KERMIT is a protocol for transferring sequential files between computers of all
sizes over ordinary asynchronous telecommunication lines using packets,
checksums, and retransmission to promote data integrity.  KERMIT is
non-@|proprietary, thoroughly documented, well tested, and in wide use.  The
protocol and the original implementations were developed at Columbia University
and have been shared with many other institutions, some of which have made
significant contributions of their own.

@header(KERMIT Implementations)

KERMIT is presently available for the following systems, with others under
development:
@begin<format,leftmargin +4>
@tabclear()@tabset(2.0inches,4.0inches)
@u<Machine>       @\@ux<Operating System> @\@u<Language>
DECsystem-10      @\TOPS-10       @\MACRO-10
DECSYSTEM-20      @\TOPS-20       @\MACRO-20
IBM 370 Series    @\VM/CMS, MTS   @\IBM Assembler, Pascal
CDC Cyber 170     @\NOS           @\Fortran-77
Univac-100        @\EXEC          @\EXEC Assembler
Honeywell         @\MULTICS       @\PL/I
VAX-11            @\VMS           @\Bliss-32, Macro-32
VAX,PDP-11,SUN,etc@\UNIX          @\C
Terak, HP-98xx    @\UCSD p-System @\UCSD Pascal, Macro-11
PDP-11            @\RT-11         @\OMSI Pascal
8080, 8085, or Z80@\CP/M-80       @\DR ASM
8086, 8088        @\PC DOS, MS DOS@\MS MASM-86
8086, 8088        @\CP/M-86       @\DR ASM86
Apple II 6502     @\Apple DOS     @\DEC-10/20 CROSS
@end<format>
The @b[8080 version] runs on the DEC VT180 ``Robin'', DEC Rainbow-100, DECmate
II (CP/M), Heath/@|Zenith-89 and 100, Intertec Superbrain, Apple II with Z80
Softcard, TRS-80 II (CP/M), Osborne 1, Osborne Executive, Kaypro II, Vector
Graphics, Ohio Scientific, Telcon Zorba, and others.  The @b[8086 MS DOS
version] runs on the IBM PC and lookalikes (such as the Compaq portable), 
the Heath/@|Zenith-100, and the Victor 9000.  The @b[8086 CP/M-86 version]
runs on the DEC Rainbow-100 and the NEC APC.

@Header(KERMIT Distribution Policy)

The KERMIT software is free and available to all.  Columbia University,
however, cannot afford to distribute free software on the scale required
for KERMIT.  Therefore, to defray our costs for media, printing, postage,
labor, and computing resources, we must request a moderate distribution fee
from sites that request KERMIT directly from Columbia.  The schedule is as
follows:
@begin<format,group,LeftMargin +4>
@tabclear()@tabset(4.0inches)
Complete KERMIT Distribution@\$100@t<.>00
   @i<(Tape, Users Guide, and Protocol Manual)>
@blankspace(0.5)
Printed Documents@\$5@t<.>00 each
   @i<(Users Guide, Protocol Manual, or Any Source Listing)>
@end<format>
The @i[Users Guide] contains complete instructions for installing and using
each implementation of KERMIT.  The @i[Protocol Manual] is a guide for writing
a new implementation of KERMIT, and includes a source listing in the C
language.

Other sites remain free to redistribute KERMIT on their own terms, and are
encouraged to do so, with the following stipulations: KERMIT should not be sold
for profit; credit should be given where it is due; and new material should be
sent back to Columbia University at the address below so that we can maintain a
definitive and comprehensive set of KERMIT implementations for further
distribution.

@begin<text,need 8>
@blankspace(1)
To order KERMIT from Columbia University, send a letter requesting either:
@begin<description,above 1,below 1,leftmargin +6,indent -5>
(a)@\The manuals or source listings you desire (specify each one), @i<or>

(b)@\A 9-track magnetic tape in one of the following formats:
@begin<format,group>
@tabclear()@tabset(1.75inches,5.0inches)
@u<System>  @\@ux<Tape Format>               @\@u<Densities>
TOPS-10     @\BACKUP/Interchange, Unlabeled  @\ 800, 1600
TOPS-20     @\DUMPER, Unlabeled              @\ 800, 1600
IBM VM/CMS  @\EBCDIC, CMS Format             @\1600, 6250
            @\   @i<or> EBCDIC, OS Standard Label@\1600, 6250
@i<Other>   @\ASCII, ANSI Label, Format ``D''@\ 800, 1600
@end<format>
(Specify system, format, and density.)
One copy of each manual will be included with the tape.  We will supply the
tape, packaging, and postage.
@end<description>
@end<text>
We can only make tapes in the formats listed above.  @ux<We cannot produce
floppy disks>; bootstrapping procedures are provided to allow the microcomputer
versions to be downloaded from the mainframe for which the tape is produced.
The tape includes all source programs, documentation, and, when practical,
binaries or hex.  Unfortunately, our limited resources to not allow us to
provide automatic updates to KERMIT recipients when new implementations,
documentation, or bug fixes appear.

Send your letter to:
@begin<format,LeftMargin +2>
KERMIT Distribution
Columbia University Center for Computing Activities  <- @i<Make check payable to>
7th Floor, Watson Laboratory
612 West 115th Street
New York, N.Y.  10025
@end<format>
Please list the machines and operating systems you expect to run KERMIT on,
specify the tape format or the listings desired, and mention whether there are
additional systems for which you require KERMIT or if you might be interested
in attempting your own implementation for a new system.

KERMIT is also available to users of the BITNET network via a server
at host CUVMA.  BITNET users may type ``SMSG RSCS MSG CUVMA KERMSRV HELP'' for
further information.  
KERMIT is also available to users of ARPANET, via anonymous FTP from host
COLUMBIA-20, in the area @q(PS:<KERMIT>).

@begin(i)
No warranty of the software nor of the accuracy of the documentation
surrounding it is expressed or implied, and neither the authors nor Columbia
University acknowledge any liability resulting from program or documentation
errors.
@end(i)
