@make(vmappendix)
@comment(this is the WILD appendix, by Carl Kass, Dec 13, 1980)
@comment<Copyright (C) 1980 Columbia University>
@case<device,diablo="@Typewheel(pica)">
@appendixname(name="WILD subroutine")
@introduction
The WILD subroutine is an assembler language subroutine which is PL/I
callable as well as assembler callable.  It compares two varying
length strings with wild card matching.  
@cmssyntax
The subroutine may be declared either with two or three parameters
from PL/I as follows:

@begin(example,group)
DECLARE WILD ENTRY(CHAR(*) VAR,CHAR(*) VAR[,CHAR(2)])
    EXTERNAL OPTIONS(ASSEMBLER,INTER,RETCODE);
@end(example)

and called as follows:
@begin(example,group)
CALL WILD(pattern,source[,wildcards]);
@end(example)
where "pattern" and "source" are character(*) varying and "wildcards"
is character(2). "pattern" and "source" need not be the same length.
"pattern" represents the pattern string, whereas "source" is the
string to be tested for matching the patten. "wildcard", if specified,
represents the two wildcard characters. The first of the two
characters is a symbol which may appear in the pattern string but not
the source string which will match any number of any characters
(SNOBOL's ARB pattern). It is the calling program's responsibility to
ensure that the first wildcard character does not appear in the source
string.  The second wildcard character which may appear in the pattern
and/or the source string will match any single character in the source
string (SNOBOL's LEN(1)). If only two strings are passed, then the
wildcard characters default to "*" for ARB and "%" for LEN(1).

To call WILD from assembler, use the standard OS calling conventions.
The format of the source and pattern strings is as follows:

@begin(verbatim)
                 +----------+--------------------+
                 |          |                    |
                 +----------+--------------------+
                    length          text
@end(verbatim)

where the length field is a binary halfword containing the length of
the text field. The wildcard string is simply a two byte string (CL2).
If no wildcard string is to be passed to WILD, then the first byte of
the second word of the parameter address block (PAB) must be X'80'.

If the strings match, then WILD will set a return code of 0 whereas if
they don't match the return code will be set to 8.  From PL/I this
value may be examined through the PLIRETV builtin function, from
assembler register 15 will contain the return code.

Note:
PLIRETV should be declared as follows:
@begin(example)
DECLARE PLIRETV BUILTIN;
@end(example)
and then used as any normal builtin function having no arguements (see
example below).
@cmsexamples
This is an example of calling WILD from a PL/I program passing it
three parameters:
@begin(example,group)
/* S1 IS THE PATTERN AND S2 IS THE SOURCE */
DECLARE (S1,S2) CHAR(72) VARYING;
/*  $ IS ARB AND  & IS LEN(1)   */
DECLARE WILDCHARS CHAR(2) STATIC INITIAL('$&'); 
DECLARE WILD ENTRY(CHAR(*) VAR,CHAR(*) VAR,CHAR(2))
     EXTERNAL OPTIONS(ASSEMBLER,RETCODE,INTER);
DECLARE PLIRETV BUILTIN;
     .
     .
     .
CALL WILD(S1,S2,WILDCHARS);
IF PLIRETV=8 THEN GOTO NOMATCH;
             ELSE GOTO MATCH;
@end(example)
@drawline
This example illustrates calling WILD from assembler using the default
wildcard characters:
@begin(example,group)
        L       15,=V(WILD)     POINT AT SUBROUTINE
        LA      1,PAB           POINT AT PAB TO PASS
        BALR    14,15           DO CALL
* THE RETURN IS TO HERE
        LTR     15,15           IS THE RETURN CODE 0?
        BZ      MATCH           IF SO THEN GOTO MATCH
        B       NOMATCH         OTHERWISE GOTO NOMTACH
         .
         .
         .
PAB     DS      0F           FULLWORD ALIGN THE PAB
        DC      A(PATTERN)   ADDRESS OF PATTERN STRING
        DC      X'80'        FLAG INDICATING ONLY 2 PARMS
        DC      AL3(SOURCE)  ADDRESS OF SOURCE STRING
         .
         .
         .
PATTERN DS      H           FILL IN LENGTH OF PATTERN
        DS      CL80        ANY LENGTH FOR PATTERN STRING
SOURCE  DS      H           FILL IN LENGTH OF SOURCE
        DS      CL90        ANY LENGTH FOR SOURCE STRING
@end(example)
@vs1syntax
@na
@vs1examples
@na
@additionalinfo
WILD runs extremely quickly and may be freely used to compare two
strings.
@references
@na
