@make(vmappendix)
@case(device,x9700="@font(univers 10)")
@comment(revised 3/31/82)
@comment{ Kermit-CMS appendix  By Daphne}
@modify<quotation,indentation 0, above 1, below 1>
@Define<Q,FaceCode r>
@appendixname(name="Kermit-CMS")
@Introduction
KERMIT is a set of programs that transfer files between computers over
normal terminal communication lines.  It implements the "@u<K>L10
@u<E>rror-@|Free @u<R>eciprocol @u<M>icrocomputer @u<I>nterchange over
@u<T>TY-@|Lines" protocol.  Originally designed to be used between a
microcomputer and the DEC-20, the protocol will also transfer files to
and from a microcomputer and the IBM 4341 systems running under VM/CMS.

KERMIT transfers data by creating packets with information regarding
the type of packet being sent, it's length, a packet number, and a 
checksum to determine whether the data has been modified during
transmission.  If a packet is lost or garbled, KERMIT will attempt
to resend it.  

@b<You must be using an ASCII terminal to run Kermit-CMS.>

Please note that this document should be used in conjunction with 
the Kermit manual, and assumes you have read the sections pertaining 
to the SuperBrain microcomputer.  For more information regarding the
manual, see the Reference Section at the end of this report.   
@CMSSyntax
@begin(verbatim)
@drawline

KERMIT  [ options ]
@end(verbatim)
@drawline
@begin(verbatim)

Alternatively, you can simply type a carriage return after issuing the 
KERMIT command.

options:
@tabset(1in,1.75in)

@\Send

@\Receive

@\Set

@\Show

@\Status

@\CMS

@\CP

@\Help

@\Exit

@\Quit

@\?
@drawline
@end(verbatim) 

@subsection(CMS KERMIT Command Options)
@begin(description) 

SEND FN FT [FM]@\Send the specified file(s), using * or % as the
wildcard characters (* will match any number of characters while %
matches only one).  Kermit-CMS assumes the file is located on the A
disk, and sets the filemode to A1.  If, however, the file is located
on a different disk, the filemode must be cited.  Also, note that if
you use * for the filemode, Kermit-CMS will send only the first file
that matches.  Examples:
@begin<quotation>
 The command @q<SEND CEN SPSS> will send CEN SPSS A1.  To send the same
file located on your B disk, you must specify: @q<SEND CEN SPSS B>.
@q<SEND * FORTRAN> will send all fortran files on your A disk.
@q<SEND ABC% EXEC> will send all exec files with a four letter filename 
beginning with ABC.
If you have the file PLOT SAS on your A disk and your B disk, 
@q<SEND PLOT SAS *> will send PLOT SAS A1.
@end<quotation>

RECEIVE [FN FT [FM]]@\ Receive the file(s) sent from the micro.  If a
file specification is not included, Kermit-CMS will use the name(s)
specified by the remote host.  Use the file specification to indicate
a different filename or a disk other than the A disk (in this case,
the file name and type must also be supplied or = = FM can be used.)
Examples:
@begin<Quotation>
 To receive files using the filename(s) sent by the micro, use:
@q<RECEIVE>.  To save the file under a different name, specify:
@q<RECEIVE ABC FORTRAN>.  To save the file under the same name but on the
B disk, specify: @q<RECEIVE ABC FORTRAN B>, or @q<RECEIVE = = B>.
@End<Quotation>

SET <parameter> <value>@\ Set the parameter to the specified value.
Legal Set commands are:
@begin<description,leftmargin +8,indent -8>
@index[RECFM]
RECFM <c>@\Denotes the record format to be used when creating the
file.  Only fixed and variable length records are allowed, where
variable is the default.  Indicate the desired record format by either
an F or a V.

LRECL <d>@\Indicates the logical record length.  The default is set
to 80, and the maximum allowed is 133.

QUOTE <c>@\The quote character you wish to use in place of the
default (#).  It must be a single, printable character from among the
following: 33-62, 96, or 123-126 (decimal).

END <d>@\Indicates the end-of-line character you choose to send.  The
default is a CR (ASCII 13), but can be set to any two digit number
between 00 and 31 (dec).

PAC <d>@\Allows the user to specify the packet size the micro should
use when sending to Kermit-CMS.  The range is 26-94 (decimal), where
94 is the default.
@end<description>

SHOW <parameter>@\Displays the current value of any variable that can
be changed via the SET command.

STATUS@\Returns the status of the previous execution of Kermit-CMS.
Therefore, STATUS will either display the message "Kermit completed
successfully", or the last error encountered prior to aborting.

CMS@\Issues a CMS command from within Kermit-CMS.

CP@\Issues a CP command from within Kermit-CMS.

HELP@\Displays a message that briefly explains Kermit-CMS commands.

EXIT@\from Kermit-CMS.

QUIT@\Same as EXIT. 

?@\Lists all legal Kermit-CMS commands.
@end(description)
@CMSexamples

Here is a brief example of how to use the SuperBrain in conjunction
with Kermit-CMS to send a file to the SuperBrain.

@Begin<ProgramExample>

B>A:kermit

Kermit-80>set loc on		; Indicate half duplex
Kermit-80>set ibm on		; Cause line turn around wait
Kermit-80>set baud

   [ Kermit-80 will list 15 baud rates - choose the appropriate one ] 

Kermit-80>connect

   [ The micro will act as a regular terminal from now on.] 
   [ Login here as you normally would, and run Kermit-CMS.]

kermit 
KERMIT-CMS>? 
Legal Commands are: 
Receive, Send, Help, Exit, Quit, Set, Status, Show, CMS, CP
KERMIT-CMS>send finger database		; Send this file
^]C					; Return to the micro 
				        ; by typing <escape>]C 

Kermit-80>
Kermit-80>receive			; Micro receives the file

    [the file is sent .......]

Kermit-80>connect

KERMIT-CMS>status 
Kermit completed successfully
KERMIT-CMS>ex 
R; 

.logoff
CONNECT= 00:00:52 VIRTCPU= 000:00.42 TOTCPU= 000:01.21
LOGOFF AT 17:13:20 EST WEDNESDAY 03/31/82
^]C

Kermit-80>exit
B>
@End<ProgramExample>

In order to send a file from the SuperBrain to the 4341 repeat the
above procedure swapping the command @q<SEND> with @q<RECEIVE> and
vice versa.

@VS1Syntax
Not applicable
@VS1Examples
Not applicable
@Additionalinfo

@begin<enumerate>
The commands are supplied with a help option, so a question mark can
be typed to get the appropriate format or a list of options.  The
question mark, however, must be followed by a carriage return;
Kermit-CMS will respond and display the prompt again.  For instance,
@q<SET ?> will list all valid options for the SET command.

When receiving files, if the record format is fixed, any record longer
than the logical record length will be truncated.  If the record format
is variable, the record length can be as high as 133.  For sending
files, the maximum record length is 133.

Before connecting to the 4341, three flags must be set.  You should
set the IBM flag on, set the LOCAL-ECHO flag on (used to indicate half
duplex), and specify the baud rate you will be using.  To turn a flag
on, type to the micro's prompt "Set XXX On" where XXX is the flag
name.  Indicate the baud rate by typing "Set baud", and choose from
among a list the SuperBrain supplies.  These flags will remain in
effect as long as you do not exit from the micro's version of Kermit.
See the example of a session for further clarification.

Note that "(" and ")" act as word separators on the input line.
Therefore, if you try to set the quote character to "(*" or "*(", for
example, only the first character will be used.

The current version of Kermit-CMS does not support timeouts.  The
user, therefore, should hit the carriage return key after a long
period of inactivity (that is, when the screen display does not
change.)

Since the micro does not send an error packet when it aborts,
Kermit-CMS does not know the micro has stopped sending it information.
Therefore, when you connect back to the IBM, Kermit-CMS may still be
sending packets (they will appear on the screen).  The user must hit a
carriage return until Kermit-CMS has sent the maximum number of
packets allowed and aborts.  The error message, however, will not
indicate that communication stopped because the micro aborted, but
rather that no start of header character was found.

The minimum send packet size Kermit-CMS will allow is 26.  This is
necessary to avoid an error while sending the filename or an error
packet.  If the micro tries to set the value to be less than 26,
Kermit-CMS will immediately abort with an error of "Bad send-packet
size."  

During the initialization process with the micro, Kermit-CMS sends 
all six pieces of information (that is, the receive packet size, the
timeout data, the number of padding characters, the character used
for  padding, the line terminator, and the quote character.)  When
receiving this data from the micro, Kermit-CMS ignores the data
regarding timeouts and padding; they do not effect the program's
execution.  Therefore, if the quote and end-of-line characters used
are the defaults, the micro need only send Kermit-CMS its buffer 
size.  Only if the defaults are not used must ALL the information
be sent (since the data is organized positionally).  If, however,
the micro sends all the information even when not required, Kermit-CMS
will simply ignore the irrelevant portion.

When sending packets to Kermit-CMS, the micro must use a carriage 
return as the end-of-line character.   CMS requires a carriage
return to terminate a read from the terminal; thus, if any other 
character is used, Kermit-CMS will never get the packets. 

While the COMTEN translates all incoming characters to EBCDIC,
Kermit-CMS translates the data it reads back to ASCII (characters 
not representable in ASCII are replaced by a null).  Not only
is it easier to work with ASCII characters, but it makes things
more consistent throughout the many versions of Kermit.  When the
packets are sent to the micro, Kermit-CMS converts all data back
to EBCDIC.  The ASCII to EBCDIC translation table can be found in
Appendix V of the Kermit manual.  
@end<enumerate>

@subsection(Error Messages)
Kermit-CMS supplies the micro and the user with numerous error
messages.  If the execution must be aborted, an error packet is
sent to the micro before Kermit-CMS stops.  The same message can
be retrieved via the STATUS command when Kermit-CMS returns and 
displays the prompt.  If Kermit-CMS aborted because the maximum
amount of retries was exceeded (20 on initialization packets and 5 on
others), the error message will display the most recent error
(i.e. - the last NAK Kermit-CMS encountered).  If execution stops
because the micro aborted, the error message will convey that to
the user, but it is the micro's responsibility to pinpoint the
error.  The messages Kermit-CMS gives are as follows :

@begin<enumerate>
@begin<description,leftmargin +8,indent -8>
"Bad send-packet size"@\ Sent when the micro attempts to set its
receive buffer size to a value that is less than 26 (the minimum that
Kermit-CMS will accept) or larger than 94, the maximum.  It will also
occur if Kermit-CMS tries to send a packet that is larger than the
maximum specified.

"Bad message number"@\ If the packet number is less than zero or
greater than 63 (at which point it should "wrap around" back to zero).

"Illegal packet type"@\ This message is returned if the packet type
does not fall between A-Z.

"Unrecognized State"@\ If Kermit-CMS is in a state not previously
defined by the protocol, it will abort with this message.

"No SOH encountered"@\ This error arises if Kermit-CMS reads the
entire packet without encountering an SOH character (^A.)  The result
is that it sends a NAK to the micro, and marks this error as the most
recent one.

"Bad Checksum"@\ If the checksum calculated by Kermit-CMS does not
match the one sent by the micro, Kermit-CMS NAK's the packet and flags
this error.

"Bad character count"@\ This error is set if Kermit-CMS receives a
packet whose size is illegal (that is, if the size parameter was
garbled during transmission of the packet.)

"Micro sent a NAK"@\ Keep track of who rejected the packet.

"Lost a packet"@\ When a packet is received and the sequence number is
different from the number Kermit-CMS expected, the packet is NAK'ed.

"Micro aborted"@\ Tells you that the micro aborted unexpectedly.

"Illegal file name"@\ When receiving the name of the file from the
micro, Kermit-CMS expects it to be in the format 'filename.filetype'.
If the filename, filetype, or dot is missing, Kermit-CMS will reject
(NAK) the packet.  Also, if either the filename or filetype exceeds
eight characters, it will be truncated.

"Invalid lrecl"@\ Kermit-CMS will abort on any file-system error it
encounters when reading from the file it is to send.  It can only send
files with variable or fixed length record formats, therefore, Wylbur
Edit or Packed format files will cause an error.

"Permanent I/O error"@\ This signifies a permanent I/O error that
occured when reading from an existing file.  Execution is aborted
immediately.

"Disk is read-only"@\ This error arises when there is an attempt to
write on a read-@|only disk.

"Recfm conflict"@\ If a filename conflict arises, Kermit-CMS will
append the received file to the existing one, provided the record
formats of the two are the same.  Otherwise, this error will cause a
halt of the execution.

"Disk is full"@\ Refers to any error regarding limitations on a user's
storage space.  Most likely, it signifies that the receiving disk is
full, but the error can also mean that the maximum number of files
allowed has been reached, or virtual storage capacity has been
exceeded, and so on.

"Err allocating space"@\ Kermit-CMS keeps a table of all files it has sent
to the micro, allocating extra space if more than ten files are sent at one
time.  If there is an error obtaining more space, Kermit-CMS will abort with
this message.  
@End<Description>
@End<Enumerate>

@references
For a more detailed explanation of Kermit or information regarding the 
Superbrain, consult the Kermit manual, @u<Kermit Users Guide and
Specification>.  The manual is available in the Reference Library,
Room 109 Computer Center for $3.50.


