
/* Definitions for FMS-11/RSX V1.0 Form Driver

   These are all defined as globals in the form driver source
   code, FDV.MAC.  MACRO programs and the high level language
   interface let the task builder resolve all offsets and
   error codes.

*/

typedef struct
{ int *sts;
  int chn;
  char *imp;
 } FDV_REQ;

typedef struct
{ int fnc;
  FDV_REQ *req;
  char *nam; int num;
  int trm;
  char *val; int len;
 } FDV_ARG;

#define	FT_NTR	0
#define	FT_NXT	1
#define	FT_PRV	2
#define	FT_ATB	3
#define	FT_XBK	4
#define	FT_XFW	5
#define	FT_SNX	6
#define	FT_SPR	7
#define	FT_SFW	8
#define	FT_SBK	9
#define	FT_KPD	0154

#define	FS_SUC	1
#define	FS_INC	2

#define	FE_FCD	-1
#define	FE_IMP	-2
#define	FE_FSP	-3
#define	FE_IOL	-4
#define	FE_FLB	-5
#define	FE_ICH	-6
#define	FE_FCH	-7
#define	FE_FRM	-8
#define	FE_FNM	-9
#define	FE_LIN	-10
#define	FE_FLD	-11
#define	FE_NOF	-12
#define	FE_DSP	-13
#define	FE_NSC	-14
#define	FE_DNM	-15
#define	FE_DLN	-16
#define	FE_UTR	-17
#define	FE_IOR	-18
#define	FE_IFN	-19
#define	FE_ARG	-20
#define	FE_INI	-21
#define	FE_STR	-22

#define CLEAR fdvpal (0, 0)

/* display a literal string */

#define LASTLINE(msg) fdvlst (msg, sizeof (msg) - 1)
#define SHOWSTAT(msg) fdvput ("STSMSG", 0, msg, sizeof (msg) -1)

/* Whitesmiths decode definitions */

#define LSTLIN_D fdvlst (&msgbuf, decode (&msgbuf, sizeof (msgbuf),
#define SHOSTS_D fdvput ("STSMSG", 0, \
  &msgbuf, decode (&msgbuf, sizeof (msgbuf),

/* Unix sprintf definitions */

#define LSTLIN_S fdvlst (&msgbuf, sprintf (&msgbuf,
#define SHOSTS_S fdvput ("STSMSG", 0, &msgbuf, sprintf (&msgbuf,

/* RSX $EDMSG definitions */

#define LSTLIN_E fdvlst (&msgbuf, edmsg (&msgbuf,
#define SHOSTS_E fdvput ("STSMSG", 0, &msgbuf, edmsg (&msgbuf,
