typedef struct
{ BYTES len;		/* length in bytes of buffer */
  char *buf;		/* its address */
 } BUF_DESC;

typedef struct
{ TINY sts;		/* I/O status */
  TEXT term;		/* terminator char for terminal input */
  BYTES bytes;		/* number of bytes transferred */
 } IOSB;

typedef struct
{ unsigned fid[3];	/* file ID = number, sequence, 0 */
  unsigned fnam[3], ftyp; /* file name and type in .RAD50 */
  int fver;		/* version number in binary */
  BITS stat, next;	/* status word, context for next _find */
  unsigned did[3];	/* file ID of directory file */
  unsigned dvnm;	/* device name as two ASCII chars */
  unsigned unit;	/* device unit number in binary */
 } FNB;

typedef struct
{ UTINY rtyp, ratt;	/* record type, attributes */
  BYTES rsiz;		/* record size if fixed, largest if variable */
  LONG hibk, efbk;	/* highest block allocated, highest block used */
  BYTES ffby;		/* 1st free byte in last block or magtape max block */
  UTINY racc, rctl;	/* record access and device characteristics */
  BUF_DESC urbd;	/* user record buffer descriptor */
  BUF_DESC nrbd;	/* next record buffer descriptor */
  BYTES ovbs;		/* override block buffer size */
  BYTES eobb;		/* end of block buffer */
  COUNT cntg;		/* initial allocation (> 0 for contiguous) */
  int *stbk;		/* statistics block */
  COUNT aloc;		/* blocks to extend (> 0 for contiguous) */
  UTINY lun, facc;	/* logical unit number, file access bits */
  BUF_DESC *dspt;	/* dataset descriptor pointer */
  FNB *dfnb;		/* default filename block */
  TINY efn;		/* I/O event flag */
  TINY bkp1;		/* FCS bookkeeping */
  TINY err, err1;	/* error code, err1 = 0 for FCS, = -1 for RSX */
  TINY mbct, mbc1;	/* number of buffers to be used, currently in use */
  TINY mbfg;		/* mult buf flag = 1 (FD_RAH) or 2 (FD_WBH) */
  TINY bgbc;		/* big buffer block count in blocks (not implemented) */
  BYTES vbsz, bbfs;	/* device buffer size, block buffer size */
  LONG vbn;		/* virtual block number */
  char *bdb;		/* block buffer descriptor block (NZ if open) */
  unsigned spdv;	/* spooler device name as two ASCII chars (IAS) */
  UTINY spun;		/* spooler unit number in binary (IAS) */
  char chr;		/* reserved for system use */
  unsigned actl;	/* low byte no. of retrieval pointers, high bits */
  unsigned seqn;	/* sequence number of sequenced record */
  FNB fnb;		/* filename block */
 } FDB;

typedef struct
{ UTINY rtyp, ratt;	/* record type, attributes */
  BYTES rsiz;		/* record size if fixed, largest if variable */
  LONG hibk, efbk;	/* highest block allocated, highest block used */
  BYTES ffby;		/* 1st free byte in last block or magtape max block */
  UTINY racc, rctl;	/* record access and device characteristics */
  BUF_DESC bkds;	/* block buffer descriptor */
  IOSB *bkst;		/* I/O status block for block I/O */
  int *bkdn;		/* AST service routine */
  BYTES ovbs;		/* override block buffer size */
  BYTES eobb;		/* end of block buffer */
  COUNT cntg;		/* initial allocation (> 0 for contiguous) */
  int *stbk;		/* statistics block */
  COUNT aloc;		/* blocks to extend (> 0 for contiguous) */
  UTINY lun, facc;	/* logical unit number, file access bits */
  BUF_DESC *dspt;	/* dataset descriptor pointer */
  FNB *dfnb;		/* default filename block */
  TINY bkef;		/* I/O event flag */
  TINY bkp1;		/* FCS bookkeeping */
  TINY err, err1;	/* error code, err1 = 0 for FCS, = -1 for RSX */
  TINY mbct, mbc1;	/* number of buffers to be used, currently in use */
  TINY mbfg;		/* mult buf flag = 1 (FD_RAH) or 2 (FD_WBH) */
  TINY bgbc;		/* big buffer block count in blocks (not implemented) */
  BYTES vbsz, bbfs;	/* device buffer size, block buffer size */
  LONG bkvb;		/* virtual block number */
  char *bdb;		/* block buffer descriptor block (NZ if open) */
  unsigned spdv;	/* spooler device name as two ASCII chars (IAS) */
  UTINY spun;		/* spooler unit number in binary (IAS) */
  char chr;		/* reserved for system use */
  unsigned actl;	/* low byte no. of retrieval pointers, high bits */
  unsigned seqn;	/* sequence number of sequenced record */
  FNB fnb;		/* filename block */
 } FDB_RW;

/* The following are from the RSXMAC.SML macro FCSBT$ */

#define	FD_FTN	01
#define	FD_CR	02
#define	FD_PRN	04
#define	FD_BLK	010
#define	FD_RWM	01
#define	FD_RAN	02
#define	FD_PLC	04
#define	FD_INS	010
#define	FD_REC	01
#define	FD_CCL	02
#define	FD_TTY	04
#define	FD_DIR	010
#define	FD_SDI	020
#define	FD_SQD	040
#define	FD_ISP	02000
#define	FD_OSP	04000
#define	FD_PSE	010000
#define	FD_COM	020000
#define	FD_F11	040000
#define	FD_MNT	0100000
#define	NB_VER	01
#define	NB_TYP	02
#define	NB_NAM	04
#define	NB_SVR	010
#define	NB_STP	020
#define	NB_SNM	040
#define	NB_DIR	0100
#define	NB_DEV	0200
#define	NB_SD1	0400
#define	NB_SD2	01000
#define	R_FIX	01
#define	R_VAR	02
#define	R_SEQ	03
#define	FA_RD	01
#define	FA_WRT	02
#define	FA_EXT	04
#define	FA_CRE	010
#define	FA_TMP	020
#define	FA_SHR	040
#define	FA_APD	0100
#define	FA_NSP	0100
#define	FA_NSR	0200	/* set to inhibit auto upward dir search */
#define	FO_RD	FA_RD
#define	FO_WRT	FA_WRT|FA_EXT|FA_CRE
#define	FO_APD	FA_WRT|FA_EXT|FA_APD
#define	FO_MFY	FA_WRT
#define	FO_UPD	FA_WRT|FA_EXT
#define	FA_ENB	0100000
#define	FA_WCK	020000
#define	FA_SEQ	040000
#define	FA_DLK	01000
#define	FA_RWD	04000
#define	FA_POS	010000
#define	FA_EXC	02000
#define	CH_AND	01
#define	FD_RAH	01
#define	FD_WBH	02
#define	FF_RWD	01
#define	FF_POE	02
#define	FF_NV	03
#define	FF_SPC	04
#define	FF_CHR	05
#define	FF_RWF	06

typedef struct			/* GCML pushdown list */
{ int gcml_sav[8];
 } GCML_PDL;

typedef struct			/* GCML control block */
{ FDB fdb;			/* FDB for command file */
  TINY err, mode;		/* error status and mode */
  BUF_DESC psds;		/* prompt string descriptor */
  BUF_DESC cmld;		/* command line descriptor */
  TINY junk, maxd;		/* -1, maximum nesting depth */
  GCML_PDL *pdl;		/* pointer to pushdown list */
  char *buf;			/* pointer to buffer */
  char dprm[6];			/* default prompt string */
  FNB dfnb;			/* default command filename block */
  BYTES size;			/* size of buffer */
 } GCMLB;

#define GE_COM	1		/* ; begins comment line to be ignored */
#define GE_IND	2		/* @ means indirect */
#define GE_CLO	4		/* close file after every GCML$ */
#define GE_LC	010		/* do not translate to upper case */
#define GE_CON	020		/* trailing - continues on next line */
#define GE_SIZ	040		/* who knows? */
#define GE_IOR	-1		/* I/O error */
#define GE_OPR	-2		/* unable to open or reopen command file */
#define GE_BIF	-3		/* syntax error in name of indirect file */
#define GE_MDE	-4		/* maximum nesting depth exceeded */
#define GE_EOF	-10		/* EOF on first (unnested) command file */
#define GE_RBG	-40		/* input buffer overflow */

#define GCMLB_1(name,maxd0,pr1,pr2,pr3,ubuf,lun0,pdl0,size0,mode0) \
  static GCMLB name = \
{ R_VAR,0,0,0,0,0,0,FD_TTY|FD_REC|FD_CCL,0,0,0,0,0,0,0,0,0,lun0,0,0,\
  &name.dfnb,0,0,0,0,1,0,0,0, 0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\
  0,mode0,0,0,0,0,-1,maxd0,pdl0,ubuf,'\r','\n',pr1,pr2,pr3,'>',\
  0,0,0,012321,0,0,012314,0,0,0,0,0,0,0,0,size0}

#define GCML_(gclblk, adpr, lnpr) \
  ((gclblk)->psds.buf=adpr, (gclblk)->psds.len=lnpr, fcscal (&_gcml1, gclblk))

#define RCML_(gclblk) fcscal (&_gcml2, gclblk);

#define CCML_(gclblk) fcscal (&_gcml3, gclblk);

typedef struct
{ char typr;		/* request type (CS_INP or CS_OUT) */
  char stat;		/* status byte */
  BUF_DESC cmld;	/* command line descriptor */
  struct		/* dataset descriptor for FDB */
  { BUF_DESC devd;	/* device name ("XXnn:") */
    BUF_DESC dird;	/* directory string ("[ggg,mmm]") */
    BUF_DESC fild;	/* filename string */
   } dsds;
  unsigned *swad;	/* current switch table address */
  unsigned mkw1, mkw2;	/* mask words switches, polarities */
  BYTES idvl; char *idva; /* input last device name */
  BYTES odvl; char *odva; /* output last device name */
  BYTES idil; char *idia; /* input last directory name */
  BYTES odil; char *odia; /* output last directory name */
  char *istr, *ostr;	/* input, output next string section */
 } CSIBLK

#define	CS_INP	1	/* request type is input */
#define	CS_OUT	2	/* request type is output */
#define	CS_NMF	1	/* current filespec contains a filename */
#define	CS_DIF	2	/* current filespec contains a directory */
#define	CS_DVF	4	/* current filespec contains a device */
#define	CS_WLD	010	/* current filespec contains a wildcard */
#define	CS_MOR	020	/* current filespec is followed by a comma */
#define	CS_EQU	040	/* command has an '=' */

#define CSI_1(csblk, buff, length) \
  ((csblk)->cmld.buf = buff, (csblk)->cmld.len = length, fcscal (&_csi1, csblk))

#define CSI_2(csblk, io, swtab) \
  ((csblk)->typr = io, (csblk)->swad = swtab, fcscal (&_csi2, csblk))

#define CSI_SET 0	/* argument "csflg" for CSI_SW2 */
#define CSI_CLEAR 1	/* argument "csflg" for CSI_SW2 */
#define CSI_NEG 1	/* argument "nflg" for CSI_SW2 */
#define CSI_ASCII 1	/* argument "type" for CSI_SV */
#define CSI_NUMERIC 2	/* argument "type" for CSI_SV */
#define CSI_OCTAL 2	/* argument "type" for CSI_SV */
#define CSI_DECIMAL 3	/* argument "type" for CSI_SV */

#define CSI_SW2(sw, mk, mkw, csflg, nflg, vtab)\
  sw, mk, mkw + csflg, vtab + nflg

#define CSI_SV(type, adr, len) type + ((unsigned) len<<8), adr

#define CSI_ND 0
