P11INCLUD.MAC        
	.TITLE	INCLUDE
;
; CORRECTION	V6-29	1980-04-02	STD
	.IDENT	/PAS629/
;
	.MCALL	OPEN$R,FDOF$L,OFID$,CLOSE$
;
	FDOF$L
;
; OPEN ( VAR F: TEXT;  STRING NAM,DIR,DEV );
;
OPEN::	TST	(SS)+		; SKIP LINK
	MOV	12.(SS),AR	; FILE ID
	SUB	#FILESIZE,AR	; FDB
	CLOSE$	R0
	OPEN$R	R0,,SS
	ADD	#14.,SS
	RTS	PC
;
;
; SAVEFDB ( VAR FDB: TEXTFDB;  VAR : TEXT;  FN: STR20 );
;
SAVEFDB::
	TST	(SS)+		; SKIP LINK
	MOV	2(SS),R		; FILE ID
	MOV	F.URBD-FILESIZE+2(R),AD	; USER RECORD BUFFER
	MOV	2(R),AR		; NUMDER OF REMAINING CHARS
	MOV	@R,R		; CURRENT RECORD POINTER
1$:	MOVB	(R)+,(AD)+	; MOV BUFFER CONTENTS
	DEC	AR
	BGT	1$
	MOV	4(SS),R		; SAVE AREA
	MOV	2(SS),AD	; FILE ID
	MOV	AD,-(HP)	; SAVE FILE ID 
	MOV	F.URBD-FILESIZE+2(AD),@AD  ; NEW BUFFER
	CLR	-(SS)		; SAVEFDB
	BR	TRFR
;
;
; UNSAVEFDB ( VAR F: TEXT;  VAR FDB: TEXTFDB );
;
UNSAVEFDB::
	TST	(SS)+		; SKIP LINK
	MOV	(SS)+,AD	; SAVE AREA
	MOV	(SS),R		; FILE ID
	MOV	R,AR
	SUB	#FILESIZE,AR
	CMPB	F.ERR(AR),#-26.	; FILE NOT FOUND	; V6-29
	BEQ	1$					; V6-29
	CLOSE$	R0
	MOV	#TRUE,EOLNSTATUS(R)
1$:	MOV	#FALSE,EOFSTATUS(R)			; V6-29
TRFR:	SUB	#FILESIZE-F.FNB,AD
	SUB	#FILESIZE-F.FNB,R
	MOV	#15.,AR		; SIZE OF FILENAME BLOCK
1$:	MOV	(AD)+,(R)+	; SAVE FILE DESCR
	DEC	AR
	BGT	1$
	TST	(SS)+
	BEQ	9$		; SAVEFDB
	MOV	R,AR
	SUB	#96.,AR		; POINT TO FDB
	OFID$	R0
	MOV	R3,-(HP)
	MOV	(AD)+,R1
	MOV	(AD)+,R3
	MOV	(AD)+,R2
	CALL	.POINT
	MOV	F.NRBD+2(AR),AD
	MOV	-(AD),F.NRBD(AR)
	MOV	(HP)+,R3
	RTS	PC
9$:	MOV	R4,-(SS)
	MOV	R3,-(SS)
	MOV	R1,-(SS)
	MOV	AD,AR
	SUB	#96.,AR		; POINT TO FDB
	CALL	.MARK
	MOV	(SS)+,R4
	MOV	R1,(R4)+
	MOV	R3,(R4)+
	MOV	R2,(R4)+
	MOV	(SS)+,R3
	MOV	(SS)+,R4
	MOV	2(SS),R		; FILE ID
	MOV	@R,-(SS)	; POINTER TO NEXT CHAR
	DEC	@SS		; ARRAY [1..
	MOV	2(R),-(SS)	; LEN
	MOV	GP,-(SS)	; LINK
	CALL	NEWSOURCE
	MOV	@SS,AD		; SAVE AREA ADDRESS
	MOV	(HP)+,R		; FILE ID
	MOVB	F.ERR-FILESIZE(R),AR			; V6-29
	BGE	10$		; IF OK
	MOV	#1,EOFSTATUS(R)	; EOFSTATUS 		; V6-29
10$:	TST	(SS)+		; SKIP SAVE AREA ADDRESS
	RTS	PC
;
;
	.END
****
P11SELECT.MAC
	.TITLE	SELECTOR
SELECTOR::	; DUMMY PROCEDURE TO ALLOW HEAVIER OVERLAY STRUCTURE
	JMP	DOSELECTOR
	.END
****
P11SWITCH.MAC        
	.TITLE	P11SWITCH
	.PSECT	SWCHIN
;
VERSION::
	.WORD	600.	; VERSION 6.0
SWCHIN::
;
	.WORD	3	; /A3	DEFLEVEL
	.WORD	55.	; /P55	PAGEWIDTH
	.WORD	64.	; /L64	LINEWIDTH
	.WORD	0	; /E-	EXTSET
	.WORD	0	; /G-	FLTSET
	.WORD	0	; /F-	FPPUNIT
	.WORD	1	; /L+	LIST
	.WORD	0	; /C-	PRCODE
	.WORD	0	; /X-	CONDCOMP
	.WORD	1	; /W+	WARNINGS
	.WORD	1	; /R+	RUNTMCHECK
	.WORD	1	; /T+	HEAPCHECK
	.WORD	1	; /M+	MAIN
	.WORD	0	; /Y-	PSECTGEN
	.WORD	0	; /S-	TRACE
	.WORD	0	; /D-	DEBUG
	.WORD	0	; /Q-	FREQUENCE
;
;
SWITCHINIT::
	MOV	PC,R1
	CMP	(R5)+,-(R1)	; SKIP LINK AND MOV INSTR
	MOV	#18.,R0
1$:	MOV	-(R1),@(R5)+
	DEC	R0
	BGT	1$
	RTS	PC
;
	.END
****
RECURSEG.MAC         
	.LIST	TTM
	.TITLE	RECURSEG	RECURSIVE SEGMENT ALLOCATION
	.NLIST	BEX,SYM,TOC
	.PSECT	$$AUTP	; TO ASSURE ALLOCATION IMMEDIATELY
			; AFTER $$AUTO
;
;
; AT SEGMENT READ TIME ( CALL SUBR ) THE OLD SEGMENT ID
; IS SAVED AND THE NEW SEGMENT ID IS STACKED.
; THE TRANSFER TO THE SUBROUTINE IS CHANGED FROM RETURN 
; IN $SAVRG TO A CALL. THIS ASSURES THAT RETURN GIVES CONTROL
; TO THIS SEGMENT HANDLING ROUTINE. THE CURRENT SEGMENT ID
; CAN BE POPPED OFF THE STACK AND THE OLD SEGMENT IS BROUGHT
; INTO CORE.
;
; A BRANCH INSTRUCTION MUST BE PATCHED INTO THE $AUTO ROUTINE.
; $AUTO+34 := BR SEGENT
;
;
;
SEGENT:
	MOV	@R5,ENTRYP
	MOV	#SEGEXIT,12(SP)
	SUB	#2,SEGP		; POINTER IN SEGMENT ID STACK
	CMP	SEGP,#SEGP
	BEQ	99$
	MOV	R2,@SEGP	;POINTER TO SEGMENT DESCR TABLE
	JMP	$AUTO+40	; READ SEGMENTS. WHEN READY CONTROL
;				; IS TRANSFERRED TO SEGEXIT
99$:	CALLSS	WRERROR
	.BYTE	70.,1
;
;
SEGEXIT:
	CALL	@ENTRYP		; CALL THE WANTED ROUTINE.
;
; PASCAL NEVER USES TH@ R6 STACK, SO THE EXTRA RETURN ADDRESS
; DOESN'T DO ANY HARM.
;
	JSR	R5,$SAVRG
	MOV	R2,-(SP)	; NORMAL SEGMENT READ START
	ADD	#2,SEGP		; SKIP THE SEGMENT JUST USED
	MOV	@SEGP,R2	; READ IN THE OLD SEGMENTS
	BEQ	9$		; NO OLD SEG
	BIT	#10000,@R2	; SEGMENT ALREADY THERE ?
	BEQ	9$		; YES
	JMP	$AUTO+40
;
9$:	MOV	(SP)+,R2
	RTS	PC
;
	.PSECT	$SEGST
;
ENTRYP:	.WORD	0
SEGP:	.WORD	SEGSTND
SEGSTK:	.BLKW	100
SEGSTND:.WORD	0
;
;
	.END
****
P11WTT.MAC           
	.LIST	TTM
	.TITLE	P11WTT
	.NLIST	BEX,SYM,TOC
;
;	.PSECT ADDED TO ALLOW DATA TO BE PLACED IN ROOT
	.PSECT	WTTDAT, D, GBL		; MUST BE IN ROOT SEGMENT
BUFF:	.BLKB	132.
EOLN:	.WORD	FALSE
EOF:	.WORD	FALSE
IORES:	.WORD	1	;OK
FILETP:	.WORD	TEXT+TTY
TT:	.WORD	BUFF	; TTY^
CNT:	.WORD	132.
;
	.PSECT	PASRUN			; MAY BE PLACED IN OVERLAY SEGMENT
;
	.MCALL	QIO$S,WTSE$S
;
;
;
WTTINT::
	MOV	#TT,-(SS)	; WRITE( TTY, N:5 )
	MOV	4(SS),-(SS)
	MOV	#5,-(SS)
	CALLSS	WRI
	ADD	#4,SS
	RTS	PC
;
;
;
WTTERR::
	MOV	#TT,-(SS)	; WRITE( TTY,
	MOV	#ERRMESS,-(SS)	;     'ERROR IN LINE ',
	MOV	#14.,-(SS)
	MOV	@SS,-(SS)
	CALLSS	WRS
	MOV	4(SS),-(SS)	;     N:6'
	MOV	#6,-(SS)
	CALLSS	WRI
	MOV	#':,-(SS)	;     ':' ) ;
	MOV	#1,-(SS)
	CALLSS	WRCHA
	ADD	#4,SS
	RTS	PC
;
;
;
WTTEOL::
	MOV	#TT,-(SS)	; WRITELN( TTY ) ;
	CALLSS	PUTLN
	ADD	#2,SS
	RTS	PC
;
;
; PROC WTTHEAD( VAR HDR,DAY,TIM: ALFA );
;
WTTHEA::
	MOV	#TT,-(SS)	; WRITELN( TTY,
	MOV	#HEAD,-(SS)	;     'PASCAL  PDP-11  VERSION ',
	MOV	#24.,-(SS)
	MOV	@SS,-(SS)
	CALLSS	WRS
	MOV	8.(SS),-(SS)	;	HDR ) ;
	INC	@SS
	MOV	#10.,-(SS)
	MOV	@SS,-(SS)
	CALLSS	WRS
	CALLSS	PUTLN
	MOV	2(SS),@SS	;  
	CALLSS	TIME
	MOV	2(SS),-(SS)
	CALLSS	DATE
	MOV	#TT,-(SS)	; WRITELN(TTY,
	MOV	4(SS),-(SS)	;	DAY,
	INC	@SS
	MOV	#10.,-(SS)
	MOV	@SS,-(SS)
	CALLSS	WRS
	MOV	2(SS),-(SS)	;	TIM );
	INC	@SS
	MOV	#12.,-(SS)
	MOV	#8.,-(SS)
	CALLSS	WRS
	CALLSS	PUTLN
	CMP	(SS)+,(SS)+
	TST	(SS)+
	RTS	PC
;
;
;   PROCEDURE  WTTSTAT( E:BOOLEAN; P,D,DD,T: INTEGER ) ;
;
WTTSTAT::
	MOV	#TT,-(SS)	; WRITELN( TTY,
	TST	12.(SS)
	BEQ	1$
	MOV	#"**,ERRM2
1$:	MOV	#ERRM2,-(SS)	;     '** ERROR DETECTED' ) ;
	MOV	#17.,-(SS)
	MOV	@SS,-(SS)
	CALLSS	WRS
	CALLSS	PUTLN
	MOV	#TT,-(SS)	; WRITELN( TTY,
	MOV	#STAT1,-(SS)	;     'TOTAL PROGRAM SIZE: ',
	MOV	#28.,-(SS)
	MOV	@SS,-(SS)
	CALLSS	WRS
	MOV	10.(SS),-(SS)	;     P:7:O ) ;
	MOV	#7,-(SS)
	CALLSS	WROCT
	CALLSS	PUTLN
	MOV	#TT,-(SS)	; WRITELN( TTY,
	MOV	#STAT2,-(SS)	;     'OUTERMOST DATA SIZE: ',
	MOV	#28.,-(SS)
	MOV	@SS,-(SS)
	CALLSS	WRS
	MOV	6.(SS),-(SS)	;     DD:7:O ) ;
	MOV	#7,-(SS)
	CALLSS	WROCT
	CALLSS	PUTLN
	MOV	#TT,-(SS)	; WRITELN( TTY,
	MOV	#STAT3,-(SS)	;     'RESERVED STACK & HEAP SIZE: ',
	MOV	#28.,-(SS)
	MOV	@SS,-(SS)
	CALLSS	WRS
	MOV	8.(SS),-(SS)	;     D:7:O ) ;
	MOV	#7,-(SS)
	CALLSS	WROCT
	CALLSS	PUTLN
	MOV	#TT,-(SS)	; WRITELN( TTY,
	MOV	#RUNTM,-(SS)	;     'RUNTIME: ',
	MOV	#9.,-(SS)
	MOV	@SS,-(SS)
	CALLSS	WRS
	MOV	4(SS),-(SS)	;     T:8,
	BGE	2$
	ADD	#28800.,(SS)	; (* 8 HOUR WRAP AROUND *)
2$:	MOV	#8.,-(SS)
	CALLSS	WRI
	MOV	#SEC,-(SS)	;     '  SECONDS' ) ;
	MOV	#9.,-(SS)
	MOV	@SS,-(SS)
	CALLSS	WRS
	CALLSS	PUTLN
	ADD	#12.,SS
	RTS	PC
;
;
;   PROCEDURE RTT ( VAR LINE: LINEBUFF;  VAR LEN: INTEGER );
;
RTT::
	MOV	#TT,-(SS)	; WRITE( TTY,
	MOV	#PROMPT,-(SS)	;     'PAS>' );
	MOV	#4,-(SS)	;
	MOV	@SS,-(SS)
	CALLSS	WRS
	CALLSS	BRKLN		; BREAK;
	TST	-(SS)
	ADD	#1,6(SS)	;   (* ARRAY (.1..80.)  *)
	QIO$S	#IO.RVB,#5,#5,,SS,,<6(SS),#80.>
	WTSE$S	#5		; READLN;  READ(LINE);
	MOV	2(SS),@4(SS)
	CMPB	@SS,#IE.EOF
	BNE	9$
	CALLSS	EXITP
9$:	ADD	#8.,SS
	RTS	PC
;
;
;
	.ENABL	LC
ERRMESS: .ASCII	/ERROR IN LINE /
HEAD:	.ASCII	/PASCAL  PDP-11  VERSION /
PROMPT:	.ASCII	/PAS>/
	.EVEN
ERRM2:	.ASCII	/NO ERROR DETECTED/
STAT1:	.ASCII	/TOTAL PROGRAM SIZE:         /
STAT2:	.ASCII	/OUTERMOST DATA SIZE:        /
STAT3:	.ASCII	/RESERVED STACK & HEAP SIZE: /
RUNTM:	.ASCII	/RUNTIME: /
SEC:	.ASCII	/  SECONDS/
	.EVEN
;
;
	.END
****
P11ERRMES.MAC        
	.TITLE	ERRMES
;
	.MCALL	QIO$S,WTSE$S
;
ERRMES::MOV	2(R5),R2
	DEC	R2
	ASL	R2
	ASL	R2
	MOV	ERRTAB(R2),R1
	MOV	ERRTAB+2(R2),R0
2$:	QIO$S	#IO.WVB,#5,#5,,,,<R1,R0,#40>
	WTSE$S	#5
	CALLSS	EXITP
;
ERRTAB:	.WORD	M1,L1
	.WORD	M2,L2
	.WORD	M3,L3
	.WORD	M4,L4
;
M1:	.ASCII	/PAS -- FILE SPECIFICATION ERROR/
L1=.-M1
M2:	.ASCII	/PAS -- FILE NOT FOUND/
L2=.-M2
M3:	.ASCII	/PAS -- SWITCH ERROR/
L3=.-M3
M4:	.ASCII	/PAS -- EOF ENCOUNTERED/
L4=.-M4
	.EVEN
;
	.END
****
P11INITC.MAC         
	.TITLE	P11INITC	;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
; CORRECTION	V5-3	1978-06-01	STD
; CORRECTION	V5-35	1979-06-26	STD
; CORRECTION	V6-32	1980-04-15	STD
	.IDENT	/PAS632/
	.SBTTL	INITIALIZATION
;
	.MCALL	FINIT$,GTSK$S
;
;
;>>>>>>>>>>>>>>>>>>>>>>>><<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;>>>>>						<<<<<<
;>>>>>		SPECIAL VERSION FOR P11V5	<<<<<<
;>>>>>						<<<<<<
;>>>>>>>>>>>>>>>>>>>>>>>><<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;
	ROUTINE	INITA	
	FINIT$
	MOV	#$$HEAP,SS
	GTSK$S	SS
	MOV	32(SS),SS	; PARTITION SIZE / 32.
	SUB	#2,SS		; POINTER TO LAST WORD IN PARTITION
	NOP
	NOP
FILAREA=FILESIZECORR+TEXTBUFFSIZE+4
	MOV	SS,AD		; CLEAR HEAP AND STACK
	MOV	AD,AR
	SUB	#$$HEAP,AR
	ASR	AR		; NO OF WORDS TO CLEAR
	BIC	#100000, AR
1$:	CLR	-(AD)
	DEC	AR
	BGT	1$
	MOV	MP,AD		; RESERV SPACE FOR STANDARD FILES
	TST	(AD)+
	BEQ	2$
	SUB	#FILAREA,SS	; INPUT
2$:	TST	(AD)+
	BEQ	3$
	SUB	#FILARE,SS	; OUTPUT
3$:	TST	(AD)+
	FILAREA=FILAREA-FDBSIZE
	BEQ	4$
	SUB	#FILAREA,SS	; TTYIN
4$:	TST	(AD)+
	BEQ	5$
	SUB	#FILAREA,SS	; TTYOUT
5$:	MOV	#LUNTABSZ+2,AR	;  LUNTAB		; V5-35
	MOV	#$$HEAP,AD				; V5-35
6$:	CLR	(AD)+		;			; V5-35
	DEC	AR
	BGT	6$
	CMP	-(SS),-(SS)	; SPARE			; V6-32
	MOV	@HP,-(SS)	; TASKSIZE		; V6-32
	MOV	#$EXITP,-(SS)	; ADDRESS OF EXIT PROC	; V6-32
	MOV	#$$HEAP,R 	; ADDRESS OF $$HEAP	; V6-32
	MOV	R, -(SS)	; LUNTABPOINTER		; V6-32
	CMP	-(SS),-(SS)	; MARKDDT & DAPDDT	; V6-32
	DEC	$$HEAP		; TTYIN NOT AVAILABLE	; V5-35
	DEC	$$HEAP+<2*TILUN>; TTYOUT NOT AVAILABLE	; V5-35
	MOV	AD,-(SS)	; DAPADDR := HEAP+LUNTAB ; V5-35
	MOV	@SS,-(SS)	; MARKADDR := START ADDR OF STACK
	MOV	#$P.SEL,-(SS)	; OPTION SELECTOR WORD	; V4-35
;				;   ( PRINT WARNINGS )	; V4-35
	CLR	-(SS)		; LINE NUMBER WORD	; V4-35
	TST	-(SS)		; RESERV SPACE FOR
	MOV	SS,@SS		;   STATIC LINK
	MOV	SS,GP
;
; OPEN STANDARD FILES
;
	MOV	#-2,-(HP)	; COUNTER
NEW:	ADD	#2,@HP		; INDEX TO FNAM & OPEN-ROUTINE
	MOV	@HP,R
	MOV	(MP)+,-(SS)	; FILE POINTER
	BEQ	NOFILE
	ADD	GP,@SS
	MOV	#-1,-(SS)	; FILE TYPE = TEXT
	MOV	FNAM(R),-(SS)	; ADDR TO FNAM STRING
	MOV	#6,-(SS)	; LEN OF FNAM STRING
	CLR	-(SS)		; DIR STRING
	CLR	-(SS)
	CLR	-(SS)		; DEV STRING
	CLR	-(SS)
	CLR	-(SS)		; IOSPEC
	JSR	MP,@FSTOPN(R)
	BR	NEXT
;
NOFILE:	TST	(SS)+		; REMOVE ZERO
NEXT:	CMP	@HP,#6
	BNE	NEW		; MORE FILEPOINTERS LEFT
	TST	(HP)+		; REMOVE COUNTER
;>>>>>>>>>>>>>>>>>>>>>>>>><<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV	MP,2(HP)	; RETURN FROM $$AUTP
	MOV	GP,MP		; INIT MP
	RTS	PC
;>>>>>>>>>>>>>>>>>>>>>>>>>>><<<<<<<<<<<<<<<<<<<<<<<<<<<<
;
FSTOPN:	.WORD	$REWRITE,$RESET,OPNTTY,OPNTTY
FNAM:	.WORD	NMO,NMI,NMO,NMI
NMI:	.ASCII	/INPUT /
NMO:	.ASCII	/OUTPUT/
	.EVEN
;
;
OPNTTY:	ADD	#16.,SS		; SKIP FILE SPEC
	MOV	(SS)+,R		; FILE POINTER
	CLR	EOFSTATUS(R)	; FALSE
	MOV	#1,IORESULT(R)	; OK
	MOV	R,@R
	SUB	#FILESICORR+TEXTBUFFSIZE-FDBSIZE,@R
	CLR	2(R)		; NO CHAR'S
	CMP	2(HP),#6	; WHICH FILE
	BNE	TTYOUT
	MOV	R,$$HEAP	; TTYIN			; V5-35
	MOV	#TRUE,EOLNSTATUS(R)
	MOV	#TTY+TEXT+INPUT,FILTYP(R)
	RETURN
;
TTYOUT:	MOV	R,$$HEAP+<2*TILUN>	; TTYOUT	; V5-35
	CLR	EOLNSTATUS(R)
	MOV	#TTY+TEXT,FILTYP(R)
;
; WRITE(TTY,'*'); BREAK; READLN(TTY);
;
	RETURN
	.END
****
P11ASM.CMD           
P11CMREAL,LI:P11CMREAL/NL=P11DEF,P11CMREAL
P11WRREAL,LI:P11WRREAL/NL=P11DEF,P11WRREAL
P11RDR,LI:P11RDR/NL=P11DEF,P11RDR
P11RDI,LI:P11RDI/NL=P11DEF,P11RDI
P11RDHLP,LI:P11RDHLP/NL=P11DEF,P11RDHLP
P11REAL,LI:P11REAL/NL=P11DEF,P11REAL
P11WRI,LI:P11WRI/NL=P11DEF,P11WRI
P11MARKP,LI:P11MARKP/NL=P11DEF,P11MARKP
P11PBOOL,LI:P11PBOOL/NL=P11DEF,P11PBOOL
P11REDSET,LI:P11REDSET/NL=P11DEF,P11REDSET
P11EXPSET,LI:P11EXPSET/NL=P11DEF,P11EXPSET
P11UNI4,LI:P11UNI4/NL=P11DEF,P11UNI4
P11INT4,LI:P11INT4/NL=P11DEF,P11INT4
P11DIF4,LI:P11DIF4/NL=P11DEF,P11DIF4
P11INITS,LI:P11INITS/NL=P11DEF,P11INITS
P11SGSIN,LI:P11SGSIN/NL=P11DEF,P11SGSIN
P11INN,LI:P11INN/NL=P11DEF,P11INN
P11MPI,LI:P11MPI/NL=P11DEF,P11MPI
P11DVI,LI:P11DVI/NL=P11DEF,P11DVI
P11LEQ,LI:P11LEQ/NL=P11DEF,P11LEQ
P11LES,LI:P11LES/NL=P11DEF,P11LES
P11GEQ,LI:P11GEQ/NL=P11DEF,P11GEQ
P11GRT,LI:P11GRT/NL=P11DEF,P11GRT
P11NEQ,LI:P11NEQ/NL=P11DEF,P11NEQ
P11EQU,LI:P11EQU/NL=P11DEF,P11EQU
P11LEQS1,LI:P11LEQS1/NL=P11DEF,P11LEQS1
P11LEQS4,LI:P11LEQS4/NL=P11DEF,P11LEQS4
P11GEQS1,LI:P11GEQS1/NL=P11DEF,P11GEQS1
P11GEQS4,LI:P11GEQS4/NL=P11DEF,P11GEQS4
P11NEQS4,LI:P11NEQS4/NL=P11DEF,P11NEQS4
P11EQUS4,LI:P11EQUS4/NL=P11DEF,P11EQUS4
P11EQUM,LI:P11EQUM/NL=P11DEF,P11EQUM
P11EQUM2,LI:P11EQUM2/NL=P11DEF,P11EQUM2
P11NEQM,LI:P11NEQM/NL=P11DEF,P11NEQM
P11NEQM2,LI:P11NEQM2/NL=P11DEF,P11NEQM2
P11LEQM,LI:P11LEQM/NL=P11DEF,P11LEQM
P11LEQM2,LI:P11LEQM2/NL=P11DEF,P11LEQM2
P11LESM,LI:P11LESM/NL=P11DEF,P11LESM
P11LESM2,LI:P11LESM2/NL=P11DEF,P11LESM2
P11GEQM,LI:P11GEQM/NL=P11DEF,P11GEQM
P11GEQM2,LI:P11GEQM2/NL=P11DEF,P11GEQM2
P11GRTM,LI:P11GRTM/NL=P11DEF,P11GRTM
P11GRTM2,LI:P11GRTM2/NL=P11DEF,P11GRTM2
P11TWPOW,LI:P11TWPOW/NL=P11DEF,P11TWPOW
P11SPLTRL,LI:P11SPLTRL/NL=P11DEF,P11SPLTRL
P11REXP,LI:P11REXP/NL=P11DEF,P11REXP
P11RLOG,LI:P11RLOG/NL=P11DEF,P11RLOG
P11RSQRT,LI:P11RSQRT/NL=P11DEF,P11RSQRT
P11SINCOS,LI:P11SINCOS/NL=P11DEF,P11SINCOS
P11RUNCHK,LI:P11RUNCHK/NL=P11DEF,P11RUNCHK
P11INIT,LI:P11INIT/NL=P11DEF,P11INIT
P11RESET,LI:P11RESET/NL=P11DEF,P11RESET
P11WROCT,LI:P11WROCT/NL=P11DEF,P11WROCT
P11GETPUT,LI:P11GETPUT/NL=P11DEF,P11GETPUT
P11GCML,LI:P11GCML/NL=P11DEF,P11GCML
P11MOVM,LI:P11MOVM/NL=P11DEF,P11MOVM
P11EXIT,LI:P11EXIT/NL=P11DEF,P11EXIT
P11WRERR,LI:P11WRERR/NL=P11DEF,P11WRERR
P11DATETM,LI:P11DATETM/NL=P11DEF,P11DATETM
P11FSR,LI:P11FSR/NL=P11DEF,P11FSR
P11WRBOOL,LI:P11WRBOOL/NL=P11DEF,P11WRBOOL
P11DUMP,LI:P11DUMP/NL=P11DEF,P11DUMP
P11ABSPAS,LI:P11ABSPAS/NL=P11DEF,P11ABSPAS
P11RANDOM,LI:P11RANDOM/NL=P11DEF,P11RANDOM
P11FORTR,LI:P11FORTR/NL=P11DEF,P11FORTR
P11EISDVI,LI:P11EISDVI/NL=P11DEF,P11EISDVI
P11EISMPI,LI:P11EISMPI/NL=P11DEF,P11EISMPI
P11FIS,LI:P11FIS/NL=P11DEF,P11FIS
P11FPP,LI:P11FPP/NL=P11DEF,P11FPP
P11FPPINI,LI:P11FPPINI/NL=P11DEF,P11FPPINI
P11DFAULT,LI:P11DFAULT/NL=P11DEF,P11DFAULT
P11TRACE,LI:P11TRACE/NL=P11DEF,P11TRACE
P11FREQV,LI:P11FREQV/NL=P11DEF,P11FREQV
P11IASRNC,LI:P11IASRNC/NL=P11DEF,P11IASRNC
****
PASGEN.CMD           
.ASK A ARE THE FILES TRANSFERRED
.IFF A .GOTO 900
SET /UIC=[1,24]
.IFINS ...LBR .GOTO 10
INS [1,54]LBR
.10:.ASK SLB DO YOU WANT TO UPDATE SYSLIB WITH PASCAL SUBROUTINES
.IFF SLB .GOTO 100
LBR [1,1]SYSLIB/IN=PASLIB
LBR [1,1]SYSLIB/RP=PASUPD
.ASK A DOES YOUR TARGET MACHINE HAVE EIS
.IFT A LBR [1,1]SYSLIB/RP=PASEIS
.ASK A DOES YOUR TARGET MACHINE HAVE FIS
.IFT A LBR [1,1]SYSLIB/RP=PASFIS
.ASK A DOES YOUR TARGET MACHINE HAVE FPP
.IFT A LBR [1,1]SYSLIB/RP=PASFPP
.GOTO 200
.100:.ASK PLB  DO YOU WANT TO CREATE PASLIB WITH PASCAL SUBROUTINES
.IFF PLB .GOTO 200
LBR [1,1]PASLIB/CR=PASLIB
LBR [1,1]PASLIB/RP=PASUPB
.ASK A DOES YOUR TARGET MACHINE HAVE EIS
.IFT A LBR [1,1]PASLIB/RP=PASEIS
.ASK A DOES YOUR TARGET MACHINE HAVE FIS
.IFT A LBR [1,1]PASLIB/RP=PASFIS
.ASK A DOES YOUR TARGET MACHINE HAVE FPP
.IFT A LBR [1,1]PASLIB/RP=PASFPP
.200:.ASK A DO YOU WANT TO BUILD A PDP11-RESIDENT COMPILER
.IFF A .GOTO 900
LBR PAS/CR:450.=P11PAS,P11FIL,P11TTY
LBR PAS/RP=P11UPD
.ASK A ARE YOU USING RSX11M V3
.IFF A .GOTO 300
; YOU HAVE TO EDIT FILES PASBLD.CMD AND PPLBLD.CMD AS FOLLOWS:
;	>EDI P??BLD.CMD
;	[PAGE 1]
;	*SC/437/435/
;	*ED
;
EDI PASBLD.CMD
EDI PPLBLD.CMD
.300:.ASK A DO YOU HAVE THE PASCAL ROUTINES IN SYSLIB
.IFT A .GOTO 400
PIP =[1,1]PASLIB.OLB
LBR PASLIB/DE:P11EXI:P11INI
TKB @PPLBLD
.GOTO 500
.400:TKB @PASBLD
.500:; [1,54]PAS.TSK CREATED
.900:; READY
****
MV3PASBLD.CMD        
; MNC -
; THIS FILE SHOULD BE USED TO GENERATE THE "HUGE" PASCAL
; COMPILER ON RSX-11M V3 SYSTEMS.
;
; MNC - In following line, removed "DB:" and added "/MA":
PAS/FP/CP,PAS/MA/-SP=PASBLD/MP
TASK=...PAS
ASG=SY0:1:2:3:4
ASG=TI0:5
ASG=SY0:6
;
; MNC - Allows 3 files. Necessary because of my change to PASLIB.  See
;	P11DEF.MAC and P11GETPUT.MAC comments:
;
EXTSCT=$$FSR1:3060
;
; MNC - The following EXTTSK option gives the compiler the maximum possible
; symbol table under RSX-11M Vers. 3.1 (and under VAX-VMS emulation of
; RSX-11M):
;
EXTTSK=12500
GBLPAT=ROOT:$AUTO+10:403	; BR   READSEGM
GBLPAT=ROOT:$AUTO+34:435	; BR	SEGENT
;
; FOR NEW DEFAULT VALUES REMOVE STARTING ;
; GBLPAT			; NEW VALUE	; OLD VALUE	; MEANING
;GBLPAT=INI1:SWCHIN:1		; /AA:1		; /AA:3		DEFLEVEL
;GBLPAT=INI1:SWCHIN+2:44	; /PW:36	; /PW:56	PAGEWIDTH (A4L)
;GBLPAT=INI1:SWCHIN+4:204	; /LW:132	; /LW:80	LINEWIDTH
;GBLPAT=INI1:SWCHIN+6:1		; (*$E+*)	; (*$E-*)	EIS
;GBLPAT=INI1:SWCHIN+10:1	; (*$G+*)	; (*$G-*)	FIS
;GBLPAT=INI1:SWCHIN+12:1	; (*$F+*)	; (*$F-*)	FPP
;GBLPAT=INI1:SWCHIN+14:0	; (*$L-*)
;GBLPAT=INI1:SWCHIN+16:1	; (*$C+*)	PRINT OCTAL ADDRESSES
;GBLPAT=INI1:SWCHIN+20:1	; (*$X+*)	CONDCOMP
;GBLPAT=INI1:SWCHIN+22:0	; (*$W-*)	WARNINGS
;GBLPAT=INI1:SWCHIN+24:0	; (*$R-*)	RUNTIME CHECKS
;GBLPAT=INI1:SWCHIN+26:0	; (*$T-*)
;GBLPAT=INI1:SWCHIN+30:0	; (*$M-*)
;GBLPAT=INI1:SWCHIN+32:1	; (*$Y+*)	OBJECT MODULE SPLITTING
;GBLPAT=INI1:SWCHIN+34:1	; (*$S+*)	TRACE
;GBLPAT=INI1:SWCHIN+36:1	; (*$D+*)	DEBUG
;GBLPAT=INI1:SWCHIN+40:1	; (*$Q+*)	FREQUENCE MEASURING
;
;GBLDEF=$P.SEL:23		; (*$H+19*)
;GBLDEF=$P.DEV:54523		; "SY  DEFAULT DEVICE
;GBLDEF=$P.UNI:0		; DEFAULT UNIT
; ABOVE $P.XXX FOR COMPILER ONLY. FOR USERS TOO:
; DEFINE A MACRO FILE
;	.TITLE	P11DFAULT
;	$P.SEL==	NEW VALUE
;	$P.DEV==	"-
;	$P.UNI==	"-
;	.END
; AND REPLACE IT INTO PASLIB OR SYSLIB.
;
;	CORRECTIONS
//
****
MV2PASBLD.CMD        
; MNC -
; THIS FILE SHOULD BE USED TO GENERATE THE "HUGE" PASCAL
; COMPILER ON RSX-11M V2 SYSTEMS.
;
; MNC - In following line, removed "DB:" and added "/MA":
PAS/FP/CP,PAS/MA/-SP=PASBLD/MP
TASK=...PAS
ASG=SY0:1:2:3:4
ASG=TI0:5
ASG=SY0:6
;
; MNC - Allows 3 files. Necessary because of my change to PASLIB.  See
;	P11DEF.MAC and P11GETPUT.MAC comments:
;
EXTSCT=$$FSR1:3060
;
; MNC - The following EXTTSK option gives the compiler the maximum possible
; symbol table under RSX-11M Vers. 3.1 (and under VAX-VMS emulation of
; RSX-11M):
;
EXTTSK=11000
GBLPAT=ROOT:$AUTO+10:403	; BR   READSEGM
GBLPAT=ROOT:$AUTO+34:437	; BR	SEGENT
;
; FOR NEW DEFAULT VALUES REMOVE STARTING ;
; GBLPAT			; NEW VALUE	; OLD VALUE	; MEANING
;GBLPAT=INI1:SWCHIN:1		; /AA:1		; /AA:3		DEFLEVEL
;GBLPAT=INI1:SWCHIN+2:44	; /PW:36	; /PW:56	PAGEWIDTH (A4L)
;GBLPAT=INI1:SWCHIN+4:204	; /LW:132	; /LW:80	LINEWIDTH
;GBLPAT=INI1:SWCHIN+6:1		; (*$E+*)	; (*$E-*)	EIS
;GBLPAT=INI1:SWCHIN+10:1	; (*$G+*)	; (*$G-*)	FIS
;GBLPAT=INI1:SWCHIN+12:1	; (*$F+*)	; (*$F-*)	FPP
;GBLPAT=INI1:SWCHIN+14:0	; (*$L-*)
;GBLPAT=INI1:SWCHIN+16:1	; (*$C+*)	PRINT OCTAL ADDRESSES
;GBLPAT=INI1:SWCHIN+20:1	; (*$X+*)	CONDCOMP
;GBLPAT=INI1:SWCHIN+22:0	; (*$W-*)	WARNINGS
;GBLPAT=INI1:SWCHIN+24:0	; (*$R-*)	RUNTIME CHECKS
;GBLPAT=INI1:SWCHIN+26:0	; (*$T-*)
;GBLPAT=INI1:SWCHIN+30:0	; (*$M-*)
;GBLPAT=INI1:SWCHIN+32:1	; (*$Y+*)	OBJECT MODULE SPLITTING
;GBLPAT=INI1:SWCHIN+34:1	; (*$S+*)	TRACE
;GBLPAT=INI1:SWCHIN+36:1	; (*$D+*)	DEBUG
;GBLPAT=INI1:SWCHIN+40:1	; (*$Q+*)	FREQUENCE MEASURING
;
;GBLDEF=$P.SEL:23		; (*$H+19*)
;GBLDEF=$P.DEV:54523		; "SY  DEFAULT DEVICE
;GBLDEF=$P.UNI:0		; DEFAULT UNIT
; ABOVE $P.XXX FOR COMPILER ONLY. FOR USERS TOO:
; DEFINE A MACRO FILE
;	.TITLE	P11DFAULT
;	$P.SEL==	NEW VALUE
;	$P.DEV==	"-
;	$P.UNI==	"-
;	.END
; AND REPLACE IT INTO PASLIB OR SYSLIB.
;
;	CORRECTIONS
//
****
DV6PASBLD.CMD        
; MNC -
; THIS FILE SHOULD BE USED TO GENERATE THE "HUGE" PASCAL
; COMPILER ON RSX-11D V6 SYSTEMS.
;
; MNC - In following line, removed "DB:" and added "/MA":
PAS/FP/CP,PAS/MA/-SP=PASBLD/MP
TASK=...PAS
ASG=SY0:1:2:3:4
ASG=TI0:5
ASG=SY0:6
;
; MNC - Allows 3 files. Necessary because of my change to PASLIB.  See
;	P11DEF.MAC and P11GETPUT.MAC comments:
;
EXTSCT=$$FSR1:3060
;
; MNC - The following EXTTSK option gives the compiler the maximum possible
; symbol table under RSX-11M Vers. 3.1 (and under VAX-VMS emulation of
; RSX-11M):
;
EXTTSK=12000
GBLPAT=ROOT:$AUTO+10:403	; BR   READSEGM
GBLPAT=ROOT:$AUTO+34:437	; BR	SEGENT
;
; FOR NEW DEFAULT VALUES REMOVE STARTING ;
; GBLPAT			; NEW VALUE	; OLD VALUE	; MEANING
;GBLPAT=INI1:SWCHIN:1		; /AA:1		; /AA:3		DEFLEVEL
;GBLPAT=INI1:SWCHIN+2:44	; /PW:36	; /PW:56	PAGEWIDTH (A4L)
;GBLPAT=INI1:SWCHIN+4:204	; /LW:132	; /LW:80	LINEWIDTH
;GBLPAT=INI1:SWCHIN+6:1		; (*$E+*)	; (*$E-*)	EIS
;GBLPAT=INI1:SWCHIN+10:1	; (*$G+*)	; (*$G-*)	FIS
;GBLPAT=INI1:SWCHIN+12:1	; (*$F+*)	; (*$F-*)	FPP
;GBLPAT=INI1:SWCHIN+14:0	; (*$L-*)
;GBLPAT=INI1:SWCHIN+16:1	; (*$C+*)	PRINT OCTAL ADDRESSES
;GBLPAT=INI1:SWCHIN+20:1	; (*$X+*)	CONDCOMP
;GBLPAT=INI1:SWCHIN+22:0	; (*$W-*)	WARNINGS
;GBLPAT=INI1:SWCHIN+24:0	; (*$R-*)	RUNTIME CHECKS
;GBLPAT=INI1:SWCHIN+26:0	; (*$T-*)
;GBLPAT=INI1:SWCHIN+30:0	; (*$M-*)
;GBLPAT=INI1:SWCHIN+32:1	; (*$Y+*)	OBJECT MODULE SPLITTING
;GBLPAT=INI1:SWCHIN+34:1	; (*$S+*)	TRACE
;GBLPAT=INI1:SWCHIN+36:1	; (*$D+*)	DEBUG
;GBLPAT=INI1:SWCHIN+40:1	; (*$Q+*)	FREQUENCE MEASURING
;
;GBLDEF=$P.SEL:23		; (*$H+19*)
;GBLDEF=$P.DEV:54523		; "SY  DEFAULT DEVICE
;GBLDEF=$P.UNI:0		; DEFAULT UNIT
; ABOVE $P.XXX FOR COMPILER ONLY. FOR USERS TOO:
; DEFINE A MACRO FILE
;	.TITLE	P11DFAULT
;	$P.SEL==	NEW VALUE
;	$P.DEV==	"-
;	$P.UNI==	"-
;	.END
; AND REPLACE IT INTO PASLIB OR SYSLIB.
;
;	CORRECTIONS
//
****
FPABLD.CMD           
; MNC -
; THIS FILE SHOULD BE USED TO GENERATE THE "FAST" PASCAL
; COMPILER ON RSX-11M V3 SYSTEMS.
;
; MNC - In following line, removed "DB:" and added "/MA":
FPA/FP/CP,FPA/MA/-SP=FPABLD/MP
TASK=...FPA
ASG=SY0:1:2:3:4
ASG=TI0:5
ASG=SY0:6
;
; MNC - Allows 3 files. Necessary because of my change to PASLIB.  See
;	P11DEF.MAC and P11GETPUT.MAC comments:
;
EXTSCT=$$FSR1:3060
;
; MNC - The following EXTTSK option gives the compiler the maximum possible
; symbol table under RSX-11M Vers. 3.1 (and under VAX-VMS emulation of
; RSX-11M):
;
EXTTSK=7000
GBLPAT=ROOT:$AUTO+10:403	; BR   READSEGM
GBLPAT=ROOT:$AUTO+34:435	; BR	SEGENT
;
; FOR NEW DEFAULT VALUES REMOVE STARTING ;
; GBLPAT			; NEW VALUE	; OLD VALUE	; MEANING
;GBLPAT=INI1:SWCHIN:1		; /AA:1		; /AA:3		DEFLEVEL
;GBLPAT=INI1:SWCHIN+2:44	; /PW:36	; /PW:56	PAGEWIDTH (A4L)
;GBLPAT=INI1:SWCHIN+4:204	; /LW:132	; /LW:80	LINEWIDTH
;GBLPAT=INI1:SWCHIN+6:1		; (*$E+*)	; (*$E-*)	EIS
;GBLPAT=INI1:SWCHIN+10:1	; (*$G+*)	; (*$G-*)	FIS
;GBLPAT=INI1:SWCHIN+12:1	; (*$F+*)	; (*$F-*)	FPP
;GBLPAT=INI1:SWCHIN+14:0	; (*$L-*)
;GBLPAT=INI1:SWCHIN+16:1	; (*$C+*)	PRINT OCTAL ADDRESSES
;GBLPAT=INI1:SWCHIN+20:1	; (*$X+*)	CONDCOMP
;GBLPAT=INI1:SWCHIN+22:0	; (*$W-*)	WARNINGS
;GBLPAT=INI1:SWCHIN+24:0	; (*$R-*)	RUNTIME CHECKS
;GBLPAT=INI1:SWCHIN+26:0	; (*$T-*)
;GBLPAT=INI1:SWCHIN+30:0	; (*$M-*)
;GBLPAT=INI1:SWCHIN+32:1	; (*$Y+*)	OBJECT MODULE SPLITTING
;GBLPAT=INI1:SWCHIN+34:1	; (*$S+*)	TRACE
;GBLPAT=INI1:SWCHIN+36:1	; (*$D+*)	DEBUG
;GBLPAT=INI1:SWCHIN+40:1	; (*$Q+*)	FREQUENCE MEASURING
;
;GBLDEF=$P.SEL:23		; (*$H+19*)
;GBLDEF=$P.DEV:54523		; "SY  DEFAULT DEVICE
;GBLDEF=$P.UNI:0		; DEFAULT UNIT
; ABOVE $P.XXX FOR COMPILER ONLY. FOR USERS TOO:
; DEFINE A MACRO FILE
;	.TITLE	P11DFAULT
;	$P.SEL==	NEW VALUE
;	$P.DEV==	"-
;	$P.UNI==	"-
;	.END
; AND REPLACE IT INTO PASLIB OR SYSLIB.
;
;	CORRECTIONS
//
****
PASBLD.ODL           

; OVERLAY DESCRIPTION FOR "HUGE" (LARGEST SYM. TAB.) PASCAL COMPILER
;	(This one will only compile 8-10 lines/sec on an RP06.)
;
; MNC - MODIFIED FOR SMALLER TASK SIZE, AND READABILITY
;
	.NAME	ROOT
	.NAME	INI1
	.NAME	INI2
	.NAME	INI3
	.NAME	COMPIL
	.NAME	BLCK
	.NAME	DECL
	.NAME	DECL1
	.NAME	DECL2
	.NAME	BODYDF
	.NAME	MODENT
	.NAME	COPYDB
	.NAME	COPYTR
	.NAME	STMNT1
	.NAME	STMNT2
	.NAME	STMNT3
	.NAME	EXPR
	.NAME	SELE
	.NAME	CALLN
	.NAME	CALLS
	.NAME	CALLS1
	.NAME	CALLS2
	.NAME	CALLS3
;
; MNC - Added following line to force data of P11WTT into root.  See MNC
;	comments in P11WTT.MAC:
;
	.PSECT	WTTDAT, D, GBL
;
	.ROOT	ROOT-R-*(INI1-I1,INI2-I2,INI3-I3,COMPIL-C),HEAP
;
R:	.FCTR	WTTDAT-SY:PAS/LB:.MAIN.:ERROR:RECURS:INSYMB-$10
$10:	.FCTR	SY:PAS/LB:NEXTCH:SRCHSE-SY:PASLIB/LB:WRERRO-$12
$12:	.FCTR	SY:PASLIB/LB:P11RAR:PBOOL:EXPSET:DIVI:DIF4:EQUM:EQUM2-$14
$14:	.FCTR	SY:PASLIB/LB:P11CMR:P11GET:GEQ:GRT:INN:LEQ:LES:LESM-$16
$16:	.FCTR	SY:PASLIB/LB:LESM2:MOVM:MULI:NEQ:EQU:UNI4:WRI:WROCT
;
HEAP:	.FCTR	SY:PAS/LB:$HEAP
;
I1:	.FCTR	SY:PAS/LB:INITTA:INIT2:P11SWI-SY:PASLIB/LB
;
I2:	.FCTR	SY:PAS/LB:ENTERI:ENTERS-SY:PASLIB/LB
;
I3:	.FCTR	SY:PAS/LB:ENTERI:OPTION:NEWPAG:OPENFI:PROGRA-$30
$30:	.FCTR	SY:PAS/LB:P11INI:P11WTT:NXTCHR:ERRMES:INCLUD:ENDOFL-$40
$40:	.FCTR	SY:PASLIB/LB:P11EXI:DATETM-SY:PASLIB/LB
;
C:	.FCTR	BLCK-BL-*(DECL-D,BD-*(NEW,STM1,STM2,STM3,EXP,SEL,CNS,CS))
CS:	.FCTR	CST-*(CS1,CS2,CS3)
;
BL:	.FCTR	SY:PAS/LB:SKIP:BODY:HEAPMA-SY:PASLIB/LB
;
D:	.FCTR	SY:PAS/LB:BLOCK:SIMPLE:ENTERI-*(DECL1-D1,DECL2-D2)
D1:	.FCTR	SY:PAS/LB:LABELD:CONSTD:TYPEDE:VARDEC-SY:PASLIB/LB
D2:	.FCTR	SY:PAS/LB:PROCED:PSERRO:EXTERN-SY:PASLIB/LB
;
BD:	.FCTR	BODYDF-SY:PAS/LB:STATEM:EXPRES:CALL:WRITOB:MULTIP:WRITOF-$70
$70:	.FCTR	SY:PAS/LB:SELECT:LARGES:COMPOU:LOADAD-SY:PASLIB/LB
;
NEW:	.FCTR	COPYTR-SY:PAS/LB:COPYTR-SY:PASLIB/LB-*(NEW1,NEW2)
NEW2:	.FCTR	COPYDB-SY:PAS/LB:WRITER-SY:PASLIB/LB
NEW1:	.FCTR	MODENT-SY:PAS/LB:STARTO-SY:PASLIB/LB
;
STM1:	.FCTR	STMNT1-SY:PAS/LB:GOTOST:WITHST-SY:PASLIB/LB
;
STM2:	.FCTR	STMNT2-SY:PAS/LB:CASEST:IFSTAT-$80
$80:	.FCTR	SY:PAS/LB:REPEAT:WHILES:LOOPST-SY:PASLIB/LB
;
STM3:	.FCTR	STMNT3-SY:PAS/LB:ASSIGN:FORSTA:STORE-SY:PASLIB/LB
;
EXP:	.FCTR	EXPR-SY:PAS/LB:LOADST-SY:PASLIB/LB
;
SEL:	.FCTR	SELE-SY:PAS/LB:DOSELE-SY:PASLIB/LB
;
CNS:	.FCTR	CALLN-SY:PAS/LB:CALLNS:BASE-SY:PASLIB/LB
;
CST:	.FCTR	CALLS-SY:PAS/LB:VARIAB:GETFIL:CALLST-SY:PASLIB/LB
;
CS1:	.FCTR	CALLS1-SY:PAS/LB:GETPUT:READRE:PACK:UNPACK-$90
$90:	.FCTR	SY:PASLIB/LB
;
CS2:	.FCTR	CALLS2-SY:PAS/LB:NEW1:ABS:SQR:TRUNC:ARITHM:ROUND-$95
$95:	.FCTR	SY:PASLIB/LB
;
CS3:	.FCTR	CALLS3-SY:PAS/LB:WRITEW-$100
$100:	.FCTR	SY:PAS/LB:ODD:ORD:CHR:PREDSU:EOFEOL:BREAKL:FORMFE-$110
$110:	.FCTR	SY:PAS/LB:DATETI:HALT:RUNTIM:MARKRE:SPLITR:SSIZE:TWOPOW-$120
$120:	.FCTR	SY:PASLIB/LB
;
	.END
****
FPABLD.ODL           

; OVERLAY DESCRIPTION FOR "HUGE" (LARGEST SYM. TAB.) PASCAL COMPILER
;	(This one will only compile 8-10 lines/sec on an RP06.)
;
; MNC - MODIFIED FOR SMALLER TASK SIZE, AND READABILITY
;
	.NAME	ROOT
	.NAME	INI1
	.NAME	INI2
	.NAME	INI3
	.NAME	COMPIL
	.NAME	BLCK
	.NAME	DECL
	.NAME	DECL1
	.NAME	DECL2
	.NAME	BODYDF
	.NAME	MODENT
	.NAME	COPYDB
	.NAME	COPYTR
;	.NAME	STMNT1
	.NAME	STMNT2
	.NAME	STMNT3
;	.NAME	EXPR
;	.NAME	SELE
	.NAME	CALLN
	.NAME	CALLS
	.NAME	CALLS1
	.NAME	CALLS2
	.NAME	CALLS3
;
; MNC - Added following line to force data of P11WTT into root.  See MNC
;	comments in P11WTT.MAC:
;
	.PSECT	WTTDAT, D, GBL
;
	.ROOT	ROOT-R-*(INI1-I1,INI2-I2,INI3-I3,COMPIL-C),HEAP
;
R:	.FCTR	WTTDAT-SY:PAS/LB:.MAIN.:ENDOFL:NEWPAG:RECURS:INSYMB-$10
$10:	.FCTR	SY:PAS/LB:ERROR:NEXTCH:SRCHSE-SY:PASLIB/LB:WRERRO-$12
$12:	.FCTR	SY:PASLIB/LB:P11RAR:PBOOL:EXPSET:DIVI:DIF4:EQUM:EQUM2-$14
$14:	.FCTR	SY:PASLIB/LB:P11CMR:P11GET:GEQ:GRT:INN:LEQ:LES:LESM-$16
$16:	.FCTR	SY:PASLIB/LB:LESM2:MOVM:MULI:NEQ:EQU:UNI4:WRI:WROCT
;
HEAP:	.FCTR	SY:PAS/LB:$HEAP
;
I1:	.FCTR	SY:PAS/LB:INITTA:INIT2:P11SWI-SY:PASLIB/LB
;
I2:	.FCTR	SY:PAS/LB:ENTERI:ENTERS-SY:PASLIB/LB
;
I3:	.FCTR	SY:PAS/LB:ENTERI:OPTION:OPENFI:PROGRA-$30
$30:	.FCTR	SY:PAS/LB:P11INI:P11WTT:NXTCHR:ERRMES:INCLUD-$40
$40:	.FCTR	SY:PASLIB/LB:P11EXI:DATETM-SY:PASLIB/LB
;
C:	.FCTR	BLCK-BL-*(DECL-D,BD-*(NEW,STM2,STM3,CNS,CS))
CS:	.FCTR	CST-*(CS1,CS2,CS3)
;
BL:	.FCTR	SY:PAS/LB:SKIP:BODY:HEAPMA-SY:PASLIB/LB
;
D:	.FCTR	SY:PAS/LB:BLOCK:SIMPLE:ENTERI-$50
$50:	.FCTR	SY:PAS/LB:LABELD:CONSTD:TYPEDE:VARDEC-$60
$60:	.FCTR	SY:PAS/LB:PROCED:PSERRO:EXTERN-SY:PASLIB/LB
;
BD:	.FCTR	BODYDF-SY:PAS/LB:STATEM:EXPRES:CALL:WRITOB:MULTIP:WRITOF-$70
$70:	.FCTR	SY:PAS/LB:SELECT:LARGES:COMPOU:LOADAD:DOSELE:LOADST-SY:PASLIB/LB
;
NEW:	.FCTR	COPYTR-SY:PAS/LB:COPYTR-SY:PASLIB/LB-*(NEW1,NEW2)
NEW2:	.FCTR	COPYDB-SY:PAS/LB:WRITER-SY:PASLIB/LB
NEW1:	.FCTR	MODENT-SY:PAS/LB:STARTO-SY:PASLIB/LB
;
;STM1:	.FCTR	STMNT1-SY:PAS/LB:GOTOST:WITHST-SY:PASLIB/LB
;
STM2:	.FCTR	STMNT2-SY:PAS/LB:CASEST:IFSTAT-$80
$80:	.FCTR	SY:PAS/LB:REPEAT:WHILES:LOOPST:WITHST-SY:PASLIB/LB
;
STM3:	.FCTR	STMNT3-SY:PAS/LB:ASSIGN:FORSTA:STORE:GOTOST-SY:PASLIB/LB
;
;EXP:	.FCTR	EXPR-SY:PAS/LB:LOADST-SY:PASLIB/LB
;
;SEL:	.FCTR	SELE-SY:PAS/LB:DOSELE-SY:PASLIB/LB
;
CNS:	.FCTR	CALLN-SY:PAS/LB:CALLNS:BASE-SY:PASLIB/LB
;
CST:	.FCTR	CALLS-SY:PAS/LB:VARIAB:GETFIL:CALLST-SY:PASLIB/LB
;
CS1:	.FCTR	CALLS1-SY:PAS/LB:GETPUT:READRE:PACK:UNPACK-$90
$90:	.FCTR	SY:PASLIB/LB
;
CS2:	.FCTR	CALLS2-SY:PAS/LB:NEW1:ABS:SQR:TRUNC:ARITHM:ROUND-$95
$95:	.FCTR	SY:PASLIB/LB
;
CS3:	.FCTR	CALLS3-SY:PAS/LB:WRITEW-$100
$100:	.FCTR	SY:PAS/LB:ODD:ORD:CHR:PREDSU:EOFEOL:BREAKL:FORMFE-$110
$110:	.FCTR	SY:PAS/LB:DATETI:HALT:RUNTIM:MARKRE:SPLITR:SSIZE:TWOPOW-$120
$120:	.FCTR	SY:PASLIB/LB
;
	.END
****
PACK.PAS             
program PACK ( input, output, tty );
 
(* This program compresses arbitrary source files 
   to one file with unpacking information in it.
   The names of the source files are given from the terminal.
   The resulting file contains for each file:
   - one line with the file name
   - the source module lines
   - one line containing '****'
   Unpacking can be performed by the program UNPACK.         *)
 
var   I,J,K: integer;
      C: char;
      FILNAM: array (.0..20.) of char;
 
 
begin
 
write( tty, 'Output file name: ');   break;   readln(tty);
FILNAM := '                     ';    J := 0;
while not eoln(ttyin) do
 begin   read( tty, FILNAM(.J.) );   J := J+1   end;
rewrite( output, FILNAM );
 
loop
  write( tty, 'Source file: ');   break;
  readln(tty);
exit if eoln(ttyin);
  FILNAM := '                     ';   J:=0;
  while not eoln(ttyin) do
   begin   read( tty, FILNAM(.J.) );   J := J+1   end;
 
  reset( input, FILNAM );
  if eof(input) then writeln(tty,FILNAM,'not found')
  else
   begin   writeln( FILNAM );
    while not eof(input) do
     begin  (* copy a line *)
      while not eoln(input) do
       begin    read(c);   write(c)   end;
      readln;   writeln;
     end;
    writeln('****');
   end;
end;
writeln(tty,'ready')
end.
****
UNPACK.PAS           
program UNPACK ( input, output, tty );
 
(* This program converts the concatenated sources of
   the runtime library into sepate files. Each module
   must start with one line giving the file name and
   end with one line containing '****'.
   Such packing is performed by the program PACK.   *)
 
type TEXT = file of char;
 
var   FILNAM: array (.0..20.) of char;
      I,J,NSTAR: integer;
      C: CHAR;
      EOM: boolean;
 
procedure attach( var f: text );  extern;
 
procedure detach( var f: text );  extern;
 
begin   write( tty, 'Name of packed file: ');   break;
 readln(tty);   J:=0;   FILNAM:='                     ';
 ATTACH( tty );
 while not eoln(ttyin) do
   begin   read(tty,FILNAM(.J.));  J := J+1   end;
 reset( input, FILNAM );
 if eof(input) then writeln( tty, FILNAM, 'not found' )
 else   while not eof(input) do
  begin     FILNAM := '                     ';   I := 0;
   while not eoln(input) and ( I<20 ) do
    begin   read( FILNAM(.I.) );   I := I+1   end;
   readln;     rewrite( output, FILNAM );   EOM := false;
   writeln( tty, FILNAM );
   while not EOM do
    begin        NSTAR := 0;
     for I:=1 to 4 do
      if input^ = '*' then
       begin   NSTAR := NSTAR+1;   get(input)   end;
     if NSTAR = 4 then EOM := true
     else
      begin   for I:=1 to NSTAR do write('*');
       while not eoln(input) do
        begin   read(C);   write(C)   end;
       writeln;
      end;
     readln;
    end;
  end
end.
****
LISTPACK.PAS         
program LISTPACK ( input, tty );
 
(* This program examines a file of concatenated sources.
   A list of module names is produced. Each module
   must start with one line giving the file name and
   end with one line containing '****'.
   Such packing is performed by the program PACK.   *)
 
var   FILNAM: array (.0..20.) of char;
      I,J,NSTAR: integer;
      C: CHAR;
      EOM: boolean;
 
begin   write( tty, 'Name of packed file: ');   break;
 readln(tty);   J:=0;   FILNAM:='                     ';
 while not eoln(ttyin) do
   begin   read(tty,FILNAM(.J.));  J := J+1   end;
 reset( input, FILNAM );
 if eof(input) then writeln( tty, FILNAM, 'not found' )
 else   while not eof(input) do
  begin     FILNAM := '                     ';   I := 0;
   while not eoln(input) and ( I<20 ) do
    begin   read( FILNAM(.I.) );   I := I+1   end;
   readln;     EOM := false;
   writeln( tty, FILNAM );
   while not EOM do
    begin        NSTAR := 0;
     for I:=1 to 4 do
      if input^ = '*' then
       begin   NSTAR := NSTAR+1;   get(input)   end;
     EOM := NSTAR = 4;
     readln;
    end;
  end
end.
****
PACKLIB.PAS          
program PACKLIB ( input, output, tty );
 
(* This program compresses the source files of
   the runtime library modules to one file with unpacking
   information in it. The names of the source files are stored
   in the array NAMES. The resulting file contains for each file:
   - one line with the file name
   - the source module lines
   - one line containing '****'
   Unpacking can be performed by the program Unpack.         *)
 
const ANTAL = 74;
var   I,J,K: integer;
      C: char;
      EXT: array (.0..3.) of char;
      FILNAM: array (.0..20.) of char;
      NAMES: array (.1..ANTAL.) of array (.0..5.) of char;
 
 
begin
NAMES(.1.) := 'DEF   ';   NAMES(.2.) := 'INIT  ';   NAMES(.3.) := 'RESET ';   
NAMES(.4.) := 'GETPUT';   NAMES(.5.) := 'WRERR ';   NAMES(.6.) := 'EXIT  ';   
NAMES(.7.) := 'CMREAL';   NAMES(.8.) := 'WRREAL';   NAMES(.9.) := 'RDR   ';   
NAMES(.10.) := 'RDI   ';   NAMES(.11.) := 'RDHLP ';   NAMES(.12.) := 'REAL  ';   
NAMES(.13.) := 'WRI   ';   NAMES(.14.) := 'MARKP ';   NAMES(.15.) := 'PBOOL ';   
NAMES(.16.) := 'REDSET';   NAMES(.17.) := 'EXPSET';   NAMES(.18.) := 'UNI4  ';   
NAMES(.19.) := 'INT4  ';   NAMES(.20.) := 'DIF4  ';   NAMES(.21.) := 'INITS ';   
NAMES(.22.) := 'SGSIN ';   NAMES(.23.) := 'INN   ';   NAMES(.24.) := 'MPI   ';   
NAMES(.25.) := 'DVI   ';   NAMES(.26.) := 'LEQS1 ';   NAMES(.27.) := 'LEQS4 ';   
NAMES(.28.) := 'LEQ   ';   NAMES(.29.) := 'LEQM  ';   NAMES(.30.) := 'LEQM2 ';   
NAMES(.31.) := 'GEQ   ';   NAMES(.32.) := 'GEQM  ';   NAMES(.33.) := 'GEQM2 ';   
NAMES(.34.) := 'LES   ';   NAMES(.35.) := 'LESM  ';   NAMES(.36.) := 'LESM2 ';   
NAMES(.37.) := 'GRT   ';   NAMES(.38.) := 'GRTM  ';   NAMES(.39.) := 'GRTM2 ';   
NAMES(.40.) := 'NEQ   ';   NAMES(.41.) := 'NEQM  ';   NAMES(.42.) := 'NEQM2 ';   
NAMES(.43.) := 'EQU   ';   NAMES(.44.) := 'EQUM  ';   NAMES(.45.) := 'EQUM2 ';   
NAMES(.46.) := 'NEQS4 ';   NAMES(.47.) := 'GEQS1 ';   NAMES(.48.) := 'GEQS4 ';   
NAMES(.49.) := 'EQUS4 ';   NAMES(.50.) := 'TWPOW ';   NAMES(.51.) := 'SPLTRL';   
NAMES(.52.) := 'REXP  ';   NAMES(.53.) := 'RLOG  ';   NAMES(.54.) := 'RSQRT ';   
NAMES(.55.) := 'SINCOS';   NAMES(.56.) := 'RUNCHK';   NAMES(.57.) := 'MOVM  ';   
NAMES(.58.) := 'WROCT ';   NAMES(.59.) := 'GCML  ';   NAMES(.60.) := 'DATETM';   
NAMES(.61.) := 'FSR   ';   NAMES(.62.) := 'DUMP  ';   NAMES(.63.) := 'WRBOOL';
NAMES(.64.) := 'ABSPAS';   NAMES(.65.) := 'RANDOM';   NAMES(.66.) := 'EISMPI';
NAMES(.67.) := 'EISDVI';   NAMES(.68.) := 'FIS   ';   NAMES(.69.) := 'FPP   ';
NAMES(.70.) := 'FORTR ';   NAMES(.71.) := 'FPPINI';  NAMES(.72.) := 'DFAULT';
NAMES(.73.) := 'TRACE ';   NAMES(.74.) := 'FREQV ';
EXT := '.MAC';
 
rewrite( output, 'PASLIB.PAC');
writeln(tty,'Creating PASLIB.PAC');
 
for I:=1 to ANTAL do
 begin FILNAM := 'P11                  ';   J:=0;
  for K:=0 to 5 do
  if NAMES(.I,J.) <> ' ' then
   begin   FILNAM(.J+3.) := NAMES(.I,J.);   J:= J+1   end;
  for k:=0 to 3 do FILNAM(.J+K+3.) := EXT(.K.);
 
  reset( input, FILNAM );
  if eof(input) then writeln(tty,FILNAM,'not found')
  else
   begin   writeln( FILNAM );
    while not eof(input) do
     begin  (* copy a line *)
      while not eoln(input) do
       begin    read(c);   write(c)   end;
      readln;   writeln;
     end;
    writeln('****');
   end;
 end;
writeln(tty,'ready')
end.
****
SELECT.PAS           
program SELECT ( input, output, tty );
 
(* This program converts the concatenated sources of
   the runtime library into sepate files. Each module
   must start with one line giving the file name and
   end with one line containing '****'.
   Such packing is performed by the program PACK.   *)
 
label	99;
 
type TEXT = file of char;
 
var   FILNAM,SEARCHED,PACKFILE: array (.0..20.) of char;
      I,J,NSTAR: integer;
      C: CHAR;
      EOM: boolean;
 
procedure attach( var f: text );  extern;
 
procedure detach( var f: text );  extern;
 
begin   write( tty, 'Name of packed file: ');   break;
 readln(tty);   J:=0;   PACKFILE:='                     ';
 ATTACH( tty );
 read ( tty, PACKFILE );
 loop
 reset( input, PACKFILE );
 if eof(input) then writeln( tty, PACKFILE, 'not found' )
 else
  begin   SEARCHED := '                     ';
   write(tty,'Searched file: ');  break;  readln(tty);
  end;
 exit if eof(input) or eoln(tty);
   read ( tty, SEARCHED );
     loop
	read ( FILNAM );
     exit if (SEARCHED = FILNAM) or eof(input);
	while (input^ # '*') and not eof(input) do readln;
	readln;
     end;
   if eof(input) then
     begin writeln(tty,SEARCHED,'not found'); goto 99 end;
   readln;     rewrite( output, FILNAM );   EOM := false;
   writeln( tty, FILNAM );
   while not EOM do
    begin        NSTAR := 0;
     for I:=1 to 4 do
      if input^ = '*' then
       begin   NSTAR := NSTAR+1;   get(input)   end;
     if NSTAR = 4 then EOM := true
     else
      begin   for I:=1 to NSTAR do write('*');
       while not eoln(input) do
        begin   read(C);   write(C)   end;
       writeln;
      end;
     readln;
    end;
99:
  end;
end.
****
PASFQV.PAS           
(*$M-,D-,T-,R-,Q-*)			(*   PASFQV.PAS   *)
 
TYPE
 
  LINEELEMP = ^ LINEELEM;
 
  LINEELEM = RECORD
		MOV: INTEGER;
		LINENO: INTEGER;
		OFFS: INTEGER;
		TST: INTEGER;
		PREVLINE: LINEELEMP;
		INC: INTEGER;
		COUNT: INTEGER
	     END;
 
  STR10 = PACKED ARRAY (.0..9.) OF CHAR;
 
  TEXT = PACKED FILE OF CHAR;
 
 
PROCEDURE PASFQV ( VAR F: TEXT; FN: STR10; LP: LINEELEMP );
 
  VAR
    N,J,K: INTEGER;
    EXT: ARRAY(.0..3.) OF CHAR;
    FILNAM: PACKED ARRAY(.0..19.) OF CHAR;
    D,T: ARRAY (.1..10.) OF CHAR;
 
  BEGIN   N:=0;   EXT:='.FQV';   FILNAM:='                    ';
    DATE(D);   TIME(T);
    WHILE (N<=9) AND (FN(.N.)<>'.') DO
      BEGIN   FILNAM(.N.):=FN(.N.);   N:=N+1;
      END;
    FOR J:=0 TO 3 DO   FILNAM(.N+J.):=EXT(.J.);
    REWRITE ( F, FILNAM );
    IF IORESULT ( F ) >= 0 THEN
      BEGIN
	WRITELN ( F, 'STATISTICS FROM EXECUTION OF ', FN : N );
	WRITELN ( F, '==========================================' : N + 29 );
	WRITELN ( F );
	WRITELN ( F, D, ' ':5, T );
	WRITELN ( F );
	WRITELN ( F, 'SOURCE CODE LINE NUMBER / NUMBER OF TIMES EXECUTED' );
	WHILE LP <> NIL DO
	  WITH LP^ DO
	    BEGIN   WRITELN ( F, LINENO, COUNT );
	      LP := PREVLINE;
	    END;
      END;
END	(*   PASFQV   *).

****
