.;
.;
.;		B R U . C M D
.;
.;	Conduct a standard BRU run.
.;	This command file can be invoked either interactively by
.;		>@BRU
.;	Or as an MCR command by
.;		>@BRU input output
.;	    or
.;		>@BRU output=input
.;	Input and output devices will be mounted (foreign) as necessary.
.;	An output disk mounted foreign WILL be initialized.
.;
.;	The following switches are legal, and can appear on either input
.;	or output device:
.;		Switch	Default	Meaning
.;		/RW	/RW	Rewind tape before copy. No effect for disk.
.;		/VE	/-VE	Verify volume after copy.
.;

.;	Author:	T. R. Wyant
.;	Maintainer:
.;		Process Systems System Manager
.;	Date:	24-Feb-83
.;	Modified:
.;		28-Apr-83 - T. R. Wyant
.;			Added size check & init switches for different-
.;				sized disks (M+V2.0 and M V4.0 only).
.;	Remarks:
.;		This command file will work under the following operating
.;		systems:
.;			RSX-11M V3.2
.;			RSX-11M V4.0
.;			RSX-11M+ V1.0
.;			RSX-11M+ V2.0
.;		Note that under the "Old" releases, volumes must not be
.;		mounted foreign before runnong the command file; all un-
.;		mounted volumes will be mounted foreign.
.;
	.ENABLE SUBSTITUTION
	.ENABLE ESCAPE
	.SETS D$MM1 ""		! Density for input from MM: drvr
	.SETS D$MM2 "/DEN:1600"	! Density for output to MM: drvr
	.SETS D$MT1 ""		! Density for input from MT: drvr
	.SETS D$MT2 "/DEN:800"	! Density for output to MT: drvr
	.SETS D$MS1 ""		! Density for input from MS: drvr
	.SETS D$MS2 ""		! Density for output to MS: drvr
	.SETS D$MF1 ""		! Density for input from MF: drvr
	.SETS D$MF2 "/DEN:6250"	! Density for output to MF: drvr
	.IFNDF P1	.SETS P1 ""
	.IFNDF P2	.SETS P2 ""
	.PARSE P1 "=" P1 S
	.IF S = ""	.GOTO NOSWAP
	.SETS P2 P1
	.SETS P1 S
.NOSWAP:.SETF PROMPT
	.IF P1 <> ""	.OR .IF P2 <> ""	.GOTO START
;
;
;		B R U . C M D
;
;	Conduct a standard BRU run.
;	For help on any query, hit the escape key.
;
	.SETT PROMPT
.START:	.IF <CLI> = "MCR"	.GOTO SYSTM
	.IF <CLI> = "DCL"	.GOTO SYSTM
	; Error -- Command line interpreter "'<CLI>'" not supported.
	.EXIT 2
.SYSTM:	.IF <SYSTEM> = 1	.GOTO DEFIN
	.IF <SYSTEM> = 6	.GOTO DEFIN
	; Error -- Operating system '<SYSTEM>' not supported.
	.EXIT 2
.DEFIN:	.SETS DIR1 "in"
	.SETS DIR2 "out"
	.SETN INDEX 1.
	.SETF ABORT
	.SETF SW$RWP		; Rewind switch not seen.
	.SETT SW$RWV		; Default is rewind.
	.SETF SW$VEP		; Verify switch not seen.
	.SETF SW$VEV		; Default is no verification.
	.GOSUB DEV		; Check out input device.
	.GOSUB DEV		; Check out output device.
	.IFT TAP1 .IFT TAP2	; Error -- Input and output cannot both be tape.
	.IFT TAP1 .IFT TAP2	.EXIT 2
	.IF DEV1 = DEV2		; Error -- Input and output device cannot be same.
	.IF DEV1 = DEV2		.EXIT 2
	.IF FIL2 <> ""		; Error -- Output file spec. not allowed.
	.IF FIL2 <> ""		.EXIT 2
.VERSW:	.SETS S ".ASK [SW$VEV]"
	.IFNDF <PRIVIL>	.SETS S ".ASK"
	.IFT PROMPT .IFF SW$VEP	'S' SW$VEV Shall I verify the output volume
	.IFF <ESCAPE>	.GOTO REWSW
	;
	; BRU has the capability of reading the output volume back in and
	; comparing it to the input volume. An error will be reported if the
	; two volumes do not match. There are two drawbacks to this:
	;	* It takes longer (about 2-3X)
	;	* You should not write to the input volume while BRU is
	;		running. If you do, you may produce spurious
	;		verification failures.
	;
	; The default is no verification.
	;
	.GOTO VERSW
.REWSW:	.IFF TAP1 .IFF TAP2	.GOTO MNT
	.SETS S ".ASK [SW$RWV]"
	.IFNDF <PRIVIL>	.SETS S ".ASK"
	.IFT PROMPT .IFF SW$RWP	'S' SW$RWV Shall I rewind the tape first
	.IFF <ESCAPE>	.GOTO MNT
	;
	; You have the choice of:
	;	Rewinding the tape before processing;
	;	beginning your processing at the current location.
.IFT TAP2	; If you rewind the tape, all backup sets currently on the tape
.IFT TAP2	; will be lost. If you do not rewind the tape, your new backup
.IFT TAP2	; set will be appended to the tape.
	.SETS S ""
	.IFF SW$RWV	.SETS S "not "
	;
	; The default is 'S'to rewind.
	;
	.GOTO REWSW
.MNT:	.SETN INDEX 1.
	.GOSUB MOU		; Mount the input device.
	.GOSUB MOU		; Mount the output device.
.;
	.SETS CMDSTR ""
	.SETS UFDSWI ""
	.IFDF <PRIVIL>		.SETS UFDSWI "/UFD"
	.IFF TAP1 .IFT F111	.SETS CMDSTR "/MOU"
	.IFF TAP2 .IFF F112	.SETS CMDSTR CMDSTR+"/INI/POS:MID/BAD:AUTO"
	.IFF TAP2 .IFT F112	.SETS CMDSTR CMDSTR+"/NOINI'UFDSWI'"
	.SETS REWSWI ""
	.IFT TAP2	.SETS REWSWI "/APP"
	.IFT SW$RWV	.SETS REWSWI "/REW"
	.IFT TAP1 .OR .IFT TAP2	.SETS CMDSTR CMDSTR+REWSWI
	.IFT TAP1		.SETS CMDSTR CMDSTR+D$$$1
	.IFT TAP2		.SETS CMDSTR CMDSTR+D$$$2
	.IFT SW$VEV		.SETS CMDSTR CMDSTR+"/VER"
	.IF <CLI> = "MCR"	.SETS CMDSTR "BRU"+CMDSTR
	.IFNDF <PRIVIL>	.IF <CLI> = "DCL"	.SETS CMDSTR "ARCHIVE"+CMDSTR
	.IFDF <PRIVIL>	.IF <CLI> = "DCL"	.SETS CMDSTR "BACKUP"+CMDSTR
	.IFT TAP1 .OR .IFT TAP2 .GOTO COPY	! If not disk to disk, go copy.
	.IFF TAP2 .IFT F112 .GOTO COPY		! If no initialize, go copy.
	.IFNDF <PRIVIL> .GOTO COPY		! Unsupported under old systems.
	.IF IN1 <> IN2 .SETS CMDSTR CMDSTR+"/HEA:'IN2'"	! Initial headers.
	.IF MX1 <> MX2 .SETS CMDSTR CMDSTR+"/MAX:'MX2'"	! Maximum headers.
.COPY:	'CMDSTR' 'DEV1''FIL1' 'DEV2'
	.GOTO DMO
.;
.;
.;
.;		DEV -- Check for legal device.
.;
.DEV:
	.SETN D INDEX
	.INC INDEX
	.IFNDF P'D'	.SETS P'D' ""
.DEV003:.SETS S DIR'D'
	.IF P'D' = ""	.ASKS P'D' Give 'S'put device
	.IFF <ESCAPE>	.GOTO DEV006
	;
	; You must give the device name in the usual RSX format: two
	; alphabetic characters, followed (optionally) by an octal number
	; in the range 0-77, and a colon. For the input device only, you
	; can also specify a file name (or names), as many as will fit on
	; the final BRU command line. If you do not give a file name, the
	; colon after the device name is optional.
	;
	; This command file will insure that your device is in the system,
	; and is either a disk or tape.
	;
	.SETS P'D' ""
	.IFT PROMPT	.GOTO DEV003
	.EXIT 2
.DEV006:.PARSE P'D' ":/" S FIL'D' SWILST
	.TESTFILE 'S':
	.IF <FILERR> = 1	.GOTO DEV010
	.IF <FILERR> = 240.	.GOTO DEV010
	.IF <FILERR> = 230.	.GOTO DEV010
	; Error -- 'S': not in system. I/O error = '<FILERR>' (Decimal).
	.SETS P'D' ""
	.IFT PROMPT	.GOTO DEV003
	.EXIT 2
.DEV010:
	.PARSE <FILSPC> ":" DEV'D' S
	.SETS S DEV'D'[3:5]
	.SETN O 'S'
	.SETS DEV'D' DEV'D'[1:2]+"'O':"
	.SETS S DEV'D'[1:2]
	.SETF TAP'D'
	.SETS D$$$'D' ""
	.IFDF D$'S''D'	.SETS D$$$'D' D$'S''D'
	.SETS S S[1:1]
	.IF S = "D"	.GOTO DEV060
	.SETT TAP'D'
	.IF S = "M"	.GOTO DEV060
	.PARSE P'D' ":" S FIL'D'
	; Error -- 'S': not disk or tape.
	.SETS P'D' ""
	.IFT PROMPT	.GOTO DEV003
	.EXIT 2
.DEV020:
	.PARSE SWILST "/" SWI SWILST
	.IF SWI = ""	.GOTO DEV020
	.SETT ASSERT
	.SETS S SWI[1:1]
	.IF S <> "-"	.SETS S SWI[1:2]
	.IF S <> "-" .IF S <> "NO"	.SETS S ""
	.IF S <> ""	.SETF ASSERT
	.TEST S
	.SETS SWI SWI[<STRLEN>+1:80.]
	.SETS S SWI[1:2]
	.TEST S
	.IF <STRLEN> <> 2	.GOTO DEV030
	.IFF <ALPHAN>		.GOTO DEV030
	.IFNDF SW$'S'P		.GOTO DEV030
	.IFT SW$'S'P		.GOTO DEV040
	.SET'ASSERT' SW$'S'V
	.GOTO DEV060
.DEV030:; Error - Switch "/'SWI'" is illegal.
	.GOTO DEV050
.DEV040:; Error - Switch "/'SWI'" has already been specified.
.DEV050:.SETT ABORT
.DEV060:.IF SWILST <> ""	.GOTO DEV020
	.IFF ABORT	.GOTO DEV070
	.IFF PROMPT	.EXIT 2
	.SETF ABORT
	.SETS P'D' ""
	.GOTO DEV003
.DEV070:.IFNDF <PRIVIL>	.RETURN
	.SETS S DEV'D'
	.TESTDEVICE 'S'
	.PARSE <EXSTRI> "," S S SUCW2 SUCW3 S
	.SETN O1 'SUCW2'&377
	.SETN O2 'SUCW3'
	.SETS S DEV'D'[1:2]
	.IF S = "DX" .OR .IF S = "DY"	.SETN O1 0

	.SETN TM'D' O1&1*100000+(O2/2)		! Calc. theoretical
	.SETN TM'D' TM'D'-(TM'D'/27.)		!    maximum files
	.IF O1 > 1	.SETN TM'D' 65500.	!    on disk.

	.SETN MX'D' O1&17*10000+(O2/16.)	! Calc. maximum files
	.IF O1 > 17	.SETN MX'D' 65500.	!    to use.

	.SETN IN'D' MX'D'/2.			! Calc. initial index
	.IF MX'D' < 100.	.SETN INFIL 16.	!    file alloc.

	.IF MX'D' < 65000.	.RETURN		! If a small disk, fine.

	.; The /INF & /MXF calculation for huge disks would go here,
	.; if I ever figure it out.

	.RETURN
.;
.;
.;		MOU -- Mount devices as necessary.
.;
.MOU:
	.SETN D INDEX
	.INC INDEX
	.SETS S DEV'D'
	.SETF DMO'D'
	.SETF F11'D'
	.SETT FOR'D'
	.SETF PUB'D'
	.IFDF <PRIVIL>	.GOTO MOU005
	.IFT TAP'D'	.GOTO MOU010
	.TESTFILE 'S'[0,0]INDEXF.SYS
	.IF <FILERR> <> 1	.GOTO MOU010
	.SETT F11'D'
	.SETF FOR'D'
	.RETURN
.MOU005:.TESTDEVICE 'S'
	.TEST <EXSTRI> "ALO,"
	.IF <STRLEN> > 0	.GOTO MOU091
	.TEST <EXSTRI> "FOR,"
	.IF <STRLEN> > 0	.RETURN
	.TEST <EXSTRI> "MTD,"
	.IF <STRLEN> = 0	.GOTO MOU007
	.SETT F11'D'
	.SETF FOR'D'
	.RETURN
.MOU007:.TEST <EXSTRI> "PUB,"
	.IF <STRLEN> > 0	.SETT PUB'D'
.MOU010:.SETT DMO'D'
	.IF <SYSTEM> = 1	.IFNDF <PRIVIL>	.RETURN
	.IF <CLI> = "MCR"	MOU 'S'/FOR
	.IF <CLI> = "DCL"	MOUNT/FOR 'S'
	.IF <EXSTAT> = 1	.RETURN
	.GOTO MOU099
.MOU091:; Error -- Device 'S' is allocated to another terminal.
	.GOTO MOU099
.MOU099:.DEC INDEX
	.GOTO DMO
.;
.;
.;		DMO -- Dismount devices as necessary.
.;
.DMO010:
	.DEC INDEX
	.SETN D INDEX
	.IF <SYSTEM> = 1	.IFNDF <PRIVIL>		.GOTO DMO
	.IFF DMO'D'		.GOTO DMO

	.SETS S DEV'D'
	.SETS S1 ""
	.IFF PUB'D'	.GOTO DMO020
	.SETS S1 "/DEV"
	.IF <CLI> = "DCL"	.SETS S1 "/PUBLIC"
.DMO020:.IF <CLI> = "MCR"	DMO 'S''S1'
	.IF <CLI> = "DCL"	DISMOUNT'S1' 'S'
.DMO:
	.IF INDEX > 1	.GOTO DMO010
	.EXIT <EXSTAT>
