.;
.; This software is provided on an "as is" basis only. Caterpillar Tractor Co.,
.; disclaims  all  warranties on the program, including without limitation, all
.; implied warranties of merchantablity and fitness.
.;
.; Full  permission  and  consent  is  hereby  given  to DECUS and to the DECUS
.; special interest groups to reproduce,  distribute,  and  publish  and permit
.; others to reproduce in whole or in part, in any form and without restriction
.; this program and any information relating thereto
.;									 
.;
.;
.; Computerized Training Module for EDT Startup Command Files
.; 
.; Author:
.;	
.;	Rick Webster, Process Control Applications, MSDGO
.;	Caterpillar Tractor Co.
.;	
.; Date: 3/4/83
.;	
.;
.; Modifications:
.;
.;	None
.;
	.ENABLE SUBSTITUTION
	.DISABLE DISPLAY
	.ENABLE CONTROL-Z
	.ENABLE ESCAPE
	.SETN NESC 33
	;                      'NESC%V'[5m... One moment please'NESC%V'[m
	.SETN TIBUF <TICWID>
	.ENABLE QUIET
	SET /BUF=TI:255.	! Discourage TT driver from auto <CR><LF>
	.DISABLE QUIET
.;
.;	The following are escape sequences to put a VT100 into
.;	various modes:
.;
	.SETS NA "'NESC%V'[m"	! Set for no attributes
	.SETS BO "'NESC%V'[1m"	! Set for BOLD
	.SETS UN "'NESC%V'[4m"	! Set for UNDERLINE
	.SETS BL "'NESC%V'[5m"	! Set for BLINK
	.SETS RV "'NESC%V'[7m"	! Set for REVERSE video
	.SETS BRV "'NESC%V'[1;7m"	! Set for BOLD and REVERSE video
	.SETS CLS "'NESC%V'[2J"	! Clear screen
	.SETS HOME "'NESC%V'[3;1H"	! Position cursor to line 3, column 1
	.SETS DHT "'NESC%V'#3"	! Set double height, top half
	.SETS DHB "'NESC%V'#4"	! Set double height, bottom half
	.SETS SWD "'NESC%V'#5"	! Set for normal height and width
	.SETS DWD "'NESC%V'#6"	! Set for double wide
	.SETS GON "'NESC%V'(0"	! Enable special graphics char. set
	.SETS GOF "'NESC%V'(B"	! Disable special graphics
	.SETS ESC "'NESC%V'"
.;
.;
	.SETS DEV COMMAN
	.PARSE DEV " " DEV DUMMY
	.PARSE DEV "/" DEV DUMMY
	.PARSE DEV "." DEV EXT
	.IF EXT EQ "" .SETS EXT "CMD"
	.TESTFILE 'DEV'.'EXT'
	.PARSE <FILSPC> "]" DEVUIC TEMP
	.SETS DEVUIC DEVUIC+"]"
	.PARSE <UIC> "[,]" SDUM GRP OWN SDUM
	.TEST GRP
	.IF <STRLEN> EQ 1 .SETS GRP "00"+GRP
	.IF <STRLEN> EQ 2 .SETS GRP "0"+GRP
	.TEST OWN
	.IF <STRLEN> EQ 1 .SETS OWN "00"+OWN
	.IF <STRLEN> EQ 2 .SETS OWN "0"+OWN
	.TESTFILE '<SYDISK>''<SYUNIT>':[0,0]'GRP''OWN'.DIR
	.IF <FILERR> EQ 1 .GOTO UFDOK
	;
	;	Sorry there is no directory file for '<UIC>' on '<SYDISK>''<SYUNIT>': which is
	;	is your current default assignment. Temporary files are required
	;	for this class so please log to an area with a UFD.
	;
	.EXIT
.UFDOK:	.SETN PAGE 0.
	.INC PAGE
.PG1:
;'CLS''HOME''ESC'[?5l'NA''ESC'[?4h'ESC'[?3l'ESC'<'ESC'(B
;                                                                            
;                                                                            
;                                                                            
;'ESC'[1;55H'GON'lqqqqqqqqqqqqqqqqqqqqqqqk
;'ESC'[2;55H'GON'xCATERPILLAR TRACTOR CO.x
;'ESC'[3;55H'GON'mqqqqqqqqqqqqqqqqqqqqqqqj
;'ESC'[1;1H'GON'lqwqwqwqwqwqwqwqwqwqwqwqwqwqwqwqwqwqwqk
;     'ESC'[2;1HxMxSxDx xPxRxOxCxExSxSx xCxOxNxTxRxOxLx
;'ESC'[3;1H'GON'mqvqvqvqvqvqvqvqvqvqvqvqvqvqvqvqvqvqvqj'GOF'
;'ESC'[4;10H'BRV'Educational Services'NA'
;'ESC'[11;14H'DHT'Presents the
;'ESC'[12;14H'DHB'Presents the
.ENABLE QUIET
.DELAY 1S
.DISABLE QUIET
;'ESC'[11;38HE'ESC'[K'ESC'[12;38HE'ESC'[K'ESC'[11;36HE'ESC'[K'ESC'[12;36HE'ESC'[K
;'ESC'[11;34HE'ESC'[K'ESC'[12;34HE'ESC'[K'ESC'[11;32HE'ESC'[K'ESC'[12;32HE'ESC'[K
;'ESC'[11;30HE'ESC'[K'ESC'[12;30HE'ESC'[K'ESC'[11;28HE'ESC'[K'ESC'[12;28HE'ESC'[K
;'ESC'[11;26HE'ESC'[K'ESC'[12;26HE'ESC'[K'ESC'[11;24HE'ESC'[K'ESC'[12;24HE'ESC'[K
;'ESC'[11;22HE'ESC'[K'ESC'[12;22HE'ESC'[K'ESC'[11;20HE'ESC'[K'ESC'[12;20HE'ESC'[K
;'ESC'[11;18HE'ESC'[K'ESC'[12;18HE'ESC'[K'ESC'[11;16HE'ESC'[K'ESC'[12;16HE'ESC'[K
;'ESC'[11;14HE'ESC'[K'ESC'[12;14HE'ESC'[K'ESC'[11;12HE'ESC'[K'ESC'[12;12HE'ESC'[K
;'ESC'[11;10HE'ESC'[K'ESC'[12;10HE'ESC'[K'ESC'[11;38HD'ESC'[K'ESC'[12;38HD'ESC'[K
;'ESC'[11;36HD'ESC'[K'ESC'[12;36HD'ESC'[K'ESC'[11;34HD'ESC'[K'ESC'[12;34HD'ESC'[K
;'ESC'[11;32HD'ESC'[K'ESC'[12;32HD'ESC'[K'ESC'[11;30HD'ESC'[K'ESC'[12;30HD'ESC'[K
;'ESC'[11;28HD'ESC'[K'ESC'[12;28HD'ESC'[K'ESC'[11;26HD'ESC'[K'ESC'[12;26HD'ESC'[K
;'ESC'[11;24HD'ESC'[K'ESC'[12;24HD'ESC'[K'ESC'[11;22HD'ESC'[K'ESC'[12;22HD'ESC'[K
;'ESC'[11;20HD'ESC'[K'ESC'[12;20HD'ESC'[K'ESC'[11;18HD'ESC'[K'ESC'[12;18HD'ESC'[K
;'ESC'[11;16HD'ESC'[K'ESC'[12;16HD'ESC'[K'ESC'[11;14HD'ESC'[K'ESC'[12;14HD'ESC'[K
;'ESC'[11;12HD'ESC'[K'ESC'[12;12HD'ESC'[K'ESC'[11;11HD'ESC'[K'ESC'[12;11HD'ESC'[K
;'ESC'[11;38HT'ESC'[K'ESC'[12;38HT'ESC'[K'ESC'[11;36HT'ESC'[K'ESC'[12;36HT'ESC'[K
;'ESC'[11;34HT'ESC'[K'ESC'[12;34HT'ESC'[K'ESC'[11;32HT'ESC'[K'ESC'[12;32HT'ESC'[K
;'ESC'[11;30HT'ESC'[K'ESC'[12;30HT'ESC'[K'ESC'[11;28HT'ESC'[K'ESC'[12;28HT'ESC'[K
;'ESC'[11;26HT'ESC'[K'ESC'[12;26HT'ESC'[K'ESC'[11;24HT'ESC'[K'ESC'[12;24HT'ESC'[K
;'ESC'[11;22HT'ESC'[K'ESC'[12;22HT'ESC'[K'ESC'[11;20HT'ESC'[K'ESC'[12;20HT'ESC'[K
;'ESC'[11;18HT'ESC'[K'ESC'[12;18HT'ESC'[K'ESC'[11;16HT'ESC'[K'ESC'[12;16HT'ESC'[K
;'ESC'[11;14HT'ESC'[K'ESC'[12;14HT'ESC'[K'ESC'[11;12HT'ESC'[K'ESC'[12;12HT'ESC'[K
;'ESC'[10;8H'RV''DWD'                         'NA'
;'ESC'[11;8H'RV' 'NA' 'ESC'[11;14HInitializer Class 'RV' 'NA'
;'ESC'[12;8H'RV' 'NA' 'ESC'[12;14HInitializer Class 'RV' 'NA'
;'ESC'[13;8H'RV''DWD'                         'NA'
;'ESC'[11;14H'BO'I'NA'nitializer'ESC'[12;14H'BO'I'NA'nitializer
;'ESC'[11;14HI'BO'n'NA'itializer'ESC'[12;14HI'BO'n'NA'itializer
;'ESC'[11;14HIn'BO'i'NA'tializer'ESC'[12;14HIn'BO'i'NA'tializer
;'ESC'[11;14HIni'BO't'NA'ializer'ESC'[12;14HIni'BO't'NA'ializer
;'ESC'[11;14HInit'BO'i'NA'alizer'ESC'[12;14HInit'BO'i'NA'alizer
;'ESC'[11;14HIniti'BO'a'NA'lizer'ESC'[12;14HIniti'BO'a'NA'lizer
;'ESC'[11;14HInitia'BO'l'NA'izer'ESC'[12;14HInitia'BO'l'NA'izer
;'ESC'[11;14HInitial'BO'i'NA'zer'ESC'[12;14HInitial'BO'i'NA'zer
;'ESC'[11;14HInitiali'BO'z'NA'er'ESC'[12;14HInitiali'BO'z'NA'er
;'ESC'[11;14HInitializ'BO'e'NA'r'ESC'[12;14HInitializ'BO'e'NA'r
;'ESC'[11;14HInitialize'BO'r'NA''ESC'[12;14HInitialize'BO'r'NA'
;'ESC'[11;14HInitializer'ESC'[12;14HInitializer
.;
;'ESC'[16;21r'ESC'[;4h
;'ESC'[21;1H    
; 'GON'lqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqk
; 'GON'x'GOF'This software is provided on an "as is" basis only. Caterpillar Tractor Co.,'GON'x'GOF'
; 'GON'x'GOF'disclaims  all  warranties on the program, including without limitation, all'GON'x'GOF'
; 'GON'x'GOF'implied warranties of merchantablity and fitness.                           'GON'x'GOF'
; 'GON'mqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqj'GOF'
;'ESC'[1;24r
.ENABLE QUIET
.DELAY 1S
.DISABLE QUIET
;
.1STQ:
	.ASKS STEMP 'ESC'[23;1HPg. 'PAGE' 'RV'Enter RETURN for next page or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .GOTO 1STQ
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG2:
;'CLS''HOME'The  capability  of  EDT  to accept commands from a startup command file
;and the ability to define keys, provides a  powerful  extension  to  the
;wealth  of  stock  EDT  commands.  It  allows you to add new commands to
;EDT which are a combination of regular commands such that  only  one  or
;two keystrokes, replace a number of keystrokes. 
;
;Unfortunately  the  EDT  manual is at best, vague on techniques of using
;these features. This class is  an  attempt  to  clear  up  some  of  the
;mysteries  and  therefore promote the use of these capabilities. We will
;be using the EDTINI.EDT startup file provided on the MSDGEN distribution
;kit as a sample initializer file later in the tutorial.
;
;EDT  will  automatically use a startup file if it is in your default UIC
;and has the name EDTINI.EDT. If  you  want  some  other file to be used,
;then use the following command format:
;
;	EDT [<outfile>=]<infile>'BRV',<startup-file>'NA'
;
;Note: This tutorial is controlled by the following keys:     'UN''BRV'RETURN'NA' will
;advance 1 page, 'BRV'ESCAPE'NA' will backup one page, entering a 'BRV'page number'NA' will
;take you to that page and 'BRV'^Z'NA' will terminate the session.
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG3:
;'CLS''HOME'
;A 'BRV'startup command file'NA' lets you customize the editor to meet your needs.
;You can use it to do the following automatically when you invoke EDT:
;
; o Define Keys
; o Set options
; o Define 'BRV'macros'NA', which are sets of line editing commands that EDT
;   executes when you enter the name of the macro as a command
; o Define  'BRV'entities of text'NA',  which are character strings that EDT
;   recognizes as a unit
;
;With  a  startup  command file you could, for example, specify how many
;lines of a file EDT displays on your screen and how wide  you  want the
;display  of  text  to  be.  You can even define what functions you want
;certain keys to perform by redefining with the 'BRV'DEFINE KEY'NA' command.
;
;You  can  also document your startup file by adding comment lines which
;are lines that start with an exclamation point 'BRV'"!"'NA'.
;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG4:
;'CLS''HOME'
;Any line mode command can be used in your startup file. No-keypad change
;mode subcommands can also be used as follows:
;
;  C; <cmd-1> <cmd-2> ... <cmd-n> EX
;
;where  cmd-1 thru cmd-n are no-keypad editing commands. This must fit on
;one line.  The  'BRV'C;'NA'  temporarily  puts EDT in no-keypad change mode. Each
;no-keypad editing command can be  separated by zero or more spaces.  The
;'BRV'EX'NA'  returns  EDT  to line mode editing. If you forget to include the EX,
;you will get the error message:
;
;
;          Change mode may be entered only from the terminal
;
;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG5:
;'CLS''HOME'
;At  this  point  we  need to clear up any confusion on line mode commands vs.
;keypad change mode commands vs. nokeypad  change  mode  commands.  There  are 
;two methods of editing in EDT. The first is 'BRV'line mode'NA' which is a line by line
;editor.  Movement  through  the  buffer must be by 1 or more lines. The other
;method of editing is 'BRV'change mode'NA'.  There  in  turn  are  two  types of change
;mode  editing.  The  first one is  'BRV'keypad'NA'  editing which is the one primarily
;used and 'BRV'nokeypad'NA' editing which is probably the most confusing.
;
;Either type of change mode provides a full screen editor on VT100 and VT52's.
;'BRV'Keypad'NA' editing allows  movement  through  the  buffer through pre-defined (or
;redefined)  keys.  'BRV'Nokeypad'NA' editing is command driven rather than key driven.
;The cursor is moved through the buffer  by  various  nokeypad  commands (also
;known  as  change  mode  subcommands).  The  cursor will be positioned at the
;current location in the buffer until you  start  to  enter a command. At that
;time  the  cursor  will move to the bottom of the screen until the command is
;completed. Then it will go to the position indicated by the command.
;
;The  nokeypad change mode is the way that EDT version 1.0 handled full screen
;editing.
;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN to continue, or ESCAPE to backup 1 page'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG6:
;'CLS''HOME'
;One  may  wonder  why the nokeypad method of full screen editing was included
;since it is so cumbersome to use. In actuality, 'UN'keypad'NA' editing is implemented
;with  'UN'nokeypad'NA' commands. If you use the 'BRV'SH'NA'OW 'BRV'K'NA'EY command on any of the keypad
;keys, you will  see the  nokeypad  mode  sequence  of commands implemented by
;that  key.   For example the  SECTION key (keypad key 8) is defined as 'BRV'(16L.)'NA'
;which is the nokeypad command to move 16 lines in the current direction.
;
;Since  the  nokeypad  commands  implement  a command language to position the
;cursor to any character in the buffer,  it  makes  it possible to define keys
;to  do  sequences  of  commands  in  addition to the pre-defined keypad keys.
;Since this allows us to do character  editing  rather  than  line editing, it
;is  possible  to  do  character oriented functions such as word deletion, cut
;and paste, insertion of special characters, etc.
;
;
;
;
;
;
;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN to continue, or ESCAPE to backup 1 page'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG7:
;'CLS''HOME'
;For a complete description of the nokeypad commands, refer to chapter 8 in the
;"EDT Editor Manual".  The  following  will  show  the  general  format  of the
;commands and discuss some of the more common ones.
;
;Nokeypad  commands operate on 'BRV'entities'NA'. These represent a portion of text that
;will be affected  by  the  command.  A  repeat count can precede the entity to
;indicate how many of that entity will be affected. Examples of entities are:
;
;  'BRV'C'NA'  - single character at cursor           'BRV'W'NA'     - word at cursor position
;
;  'BRV'L'NA'  - single line containing cursor        
;
;  'BRV'BL'NA' - characters in line before         'BRV'''string'''NA' - all characters from cursor
;       cursor character                             to string
;
;  'BRV'EL'NA' - characters in line after and         'BRV'SR'NA'    - all characters in the  
;       including cursor character                   current select range
;
;  'BRV'BR'NA' - All characters in buffer             'BRV'ER'NA'    - All characters after and
;       before cursor character                      including cursor character
.;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN to continue, or ESCAPE to backup 1 page'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG8:
;'CLS''HOME'
;If  these  entities  are used without a subcommand then they are interpreted
;as a MOVE command. For example:
;
; 'UN''BRV'+3L'NA'		moves the cursor in the current direction, 3 lines
; 'UN''BRV'-4L+2W'NA'		moves back 4 lines and then to the third word in that line
; 'BRV'6V'NA'		V is the same as L except that the cursor will stay in the
;		same column. 6V moves in the current direction by 6 lines
;
;Examples of entities used with other nokeypad commands:
;
; 'UN''BRV'D'NA''UN''RV'L'NA'		delete line containing cursor
; 'BRV'D'NA''RV'3L'NA'		delete line containing cursor plus next 2 lines in current
;		direction
; 'UN''BRV'CHGC'NA''UN''RV'SR'NA'		change the case of all characters in select range
; 'UN''BRV'SEL'NA''UN''RV'-5C'NA'		puts the 5 chars. before cursor in select range
; 'BRV'CUT'NA''RV'''XYZ'''NA'	cut all chars. from cursor to string XYZ
;
;Again, refer to chapter 8 in the "EDT Editor Manual" for descriptions of all
;the  commands.  Now you should at least have a general idea of what is meant
;by nokeypad commands in the remaining discussions.
.;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN to continue, or ESCAPE to backup 1 page'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG9:
;'CLS''HOME'
;In addition to including line mode and nokeypad commands in the initializer,
;you  can  also  insert  text into the MAIN as well as create and add text to
;alternate buffers.  For  example,  if  you  wanted to insert the string 'BRV'TEST'NA'
;into the main buffer you could do it in one of the following ways:
;
;'UN'Method 1:'NA'
;
;	'UN''BRV'I'NA'			enter insert mode
;	'UN''BRV'TEST'NA'			text to be inserted
;	'BRV'^Z'NA'			exit insert mode, this is entered with the
;				two characters 'BRV'^'NA' and 'BRV'Z'NA'
;'UN'Method 2:'NA'
;
;	'BRV'I;TEST'NA'			this is a one line insert command
;
;Method 1 can have multiple lines of text but method 2 can also insert multiple
;lines of text as long as each line is preceded with 'BRV'I;'NA'.
;
;
;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG10:
;'CLS''HOME'Text can be inserted into an alternate buffer by doing the following:
;
;'UN'Method 1:'NA'
;
;	'UN''BRV'I=BUFF2'NA'			create and insert in buffer  'BRV'BUFF2'NA'
;	'UN''BRV'TEST'NA'			text to be inserted
;	'BRV'^Z'NA'			exit insert mode,   current buffer
;				is still 'BRV'BUFF2'NA'
;'UN'Method 2:'NA'
;
;	'BRV'F=BUFF2'NA'			Create and switch to buffer  'BRV'BUFF2'NA'
;				At this point either insert method
;				described on the previous page can
;				be used.
;
;If  you want to insert control or other non-printable characters, they can
;be included in the text to be inserted. However this should be avoided, if
;possible,  since  it will make your initializer file hard to read when you
;print it.  All  the  carriage  control characters will do carriage control
;(ie. formfeeds, linefeeds, carriage return, etc.)  instead of printing the
;way they appear in EDT (ie. <LF> for linefeed, <CR> for return, etc.)
.;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG11:
;'CLS''HOME'
;Another  way  to  insert  control  characters is to use the one line, no-keypad
;change mode as previously described.  For  example,  if  you  wanted  to insert
;escape  sequences  to  display  the  text on a VT100 as bold and then return to
;normal attributes, you could do the following:
;
;	C; 27ASC I[1mBold text^Z 27ASC I[m^Z EX
;
;The  'BRV'27ASC'NA'  is  a  no-keypad  mode  subcommand  to  insert  the character whose
;decimal value is 27 (octal 33, which is the escape character),  at  the current
;cursor  location.  The  'BRV'I'NA'  is a subcommand to insert text at the current cursor
;location. The text to be inserted after the ESC is 'BRV'[1mBold text'NA' and then insert
;mode is exited with the 'BRV'^Z'NA'. Another  ESC  is appended  followed by the text 'BRV'[m'NA'.
;Insert mode is terminated with 'BRV'^Z'NA' and change mode is exited with 'BRV'EX'NA'.
;
;In  this  case,  no  actual control characters are imbedded in the initializer 
;file (remember 'BRV'^Z'NA' is  two  characters,  the  circumflex  'BRV'^'NA' and a 'BRV'Z'NA'). Therefore
;when printed the command will appear the same as it does above. 
;
;Note  that  each  subcommand  is  separated  by a space. This is only done for
;readability and is not required.
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG12:
;'CLS''HOME'
;The most common use of insert mode in an intializer file is to create 'BRV'macros'NA'.
;The 'BRV'DEF'NA'INE 'BRV'M'NA'ACRO command will create a new text buffer if it does not already
;exist  and  add  the name of that buffer to EDT's list of line mode commands.
;You can set up a macro name to be  the  same as an existing line mode command
;but  then  that command is no longer available. This text buffer must contain
;one or more line mode editing commands  which  will  be executed whenever the
;buffer name  is  entered to the  EDT command prompt ('BRV' * 'NA' in line mode, 'BRV'GOLD 7'NA'
;in keypad change mode). Macros can be defined as follows:
;
;	'UN''BRV'DEF M NEWCMD'NA'		create buffer 'BRV'NEWCMD'NA' and define it as a macro
;	'UN''BRV'F=NEWCMD'NA'		switch editing to that buffer
;	'UN''BRV'I'NA'			go into insert mode
;	'UN''BRV'command 1'NA'		one or
;	    'UN''BRV''GON'~'GOF''NA'			   more line
;	    'UN''BRV''GON'~'GOF''NA'			      mode
;	'UN''BRV'command n'NA'		       commands
;	'BRV'^Z'NA'			exit insert mode
;
;Now any time the command 'BRV'NEWCMD'NA' is entered, all the line mode commands in
;the buffer will be executed.
.;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG13:
;'CLS''HOME'
;Macros  are often used in conjunction with a redefined key. The 'BRV'DEF'NA'INE 'BRV'K'NA'EY
;command requires that  all the commands  fit on one line. If a function is
;too  complex  to define in one line, a macro must be used. For example, if
;we want 'BRV'GOLD N'NA' to cause the commands in the 'BRV'NEWCMD'NA' buffer from the example
;on the previous page we would do the following:
;
;	1) Define 'BRV'NEWCMD'NA' to be a macro as on previous page
;
;	2) Use the 'BRV'DEF'NA'INE 'BRV'K'NA'EY command to redefine 'BRV'GOLD N'NA' as follows:
;
;		DEF K GOLD N AS "EXT NEWCMD."
;
;Now anytime 'BRV'GOLD N'NA' is entered, the commands in the alternate buffer 'BRV'NEWCMD'NA'
;will be executed.
;
;
;
;
;
;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG14:
;'CLS''HOME'
;			      'BRV'Redefining Keys'NA'
;
;Since one of the most common uses of the initializer file is to redefine keys,
;we will now digress somewhat and describe the 'BRV'DEF'NA'INE 'BRV'K'NA'EY command.
;
;All  of  the  keypad  keys  and several keyboard and control keys are assigned
;specific functions in EDT. These are actually  'UN'pre-redefined'NA' keys and they are
;only  accessable  in  'UN'keypad'NA'  mode  editing.  The same is true for any key you
;redefine.
;
;Keypad  editing  functions  are  based  on  'UN'nokeypad'NA'  mode  commands. When you
;redefine a key,  you  are  really assigning  one  or  more  nokeypad  commands
;to the key.
;
;You can redefine all keypad keys (except 'BRV'GOLD'NA') and several of the keyboard and
;control keys.
;
;Each  of these keys has a string of characters associated with it that defines
;the functions  of the key.  This string consists of nokeypad editing commands.
;For example the 'BRV'OPEN LINE'NA' key, 'BRV'GOLD 0'NA' is 'BRV'(^M-C).'NA'.
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG15:
;'CLS''HOME'When you define keys, the following rules apply:
;
;	1) A string can contain multiple commands.
;
;	2) A string ending in a period is executed immediately when you strike
;	   the key associated with that string.
;
;	3) If the string does not end in a period, EDT buffers it until you do
;	   enter  a  command  that  does end with a period (one of the regular
;	   keypad commands for example ).  At  that  time,  all  the  buffered
;	   commands will be executed.
;
;	4) A string can  contain a question mark. The 'BRV' ? 'NA' followed by a quoted
;	   string  causes that  string  to be used as a prompt for input. This
;	   string must be enclosed in  single 'BRV' '' 'NA' or double 'BRV' " 'NA' quotes. A user
;	   can then enter up to 64 characters in response to the prompt.
;
;	5) If  you  want  the  key to be able to use a repeat count, you  must 
;	   enclose the entire definition  except  the  terminating  period, in
;	   parentheses  otherwise  only  the  first  nokeypad  command  in the
;	   definition, will be repeated.
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG16:
;'CLS''HOME'
;'BRV'DEF'NA'INE 'BRV'K'NA'EY is a line editing command that enables you to redefine keys in
;terms of nokeypad mode commands. Its format is:
;
;	'BRV'DEF'NA'INE 'BRV'K'NA'EY key-selector 'BRV'AS'NA' "string"
;
;where  'BRV'"string"'NA' refers to one or more nokeypad mode commands that you use
;to redefine the  key  and  'BRV''UN'key-selector'NA'  is one of, 'BRV'number'NA' , 'BRV'GOLD number'NA', 
;'BRV'CONTROL letter'NA' , 'BRV'GOLD CONTROL letter'NA' or 'BRV'GOLD letter'NA'.
;
;     o 'BRV'number'NA' is the number of the selected keypad key (See next page).
;
;     o 'BRV'CONTROL letter'NA' means that you enter 'UN'CONTROL'NA' followed by a keyboard
;       character from A to Z. Lower case is interpreted as the upper case 
;       equivalent.
;
;     o 'BRV'GOLD'NA' refers to the GOLD keypad key
;
;     o 'BRV''UN'GOLD  character'NA'  means that you enter 'UN'GOLD'NA' and any of the keyboard 
;       keys except 'BRV'0-9'NA' , 'BRV'!'NA' , 'BRV'%'NA' , 'BRV''''NA' , and  'BRV'"'NA' . You can specify the 'BRV'DELETE'NA'
;       key by using the reserved word 'UN'DELETE'NA'.
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG17:
;'CLS''HOME'When defining keys using 'BRV'number'NA' or 'BRV'GOLD number'NA', number refers to one of the
;keypad  keys  or  one of the four cursor position keys. On a VT100 the keys
;are defined as follows:
;'GON'
;          lqqqqwqqqqwqqqqwqqqqk       lqqqqwqqqqwqqqqwqqqqk
;          x 12 x 13 x 15 x 14 x       xGOLDx 10 x 11 x 17 x
;          mqqqqvqqqqvqqqqvqqqqj       tqqqqnqqqqnqqqqnqqqqu
;               'GOF''BRV'Cursor Keys'NA''GON'            x  7 x  8 x  9 x 18 x
;                                      tqqqqnqqqqnqqqqnqqqqu
;                                      x  4 x  5 x  6 x 19 x
;                                      tqqqqnqqqqnqqqqnqqqqu
;                                      x  1 x  2 x  3 x    x
;                                      tqqqqvqqqqnqqqqu 21 x
;                                      x    0    x 16 x    x
;                                      mqqqqqqqqqvqqqqvqqqqj'GOF'
;                                           'BRV'Keypad keys'NA'
;
;
;
;
;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG18:
;'CLS''HOME'
;As  an  example  of  redefining  a  key we will enhance the function of the
;'BRV'Special Insert'NA' , 'BRV'GOLD 3'NA' key.   This key is  used  to  insert  non-printable
;characters, 'GON'd , e , c'GOF'  etc.  into your file. To use this key you must enter
;'BRV'GOLD number GOLD 3'NA'  where  number  is the decimal value of the character to
;be inserted (ie. 13 for 'GON'd'GOF' , 10 for 'GON'e'GOF' , etc.).   If  we  wanted  to redefine
;'BRV'Special Insert'NA'  to  prompt  for  the  decimal value when 'BRV'GOLD 3'NA' is entered,
;we could redefine the key as follows (Note that parentheses enable a repeat
;count to be specified, with 'BRV'GOLD number'NA' before the defined key is struck):
;
;	DEF K GOLD 3 AS "(?''Enter decimal value > ''ASC)."
;
;If we wanted to leave 'BRV'GOLD 3'NA' unchanged but define some other key as having
;this  function,  we  could  use  for  example  'BRV'GOLD CONTROL X'NA' or 'BRV'GOLD X'NA' or 
;just 'BRV'CONTROL X'NA' with the following define key commands:
;
;	DEF K GOLD CONT X AS "(?''Enter decimal value > ''ASC)."
;
;	DEF K GOLD X AS "(?''Enter decimal value > ''ASC)."
;
;	DEF K CONT X AS "(?''Enter decimal value > ''ASC)."
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG19:
;'CLS''HOME'
;In  most  cases,  you  will  probably terminate your key definitions with a
;period to cause EDT to execute the associated nokeypad commands immediately
;when you press that key.  The  following  example  will  illustrate why you
;may want to define a key that is not executed immediately.
;
;Suppose  you  wanted  to  redefine the PAGE key, keypad key 7, such that it
;is a general purpose delete key defined as follows:
;
;	DEF K 7 AS "+D"
;
;Since  it is not terminated with a period, EDT will not execute the command
;until you strike a key whose  definition does end with a period.  If we now
;press  keypad  key 0, 'BRV'LINE'NA', we will delete a line. Keypad key 3, 'BRV'CHARACTER'NA',
;will delete 1 character, while keypad key 1, 'BRV'WORD'NA', will delete a word.
;
;
;
;
;
;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG20:
.;
.;Note: the page reference on the last page must be changed if this page 
.;number is changed from 20
.;
;'CLS''HOME'
;So far this tutorial has been driven by an indirect command file. Most of the
;remainder will be driven by EDT itself. We will be taking a look at an actual
;EDT initializer file.  The  tutorial  text will describe the function of each
;line  in the initializer file. Although the commands created by this file may
;or may not be of use to you,  understanding  the techniques used to implement 
;them will  allow you to create initializer files to do many otherwise tedious
;or time consuming operations for you.
;
;EDT  will  be accessing the explanatory text file with /RO, read only access.
;So if you like,  you can try out each new function as it is explained.  Don''t
;worry about putting garbage into the file.  If  it becomes too corrupted, you
;can  always  exit EDT with GOLD 7 and then QUIT to the Command: prompt or use
;the redefined key GOLD Q.
;
;'BL'Note:'NA'  Unfortunately  we can not use 'BRV'RETURN'NA' and 'BRV'ESCAPE'NA' to go forward and back
;pages in EDT.  These  functions  are  implemented with 'BRV'LINEFEED'NA' to go forward
;and  'BRV'GOLD LINEFEED'NA'  to  go  back one page.  If  you are continuing a previous
;session  and  you  know  what  page  you  were on, use 'BRV'GOLD P'NA' and you will be
;prompted for a page number (remember to use 'BRV'ENTER'NA' instead of 'BRV'RETURN'NA')
;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO RUNEDT
	.IFF <NUMBER> .GOTO RUNEDT
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.RUNEDT:.TESTFILE TI:
	.PARSE <FILSPC> "T:" DUMMY TT DUMMY
	;                      'BL'... One moment please'NA'
	.TESTFILE 'DEVUIC'EDTINICLS.SAM
	.IF <FILERR> EQ 1 .GOTO REDT1
	.SETS SYSDEV <SYDISK>+"'<SYUNIT>'"+":"
	.SETS UIC <UIC>
	;'CLS''HOME'
	;
	;
	;
	;	'DEVUIC'EDTINICLS.SAM does not exist, it is needed for
	;	this portion of the tutorial, please use another terminal
	;	and log to 'DEVUIC' and execute @EDTINISAM.CMD to create it.
	;
	;	The tutorial will now pause to allow you to do this.
	;
	;
	.PAUSE
	ASN 'SYSDEV'=SY:
	SET /UIC='UIC'
	.DEC PAGE
	.GOTO PG'PAGE'
.REDT1:	.OPEN T.EDT
	.SETS INIFIL <FILSPC>
	.DATA F=EDTINI
	.DATA INC 'DEVUIC'EDTINICLS.SAM
	.DATA DEF MACRO EDTINI
	.DATA EDTINI
	.DATA F=EDTINI_RESTORE
	.DATA %E
	.DISABLE SUBSTITUTION
	.DATA I;C;ADVL-'[Page'TOPEL
	.DATA F =MAIN
	.DATA DEF KEY GOLD CONTROL J AS "+L BACK '[Page ' '' ADV TOP EL."
	.DATA DEF KEY CONT J AS "ADV L '[Page 'TOP EL."
	.DATA DEF KEY GOLD P AS "ADV BR '[Page ?'Page number > '' TOP EL."
	.DATA C; EL EX
	.DATA SE M C
	.DATA SE CU 0:21
	.ENABLE SUBSTITUTION
	.CLOSE
	.ENABLE QUIET
	INS $EDT/TASK=EDT'TT'/CMD=" 'DEVUIC'EDTINICLS.DAT/RO,T.EDT"
	PIP 'INIFIL'/DE
	.DISABLE QUIET
.PG21:
;'CLS''HOME'
;At  this  time  we  will describe the initializer file used to conduct  the
;EDT portion of the tutorial.
;
;'BRV'LINEFEED'NA' was redefined to:
;
;DEF K CONTROL J AS "ADV L ''[Page ''TOP EL."
;
;'BRV'ADV'NA' assures that the current direction is forward. Each page of the tutorial
;is  identified  with the string 'UN''BRV'[Page 'NA'. The 'BRV'L'NA' command makes sure that we are
;not presently positioned  at  the  'BRV'[Page 'NA' for the current page. The 'UN''BRV'''[Page '''NA'
;will  position  the  cursor  to  the next occurrence of that string. The 'BRV'TOP'NA'
;command will force that line to the  top of the screen and the 'BRV'EL'NA' will force
;the  cursor  to  the  end  of  that  line to make it look like you are being 
;prompted.
;
;
;
;
;
;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG22:
;'CLS''HOME'
;'BRV'GOLD LINEFEED'NA' was redefined as:
;
;DEF K GOLD CONTROL J AS "+L BACK ''[Page '' '''' ADV TOP EL."
;
;'BRV'+L'NA'  advances 1 line to insure that we are not at the 'UN''BRV'[Page 'NA' for the current 
;page. 'BRV'BACK'NA' sets the current direction to backward. The 'BRV'''[Page '''NA' locates the 
;previous  occurrence of that string which should be the one for the current 
;page.  The 'BRV''''''NA' is the nokeypad 'BRV'FIND NEXT'NA' command and should locate the [Page  
;of  the  previous page. 'BRV'ADV'NA' resets the current direction to forward and 'BRV'TOP'NA'
;makes the page header just located,   the  top line on the screen. 'BRV'EL'NA' again 
;makes it look like we are being prompted.
;
;
;
;
;
;
;
;
;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG23:
;'CLS''HOME'
;'BRV'GOLD P'NA' was redefined to allow you to go to specific pages as follows:
;
;DEF K GOLD P AS "ADV BR ''[Page ?''Page number > '''' TOP EL."
;
;'BRV'ADV'NA'  makes sure the current direction is forward and the 'BRV'BR'NA' command sets the
;current  position  to  the  top  of  the  buffer.   A  search for the string 
;'BRV'[Page page-number'NA'  is  then  conducted  where  page-number  is  the response
;you  entered  to the 'BRV'Page number > 'NA' prompt. When that line is found, the 'BRV'TOP'NA'
;command makes that page header the top line on the screen and 'BRV'EL'NA' again makes
;it look like you are being prompted.
;
;The  initializer  also  contains  the  command 'BRV'C; EL EX'NA'. This will cause the
;cursor to position to the end  of  the  first line, which is the page header
;for the first page, when EDT is first initiated.
;
;The  command  'BRV'SET CURSOR 0:21'NA'  is used to eliminate any scrolling unless the
;cursor is moved past the top or bottom line of each page displayed.
;
;
;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG24:
;'CLS''HOME'
;Finally,  it  was  necessary  to  make  the initializer file that was being 
;described available during the session so that you would be able to try out
;the  redefined  keys  as they were explained. To do this would require that
;both initializers be used at the same time.  Since  EDT  does not provide a
;standard  means  of  doing  this,  the  following  was done in the tutorial
;initializer:
;
;   'UN''BRV'F=EDTINI'NA'		create and switch to alternate buffer 'BRV'EDTINI'NA'
;   'UN''BRV'INC EDTINI.EDT'NA'	include sample initializer into this buffer
;   'UN''BRV'DEF MACRO EDTINI'NA'	define the buffer as a macro
;   'UN''BRV'EDTINI'NA'		execute the macro
;   'BRV'F =MAIN'NA'		return to main buffer
;
;This in effect causes both initializers to be executed during EDT start up.
;A  side  benefit  is that the sample initializer can be examined during the
;tutorial by merely making the EDTINI buffer the current buffer.
;
;
;
;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG25:
;'CLS''HOME'
;One  final  comment  on  initializer  files. Since 'BRV'EXIT'NA' is a valid line mode
;command, it is possible to create  an  initializer  file  that  will perform
;mass  edits  on  a  file  and  then exit automatically. If you have a number
;of similar files to be edited,  an  indirect  command  file  can  be created
;to  perform  the  edits  without any intervention. The 'BRV'/CM'NA' switch in the 'BRV'SRD'NA'
;utility distributed on the MSDGEN distribution kit makes this very simple.
;
;For  example,  lets  consider the case where we have a global symbol that we
;want to change from 'BRV'$XYZ'NA' to 'BRV'$ABC'NA'  in  all the .MAC files in the current UIC. 
;Create the file EDTINI.EDT in the current UIC with the following two lines:
;
;	S/$XYZ/$ABC/WH
;	EX
;
;If  you  have SRD, use the command 'UN''BRV'SRD MASSCHG.CMD=*.MAC/CM:EDT:T'NA'. This will 
;put in file MASSCHG.CMD,  lines  of the form 'UN''BRV'EDT file.MAC'NA' for each .MAC file 
;in the current UIC. If you then enter 'BRV'@MASSCHG'NA', new versions of all the .MAC 
;files  will  be  created with the desired change. (See SRD documentation for 
;more information on the /CM switch).
;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG26:
;'CLS''HOME'
;This  now  concludes  the  EDT initializer tutorial. If you would like to
;terminate the session, just enter  'BRV'RETURN'NA'.  If  you  would like to repeat
;the  portion  of this tutorial that was conducted by EDT, on the detailed
;explanation of the sample initializer file, enter page 20.
;
;In  either  case,  thank you for your time. It is hoped that you now have
;enough knowledge of the workings of initializer files to use them to your
;advantage.
;
;
;
;
;
;
;
;
;
;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN to exit, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG27:
	;'CLS''HOME'
	;     'ESC'[10;8H'RV''DWD'                         'NA'
	;'DHT' 'ESC'[11;8H'RV' 'NA' EDT Initializer Class 'RV' 'NA'
	;'DHB' 'ESC'[12;8H'RV' 'NA' EDT Initializer Class 'RV' 'NA'
	;'DHT' 'ESC'[13;8H'RV' 'NA'   *** Completed ***   'RV' 'NA'
	;'DHB' 'ESC'[14;8H'RV' 'NA'   *** Completed ***   'RV' 'NA'
	;     'ESC'[15;8H'RV''DWD'                         'NA'
	;
	.ENABLE QUIET
	SET /BUF=TI:'TIBUF'.
	.EXIT
.CTRLZ:
	.ASK Q 'ESC'[23;1H'ESC'[K'BRV''BL'Are you sure you want to quit'NA' 
	.IFF Q .GOTO PG'PAGE'
	;'CLS''HOME'
	;     'ESC'[10;8H'RV''DWD'                         'NA'
	;'DHT' 'ESC'[11;8H'RV' 'NA' EDT Initializer Class 'RV' 'NA'
	;'DHB' 'ESC'[12;8H'RV' 'NA' EDT Initializer Class 'RV' 'NA'
	;'DHT' 'ESC'[13;8H'RV' 'NA'  *** Terminated ***   'RV' 'NA'
	;'DHB' 'ESC'[14;8H'RV' 'NA'  *** Terminated ***   'RV' 'NA'
	;     'ESC'[15;8H'RV''DWD'                         'NA'
	;
	.ENABLE QUIET
	SET /BUF=TI:'TIBUF'.
	.EXIT
.INVPG:	
	.ASKS STEMP 'ESC'[23;1H'ESC'[K'BRV''BL'Invalid page number ('PAGE'), Enter RETURN to continue'NA' 
	.SETN PAGE PGSAV
	.GOTO PG'PAGE'
	.;
;'CLS''HOME'
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
	.ASKS STEMP 'ESC'[1;1HPg. 'PAGE' 'RV'Enter RETURN for next page, ESCAPE for previous page, or page number'NA' 
	.IFT <EOF> .GOTO CTRLZ
	.IFT <ESCAPE> .DEC PAGE
	.IFT <ESCAPE> .GOTO PG'PAGE'
	.INC PAGE
	.IFT <DEFAUL> .GOTO PG'PAGE'
	.IFF <NUMBER> .GOTO PG'PAGE'
	.ONERR INVPG
	.SETN PGSAV PAGE-1.
	.SETN PAGE 'STEMP'.
	.GOTO PG'PAGE'
.PG:
