.;									 
.;******************************************************************************
.;
.; This software is provided on an "as is" basis only. Caterpillar Tractor Co.,
.; disclaims  all  warranties on the program, including without limitation, all
.; implied warranties of merchantablity and fitness.
.;
.; Full  permission  and  consent  is  hereby  given  to DECUS and to the DECUS
.; special interest groups to reproduce,  distribute,  and  publish  and permit
.; others to reproduce in whole or in part, in any form and without restriction
.; this program and any information relating thereto
.;
.;******************************************************************************
.;
.; Author:
.; 
.; 	Rick Webster, Process Control Applications, MSDGO
.; 	Caterpillar Tractor Co.
.; 
.; Description:
.; 
.; 	This command file is used in conjunction with the command files
.; 	CONFIG1.CMD and CONFIG2.CMD. It is used to give a sysgen-like
.; 	listing of a saved answer file. The output looks similar to the
.; 	SYSGEN printout when the saved answer file was originally created.
.; 
.; Usage:
.; 
.;	The command files must be on the current default device and UIC
.;	to function properly but the input saved answer file can be anywhere.
.;	
.;	
.; 	>@CONFIG saved-answer-file output-file
.;	
.;	where:	saved-answer-file	is the name of your save answer file
.;		output-file		is the name of the file to contain the
.;					sysgen listing (Default is TI:)
.;	
.;	If either are un-specified on the command line, you will be prompted 
.;	for them. If output is directed to a file, it will also be printed on 
.;	TI:
.;	
.;	The output will contain the appropriate SYSGEN question with the
.;	response that is in the saved answer file along with the appropriate
.;	symbol name used in the saved answer file
.;	
.;	
.; 
.; 
.; 
.; 
.; 
.ENABLE SUBSTITUTION
.ENABLE GLOBAL
.00000A:
.; 
.;CONFIG list file
.;
.SETF $TTCFG
.SETS CFGFIL "TI:"
.IF P2 NE "" .SETS CFGFIL P2
.IF P2 EQ "" .ASKS [::"TI:"] CFGFIL  8A. Name of configuration listing file 
.PARSE CFGFIL ";" CFGFIL VER
.PARSE CFGFIL "." CFGFIL EXT
.IF EXT EQ "" .SETS EXT "CFG"
.TESTFILE 'CFGFIL'.'EXT';'VER'
.IF <FILERR> EQ 1 .GOTO 00000B
.IF <FILERR> EQ 346 .GOTO 00000B
.IF VER NE "" .SETS VER ";'VER'"
;
;  CONFIG -- File specification error on 'CFGFIL'.'EXT''VER' -- RETRY.
;
.SETS P2 ""
.GOTO 00000A
.00000B:
.OPEN #3 'CFGFIL'.'EXT';'VER'
.SETS CHGFIL <FILSPC>
.SETS STEMP CHGFIL[1:2]
.IF STEMP EQ "TT" .SETT $TTCFG
.DATA #3 ;
.DATA #3 ;        ===========================================================
.DATA #3 ;        =  ***  C O N F I G . C M D  *** Saved answer file lister =
.DATA #3 ;        ===========================================================
.DATA #3 ;
.IFF $TTCFG ;
.IFF $TTCFG ;        ===========================================================
.IFF $TTCFG ;        =  ***  C O N F I G . C M D  *** Saved answer file lister =
.IFF $TTCFG ;        ===========================================================
.IFF $TTCFG ;
.IFNDF $PHAS1 .SETS $PHAS1 ""
.SETS $PHAS1 $PHAS1+"1.53"
.SETN $BASEL 32.
.SETS $BLREV "  "	! INTERIM BASELEVEL
.SETS $CUIC <UIC>
.TEST <UIC>
.SETS $DFUIC <UIC>[2:<STRLEN>-1]
.IFNDF $SGNUC .SETS $SGNUC <UIC>[2:<STRLEN>-1]
.SETT $SGN1
.SETF $SGN2
.SETF $CS1
.SETF $CS2
.IFNDF $UIC .SETN $UIC 11
.IFNDF $SYGRP .SETN $SYGRP 1
.IFNDF $IAS .SETF $IAS
.IFNDF $SYBLD .SETF $SYBLD
.IFT $SYBLD .SETT $MCR
.IFNDF $11SGN .SETF $11SGN
.IFT $11SGN .OR .IFT $SYBLD .SETT $XXX1
.IFNDF $XXX1 .SETF $XXX1
.IFNDF $MPLUS .SETF $MPLUS
.SETN $ICLOC 0
.SETN $IPLOC 0
.SETN $UDLOC 0
.SETN $ISLOC 0
.SETF $ABORT
.SETF $XXX2
.SETT $ONL
.IFNDF <BASLIN> .GOTO 0
.IFT <BASLIN> .SETF $ONL
.0:.DATA #3 ;
.IFF $TTCFG ;
.; 
.;INPUT SAVED ANSWERS
.;
.SETS $SAI "SYSSAVED.CMD"
.SETT $SAVED
.TESTFILE SYSSAVED.CMD
.SETS TEMPS ""
.IF <FILERR> EQ 1 .SETS TEMPS " [D: SYSSAVED.CMD]"
.IF P1 NE "" .SETS $SAI P1
.IF P1 EQ "" .ASKS $SAI  8. Name of input saved answer file'TEMPS'
.IF P1 EQ "" .IF <FILERR> EQ 1 .IF $SAI EQ "" .SETS $SAI "SYSSAVED.CMD"
.PARSE $SAI ";" $SAI VER
.PARSE $SAI "." $SAI EXT
.IF EXT EQ "" .SETS EXT "CMD"
.TESTFILE '$SAI'.'EXT';'VER'
.IF <FILERR> EQ 1 .SETS $SAI <FILSPC>
.IF <FILERR> EQ 1 .GOTO 0000A
.IF VER NE "" .SETS VER ";'VER'"
;
;  CONFIG -- Input saved answer file '$SAI'.'EXT''VER' does not exist -- RETRY.
;
.SETS P1 ""
.GOTO 0
.0000A:
.IFT $11SGN .GOTO SGEN
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ; RSX-11M V4.0 BL'$BASEL''$BLREV' System Generation PHASE I -- version '$PHAS1'
.IFF $TTCFG ; RSX-11M V4.0 BL'$BASEL''$BLREV' System Generation PHASE I -- version '$PHAS1'
.DATA #3 ;
.IFF $TTCFG ;
.IFF $IAS .DATA #3 ; '<DATE>' '<TIME>'
.IFF $TTCFG ; '<DATE>' '<TIME>'
.IFT $IAS TIM
.SGEN: .;.ONERR 99900
.ENABLE GLOBAL
.SETF REPEAT
.;
.;KIT TYPE
.;
.SETT $BGDSK
.SETF $RK06
.SETF $RL
.SETF $2RK
.IFNDF $2RK .SETF $2RK
.IFT $2RK .SETS $KIT "Dual RK05"
.IFNDF $BGDSK .SETT $BGDSK
.IFT  $BGDSK .SETS $KIT "Big disk"
.IFNDF $RK06 .SETF $RK06
.IFT $RK06 .SETS $KIT "RK06"
.IFNDF $RL .SETF $RL
.IFT $RL .SETS $KIT "RL01"
.DATA #3 ; '$KIT' distribution kit
.IFF $TTCFG ; '$KIT' distribution kit
.DATA #3 ;
.IFF $TTCFG ;
.;
.; DETERMINE IF LARGE ENOUGH INDIRECT COMMAND PROCESSOR
.;
.IFNDF <CONFIG> .GOTO 00A
.TEST <CONFIG>
.SETS TEMPS <CONFIG>[4:4]
.IF TEMPS EQ "4" .GOTO 00A
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;   CONFIG -- Procedure can only be executed under the ICP.TSK version of the
.IFF $TTCFG ;   CONFIG -- Procedure can only be executed under the ICP.TSK version of the
.DATA #3 ;	       Indirect Command Processor.
.IFF $TTCFG ;	       Indirect Command Processor.
.DATA #3 ;
.IFF $TTCFG ;
/
.00A:.DISABLE LOWERCASE
.;
.;DETERMINE CLI
.;
.SETF $MCR
.IF <CLI> EQ "DCL" .OR .IF <CLI> EQ "MCR" .GOTO 0A
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;   CONFIG -- Procedure can only be run from MCR or DCL
.IFF $TTCFG ;   CONFIG -- Procedure can only be run from MCR or DCL
.DATA #3 ;
.IFF $TTCFG ;
/
.0A: .IF <CLI> EQ "MCR" .SETT $MCR
.IFT $MCR .GOTO 0B
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ; Setting the CLI to MCR
.IFF $TTCFG ; Setting the CLI to MCR
.DATA #3 ;
.IFF $TTCFG ;
SET TERM MCR
.DATA #3 ;
.IFF $TTCFG ;
.0B:
.;
.;GENERATING A MAPPED SYS?
.;
.0C:.SETT $MAP
.SET'$MAP' MAP
.1:.SETF DEL
.SETN $GRP 0
.IFT MAP .SETN $GRP 4
.1A:.SETS CSGRP "0"
.IFT <MAPPED> .SETS CSGRP "4"
.SETN OSGRP 4
.IFT <MAPPED> .SETN OSGRP 0
.3:
.4:
.5:.IFNDF $FFE .SETF $FFE
.;
.;INVOKE THE SAVED ANSWER FILE
.;
.OPEN NL:
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ; Phase I input saved answers
.IFF $TTCFG ; Phase I input saved answers
@'$SAI'
.CLOSE
.DATA #3 ; are from file '$SAI'
.IFF $TTCFG ; are from file '$SAI'
.DATA #3 ;
.IFF $TTCFG ;
.IFNDF $MAP .GOTO 6
.IFT MAP .IFT $MAP .GOTO 6
.IFF MAP .IFF $MAP .GOTO 6
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;   CONFIG -- Mapping option of the input saved answer file is different
.IFF $TTCFG ;   CONFIG -- Mapping option of the input saved answer file is different
.DATA #3 ;	       from the mapping option selected in question 5.
.IFF $TTCFG ;	       from the mapping option selected in question 5.
.DATA #3 ;
.IFF $TTCFG ;
/
.6:.IFF $CS1 .DATA #3 ;
.IFF $CS1 .IFF $TTCFG ;
.IFF $CS1 .DATA #3 ;  CONFIG -- Warning:  Input saved answers for PHASE I may be incomplete.
.IFF $CS1 .IFF $TTCFG ;  CONFIG -- Warning:  Input saved answers for PHASE I may be incomplete.
.IFF $CS1 .DATA #3 ;
.IFF $CS1 .IFF $TTCFG ;
.7:.SET'MAP' $MAP
.IFT $CS2 .GOTO 101A
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;   CONFIG --  Warning:  Input saved answers for PHASE II may be incomplete.
.IFF $TTCFG ;   CONFIG --  Warning:  Input saved answers for PHASE II may be incomplete.
.DATA #3 ;
.IFF $TTCFG ;
.101A:.IFNDF $XXX2 .SETF $XXX2
.;
.;DETERMINE EXECUTIVE-TYPE OPTIONS
.;
.3001:
@['$SGNUC']CONFIG1
.DATA #3 ; End of Executive option generation
.IFF $TTCFG ; End of Executive option generation
.;
.; PROCESS PERIPHERAL RELATED ANSWERS
.;
@['$SGNUC']CONFIG2
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;                    ==================================
.IFF $TTCFG ;                    ==================================
.DATA #3 ;                    =  ***  C O N F I G . C M D  *** =
.IFF $TTCFG ;                    =  ***  C O N F I G . C M D  *** =
.DATA #3 ;                    =              End               =
.IFF $TTCFG ;                    =              End               =
.DATA #3 ;                    ==================================
.IFF $TTCFG ;                    ==================================
.DATA #3 ;
.IFF $TTCFG ;
.CLOSE #3

