.;
.; INCBACKUP.CMD -- Command file driver for daily incremental disk backup
.;		    using the BACBRU utility.
.;
.; Author:	G. L. Maxwell
.;		U. S. Geological Survey
.;		345 Middlefield Road Mailstop 77
.;		Menlo Park, CA 94025
.;
.; Date:	2-Feb-83
.;
.; Modifications:
.;
.;	8-Mar-83	G. L. Maxwell
.;			Change default batch resubmission time to 4:00 A.M.
.;
.; Operating system: RSX-11M-Plus V2.0, V2.1 (with Batch support)
.;
.; Usage:
.;
.;       @INCBACKUP /ddn:/control_file/logfile_spec/next_time/XYZZY
.;
.; where all arguments except the last are optional (but "/" must be there!)
.; and where:
.;
.;  ddn:	 Is the specification for the tape drive to use for
.;		 the backup operation. Default: MM0:
.;
.;  control_file Is the name of the control file specifying each
.;		 disk device to be backed up as well as the starting
.;		 time for file inclusion in the backup operation.
.;		 Default: SY:[current_uic]INCBACKUP.CNF
.;
.;  logfile_spec Is the device and UIC specification for the log file
.;		 produced by the BACBRU program. Note that the actual
.;		 name of this file is governed by the current month,
.;		 year, and the disk device being backed up.
.;		 Default: SY:[current_uic]DDnnmmmyy.LOG, where "DDnn"
.;               is the device being backed up, "mmm" is the current
.;		 month, and "yy" is the current year.
.;
.;  next_time	 Is the date and/or time at which the next backup
.;		 job is to be initiated by the Batch processor.
.;		 The format to use to specify the time is
.;		     "hh:mm:dd-mmm-yy"
.;		 Default: 4:00 (4 A.M. tomorrow morning)
.;
.;  XYZZY        Is a code word which must exist on the command line
.;		 to prevent unauthorized use of this command file.
.;
.;  Other command files called:
.;
.;		TOMORROW.CMD
.;
.;  This command file assumes the following:
.;
.;	- BACBRU.TSK resides on the current default disk and UIC.
.;	- The output magtape is loaded on the required tape drive
.;	  and is online.
.;	- The input disk is spun up and mounted as a Files-11 device.
.;	- The next backup job will be submitted to the batch queue "SYSBAC".
.;
.;-------------------------------------------------------------------------
.;
.; Module description:
.;
.;	This command file drives the BACBRU utility to perform incremental
.; backup of disk files to tape. Each time the command file is invoked
.; (through the RSX-11M-Plus batch mechanism), a new backup set (with the
.; backup set name derived from the disk being backed up and the current date)
.; is appended to the output volume. 
.;
.;      This command file is sensitive to errors flagged by BRU and BACBRU; 
.; when these occur, the current date and time parameters used for the
.; incremental backup are preserved for the next run of the program. For
.; example, if the current output volume becomes full, BRU will unload the
.; tape and ask for the next volume. BACBRU detects this situation, aborts
.; BRU, and exits with an error status. This command file then sets up to
.; retry the same operation the next day. 
.; 
.;	The command file finds work to do by reading its control file.
.; A control file is composed of single line entries of the form:
.;
.;		ddnn:(dd-mm-yy hh:mm:ss)
.;
.; where "ddnn:" is the disk to be backed up, and (dd-mm-yy hh:mm:ss)
.; is the argument to be used in BRU's /REVISED:AFTER: switch.
.;
.; 	For each line in the control file, INCBACKUP.CMD mounts the required
.; tape drive (as /PUBLIC/FOREIGN), creates the BACBRU command file, 
.; and spawns BACBRU to call BRU and create the incremental log file.
.; Of course, the output volume must already be online on the required
.; tape drive.
.;
.;      The backup set name created on the output volume has the format:
.;
.;		DDnn_ddmmmyy
.;
.; where "DDnn" is the disk device, "dd" is the current day, "mmm" is the
.; current month, and "yy" is the current year.
.;
.; 	The BACBRU log file created by the command file has the 
.; filename format:
.;
.;		ddnnmmmyy.log
.;
.; where "ddnn" is the disk device, 'mmm' is the current month, and 'yy'
.; is the current year. Successive incremental backup operations append
.; log output to the current month's log file.
.;
.;	Whether the BACBRU operation works or not, INCBACKUP.CMD creates
.; a new control file for itself for its next invocation. If the BACBRU
.; operation failed, then the date and time to be used in the next
.; /REV:AFT argument will not change. If the current operation succeded,
.; then the date and time are set to 00:00 of the current day.
.;
.;---------------------------------------------------------------------------
.;
.Enable Substitution
.Enable Global
.Disable Lowercase
.Disable Quiet
.Sets Oldcli <CLI>
.If <CLI> = "DCL" Set Terminal MCR
.;
.; Parse the command line into component parts and set defaults for
.; sections that are not specified.
.;
	.Parse Comman " /" D1 D2 $MDV $CNF1 $LGF $NTM $CHK D3

	.If $CHK = "XYZZY" .Goto 10
	;
	; Invalid invocation of INCBACKUP -- Go away unless you know what you''re doing!
	;
	.Setn Exval 2
	.Goto Doexit

.10:	.If $MDV = "" .Sets $MDV "MM0:"
	.If $CNF1 = "" .Sets $CNF1 "SY:'<UIC>'INCBACKUP.CNF"

	.; Disallow version numbers in control file

	.Parse $CNF1 ";" $CNF D1

	.If $LGF = "" .Sets $LGF "SY:'<UIC>'"

	.; Get tomorrow's date

	@Tomorrow.cmd

	.If $NTM = "" .Sets $NTM "4:00:'<Exstri>'"

	.; Submit tomorrow's job now, in case the system goes belly-up
	.; before we finish our work.

	Submit Sysbac:Incbac/Aft:'$NTM'/Noprint=Incbackup.Bat

	.; Lookup the control file and open for reading

	.Testfile '$CNF'
	.If <Filerr> Eq 1 .Goto 20
	;
	; File open failure on control file: '$CNF'
	;
	.Setn Exval 2
	.Goto Doexit

.20:	.Openr #0 '$CNF'

	.; Open next version of control file for tomorrow's job

	.Open #1 '$CNF'

	.; Now begins the processing loop. We read one line from the
	.; control file, and using variables defined above, we spawn
	.; BACBRU to do the job.

.Loop:
	.Read #0 Param
	.Ift <EOF> .Goto Finish		! End of control file

	.; Parse command line from control file. Note that we want to
	.; fiddle with the device unit number for later output as
	.; a two-digit octal number

	.Parse Param ":" Disk Backt
	.Test Disk
	.Sets Dnum Disk[3:'<Strlen>']
	.Seto Dunit
	.Setn Dunit 'Dnum'
	.Sets Dnum "'Dunit%OMZR2'"
	.Sets Disk Disk[1:2]+Dnum	! The finished product: DDnn

	.; Get the current time and break up into component parts

	.Parse <Date> "-" Day Month Year
	.Sets Time <Time>

	.; Mount the tape drive. Note that we remount it every time
	.; through the loop to guarantee that the tape is online. If
	.; The last run produced a BRU tape error, then BRU unloads
	.; the tape. Unless we check for this, the next time BRU is
	.; invoked, we'll get magtape SELECT ERRORS "up the whazoo."

	Mount '$MDV'/For/Pub
	.If <Exstat> Eq 1 .Goto 30
	;
	; Mount error on tape drive '$MDV'
	.Goto Rcover

.30:	.; Create the command file for BACBRU

	.Open #2 Bacbrucmd.tmp

	.; First line is the specification of the log file

	.Data #2 '$LGF''Disk''Month''Year'.Log

	.; Second and subsequent lines are the BRU command lines

	.Sets Bacnam "'Disk'_'Day''Month''Year'"

	.Data #2 /Rewind/Append/Back:'Bacnam'/Density:1600/Display-
	.Data #2 /Mount/Revised:After:'Backt'
	.Data #2 'Disk':
	.Data #2 '$MDV'

	.Close #2

	.; Start up BACBRU and wait for it

	Run Bacbru/CMD="BBR Sy:'<UIC>'Bacbrucmd.tmp"

	.Setn Exstat <Exstat>
	Pip Bacbrucmd.tmp;*/de/nm
	Dmount '$MDV'/Dev/Lock=v

	.; If exit status was ERROR or worse, go to recovery routine

	.If Exstat GT 1 .Goto Rcover

	.; If everything worked, output line to control file to be
	.; executed tomorrow. Then go back to top of loop.

	.Data #1 'Disk':('Day'-'Month'-'Year' 00:00)
	.Goto Loop

.Rcover:.; In recovery mode, we restore the current parameters, write
	.;   them out to the new control file, so that the same backup
	.;   attempt will be done tomorrow.

	.Data #1 'Disk':'Backt'
	;
	; Incbackup -- Error backing up 'Disk':
	;              Will retry tomorrow, /Revised:After:'Backt'
	.Goto Loop

.Finish: .; All done with backup operations. Close output files, and
	.; purge all but most recent control files

	.Close #1
	Pip '$CNF'/Pu:7
	.Setn Exval 1
.Doexit:
	.If Oldcli = "DCL" Set /DCL=TI:
	.Exit 'Exval'
