.; MERGE.CMD
.;									 
.;******************************************************************************
.;
.; This software is provided on an "as is" basis only. Caterpillar Tractor Co.,
.; disclaims  all  warranties on the program, including without limitation, all
.; implied warranties of merchantablity and fitness.
.;
.; Full  permission  and  consent  is  hereby  given  to DECUS and to the DECUS
.; special interest groups to reproduce,  distribute,  and  publish  and permit
.; others to reproduce in whole or in part, in any form and without restriction
.; this program and any information relating thereto
.;
.;******************************************************************************
.;
.;
.;	This command file is used to generate a concatenated listing
.;	of the RSX11M executive
.;
.; Author:
.;
.;	Rick Webster, Process Control Applications
.;	MSDGO, Caterpillar Tractor Co.
.;
.; Modifications:
.;
.;	07/12/82	Modified by Rick Webster to support
.;			RSX11M V4.0 and also provide listings
.;			for executive commons and non-resident
.;			loader.
.;
.;
	.ENABLE SUBSTITUTION
	.SETS UIC <UIC>
	;
	; **-MERGE.CMD-*
	;
	; Build and assemble Concatenated Executive
	;
	; This command file creates and assembles a concatenated RSX-11M
	; executive. It will also create concatenated listings of EXCOM1
	; and EXCOM2 if your system supports executive commons and a
	; listing of the loader LDR if your system has a non-resident
	; loader.
	;
	;
	; The following files from the system generation must
	; be present on your disk.
	;
	;	[1,24]RSXBLD.CMD	Task build command file
	;	[11,10]RSXMC.MAC	Configuration prefix file
	;	[11,10]SYSTB.MAC	Device table source file
	;
	;
	; The tasks PIP, MAC and CRF must be installed. Also you will
	; be asked for the device that contains the executive sources and 
	; the device that contains your system. These must be mounted. 
	;
	.SETT PIP
	.SETT MAC
	.SETT CRF
	.IFNINS ...PIP .SETF PIP
	.IFNINS ...MAC .SETF MAC
	.IFNINS CRF... .SETF CRF
	.IFT PIP .AND .IFT MAC .AND .IFT CRF .GOTO GTDEV
	;
	.IFF PIP ;	*** PIP is not installed
	.IFF MAC ;	*** MAC is not installed
	.IFF CRF ;	*** CRF is not installed
	;
	;	*** Executive source merge terminated ***
	;
	;	Please install required tasks and try again
	;
	.EXIT
.GTDEV:	.ASKS [2:5] EXSRC Enter device which contains exec sources (ddn)
	.PARSE EXSRC ":" EXSRC DUMMY
	.SETS EXSRC EXSRC+":"
	.ASKS [2:5] SYSDV Enter device that contains your system (ddn)
	.PARSE SYSDV ":" SYSDV DUMMY
	.SETS SYSDV SYSDV+":"
	.SETT RSXMC
	.SETT SYSTB
	.SETT RSXBLD
	.TESTFILE 'SYSDV'[11,10]RSXMC.MAC
	.IF <FILERR> NE 1 .SETF RSXMC
	.TESTFILE 'SYSDV'[11,10]SYSTB.MAC
	.IF <FILERR> NE 1 .SETF SYSTB
	.TESTFILE 'SYSDV'[1,24]RSXBLD.CMD
	.IF <FILERR> NE 1 .SETF RSXBLD
	.IFT RSXMC .AND .IFT SYSTB .AND .IFT RSXBLD .GOTO EXCHK
	;
	.IFF RSXMC ;	*** Open error on 'SYSDV'[11,10]RSXMC.MAC
	.IFF SYSTB ;	*** Open error on 'SYSDV'[11,10]SYSTB.MAC
	.IFF RSXBLD ;	*** Open error on 'SYSDV'[1,24]RSXBLD.CMD
	;
	;	*** Executive source merge terminated ***
	;
	.EXIT
.EXCHK:	.;	Verify that exec source disk is correct
	.SETT REQSB
	.SETT NLDRV
	.TESTFILE 'EXSRC'[11,10]REQSB.MAC
	.IF <FILERR> NE 1 .SETF REQSB
	.TESTFILE 'EXSRC'[11,10]NLDRV.MAC
	.IF <FILERR> NE 1 .SETF NLDRV
	.IFT NLDRV .AND .IFT REQSB .GOTO START
	;
	.IFF REQSB ;	*** Exec sources incomplete or non-existant on 'EXSRC'
	.IFF NLDRV ;	*** Driver sources incomplete or non-existant on 'EXSRC'
	;
	;	*** Executive source merge terminated ***
	;
	.EXIT	
.START:
	ASN 'SYSDV'=SY:
	SET /UIC=[1,34]
	PIP EDTINI.EDT;*/DE/NM
	PIP MERGE.EDT;*/DE/NM
	PIP RSX11M.MAC;*/DE/NM
	PIP EXCOM1.MAC;*/DE/NM
	PIP EXCOM2.MAC;*/DE/NM
	.OPEN #2 EDTINI.EDT
	.DATA #2 INC MERGE.EDT =MERGE
	.DATA #2 =MAIN .
	.DATA #2 DEFINE MACRO MERGE
	.DATA #2 MERGE
	.DATA #2 EXIT
	.CLOSE #2
	.SETF EXEC
	.SETF LOADER
	.SETF EXCOM1
	.SETF EXCOM2
	.OPENR 'SYSDV'[1,24]RSXBLD.CMD
	;
	; Reading RSXBLD.CMD to determine if this
	; system has executive commons and/or a
	; non-resident loader.
	;
.CHKFIL:
	.READ LINE
	.IFT <EOF> .GOTO CHKDON
	.TEST LINE "[1,54]RSX11M/"
	.IF <STRLEN> NE 0 .SETT EXEC
	.TEST LINE "[1,54]LDR/"
	.IF <STRLEN> NE 0 .SETT LOADER
	.TEST LINE "[1,54]EXCOM1/"
	.IF <STRLEN> NE 0 .SETT EXCOM1
	.TEST LINE "[1,54]EXCOM2/"
	.IF <STRLEN> NE 0 .SETT EXCOM2
	.GOTO CHKFIL
.CHKDON:;
	; Source listings will be generated
	; for the following:
	;
	.IFT EXEC ;	RSX11M
	.IFT EXCOM1 ;	EXCOM1
	.IFT EXCOM2 ;	EXCOM2
	.IFT LOADER ;	LDR
	;
	.CLOSE
.STRSX:	.IFF EXEC .GOTO STEX1
	.OPEN #3 MERGE.EDT
	.DATA #3 "S$$YDF"
	.DATA #3 D
	.DATA #3 S/.TITLE/.SBTTL
	.DATA #3 "S$$YDF"
	.DATA #3 D
	.GOSUB FSTFIL RSX11M
	PIP RSX11M.MAC/AP='SYSDV'[11,10]RSXMC.MAC
	.OPENR 'SYSDV'[1,24]RSXBLD.CMD
.FRSX:
	.READ LINE
	.IFT <EOF> .GOTO ERROR1
	.TEST LINE "[1,54]RSX11M/"
	.IF <STRLEN> EQ 0 .GOTO FRSX
.GETRSX:
	.READ LINE
	.IFT <EOF> .GOTO DONRSX
	.SETS FIRST LINE[1:1]
	.IF FIRST EQ "/" .GOTO DONRSX
	.PARSE LINE "/" DUMMY LINE
	.PARSE LINE ":" DUMMY LINE
	.TEST LINE
	.IF <STRLEN> EQ 0 .GOTO DONRSX
.LPRSX:
	.PARSE LINE ":" FIELD LINE
	.TEST FIELD
	.IF <STRLEN> LE 6 .GOTO RSXC1
	.PARSE FIELD "," FIELD LINE
	PIP RSX11M.MAC/AP='EXSRC'[11,10]'FIELD'.MAC
	.GOSUB LASTFL $INITL
	.GOTO DONRSX
.RSXC1:
	.IF FIELD EQ "SYSTB" PIP RSX11M.MAC/AP='SYSDV'[11,10]SYSTB.MAC
	.IF FIELD EQ "SYSTB" .GOTO RSXC2
	.IF FIELD EQ "C5TA" .GOSUB C5TA
	.IF FIELD EQ "C5TA" .GOTO RSXC2
	PIP RSX11M.MAC/AP='EXSRC'[11,10]'FIELD'.MAC
.RSXC2:
	.GOSUB SBTTL
	.TEST LINE
	.IF <STRLEN> GT 0 .GOTO LPRSX
	.GOTO GETRSX
.DONRSX:.CLOSE
	.CLOSE #3
	;
	; Format RSX11M.MAC into correct form.
	;
	EDT RSX11M.MAC
	PIP MERGE.EDT;*/DE
.STEX1:	.IFF EXCOM1 .GOTO STEX2
	.OPEN #3 MERGE.EDT
	.DATA #3 "S$$YDF"
	.DATA #3 D
	.DATA #3 S/.TITLE/.SBTTL
	.DATA #3 "S$$YDF"
	.DATA #3 D
	.GOSUB FSTFIL EXCOM1
	PIP EXCOM1.MAC/AP='SYSDV'[11,10]RSXMC.MAC
	.OPENR 'SYSDV'[1,24]RSXBLD.CMD
.FEX1:
	.READ LINE
	.TEST LINE "[1,54]EXCOM1/"
	.IF <STRLEN> EQ 0 .GOTO FEX1
.GETEX1:
	.READ LINE
	.TEST LINE "[1,24]RSX11M/LB:"
	.IF <STRLEN> EQ 0 .GOTO DONEX1
	.PARSE LINE "/" DUMMY LINE
	.PARSE LINE ":" DUMMY LINE
.LPEX1:
	.PARSE LINE ":" FIELD LINE
	PIP EXCOM1.MAC/AP='EXSRC'[11,10]'FIELD'.MAC
	.IF FIELD NE "DRSST" .GOTO EX1C1
	.SETS COMMAN ""
	.GOSUB LASTFL
	.GOTO DONEX1
.EX1C1:
	.GOSUB SBTTL
	.TEST LINE
	.IF <STRLEN> GT 0 .GOTO LPEX1
	.GOTO GETEX1
.DONEX1:.CLOSE
	.CLOSE #3
	;
	; Format EXCOM1.MAC into correct form.
	;
	EDT EXCOM1.MAC
	PIP MERGE.EDT;*/DE
.STEX2:	.IFF EXCOM2 .GOTO STASM
	.OPEN #3 MERGE.EDT
	.DATA #3 "S$$YDF"
	.DATA #3 D
	.DATA #3 S/.TITLE/.SBTTL
	.DATA #3 "S$$YDF"
	.DATA #3 D
	.GOSUB FSTFIL EXCOM2
	PIP EXCOM2.MAC/AP='SYSDV'[11,10]RSXMC.MAC
	.OPENR 'SYSDV'[1,24]RSXBLD.CMD
.FEX2:
	.READ LINE
	.TEST LINE "[1,54]EXCOM2/"
	.IF <STRLEN> EQ 0 .GOTO FEX2
.GETEX2:
	.READ LINE
	.TEST LINE "[1,24]RSX11M/LB:"
	.IF <STRLEN> EQ 0 .GOTO DONEX2
	.PARSE LINE "/" DUMMY LINE
	.PARSE LINE ":" DUMMY LINE
.LPEX2:
	.PARSE LINE ":" FIELD LINE
	PIP EXCOM2.MAC/AP='EXSRC'[11,10]'FIELD'.MAC
	.IF FIELD NE "DRSMG" .GOTO EX2C1
	.SETS COMMAN ""
	.GOSUB LASTFL
	.GOTO DONEX2
.EX2C1:
	.GOSUB SBTTL
	.TEST LINE
	.IF <STRLEN> GT 0 .GOTO LPEX2
	.GOTO GETEX2
.DONEX2:.CLOSE
	.CLOSE #3
	;
	; Format EXCOM2.MAC into correct form.
	;
	EDT EXCOM2.MAC
	PIP MERGE.EDT;*/DE
.STASM:	;
	; Delete temporary files
	;
	PIP RSX11M.MAC/PU/NM
	PIP EXCOM1.MAC/PU/NM
	PIP EXCOM2.MAC/PU/NM
	PIP EDTINI.EDT;*/DE
	;
	.IFT EXEC ; Assemble executive, getting list and cref.
	.IFT EXEC ;
	.IFT EXEC MAC ,RSX11M/-SP/CR=LB:[1,1]EXEMC/ML,'SYSDV'[11,10]RSXMC/PA:1,[1,34]RSX11M
	.IFT EXEC .IF <EXSTAT> EQ 1 PIP RSX11M.MAC;*/DE/NM
	.IFT EXEC ;
	.IFT EXCOM1 ; Assemble EXCOM1, getting list and cref.
	.IFT EXCOM1 ;
	.IFT EXCOM1 MAC ,EXCOM1/-SP/CR=LB:[1,1]EXEMC/ML,'SYSDV'[11,10]RSXMC/PA:1,[1,34]EXCOM1
	.IFT EXCOM1 .IF <EXSTAT> EQ 1 PIP EXCOM1.MAC;*/DE/NM
	.IFT EXCOM1 ;
	.IFT EXCOM2 ; Assemble EXCOM2, getting list and cref.
	.IFT EXCOM2 ;
	.IFT EXCOM2 MAC ,EXCOM2/-SP/CR=LB:[1,1]EXEMC/ML,'SYSDV'[11,10]RSXMC/PA:1,[1,34]EXCOM2
	.IFT EXCOM2 .IF <EXSTAT> EQ 1 PIP EXCOM2.MAC;*/DE/NM
	.IFT EXCOM2 ;
	.IFT LOADER ; Assemble LOADER, getting list and cref.
	.IFT LOADER ;
	.IFT LOADER MAC ,LOADR/-SP/CR=LB:[1,1]EXEMC/ML,'SYSDV'[11,10]RSXMC/PA:1,[11,10]LOADR
	.IFT LOADER .IF <EXSTAT> EQ 1 PIP LOADR.MAC;*/DE/NM
	.IFT LOADER ;
	; Waiting for CRF to finish
	.WAIT CRF...
.;	.ASK Q Do you want to delete concatenated source files
.;	.IFT Q .IFT EXEC PIP RSX11M.MAC;*/DE
.;	.IFT Q .IFT EXCOM1 PIP EXCOM1.MAC;*/DE
.;	.IFT Q .IFT EXCOM2 PIP EXCOM2.MAC;*/DE
.;	.ASK Q Spool listing files
.;	.IFT Q .IFT EXEC PIP RSX11M.LST/SP
.;	.IFT Q .IFT EXCOM1 PIP EXCOM1.LST/SP
.;	.IFT Q .IFT EXCOM2 PIP EXCOM2.LST/SP
	;
	;	Executive source merge completed
	;
	.EXIT
.C5TA:
	;
	;	Adding dummy C5TA.MAC modules to concatenated RSX11M.MAC
	;
	.OPENA #1 RSX11M.MAC
	.DATA #1 	.TITLE	C5TA
	.DATA #1 	.IDENT	/02/
	.DATA #1 ;
	.DATA #1 ; Fake C5TA used to correct space fill executive.
	.DATA #1 ;
	.DATA #1 $C5TA::				;REF LABEL
	.DATA #1 	.BLKB	110		;SIZE OF MODULE
	.DATA #1 
	.DATA #1 	.END
	.CLOSE #1
	.RETURN
.FSTFIL:
	;
	;	Creating initial copy of 'COMMAN'.MAC
	;
	.OPEN 'COMMAN'.MAC
	.DATA 	.TITLE	'COMMAN'
	.DATA 	.SBTTL	'COMMAN'
	.DATA ;
	.DATA ; Prefix file for concatenated 'COMMAN' assembly.
	.DATA ;
	.DATA ; This file declares the macros used to define executive
	.DATA ; table structures and bits. This is done to get as many
	.DATA ; non-global symbols as possible.
	.DATA ;
	.DATA 	.MCALL	IOERR$
	.DATA 	IOERR$
	.DATA 	.MCALL	FILIO$
	.DATA 	FILIO$
	.DATA 	.MCALL	ABODF$
	.DATA 	ABODF$
	.DATA 	.MCALL	CLKDF$
	.DATA 	CLKDF$
	.DATA 	.MCALL	DCBDF$
	.DATA 	DCBDF$
	.DATA 	.MCALL	EPKDF$
	.DATA 	EPKDF$
	.DATA 	.MCALL	HDRDF$
	.DATA 	HDRDF$
	.DATA 	.MCALL	HWDDF$
	.DATA 	HWDDF$
	.DATA 	.MCALL	ITBDF$
	.DATA 	ITBDF$
	.DATA 	.MCALL	PCBDF$
	.DATA 	PCBDF$	,,SYSDEF
	.DATA 	.MCALL	PKTDF$
	.DATA 	PKTDF$
	.DATA 	.MCALL	SCBDF$
	.DATA 	SCBDF$
	.DATA 	.MCALL	TCBDF$
	.DATA 	TCBDF$
	.DATA 	.MCALL	UCBDF$
	.DATA 	UCBDF$
	.DATA 
	.DATA 	.PAGE
	.CLOSE
	.RETURN
.LASTFL:
	.DATA #3 ".TITLE"
	.DATA #3 S/.TITLE/.SBTTL
	.DATA #3 I
	.DATA #3 	.PAGE
	.DATA #3 ^Z
	.DATA #3 %E
	.DATA #3 .-1
	.DATA #3 D
	.DATA #3 I
	.DATA #3 	.END	'COMMAN'
	.DATA #3 ^Z
	.RETURN
.SBTTL:
	.DATA #3 ".TITLE"
	.DATA #3 S/.TITLE/.SBTTL
	.DATA #3 I
	.DATA #3 	.PAGE
	.DATA #3 ^Z
	.IF FIELD NE "SYSDF" .GOTO SBTC1
	.DATA #3 "K$$W11==-1"
	.DATA #3 S/K/;K
.SBTC1:
	.DATA #3 ".TITLE"
	.DATA #3 -".END"
	.DATA #3 D
	.DATA #3 I
	.DATA #3 	.DSABL	LSB
	.DATA #3 	.PSECT
	.DATA #3 ^Z
	.DATA #3 .-1
	.RETURN
