.;
.; TOMORROW.CMD -- Command file to compute the date from
.;		   a specified date to a future number of days.
.;
.; Usage:
.;
.;	@Tomorrow <date>, <inc>
.;
.; Where:
.;
.;	<date>	Is the base date from which the date computation
.;		is made. Format: dd-mmm-yy. Default: Current date.
.;
.;	<inc>	Is the number of days to add to the <date> argument
.;		which will produce the desired date. This must be
.;		a decimal number. Default value: 1.
.;
.; The result is returned in the reserved string symbol <EXSTRI> in
.; the format mm-ddd-yy
.;
.; Notes:
.;
.;	- The value of <inc> should not be so great as to cause
.;	  several years to be skipped. The leap year logic is not
.;	  smart enough to work across spanned years.
.;
.Enable Substitution

	.Parse Comman " ," D1 Curdat Incs
	.If Curdat = "" .Sets Curdat <Date>
	.If Incs = "" .Sets Incs "1"

	.Setd Inc
	.Setn Inc 'Incs'

	.; Initialize lists of months and days in each month

	.Sets Mont1 "JAN"
	.Sets Mont2 "FEB"
	.Sets Mont3 "MAR"
	.Sets Mont4 "APR"
	.Sets Mont5 "MAY"
	.Sets Mont6 "JUN"
	.Sets Mont7 "JUL"
	.Sets Mont10 "AUG"
	.Sets Mont11 "SEP"
	.Sets Mont12 "OCT"
	.Sets Mont13 "NOV"
	.Sets Mont14 "DEC"

	.Setn Days1 31.
	.Setn Days2 28.
	.Setn Days3 31.
	.Setn Days4 30.
	.Setn Days5 31.
	.Setn Days6 30.
	.Setn Days7 31.
	.Setn Days10 31.
	.Setn Days11 30.
	.Setn Days12 31.
	.Setn Days13 30.
	.Setn Days14 31.

	.; Determine if this is currently a leap year

	.Parse Curdat "-" Day Month Year
	.Setd Y
	.Setn Y 'Year'.
	.Gosub Leapit		! Determine if this is a leap year

	.; Now calculate current day (Julian day)

	.Ift Leap .Setn Days2 29.
	.Setd Jdate
	.Setn L 1
.10:	.If Month = Mont'L' .Goto 20
	.Setn Jdate Jdate+Days'L'
	.Inc L
	.Goto 10

.20:	.Setn Jdate Jdate+'Day'.

	.; Add the number of days required

	.Setn Jdate Jdate+Inc

	.; Now reverse the process above

.30:	.Iff Leap .Setn YD 365.
	.Ift Leap .Setn YD 366.
	.If Jdate <= YD .Goto 40
	.Inc Y				! Next year
	.Setn Jdate Jdate-YD
	.Gosub Leapit
	.Goto 30

.40:	.Setn L 1
	.Ift Leap .Setn Days2 29.
	.Iff Leap .Setn Days2 28.
.50:	.If Jdate <= Days'L' .Goto 60
	.Setn Jdate Jdate-Days'L'
	.Inc L
	.Goto 50

.60:	.Sets M Mont'L'
	.Sets <Exstri> "'Jdate'-'M'-'Y'"
	.Exit 1

.Leapit:
	.; Calculates whether current year (Y) is a leap year

	.Setn Y1 Y/4
	.Setn Y2 Y1*4
	.Setf Leap
	.If Y = Y2 .Sett Leap
	.Return

