.;
.; XDTGEN.CMD
.;
.; Modified for RSX-11M V4.0 by
.;	Bob Denny
.;	13-Jul-82
.;
.ENABLE SUBSTITUTION
.SETS $C ""
.IF <CLI> NE "MCR" .SETS $C "MCR "
.SETS UIC <UIC>
;
; This command file assmbles and builds the XDT task. This task provides
; support for loading and unloading XDT into a task or system partition.
; This allows systems to be generated without XDT and later use XDT when
; it really is needed.
;
; The command lines accepted by the task are as follows:
;
;	>XDT /LOA[/PAR=partition/TER=ttnn:]	!Load XDT
;	>XDT /UNL				!Unload XDT
;
; If specified, /PAR is the partition to load XDT. The default is GEN.
; /TER allows an alternate DL11 terminal to be specified. The default
; is the console.
;
; The command file assumes the system device (SY:) is the disk the
; XDT software is on and the library device (LB:) is the disk with the
; system software. It also assumes the current UIC is the UIC with the
; XDT software and will create the XDT task in this UIC. We will now
; check all files are in the correct place. Any files not in the correct
; place will generate a message and the command file will pause to allow
; you to correctly position them.
.100: ;
;
.SETT FOUND
.TESTFILE SY:'UIC'XDTBLD.CMD
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE SY:'UIC'XDTROT.MAC
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE SY:'UIC'XDTLOA.MAC
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE SY:'UIC'XDTUNL.MAC
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE SY:'UIC'XDTSYS.MAC
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE SY:'UIC'XDTCDE.COR
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE SY:'UIC'EXDBT.MAC
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE LB:[1,1]EXEMC.MLB
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE LB:[11,10]RSXMC.MAC
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE LB:[1,54]RSX11M.STB
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.IFT FOUND .GOTO 200
;
; We will now pause. Please correct any problems
;
.PAUSE
.GOTO 100
.200: ;
; Patch Digital's version of XDT.
;
.IFNINS ...SLP '$C'INS $SLP
'$C'SLP @XDTCDE.COR
;
; Assemble XDT sources
;
.IFNINS ...MAC INS $MAC
'$C'MAC XDTROT,XDTROT/-SP=LB:[1,1]EXEMC/ML,[11,10]RSXMC/PA:1,SY:'UIC'XDTROT
'$C'MAC XDTLOA,XDTLOA/-SP=LB:[1,1]EXEMC/ML,[11,10]RSXMC/PA:1,SY:'UIC'XDTLOA
'$C'MAC XDTUNL,XDTUNL/-SP=LB:[1,1]EXEMC/ML,[11,10]RSXMC/PA:1,SY:'UIC'XDTUNL
'$C'MAC XDTSYS,XDTSYS/-SP=LB:[1,1]EXEMC/ML,[11,10]RSXMC/PA:1,SY:'UIC'XDTSYS
'$C'MAC XDTCDE,XDTCDE/-SP=LB:[1,1]EXEMC/ML,[11,10]RSXMC/PA:1,SY:'UIC'XDTCDE
;
; Task build XDT task.
;
.IFNINS ...TKB '$C'INS $TKB
'$C'TKB @XDTBLD.CMD
;
; All done.
;
