/*
 *       *********************
 *       *  F S U S E R . H  *
 *       *********************
 *
 * Combined file of symbolics for using the FLSERV file server
 * from C.
 *
 * REQUIRES PREINCLUDE OF TYPDEF.H
 *
 * Edits:
 * V1.0 13-Oct-82 RBD   Merged FLSERV files to create this
 */

/*
 * File specification block
 */
struct fsb     {
               char  fs_fsp[40];       /* ASCII file specification (null trm) */
               word  fs_pro;           /* Static file protection */
               word  fs_ext;           /* Extent increment, blocks */
               byte  fs_fmt;           /* File format */
               byte  fs_rec;           /* Recording mode */
               long  fs_bsz;           /* # blocks in file (SEQ) */
               word  fs_rsz;           /* Data rec len, bytes (REL,ISAM) */
               long  fs_nrc;           /* Record capacity (REL,ISAM) */
               byte  fs_ndf;           /* Number of data files (ISAM) */
               byte  fs_nky;           /* Number of keys (ISAM) */
               struct kdb
                  {
                  byte  kd_ksz;        /* Length of key, bytes (ISAM) */
                  byte  kd_kfl;        /* Key flags (ISAM) */
                  word  kd_kof;        /* Offset to key in data rec (ISAM) */
                  }  fs_kys[10];
               };

/*
 * Recording mode values - mutually exclusive
 * NOTE: Must match (FCS FD.xxx) attribute codes!!
 * Ignored for ISAM files.
 */
#define  RM_ANO   0                    /* ASCII - No carriage control */
#define  RM_AFT   1                    /* ASCII - FORTRAN carriage control */
#define  RM_ACR   2                    /* ASCII - Normal carriage control */
#define  RM_ISA   0100                 /* ISAM */
#define  RM_BIN   0200                 /* Binary */

/*
 * File format values - mutually exclusive
 * NOTE: Must match (FCS R.xxx) attribute codes!!
 */
#define  FF_ISA   1                    /* ISAM (F.RTYP = R.FIX) */
#define  FF_REL   1                    /* Relative (R.FIX) */
#define  FF_SEQ   2                    /* Sequential (R.VAR) */

/*
 * Key flags - KF.DUP may be specified together with ONE of the
 *             other KF values.
 */
#define  KF_ASC   0                    /* ASCII - code order */
#define  KF_DIC   1                    /* ASCII - dictionary order */
#define  KF_BIN   2                    /* 16 bit unsigned integer key */
#define  KF_DUP   0200                 /* Duplicates allowed this key */

/*
 * I/O Function codes supported by FLSERV
 */

/*
 * RSX standard codes
 */
#define  IO_MOU   002400               /* Mount/Enable */
#define  IO_DMO   003000               /* Dismount/Disable */
#define  IO_CLN   003400               /* Abort User Task Connections */

/*
 * FLSERV-specific I/O functions
 */
#define  FS_CON   017400               /* Connect to file */
#define  FS_DIS   017401               /* Disconnect from file */
#define  FS_CRE   017402               /* Create file */
#define  FS_DEL   017403               /* Delete file */
#define  FS_GET   017404               /* Get existing record */
#define  FS_PUT   017405               /* Put new record */
#define  FS_UPD   017406               /* Update existing record */
#define  FS_ERA   017407               /* Erase existing record */
#define  FS_ULK   017410               /* Unlock all records on stream */
#define  FS_POS   017411               /* Position stream on key */
#define  FS_MRK   017412               /* Mark current stream position */
#define  FS_PNT   017413               /* Point stream to saved position */
#define  FS_RWD   017414               /* Rewind stream */
#define  FS_RFS   017415               /* Read file specifications */
#define  FS_CTL   017416               /* Control function */

/*
 * Options values for FS_CRE and FS_CON
 */
#define  O_SUP    1                    /* Allow supersede for create */
#define  O_NXT    2                    /* Disable auto-extend at EOF */
#define  O_DEL    020                  /* Delete on disconnect */
#define  O_WTD    0100                 /* Disable write-thru caching */

/*
 * Options for FS_DIS
 */
#define O_MKD  2                       /* Mark for delete on final deaccess */
#define O_SPL  4                       /* Spool on deaccess */
#define O_TRN  8                       /* Truncate to LEOF before deaccess */

/*
 * Options for FS_GET, FS_UPD and FS_ERA
 */
#define O_LOK  1                       /* Read with lock (FS_GET) */
#define O_WAI  2                       /* Wait on locked record */
#define O_SKR  4                       /* Set new key of reference (FS_GET) */
                                       /* (Hi byte = new KOR number) */
#define O_PGT  8                       /* Position > key (GET ONLY)*/
#define O_PGE  16                      /* Position >= key (GET ONLY)*/

/*
 * Options for FS.POS
 */
#define O_SKR  4                       /* Set new key of reference */
                                       /* (Hi byte = new KOR number) */
#define O_PGT  8                       /* Position > key */
#define O_PGE  16                      /* Position >= key */

/*
 * Access values
 */
#define  CM_INP   1                    /* INPUT */
#define  CM_OTP   2                    /* OUTPUT */
#define  CM_IO    3                    /* INPUT|OUTPUT */
#define  CM_UPD   3                    /* Synonym for CM_IO */
#define  CM_APD   0100                 /* APPEND */

/*
 * Dynamic protection codes
 */
#define DP_SHR    1                    /* SHARED access */
#define DP_PRO    2                    /* PROTECTED access */
#define DP_EXC    3                    /* EXCLUSIVE access */

/*
 * FLSERV-specific error codes returned to user task
 *
 * These codes have a 200(8) in the low byte and the specific
 * code in the high byte.
 */

/*
 * Filespec syntax errors
 */
#define  FE_SDV   000600     /* Code:   1 => Syntax: Device Name */
#define  FE_SDR   001200     /* Code:   2 => Syntax: Directory (UIC) */
#define  FE_SFN   001600     /* Code:   3 => Syntax: File Name */
#define  FE_SEX   002200     /* Code:   4 => Syntax: Extension */
#define  FE_SVR   002600     /* Code:   5 => Syntax: Version */
#define  FE_XXX   003200     /* Code:   6 => */
#define  FE_XXX   003600     /* Code:   7 => */

/*
 * Device Errors
 */
#define  FE_NSD   004200     /* Code:   8 => No Such Device on System */
#define  FE_DNL   004600     /* Code:   9 => Driver Not Loaded */
#define  FE_NFS   005200     /* Code:  10 => Device not Files-11 */
#define  FE_DNM   005600     /* Code:  11 => Device Not Mounted */
#define  FE_XXX   006200     /* Code:  12 => */
#define  FE_XXX   006600     /* Code:  13 => */
#define  FE_XXX   007200     /* Code:  14 => */
#define  FE_XXX   007600     /* Code:  15 => */

/*
 * Directory Errors
 */
#define  FE_DNF   010200     /* Code:  16 => Directory Not Found */
#define  FE_DPR   010600     /* Code:  17 => Directory protection violation */
#define  FE_XXX   011200     /* Code:  18 => */

/*
 * File Creation, Deletion and Access Errors
 */
#define  FE_FEX   011600     /* Code:  19 => File Already Exists */
#define  FE_FAC   012200     /* Code:  20 => File Currently Accessed */
#define  FE_BVR   012600     /* Code:  21 => Bad Version Number */
#define  FE_LCK   013200     /* Code:  22 => File Locked */
#define  FE_SPV   013600     /* Code:  23 => Static protection violation */
#define  FE_DPV   014200     /* Code:  24 => Dynamic protection violation */
#define  FE_ZFS   014600     /* Code:  25 => Zero file size (create) */
#define  FE_ILA   015200     /* Code:  26 => Bad file format and/or rec. mode */
#define  FE_CLO   015600     /* Code:  27 => Error closing file */
#define  FE_IUF   016200     /* Code:  28 => Index update flag set */
#define  FE_XXX   016600     /* Code:  29 => */

/*
 * This one's checked for all over the place
 */
#define  FE_BSI   017200     /* Code:  30 => Bad stream ID (handle) */


/*
 * Data transfer errors
 */
#define  FE_RTL   017600     /* Code:  31 => Record too long */
#define  FE_LIV   020200     /* Code:  32 => Record already exists */
#define  FE_RDL   020600     /* Code:  33 => Record logically deleted */
#define  FE_IRS   021200     /* Code:  34 => Inconsistent record size */
#define  FE_ACC   021600     /* Code:  35 => Illegal access */
#define  FE_LOK   022200     /* Code:  36 => Record already locked */
#define  FE_TMO   022600     /* Code:  37 => Wait-lock timed out */
#define  FE_ILK   023200     /* Code:  38 => Invalid key */
#define  FE_NSK   023600     /* Code:  39 => No such key */
#define  FE_XXX   024200     /* Code:  40 => */
#define  FE_XXX   024600     /* Code:  41 => */
#define  FE_XXX   025200     /* Code:  42 => */
#define  FE_XXX   025600     /* Code:  43 => */
#define  FE_XXX   026200     /* Code:  44 => */
#define  FE_XXX   026600     /* Code:  45 => */
#define  FE_XXX   027200     /* Code:  46 => */
#define  FE_XXX   027600     /* Code:  47 => */
#define  FE_XXX   030200     /* Code:  48 => */
#define  FE_XXX   030600     /* Code:  49 => */
#define  FE_XXX   031200     /* Code:  50 => */
#define  FE_XXX   031600     /* Code:  51 => */
#define  FE_XXX   032200     /* Code:  52 => */
#define  FE_XXX   032600     /* Code:  53 => */
#define  FE_XXX   033200     /* Code:  54 => */
#define  FE_XXX   033600     /* Code:  55 => */

/*
 * Misc. Internal Errors
 */
#define  FE_DYN   034200     /* Code:  56 => Insufficient Dynamic Memory */
#define  FE_DIR   034600     /* Code:  57 => Directive Error */
#define  FE_FVA   035200     /* Code:  58 => File vanished during proc. */
#define  FE_XXX   035600     /* Code:  59 => */
#define  FE_XXX   036200     /* Code:  60 => */
#define  FE_XXX   036600     /* Code:  61 => */
#define  FE_XXX   037200     /* Code:  62 => */
#define  FE_XXX   037600     /* Code:  63 => */


