/*
 *			f l e x . h
 */

#ifdef	DOCUMENTATION

title	flex	Header file for flexes
index		Header file for flexes

synopsis

	#include <flex.h>

description

	This header file is used to allow programs to access flexes.  See
	flex.c for additional details.
	.s
	This file defines the structure of a flex.  The fields are as follows:
	.lm+16
	.s.i-16;char *fxdata	Pointer  to the  actual data.  This will
	always be the first  element, so  that a
	flex  can  be  considered to  be of type
	char ** (or  whatever) if you  only want
	to read it.  fxdata will be  NULL if the
	flex has been damaged.
	.s.i-16;unsigned fxused	Number of items used in the flex.
	.s.i-16;unsigned fxdim	Number of items the  flex can hold; 0 if
	the flex has been damaged.
	.s.i-16;unsigned fxisz	Size of one item, in bytes.
	.s.i-16;unsigned fxext	Number of  items to grow  by;  if 0, the
	flex won't grow. 
	.s.lm -16
	The only fields generally directly accessed by programs are fxdata
	and fxlen.  Note that fxdata may change over time as items are added
	to and removed from the flex.
	.s
	The only field you should normally change is fxext, the extension
	quantity. The value current the next time the flex must grow will
	determine how much it grows by.
	.s
	flex.h also contains declarations describing all the flex-handling
	routines. They are not normally included since they will create
	external references to every one of these routines, probably making
	your program larger than it has to be.  If you can accept the space
	loss, define symbol FXDODEFS before including flex.h.  Alternatively,
	you can extract just the declarations you need from this file and
	include them in your own code.

bugs

author
	Jerry Leichter
#endif

/*
)EDITLEVEL=07
 *
 * Edit history
 * 0.0  4-May-81 JSL	Invention
 * 0.1  7-May-81 JSL	Various cleanups; added FXDODEFS
 * 0.2 13-May-81 JSL	Added _FLEX_
 * 0.3 22-Jun-81 JSL	Conversion to new documentation conventions
 */

#ifndef _FLEX_			/* Don't do this twice */
#define _FLEX_

typedef struct fxheader
	{ char *fxdata;
	  unsigned fxused;
	  unsigned fxdim;
	  unsigned fxisz;
	  unsigned fxext;
	} FLEX;

#ifdef FXDODEFS
	extern FLEX	*flex();	/* make a new flex */
	extern FLEX	*fxadd();	/* add an item to the end */
	extern FLEX	*fxaddo();	/* add an item, ordered */
	extern unsigned	fxladd;		/* where fxaddo() added an item */
	extern FLEX	*fxeject();	/* eject (delete) an item */
	extern		fxfree();	/* free all space used by a flex */
	extern FLEX	*fxinject();	/* inject (insert) an item */
	extern char	*fxitem();	/* return pointer to an item */
	extern FLEX	*fxneed();	/* explicitly alter a flex's size */
	extern FLEX	*fxset();	/* set a value into an item */
#endif

#endif
