.;
.;	****** ACCGEN Version 7 ******
.;
.;	Steve Thompson, April 1981.
.;
.;	School of Chemical Engineering
.;	Olin Hall
.;	Cornell University
.;	Ithaca
.;	NY 14853
.;
.;	*NOTE* This command file runs on RSX11M V3.2 or V4.0.
.;	and builds the accounting package for those systems.
.;
.;	Revision History:
.;	-----------------
.;
.;	SMT701	29 June 1981	Addition of reporting task RPT to
.;				ACCGEN.
.;
.;	SMT702	29 June 1981	Correction of assembly bug if $PSWD not
.;				defined.
.;
.;	SMT703	29 June 1981	Tidying up of ACCGEN layout in
.;				task-build section.
.;
.;	SMT704	30 June 1981	Removal of some extraneous comments.
.;
.;	SMT705	30 June 1981	Slight alteration of long dialogue.
.;
.;	SMT706	 2 July 1981	Addition of ACCGEN.ULB to contain the
.;				tasks required to set rates.
.;
.;	SMT707	 7 July 1981	Changes to comments required by the
.;				LOG... simulated logon feature.
.;
.;	SMT710	10 July 1981	Removed ACCANSWER.DAT answer file from
.;				ACCGEN so that there is only one answer
.;				file of type CMD. Thus there is no need
.;				to rename the answer file between runs
.;				of ACCGEN.
.;
.;	SMT715	13 July 1981	Small internal changes to ACCGEN, not
.;				affecting the operation of the system.
.;
.;	SMT718	20 July 1981	Add the PAGOVR overlay to LOG... to
.;				deal with printed page accounting
.;
.;	SMT730	28 July 1981	Changed handling of OBJ modules during task
.;				build phase, so that deletion as ACCGEN goes
.;				along is an option, and deletion of the lot
.;				at the end is an option.
.;
.;	SMT742	 4 Sept 1981	Changed name of pre-assembly file from
.;				ACCPREV7.MAC to ACCPRE.MAC for compatibility
.;				with future versions of the accounting
.;				software.
.;
.;	SMT750	23 Sept 1981	Added support for the system load statistics
.;				feature to ACCGEN. An additional question was
.;				added right at the end.
.;
.;	SMT753	 7 Oct 1981	Changed names of conditional assembly
.;				parameters; see the files MODIFY.TXT and
.;				CONDEF.MAC for details. Also changed size of
.;				LOGLIB from 34 to 35 blocks.
.;
.;	SMT758	 7 Oct 1981	Added checks for the existence of the rates
.;				file RATES.CMD and the non-standard rates
.;				files NSCONNECT.CMD, NCCONNECT.CMD, NSCPU.CMD
.;				and NCCPU.CMD.
.;
.;	SMT764	10 Oct 1981	Added AA$UFD in ACCPRE.MAC as a default. This
.;				causes the size of a UFD to be included in the
.;				size of a user's files during disk accounting.
.;
.;	SMT769	12 Oct 1981	Defined a macro BATDV$ which produces the name
.;				of a batch stream device (in ACCPRE.MAC)
.;
.;	SMT770	12 Oct 1981	Addition of NONSTAN.TSK and update of patch
.;				SMT758
.;
.;	SMT773	19 Oct 1981	Added support for memory usage accounting.
.;
.;	SMT777	27 Oct 1981	Modified to correctly assemble and build the
.;				new overlaid version of RPT.
.;
.;	SMT788	13 Nov 1981	Added overlay GACOVR to LOG...
.;
.;	SMT793	19 Nov 1981	Added the ACL command.
.;
.;	SMT804	16 Mar 1982	Allow units/dollars charging units to be an
.;				ACCGEN-selectable feature.
.;
.;	SMT810	25 Mar 1982	Added support for the terminal watcher task
.;				WATCHR (requires TSF command support).
.;
.;	SMT811	29 Mar 1982	Check for existence of HELV7.MAC and BYEV7.MAC
.;				before assembly (these files require
.;				construction by SLP before ACCGEN).
.;
.;	SMT812	 5 Apr 1982	Changed name of reporting task from RPT to
.;				RSU.
.;
.;	SMT814	12 Apr 1982	Added RSX-11M V4.0 support. Many cosmetic
.;				changes and some new features to assist
.;				progress of ACCGEN.
.;
.;	SMT815	12 Apr 1982	Made priority linking of accounting list a
.;				standard feature (used to be conditionalised
.;				on AA$PRQ).
.;
.;	SMT820	21 Apr 1982	Changed name of MACNT to BAL.
.;
.;	SMT826	30 Jun 1982	Added the DISKUSE command.
.;
.;	SMT836	 6 Sep 1982	Don't include EXEMC.MLB and RSXMC.MAC on
.;				assemblies where not required in order to
.;				speed the assembly process.
.;
.;	SMT838	21 Sep 1982	Question text changes.
.;
.ENABLE SUBSTITUTION
.ENABLE GLOBAL
.ENABLE ESCAPE
.SETS $IDENT "V7.13"	! Specify version of ACCGEN.
.SETS PRTPRI "40"	! Priority of Print Jobs (if Queue Manager used)
.SETF $COMM
.SETS LINK "TKB"
.SETS $EDIT "EDI"	! Specify editor to be used by ACCGEN (extension).
.IF P1 EQ "GO" .GOTO 10	! @ACCGEN GO sets short comments and dives in.
.SETS $EDIT P1		! Use editor specified in command line
;
;	<ACCGEN '$IDENT'> '<DATE>' '<TIME>'
;
; Accounting System Generation Procedure.
; Accounting System Version 7, January 1981.
;
;	Long comments provide a description of all the options and
;	requirements in building version 7 of the accounting
;	package. If you do not select long comments, many of the
;	questions can be answered with <ESC>, when the descriptive
;	text is displayed and the question is asked again.
;

.START:

.ASK $COMM 1. Do you want long comments
.IFT <ESCAPE> .GOTO START
.IFF $COMM .GOTO 10
;
;	You must be running on the exact version of the system that
;	is to be run with accounting.
;	Version 7 shares many features in common with version 6
;	but it is generally more efficient. The output format of
;	several commands is different and the handling of I/O
;	operations has changed.
;	The following tasks must be installed: MAC, TKB, PIP and
;	PRI if you use the Queue Manager.
;

.10:

.IFF $COMM .GOTO 11

.10A:

;
;	ACCGEN can create an answer file called ACCANSWER.CMD during
;	its execution. This file can be used to drive a subsequent
;	ACCGEN to rebuild the accounting package. This feature is
;	useful if a SYSGEN has been performed, since the accounting
;	package can be rebuilt without having to answer any of the
;	option questions. The answer files are assumed
;	to be stored under the current default UIC, on the device
;	currently assigned to SY:.
;

.11:

.ASK $SAVE 2. Save answers and create ACCANSWER.CMD
.IFT <ESCAPE> .GOTO 10A

.11A:

.ASK $AUTO 3. Use previous ACCANSWER.CMD to drive this ACCGEN
.IFT <ESCAPE> .GOTO 11A
.IFT $AUTO .DISABLE ESCAPE
.IFF $AUTO .SETS WAKE ""
.; *** The next string contains a CTRL/G (Bell)
.IFT $AUTO .SETS WAKE ""
.IFF $COMM .GOTO 12
.IFT $AUTO ;
.IFT $AUTO ; *NOTE*	In automatic mode, ACCGEN will cause the terminal
.IFT $AUTO ;		bell to ring and will pause if any undefined
.IFT $AUTO ;		answers are found. The <ESC> terminator to
.IFT $AUTO ;		the questions asked is illegal in these cases.
.IFT $AUTO ;
.IFF $AUTO .GOTO 12
;
;	ACCGEN will prompt you for any undefined answers that are
;	required during this run.
;

.12:

.IFT $AUTO @ACCANSWER.CMD

.IFF $COMM .GOTO 14

.13:

;
;	The accounting package supports either RSX-11M V3.2 or V4.0
;	in all configurations. You must select which system you are
;	to run accounting on, and furthermore, you must be running on
;	that system for this ACCGEN. If you answer NO to the next
;	question, ACCGEN will configure the system to run under
;	RSX-11M V3.2.
;

.14:

.IFT $AUTO .IFDF $RSXV4 .GOTO 15
.ASK $RSXV4 4.'WAKE' Are you running RSX-11M V4.0
.IFF $AUTO .IFT <ESCAPE> .GOTO 13

.15:

.IFT $AUTO ;
.IFT $AUTO .IFT $RSXV4 ;	RSX-11M V4.0 is the supported Executive.
.IFT $AUTO .IFF $RSXV4 ;	RSX-11M V3.2 is the supported Executive.

.IFF $COMM .GOTO 20

.19:

;
;	The accounting package provides support for a standard line
;	frequency clock (50 or 60 cycle) or a KW11-P programmable
;	clock. You cannot use another clock with the present version
;	without making changes to ACNODE.MAC. ACCGEN determines your
;	clock frequency from the SYSGEN-generated file RSXMC.MAC.
;

.20:

.IFT $AUTO .GOTO 30

.21:

.ASK $KW11L 5.'WAKE' Do you have a standard line frequency clock
.IFF $AUTO .IFT <ESCAPE> .GOTO 19
.IFT $KW11L .SETF $KW11P
.IFF $KW11L .SETT $KW11P
.IFF $KW11P .GOTO 39
;
;	ACCGEN will assume that you have a KW11-P programmable clock.
;
.GOTO 39

.30:

.IFDF $KW11L .GOTO 32
.IFNDF $KW11P .GO TO 31
.IFT $KW11P .SETF $KW11L
.IFT $KW11P .GOTO 38

.31:

;
; *ERROR* Clock type is not defined.
;
.GOTO 21

.32:

.IFDF $KW11P .GOTO 33
.IFT $KW11L .SETF $KW11P
.IFT $KW11L .GOTO 38
.IFF $KW11L .GOTO 31

.33:

.IFF $KW11L .OR .IFF $KW11P .GOTO 34
;
; *ERROR* Both clock types defined.
;
.GOTO 21

.34:

.IFT $KW11L .AND .IFF $KW11P .GOTO 38
.IFF $KW11L .AND .IFT $KW11P .GOTO 38
.GOTO 31

.38:

.IFT $KW11L ;
.IFT $KW11L ;	KW11-L line frequency clock defined.
.IFT $KW11L ;
.IFT $KW11P ;
.IFT $KW11P ;	KW11-P programmable clock defined
.IFT $KW11P ;

.39:

.IFF $COMM .GOTO 40
;
;	Now we determine the selection of options to be supported
;	by the accounting system. ACCGEN will construct a pre-assembly
;	file called ACCPRE.MAC which is used to control the assembly
;	of the accounting modules. This file contains conditional
;	assembly parameters and some macros, rather like RSXMC.MAC.
;	Its contents should never be altered: a new version should
;	be created only by running ACCGEN.
;
;	'<TIME>' '<DATE>'
;
;	Now delete files from previous ACCGENs.
;

.40:

PIP *.OBJ;*/DE/NM,*.LST;*,*.ASM;*
PIP LOGLIB.OLB;*/DE/NM,ACCLIB;*,RSULIB;*
PIP /FR	! Make sure there''s enough space on the volume.

.IFF $COMM .GOTO 60

.59:

;
;	If you want to keep a count of QIOs completed for each task
;	in the system in order to charge for I/O requests, or just to
;	keep a total of system-wide I/O activity to monitor system
;	load, you must select the next option.
;

.60:

.IFT $AUTO .IFDF $CQIO .GOTO 61
.ASK $CQIO 6.'WAKE' Do you want to intercept I/O activity
.IFF $AUTO .IFT <ESCAPE> .GOTO 59

.61:

.IFT $AUTO ;
.IFT $AUTO .IFT $CQIO ;	I/O monitoring support included.
.IFT $AUTO .IFF $CQIO ;	I/O monitoring support not included.
.IFF $CQIO .SETF $TQIO
.IFF $CQIO .GOTO 90
.IFF $COMM .GOTO 80

.69:

;
;	There are two possible ways to deal with I/O activity:
;	(1) Tasks are not charged for I/O, but a count is kept of
;	    total system-wide QIOs for the USE command, which
;	    prints a summary of system usage statistics (see later).
;	(2) Tasks are charged for I/O to all types of devices, as
;	    well as keeping a count for USE.
;
;	I/O activity is charged to tasks by making a count of the
;	number of I/O requests completed (those that make it as far
;	as the Executive routine $IOFIN). A charge is made based
;	on a selectable rate per request (not as in Version 6
;	where the I/O count was converted to an arbitrary time to be
;	charged at the same rate as CPU time. The end result is as
;	before, but the displays produced by the system are more
;	meaningful).
;
;	If you answer no to the next question, a count of system-
;	wide QIOs is kept for the USE command, but individual tasks
;	are not charged for I/O. An answer of no automatically
;	selects support for the USE command, since you have
;	requested that I/O be intercepted.
;

.80:

.IFT $AUTO .IFDF $TQIO .GOTO 89
.ASK $TQIO 7.'WAKE' Should tasks be charged for I/O
.IFF $AUTO .IFT <ESCAPE> .GOTO 69

.89:

.IFT $AUTO ;
.IFT $AUTO .IFT $TQIO ;	Tasks will be charged for I/O.
.IFT $AUTO .IFF $TQIO ;	Tasks will not be charged for I/O.
.IFF $TQIO .SETT $SUSE
.IFF $TQIO .GOTO 100

.90:

.IFF $COMM .GOTO 100

.99:

;
;	The USE command gives details of system use. It has two options:
;	(1) Display average system use over the last "n" minutes,
;	where n is equal to the reschedule time of accounting task
;	UPD... in the clock queue;
;	(2) Display average system use since system boot.
;	If you select support for USE, the display will include the
;	amount of CPU time used by users, the executive, and the null
;	task (idle time). Optionally, you can include the average
;	rate of issuance of I/O requests, the average rate of
;	issuance of loader requests (that is, the checkpoint rate plus
;	the rate of initial load requests), and the context switching
;	rate.  The second option can be
;	selected to be available to only privileged users if you wish.
;

.100:

.IFT $AUTO .IFDF $SUSE .GOTO 101
.ASK $SUSE 8.'WAKE' Do you want support for the USE command
.IFF $AUTO .IFT <ESCAPE> .GOTO 99

.101:

.IFT $AUTO ;
.IFT $AUTO .IFT $SUSE ;	USE command supported.
.IFT $AUTO .IFF $SUSE ;	USE command not supported.
.IFF $SUSE .SETF $CLDR
.IFF $SUSE .SETF $CSWT
.IFF $SUSE .SETF $UPRV
.IFF $SUSE .GOTO 115
.IFT $AUTO .IFDF $CLDR .GOTO 103

.102:

.ASK $CLDR 9.'WAKE' Do you want USE to display the loader rate
.IFF $AUTO .IFT <ESCAPE> .GOTO 102

.103:

.IFT $AUTO ;
.IFT $AUTO .IFT $CLDR ;	Loader requests will be monitored for USE.
.IFT $AUTO .IFF $CLDR ;	USE will not display Loader rate information.
.IFT $AUTO .IFDF $CSWT .GOTO 105

.104:

.ASK $CSWT 10.'WAKE' Do you want USE to display the context switching rate
.IFF $AUTO .IFT <ESCAPE> .GOTO 104

.105:

.IFT $AUTO ;
.IFT $AUTO .IFT $CSWT ;	USE will display the context switching rate.
.IFT $AUTO .IFF $CSWT ;	USE will not display the context switching rate.
.IFT $AUTO .IFDF $UPRV .GOTO 115

.106:

.ASK $UPRV 11.'WAKE' Do you want the USE /FU option to be privileged
.IFF $AUTO .IFT <ESCAPE> .GOTO 106

.115:

.IFT $AUTO ;
.IFT $AUTO .IFT $UPRV ;	/FU is a privileged option of USE.
.IFT $AUTO .IFF $UPRV ;	/FU will not be a privileged USE option.
.IFF $COMM .GOTO 120

.119:

;
;	The accounting system can be constructed so that each
;	task is charged for CPU depending on its priority, with
;	higher priorities costing more.  I/O charges are not
;	affected by the priority (unlike Version 6). This option
;	adds a little overhead at each context switch, but not
;	much. If you do not select this option, all tasks are charged
;	the same regardless of their priorities. The average priority
;	of a task is examined at each context switch such that any
;	changes to priorities made by ALT TASK/PRI= will be reflected
;	in the charges. The "priority factor" is defined as the constant
;	F such that the charges for a task are multiplied by 
;		(F+P)/(F+50)
;	where P is the task''s average priority.  The higher F is, the
;	less discrimination there is between different priorities. A low
;	value of F makes low priorities cheap and high priorities
;	expensive. A typical value of F is 30 (decimal), and will be
;	the default if you answer question 13 with a <CR>
;

.120:

.IFT $AUTO .IFDF $FPRI .GOTO 121
.ASK $FPRI 12.'WAKE' Do you want support for the priority factor
.IFF $AUTO .IFT <ESCAPE> .GOTO 119

.121:

.IFT $AUTO ;
.IFT $AUTO .IFT $FPRI ;	Priority factor support included.
.IFT $AUTO .IFF $FPRI ;	Priority factor support not included.
.IFF $FPRI .SETN $VFPRI 0
.IFF $FPRI .GOTO 130
.IFT $AUTO .IFDF $VFPRI .GOTO 130

.122:

.ASKN [5.:255.:30.] $VFPRI 13.'WAKE' Value of priority factor constant
.IFF $AUTO .IFT <ESCAPE> .GOTO 121

.130:

.IFT $AUTO ;
.IFT $AUTO .IFT $FPRI ;	Priority factor constant is '$VFPRI'.
.IFF $COMM .GOTO 140

.139:

;
;	Any tasks that run under the system UIC, as established by
;	SET /SYSUIC, can be exempt from accounting if they are running
;	on TT0:. This option saves a little pool while the system is
;	running. It should be selected if you are not interested in
;	any system tasks, or do not have much pool to begin with.
;

.140:

.IFT $AUTO .IFDF $STEM .GOTO 141
.ASK $STEM 14.'WAKE' Do you want to exclude system tasks
.IFF $AUTO .IFT <ESCAPE> .GOTO 139

.141:

.IFT $AUTO ;
.IFT $AUTO .IFT $STEM ;	System tasks will be excluded from accounting.
.IFT $AUTO .IFF $STEM ;	System tasks will be included in accounting.
.IFF $COMM .GOTO 160

.159:

;
;	The task CPU allows you to find out how much CPU time was
;	used and/or how many I/O requests were issued by a
;	particular task. Messages reporting this data are sent by
;	the accounting system to the terminal every time a
;	task exits if you have enabled reporting by typing CPU /ON.
;	Messages can be cancelled at a later time by typing CPU /OFF.
;	Version 7 supports a second function of the CPU command;
;	charge redirection. If a privileged user changes his UIC by
;	means of SET /UIC, the logon UIC of the terminal is changed
;	also. The accounting system will then attempt to charge to
;	the new UIC. Non-privileged users do not change their logon
;	UIC in this fashion and so are not affected. The command
;	CPU /DS disables this charge redirection, which is useful if
;	you are performing a SYSGEN, for example. The command 
;	CPU /EN re-enables redirection. These two types of
;	function are independent, but are serviced by the same
;	command. You can have either /ON or /OFF at logon,
;	and either /EN or /DS. It is recommended that you don''t
;	have /EN at logon as default.
;

.160:

.IFT $AUTO .IFDF $SCPU .GOTO 161
.ASK $SCPU 15.'WAKE' Do you want CPU time and I/O request messages (ON/OFF)
.IFF $AUTO .IFT <ESCAPE> .GOTO 159

.161:

.IFT $AUTO ;
.IFT $AUTO .IFT $SCPU ;	CPU /ON and /OFF functions supported.
.IFT $AUTO .IFF $SCPU ;	CPU /ON and /OFF functions not supported.
.IFF $SCPU .SETF $CPUO
.IFF $SCPU .GOTO 170
.IFT $AUTO .IFDF $CPUO .GOTO 170

.162:

.ASK $CPUO 16.'WAKE' Do you want these messages to be the logon default
.IFF $AUTO .IFT <ESCAPE> .GOTO 162

.170:

.IFT $AUTO ;
.IFT $AUTO .IFT $SCPU .IFT $CPUO ;	CPU /ON is the logon default.
.IFT $AUTO .IFT $SCPU .IFF $CPUO ;	CPU /OFF is the logon default.
.IFT $AUTO .IFDF $ENDS .GOTO 171
.ASK $ENDS 17.'WAKE' Do you want charge redirection support (EN/DS)
.IFF $AUTO .IFT <ESCAPE> .GOTO 170

.171:

.IFT $AUTO ;
.IFT $AUTO .IFT $ENDS ;	CPU /EN  and /DS functions supported.
.IFT $AUTO .IFF $ENDS ;	CPU /EN and /DS functions not supported.
.IFF $ENDS .SETF $CENB
.IFF $ENDS .GOTO 180
.IFT $AUTO .IFDF $CENB .GOTO 180

.172:

.ASK $CENB 18.'WAKE' Do you want redirection enabled at logon
.IFF $AUTO .IFT <ESCAPE> .GOTO 172

.180:

.IFT $AUTO ;
.IFT $AUTO .IFT $ENDS .IFT $CENB ;	CPU /EN is the logon default.
.IFT $AUTO .IFT $ENDS .IFF $CENB ;	CPU /DS is the logon default.
.IFF $COMM .GOTO 190

.189:

;
;	The task LOG... is a permanently running part of the accounting
;	system which maintains various counts for logged-in users and
;	intercepts commands from other accounting system tasks. It can
;	be built as overlaid or non-overlaid. Bear in mind that LOG... is
;	always resident in core (it is built non-checkpointable).
;	It builds by default for a user-controlled partition called
;	LOGPAR. The overlaid version allows more users to log on at once
;	than the non-overlaid version. You are recommended to select the
;	overlaid version.
;

.190:

.IFT $AUTO .IFDF $LOVR .GOTO 191
.ASK $LOVR 19.'WAKE' Do you want the overlaid version of LOG...
.IFF $AUTO .IFT <ESCAPE> .GOTO 189

.191:

.IFT $AUTO ;
.IFT $AUTO .IFT $LOVR ;	Task LOG... will be overlaid.
.IFT $AUTO .IFF $LOVR ;	Task LOG... will not be overlaid.
.IFF $COMM .GOTO 200

.199:

;
;	If your system runs any privileged tasks which are allowed
;	to execute after logging off (BYE allows this),  or has any
;	privileged users that change their logon UIC with redirection
;	enabled, the task ALT... is required to perform the necessary
;	accounting when these tasks finish. If you don''t select support
;	for this accounting system task, all accounting information for
;	these tasks is ignored, unless the user happens to be logged
;	on at another terminal when the task exits. 
;
;	All pages printed while the user is logged off are charged by
;	ALT also, providing that you use the Queue Manager and have
;	made the required changes to LPP (see the documentation).
;

.200:

.IFT $AUTO .IFDF $SALT .GOTO 201
.ASK $SALT 20.'WAKE' Do you want support for the task ALT...
.IFF $AUTO .IFT <ESCAPE> .GOTO 199

.201:

.IFT $AUTO ;
.IFT $AUTO .IFT $SALT ;	The auxiliary logging task ALT... is supported.
.IFT $AUTO .IFF $SALT ;	The auxiliary logging task ALT... is not supported.
.IFF $COMM .GOTO 210

.209:

;
;	In connection with charge redirection, if CPU /EN is
;	in effect, you can either have ALT... log the task
;	if the logon UIC has been changed, or you can have
;	this logging take place only if the group code has
;	changed. That is, the time used by any tasks run at the
;	terminal will still be made to the current terminal session
;	if the group code is still the same. If you set up
;	users in groups by the group number, it is a good idea to
;	select this option.
;

.210:

.IFT $AUTO .IFDF $CGRP .GOTO 211
.ASK $CGRP 21.'WAKE' Do you want accounting by group code
.IFF $AUTO .IFT <ESCAPE> .GOTO 209

.211:

.IFT $AUTO ;
.IFT $AUTO .IFT $CGRP ;	Accounting is by group code if logon UIC changes.
.IFT $AUTO .IFF $CGRP ;	Logon UIC change will cause charge redirection.
.IFF $COMM .GOTO 220

.219:

;
;	The TSF command provides you with information on how
;	much CPU time or I/O requests has been used by your terminal
;	session since you logged on. Its format is:
;	  TSF		Gives info. on all tasks, stopped or running.
;	  TSF /RUN	Gives info. on only your running tasks.
;	  TSF /FIN	Gives info. on only tasks that have exited.
;	In each case, a privileged user may precede the switch with
;	a device specification (it must be a terminal) to find out
;	information for other terminals, for example,
;	  TSF TT4:/RUN
;	A non-privileged user cannot specify a different terminal
;	from his own, unless the logon UIC of that terminal is the
;	same. If you want to use the FORTRAN subroutine CPTIME, you
;	must select this option.
;	Also, TSF command support allows you to use the terminal
;	watcher task WATCHR to log off idle terminals.
;

.220:

.IFT $AUTO .IFDF $STSF .GOTO 221
.ASK $STSF 22.'WAKE' Do you want support for the TSF command
.IFF $AUTO .IFT <ESCAPE> .GOTO 219

.221:

.IFT $AUTO ;
.IFT $AUTO .IFT $STSF ;	The TSF command is supported.
.IFT $AUTO .IFF $STSF ;	The TSF command is not supported.
.IFF $COMM .GOTO 224

.223:

;
;	The accounting system can be built with or without support for
;	Versions 2 or 3 of the Batch System. If batch support is
;	selected, jobs can run with time limits measured in CPU used
;	rather than elapsed time, and charges can be made for these
;	jobs. This support is independent of support of the TSF command,
;	unlike Version 6 of the accounting package.
;

.224:

.IFT $AUTO .IFDF $SBAT .GOTO 225
.ASK $SBAT 23.'WAKE' Do you want Batch System support
.IFF $AUTO .IFT <ESCAPE> .GOTO 223

.225:

.IFT $AUTO ;
.IFT $AUTO .IFT $SBAT ;	The Batch System is supported.
.IFT $AUTO .IFF $SBAT ;	The Batch System is not supported.
.IFF $SCPU .SETF $FRMT
.IFF $SCPU .SETN $VFRMT 0
.IFF $SCPU .GOTO 233
.IFF $COMM .GOTO 230

.229:

;
;	When you receive accounting messages from the system (after CPU
;	/ON), the time of day can be optionally displayed. You can
;	choose from several formats:
;	(1) HH
;	(2) HH:MM
;	(3) HH:MM:SS
;	(4) HH:MM:SS.T
;

.230:

.IFT $AUTO .IFDF $FRMT .GOTO 231
.ASK $FRMT 24.'WAKE' Do you want the time of day in CPU messages
.IFF $AUTO .IFT <ESCAPE> .GOTO 229

.231:

.IFT $AUTO ;
.IFT $AUTO .IFT $FRMT ;	CPU and I/O used messages will contain time of day.
.IFT $AUTO .IFF $FRMT ;	CPU and I/O used messages will not be time-stamped.
.IFF $FRMT .SETN $VFRMT 0
.IFF $FRMT .GOTO 233
.IFT $AUTO .IFDF $VFRMT .GOTO 232A

.232:

.ASKN [1:4:3] $VFRMT 25.'WAKE' What time format do you want
.IFF $AUTO .IFT <ESCAPE> .GOTO 232

.232A:

.IFT $AUTO ;
.IFT $AUTO .IF $VFRMT EQ 1 ;	Time format will be HH.
.IFT $AUTO .IF $VFRMT EQ 2 ;	Time format will be HH:MM
.IFT $AUTO .IF $VFRMT EQ 3 ;	Time format will be HH:MM:SS
.IFT $AUTO .IF $VFRMT EQ 4 ;	Time format will be HH:MM:SS.T

.233:

.IFT $AUTO ;
.IFF $COMM .GOTO 240

.239:

;
;	The task LOG... will time out messages to terminals if any
;	delays occur if you select the next option. If you have only
;	CRTs or fast terminals there is no need to select this option.
;	An answer of RETURN alone to question 27 default to 180 ticks
;	(3 seconds for a 60-cycle clock).
;

.240:

.IFT $AUTO .IFDF $TOUT .GOTO 241
.ASK $TOUT 26.'WAKE' Do you want LOG... message timeout support
.IFF $AUTO .IFT <ESCAPE> .GOTO 239

.241:

.IFT $AUTO ;
.IFT $AUTO .IFT $TOUT ;	LOG... message timeout is supported.
.IFT $AUTO .IFF $TOUT ;	LOG... message timeout is not supported.
.IFF $TOUT .SETN $VTOUT 0
.IFF $TOUT .GOTO 250
.IFT $AUTO .IFDF $VTOUT .GOTO 243

.242:

.ASKN [30.:1000.:180.] $VTOUT 27.'WAKE' What is the timeout count (in ticks)
.IFF $AUTO .IFT <ESCAPE> .GOTO 242

.243:

.IFT $AUTO ;
.IFT $AUTO ;	Timeout period will be '$VTOUT'. ticks.

.250:

.IFF $COMM .GOTO 260

.259:

;
;	If charges have been redirected by means of CPU /EN and a
;	change of logon UIC, CPU messages will appear for the
;	redirected account if it is logged on and has CPU /ON. If
;	you select this option, messages of this sort are flagged
;	with the specification (TTn:) of the terminal that caused the
;	redirection.
;

.260:

.IFT $AUTO .IFDF $DTRM .GOTO 261
.ASK $DTRM 28.'WAKE' Do you want redirected charge notification
.IFF $AUTO .IFT <ESCAPE> .GOTO 259

.261:

.IFT $AUTO ;
.IFT $AUTO .IFT $DTRM ;	Charge redirection notification supported.
.IFT $AUTO .IFF $DTRM ;	Charge redirection notification not supported.
.IFF $COMM .GOTO 270

.269:

;
;	The task BAL is the account balance maintenance program, and
;	is used to maintain account balance. If it is run at a privileged
;	terminal, you have the option of having BAL ask for a password
;	before it will let you modify any accounts. The response to the
;	password prompt from BAL should be in UPPER case. If it is
;	installed and run from a non-privileged terminal, the password
;	logic (if selected) is bypassed, and the account parameters of
;	the user are displayed. In this case, no modifications are
;	permitted.
;

.270:

.IFT $AUTO .IFDF $PSWD .GOTO 271
.ASK $PSWD 29.'WAKE' Do you want BAL password support
.IFF $AUTO .IFT <ESCAPE> .GOTO 269

.271:

.IFF $PSWD .SETS $MPAS ""
.IFF $PSWD .GOTO 278
.IFT $AUTO .IFDF $MPAS .GOTO 274

.272:

.ASKS $MPAS 30.'WAKE' What password would you like (default=PENGE)
.IFF $AUTO .IFT <ESCAPE> .GOTO 272
.IF $MPAS EQ "" .SETS $MPAS "PENGE"

.274:

.IFT $AUTO ;
.IFT $AUTO ;	BAL password support included: password is '$MPAS'.

.278:

.IFF $COMM .GOTO 280

.279:

;
;	BAL can be used to give each account an allocation of disk
;	blocks. During normal disk accounting, any user that has a
;	larger number of blocks than his allocation is charged double
;	for those blocks in excess if you select this option. Also,
;	if the average block use since the start of the current
;	accounting period exceeds the allocation, HELLO will type out
;	a warning message when the user logs on.
;	Disk Accounting is normally built-in to the accounting
;	system. If you do not want it, delete the file DISK.TSK
;	at the end of ACCGEN; the file STARTUP.CMD will have to be
;	edited too; but it contains all instructions to do this.
;

.280:

.IFT $AUTO .IFDF $BALL .GOTO 281
.ASK $BALL 31.'WAKE' Do you want Block Allocation support
.IFF $AUTO .IFT <ESCAPE> .GOTO 279

.281:

.IFT $AUTO ;
.IFT $AUTO .IFT $BALL ;	Block Allocation support included.
.IFT $AUTO .IFF $BALL ;	Block Allocation support not included.
.IFF $COMM .GOTO 290

.289:

;
;	BAL can be used in two ways to maintain account balances.
;	Either a user can purchase a certain amount of time and have
;	the balance updated accordingly, or you can give each user
;	a specific allocation. In the latter case, this amount of money
;	will be the balance of each account at the start of each
;	new accounting period. In this case, users should be billed
;	for their actual usage at suitable intervals. All data
;	necessary for doing this is maintained automatically by the
;	accounting system. Whichever method is used, logon is prohibited
;	when the account balance falls below zero.
;

.290:

.IFT $AUTO .IFDF $MALL .GOTO 291
.ASK $MALL 32.'WAKE' Do you want Monthly Balance Allocation support
.IFF $AUTO .IFT <ESCAPE> .GOTO 289

.291:

.IFT $AUTO ;
.IFT $AUTO .IFT $MALL ;	Monthly Balance Allocation supported.
.IFT $AUTO .IFF $MALL ;	Monthly Balance Allocation not supported.

.IFF $COMM .GOTO 330

.329:

;
;	Each file on the disk requires one block in the index file for its
;	file header, plus additional blocks for extension headers for large
;	or very fragmented files. Thus a user with 1000 blocks in 10
;	files is taking up less disk space than a user with 1000 blocks
;	in 100 files. If you answer yes to the next question, the disk
;	accounting system will take into account the space each user has got
;	in the index file when it calculates the charges. This option adds
;	no additional overhead to the normal disk accounting procedure.
;

.330:

.IFT $AUTO .IFDF $CFIL .GOTO 331
.ASK $CFIL 33.'WAKE' Should disk accounting include index file space
.IFF $AUTO .IFT <ESCAPE> .GOTO 329

.331:

.IFT $AUTO ;
.IFT $AUTO .IFT $CFIL ;	Disk accounting will include index file space.
.IFT $AUTO .IFF $CFIL ;	Disk accounting will not include index file space.

.IFF $SUSE .SETF $STAT
.IFF $SUSE .GOTO 358
.IFF $COMM .GOTO 350

.349:

;
;	Since you have selected USE support, it is possible for the system
;	to record the selected load statistics in a file for later analysis
;	by either RSU or a user-written program. This enables you to obtain
;	a plot of the system load as a function of time of day.
;

.350:

.IFT $AUTO .IFDF $STAT .GOTO 351
.ASK $STAT 34.'WAKE' Do you want to record load statistics in a file
.IFF $AUTO .IFT <ESCAPE> .GOTO 349

.351:

.IFT $AUTO ;
.IFT $AUTO .IFT $STAT ;	Load statistics will be recorded in a file.
.IFT $AUTO .IFF $STAT ;	Load statistics will not be recorded in a file.

.358:

.IFF $COMM .GOTO 360

.359:

;
;	A simple algorithm is implemented to provide accounting for usage
;	of main memory. This feature is independent of any others, and
;	adds no significant overhead to the operation of the system.
;	Both checkpointable and non-checkpointable tasks are handled
;	correctly, and a simple measure of task extension is provided.
;

.360:

.IFT $AUTO .IFDF $SMEM .GOTO 361
.ASK $SMEM 35.'WAKE' Do you want memory usage accounting
.IFF $AUTO .IFT <ESCAPE> .GOTO 359

.361:

.IFT $AUTO ;
.IFT $AUTO .IFT $SMEM ;	Memory usage accounting is supported.
.IFT $AUTO .IFF $SMEM ;	Memory usage accounting is not supported.

.IFF $COMM .GOTO 370

.369:

;
;	Charges for resource usage may be made in terms of dollars or
;	"accounting units". Selection of either of these units just
;	alters the formatting routines used by the system, and has
;	no other effect. If you answer NO to the next question,
;	charges will be displayed in units of dollars.
;

.370:

.IFT $AUTO .IFDF $FUNI .GOTO 371
.ASK $FUNI 36.'WAKE' Do you want charges in "accounting units"
.IFF $AUTO .IFT <ESCAPE> .GOTO 369

.371:

.IFT $AUTO ;
.IFT $AUTO .IFT $FUNI ;	Charges will be made in "accounting units".
.IFT $AUTO .IFF $FUNI ;	Charges will be made in "dollars".

.OK:

.IFF $AUTO .ASK BLEWIT 37. Are you satisfied with your answers
.IFT $AUTO .GOTO ANS1
.IFT BLEWIT .GOTO ANS1
;
;	ACCGEN will return to the beginning and let you answer
;	the questions again.
;
.GOTO START

.ANS1:

.IFF $SAVE .GOTO CONSAP
;
; '<TIME>' '<DATE>' Construct answer file ACCANSWER.CMD
;
.OPEN ACCANSWER.CMD
.ENABLE DATA
;
; Answer file constructed by ACCGEN '$IDENT' on '<DATE>' at '<TIME>'
;
.ENABLE GLOBAL
.DISABLE DATA
.IFT $RSXV4 .DATA .SETT $RSXV4
.IFF $RSXV4 .DATA .SETF $RSXV4
.IFT $KW11L .DATA .SETT $KW11L
.IFF $KW11L .DATA .SETF $KW11L
.IFT $KW11P .DATA .SETT $KW11P
.IFF $KW11P .DATA .SETF $KW11P
.IFT $CQIO .DATA .SETT $CQIO
.IFF $CQIO .DATA .SETF $CQIO
.IFT $TQIO .DATA .SETT $TQIO
.IFF $TQIO .DATA .SETF $TQIO
.IFT $SUSE .DATA .SETT $SUSE
.IFF $SUSE .DATA .SETF $SUSE
.IFT $CLDR .DATA .SETT $CLDR
.IFF $CLDR .DATA .SETF $CLDR
.IFT $CSWT .DATA .SETT $CSWT
.IFF $CSWT .DATA .SETF $CSWT
.IFT $STAT .DATA .SETT $STAT
.IFF $STAT .DATA .SETF $STAT
.IFF $SMEM .DATA .SETF $SMEM
.IFT $SMEM .DATA .SETT $SMEM
.IFT $UPRV .DATA .SETT $UPRV
.IFF $UPRV .DATA .SETF $UPRV
.IFT $FPRI .DATA .SETT $FPRI
.IFF $FPRI .DATA .SETF $FPRI
.IFT $FPRI .DATA .SETN $VFPRI '$VFPRI'.
.IFT $STEM .DATA .SETT $STEM
.IFF $STEM .DATA .SETF $STEM
.IFT $SCPU .DATA .SETT $SCPU
.IFF $SCPU .DATA .SETF $SCPU
.IFT $CPUO .DATA .SETT $CPUO
.IFF $CPUO .DATA .SETF $CPUO
.IFT $ENDS .DATA .SETT $ENDS
.IFF $ENDS .DATA .SETF $ENDS
.IFT $CENB .DATA .SETT $CENB
.IFF $CENB .DATA .SETF $CENB
.IFT $LOVR .DATA .SETT $LOVR
.IFF $LOVR .DATA .SETF $LOVR
.IFT $SALT .DATA .SETT $SALT
.IFF $SALT .DATA .SETF $SALT
.IFT $CGRP .DATA .SETT $CGRP
.IFF $CGRP .DATA .SETF $CGRP
.IFT $STSF .DATA .SETT $STSF
.IFF $STSF .DATA .SETF $STSF
.IFT $SBAT .DATA .SETT $SBAT
.IFF $SBAT .DATA .SETF $SBAT
.IFT $FRMT .DATA .SETT $FRMT
.IFF $FRMT .DATA .SETF $FRMT
.IFT $FRMT .DATA .SETN $VFRMT '$VFRMT'.
.IFT $TOUT .DATA .SETT $TOUT
.IFF $TOUT .DATA .SETF $TOUT
.IFT $TOUT .DATA .SETN $VTOUT '$VTOUT'.
.IFT $DTRM .DATA .SETT $DTRM
.IFF $DTRM .DATA .SETF $DTRM
.IFT $PSWD .DATA .SETT $PSWD
.IFF $PSWD .DATA .SETF $PSWD
.IFT $PSWD .DATA .SETS $MPAS "'$MPAS'"
.IFT $BALL .DATA .SETT $BALL
.IFF $BALL .DATA .SETF $BALL
.IFT $MALL .DATA .SETT $MALL
.IFF $MALL .DATA .SETF $MALL
.IFT $CFIL .DATA .SETT $CFIL
.IFF $CFIL .DATA .SETF $CFIL
.IFT $FUNI .DATA .SETT $FUNI
.IFF $FUNI .DATA .SETF $FUNI
.CLOSE

.CONSAP:

;
; '<TIME>' '<DATE>' Construct pre-assembly file ACCPRE.MAC.
.IFT $COMM ;		All conditional assembly parameters are of the
.IFT $COMM ;		form AA$XXX to avoid conflict with the DEC
.IFT $COMM ;		conditional assembly parameters of the form
.IFT $COMM ;		X$$XXX.
	;
.OPEN ACCPRE.MAC
.ENABLE DATA
	.TITLE ACCPRE
	.IDENT	/'$IDENT'/
;
; Pre-assembly file for accounting system Version 7.
.DISABLE DATA
.IFT $RSXV4 .DATA ; RSX-11M V4.0 (AA$V40 is defined)
.IFF $RSXV4 .DATA ; RSX-11M V3.2 (AA$V40 is undefined)
.ENABLE DATA
; Constructed by ACCGEN '$IDENT' on '<DATE>' at '<TIME>'
;
AA$RSY	=	0	; Always defined in V7
AA$SHF	=	0	; Always defined in V7
AA$UFD	=	0	; Always defined in V7
.DISABLE DATA
.IFT $RSXV4 .DATA AA$V40	=	0	; RSX-11M V4.0 support
.IFT $KW11L .DATA AA$VEC	=	100	; KW11-L line frequency clock
.IFT $KW11P .DATA AA$VEC	=	104	; KW11-P programmable clock
.IFT $SMEM .DATA AA$MEM	=	0		; Memory accounting support
.IFT $CQIO .DATA AA$QIO	=	0		; Count system-wide QIOs
.IFT $TQIO .DATA AA$TCQ	=	0		; Charge tasks for I/O
.IFT $SUSE .DATA AA$USE	=	0		; USE command support
.IFT $CLDR .DATA AA$LDR	=	0		; USE gives loader rate
.IFT $CSWT .DATA AA$CSW	=	0		; USE gives context switch rate
.IFT $STAT .DATA AA$STA	=	0		; Load statistics in a file
.IFT $UPRV .DATA AA$USP	=	0		; USE/FU is privileged
.IFT $FPRI .DATA AA$FPR	=	'$VFPRI'.	; Priority factor constant
.IFT $STEM .DATA AA$SYS	=	0		; Exclude system tasks
.IFT $SALT .DATA AA$ALT	=	0		; ALT... support
.IFT $SCPU .DATA AA$CPU	=	0		; CPU/ON and /OFF functions
.IFT $CPUO .DATA AA$PUO	=	0		; CPU/ON at logon
.IFT $ENDS .DATA AA$ENA	=	0		; CPU/EN and /DS functions
.IFT $CENB .DATA AA$ENB	=	0		; CPU/EN at logon
.IFT $LOVR .DATA AA$OVR	=	0		; Overlaid LOG...
.IFT $CGRP .DATA AA$GRP	=	0		; Accounting by group code
.IFT $STSF .DATA AA$TSF	=	0		; TSF command support
.IFT $SBAT .DATA AA$BAT	=	0		; Batch system support
.IFT $FRMT .DATA AA$FRM	=	'$VFRMT'.	; CPU message format
.IFT $TOUT .DATA AA$TOU	=	'$VTOUT'.	; LOG message timeout count
.IFT $DTRM .DATA AA$DTM	=	0		; Diff. term. messages
.IFT $PSWD .DATA AA$PSW	=	0		; BAL password support
.IFT $BALL .DATA AA$BLK	=	0		; Block allocation support
.IFT $MALL .DATA AA$MMA	=	0		; Monthly alloc. support
.IFT $CFIL .DATA AA$CFL	=	0		; Include index file space
.IFT $FUNI .DATA AA$UNI	=	0		; Charge in units, not $
.ENABLE DATA
;
	.MACRO	MOVSTR	STR,SAVER1
	.IF NB	SAVER1
	MOV	R1,-(SP)
	.IFTF
	MOV	STR,R1
	CALL	MV.STR
	.IFT
	MOV	(SP)+,R1
	.ENDC
	.ENDM
;
.DISABLE DATA
.IFF $PSWD .GOTO CLO
.ENABLE DATA
	.MACRO	MPASS
	.ENABL	LC
	PASS:	.ASCII	/'$MPAS'/
	PASSZ=.-PASS
	.DSABL	LC
	.ENDM
;
.DISABLE DATA

.CLO:

.CLOSE

PIP ACCPRE.MAC=ACCDF.MAC/AP,BITDF,ACTDF,FILDF,STADF,BATDV
.ENABLE ESCAPE
.IFF $COMM .GOTO EXEMC
;
;	There follow two questions concerning the location of two
;	Executive files. The rules for answering are as follows:
;	(1) An answer of RETURN defaults to the device/UFD in the question.
;	(2) An answer of ESCAPE defaults the the user''s current SY:/UIC.
;	(3) An answer of ddnn:[ggg,mmm] uses the value entered.
;	Please enter both the device and UIC if format (3) is used.
;	The type of answer you give will depend on how you set up the
;	files EXEMC.MLB and RSXMC.MAC before running ACCGEN.
;

.EXEMC:

.ASKS LIBUIC Where is EXEMC.MLB if not LB:[1,1]
.IFT <ESCAPE> .SETS LIBUIC "SY:'<UIC>'"
.IFF <ESCAPE> .IF LIBUIC EQ "" .SETS LIBUIC "LB:[1,1]"
.ASKS RSXMC Where is RSXMC.MAC if not LB:[200,200]?
.IFT <ESCAPE> .SETS RSXMC "SY:'<UIC>'"
.IFF <ESCAPE> .IF RSXMC EQ "" .SETS RSXMC "LB:[200,200]"
.IFF $COMM .GOTO SPL
;
;	Now we can go ahead and assemble all the modules.
;

.SPL:

.ASKS SRCDEV Device and UIC for source files (ddu:[g,m], default is SY:'<UIC>')
.IF SRCDEV EQ "" .SETS SRCDEV "SY:'<UIC>'"
.SETF SPOOL
.SETF QMG
.SETS LSTDEV "SY:"
.ASK LIST Do you want assembly listings
.IFT LIST .ASKS LSTDEV What is the listing device (ddu:, default is SY:)
.IFT LIST .IF LSTDEV EQ "" .SETS LSTDEV "SY:"
.IFT LIST .ASK QMG Use Queue Manager to print listings
.IFT LIST .IFF QMG .ASK SPOOL Spool listing files
.IFT LIST .IFT SPOOL .SETS LSTDEV "SY0:"
.IFT LIST .IFT QMG .SETS LSTDEV "SY0:"
.IFF $COMM .GOTO COM1
;
;	Now we start the assembly phase, so you can go and have a
;	cup of coffee. ACCGEN will create assembly files (type ASM)
;	for each module that requires assembly.

.COM1:

.TSTHEL:

.TESTFILE HELV7.MAC
.IF <FILERR> EQ 1 .GOTO TSTBYE
.SETN FCSNUM 256.-<FILERR>
;
;	'WAKE'*WARNING* File HELV7.MAC has problems: FCS -'FCSNUM'.
;	Please correct this situation (did you run SLP?).
;
.PAUSE

.TSTBYE:

.TESTFILE BYEV7.MAC
.IF <FILERR> EQ 1 .GOTO TSTOK
.SETN FCSNUM 256.-<FILERR>
;
;	'WAKE'*WARNING* File BYEV7.MAC has problems: FCS -'FCSNUM'.
;	Please correct the situation (did you run SLP?).
;
.PAUSE

.TSTOK:

;
; '<TIME>' '<DATE>' Begin assembly.
;
; First build a library with some utility routines in it.
;
.SETT $EXEC
.SETS FILE "TEFF"
.GOSUB ASM
.SETS FILE "FMTCPU"
.GOSUB ASM
.SETS FILE "FMTCON"
.GOSUB ASM
.IFT $FUNI MAC FMTUNI=FMTUNI
.IFF $FUNI MAC FMTDLR=FMTDLR
.IFT $FUNI LBR ACCLIB/CR:6.:64.:64.=TEFF,FMTCPU,FMTCON,FMTUNI
.IFF $FUNI LBR ACCLIB/CR:6.:64.:64.=TEFF,FMTCPU,FMTCON,FMTDLR
;
; '<TIME>' '<DATE>' Assemble routines for HELLO (logon) processor.
;
.SETT $EXEC
.SETS FILE "ACCHEL"
.GOSUB ASM
.SETS FILE "HELV7"
.GOSUB ASM
;
; '<DATE>' '<TIME>' Assemble routines for BYE (logoff) processor.
;
.SETT $EXEC
.SETS FILE "ACCBYE"
.GOSUB ASM
.SETS FILE "BYEV7"
.GOSUB ASM
;
; '<DATE>' '<TIME>' Assemble task ACNODE.TSK
;
.SETT $EXEC
.SETS FILE "ACNODE"
.GOSUB ASM
;
; '<DATE>' '<TIME>' Assemble all routines for LOG...
;
.SETT $EXEC
.SETS FILE "LOGROT"
.GOSUB ASM
.SETS FILE "HELOVR"
.GOSUB ASM
.SETS FILE "BYEOVR"
.GOSUB ASM
.SETS FILE "CPUOVR"
.GOSUB ASM
.SETS FILE "CHGOVR"
.GOSUB ASM
.SETS FILE "INIOVR"
.GOSUB ASM
.SETS FILE "NDEOVR"
.GOSUB ASM
.SETS FILE "GACOVR"
.GOSUB ASM
.SETS FILE "TSFOVR"
.GOSUB ASM
.SETS FILE "TSKOVR"
.GOSUB ASM
.SETS FILE "UPDOVR"
.GOSUB ASM
.SETS FILE "USEOVR"
.GOSUB ASM
.SETS FILE "USFOVR"
.GOSUB ASM
.SETS FILE "PAGOVR"
.GOSUB ASM
LBR LOGLIB/CR:42.:512.:64.=LOGROT,BYEOVR,CPUOVR,HELOVR,INIOVR
LBR LOGLIB/IN=NDEOVR,TSFOVR,UPDOVR,USEOVR,USFOVR,TSKOVR
LBR LOGLIB/IN=CHGOVR,PAGOVR,GACOVR
PIP LOGROT.OBJ;*/DE/NM,BYEOVR;*,CPUOVR;*,HELOVR;*,INIOVR;*,TSKOVR;*
PIP NDEOVR.OBJ;*/DE/NM,TSFOVR;*,UPDOVR;*,USEOVR;*,USFOVR;*
PIP CHGOVR.OBJ;*/DE/NM,PAGOVR;*,GACOVR;*
;
; '<DATE>' '<TIME>' Assemble module for CHG command
;
.SETT $EXEC
.SETS FILE "CHG"
.GOSUB ASM
.IFF $SCPU .AND .IFF $ENDS .GOTO AUSE
;
; '<DATE>' '<TIME>' Assemble module for CPU command
;
.SETT $EXEC
.SETS FILE "CPU"
.GOSUB ASM

.AUSE:

.IFF $SALT .GOTO AUSE1
;
; '<DATE>' '<TIME>' Assemble module for task ALT...
;
.SETT $EXEC
.SETS FILE "ALT"
.GOSUB ASM

.AUSE1:

.IFF $SUSE .GOTO MISC
;
; '<DATE>' '<TIME>' Assemble routines for USE command
;
.SETT $EXEC
.SETS FILE "USE"
.GOSUB ASM
.SETS FILE "UPD"
.GOSUB ASM

.MISC:

.IFF $STSF .GOTO MISC1
;
; '<DATE>' '<TIME>' Assemble module for TSF command, CPTIME interface
;			task CPTASK and terminal watcher task WATCHR.
;
.SETT $EXEC
.SETS FILE "TSF"
.GOSUB ASM
.SETS FILE "CPTASK"
.GOSUB ASM
.SETS FILE "WATCHR"
.GOSUB ASM

.MISC1:

;
; '<DATE>' '<TIME>' Assemble module for ACL command.
;
.SETT $EXEC
.SETS FILE "ACL"
.GOSUB ASM
;
; '<DATE>' '<TIME>' Assemble miscellaneous accounting system programs
;
.SETF $EXEC
.SETS FILE "SYSTIM"
.GOSUB ASM
.SETS FILE "RESET"
.GOSUB ASM
.SETT $EXEC
;
; '<DATE>' '<TIME>' Assemble account balance maintenance program.
;
.SETS FILE "BAL"
.GOSUB ASM
;
; '<DATE>' '<TIME>' Assemble reporting program modules.
;
.SETF $EXEC
.SETS FILE "RSUROT"
.GOSUB ASM
.SETS FILE "RSUFCS"
.GOSUB ASM
.SETS FILE "RSUCMD"
.GOSUB ASM
.SETS FILE "RSULOA"
.GOSUB ASM
.SETS FILE "RSUREP"
.GOSUB ASM
.SETT $EXEC
LBR RSULIB/CR:68.=RSUROT,RSUFCS,RSUCMD,RSULOA,RSUREP
PIP RSUROT.OBJ;*/DE,RSUFCS;*,RSUCMD;*,RSULOA;*,RSUREP;*
;
; '<DATE>' '<TIME>' Assemble disk accounting program and DISKUSE task.
;
.SETF $EXEC
.SETS FILE "DISK"
.GOSUB ASM
MAC DISKUSE=ACCPRE/PA:1,DISKUSE
.SETT $EXEC
;
; '<DATE>' '<TIME>' Assemble patch for line printer despooler task (LPP)
;
PIP JOBEND.MAC/NV=JOBEND.PAT
.SETS FILE "JOBEND"
.GOSUB ASM
PIP JOBEND.POB/RE/NV=JOBEND.OBJ
PIP JOBEND.MAC;0/DE
PIP JOBEND.POB/PU
;
; '<DATE>' '<TIME>' End of assembly phase.
;
.ASK ASMOK Did the modules assemble OK
.IFT ASMOK .GOTO TKB
;
; ACCGEN will pause and let you correct the problem. You can then restart
; ACCGEN and continue as normal.
;
.PAUSE

.TKB:

.ASK DELASM Delete assembly (.ASM) files
.IFT DELASM PIP *.ASM;*/DE
.IFF DELASM .IFF $RSXV4 PIP *.ASM/TR

.TKB0:

.IFF $COMM .GOTO TKB1
;
;	Now we run the program AGN.V7 to determine the charging rates. This
;	program creates some files which are included by means of @
;	references in the task builder command files. Since integer
;	arithmetic is used throughout the accounting package, it may not
;	be possible to give you exactly the rates you ask for, but usually
;	they will be very close. If you have already set up charges from
;	a previous run of ACCGEN, answer no to the next question. An answer
;	of CTRL/Z to the AGN questions gives a zero charge.
;	The AGN prompts may be in terms of dollars, but the values should
;	be given in terms of the units selected earlier.
;	The ACCGEN programs are supplied in a universal library and will have
;	to be extracted if you have not already done so.
;

.TKB1:

.ASK AGNULB Have you already extracted the ACCGEN tasks from ACCGEN.ULB
.IFT AGNULB .GOTO TKB2
PIP *.V7;*/DE/NM
LBR AGN.V7=ACCGEN.ULB/EX:AGN
LBR NSCONNECT.V7=ACCGEN.ULB/EX:NSCONN
LBR NSCPU.V7=ACCGEN.ULB/EX:NSCPU

.TKB2:

.;
.ASK AGNV7 Do you want to run AGN.V7 to determine charging rates
.IFF AGNV7 .GOTO SPCONN
RUN AGN.V7

.SPCONN:

.IFF $COMM .GOTO SPC1
;
;	Now we run the program NSCONNECT.V7 to assign non-standard rates for
;	connect time. This program creates a file called NSCONNECT.CMD which
;	is included in HELV7xVyy.CMD by means of an @ reference, and a similar
;	file called NCCONNECT.CMD which goes with the CHG command. If you have
;	already created this file from a previous ACCGEN run, answer no to
;	the next question. The format of the input data to NSCONNECT.V7 is
;	described in the documentation.
;	*NOTE* You MUST run these programs the first time ACCGEN is run. If you do
;	not want any non-standard rates, answer CTRL/Z when the programs prompt.
;

.SPC1:

.ASK SPCNV7 Do you want to assign non-standard connect rates now
.IFF SPCNV7 .GOTO SPCPU
RUN NSCONNECT.V7

.SPCPU:

.IFF $COMM .GOTO SPC2
;
;	Now we run the program NSCPU.V7 to assign non-standard rates for
;	CPU time. This program is similar to NSCONNECT above, and generates
;	similar indirect files that are used in the task builds below.
;

.SPC2:

.ASK SPCPV7 Do you want to assign non-standard CPU rates now
.IFF SPCPV7 .GOTO TKBNOW
RUN NSCPU.V7

.TKBNOW:

.;
.; *** Check for existence of required files to be included by TKB ***
.;

.TESTFILE RATES.CMD
.IF <FILERR> EQ 1 .GOTO FIL1
.SETN FCSNUM 256.-<FILERR>
;
;	'WAKE'*WARNING* File RATES.CMD has problems: FCS -'FCSNUM'.
;	'WAKE'*WARNING* This section will be run again.
;
.GOTO TKB0

.FIL1:
.TESTFILE NSCONNECT.CMD
.IF <FILERR> EQ 1 .GOTO FIL2
.SETN FCSNUM 256.-<FILERR>
;
;	'WAKE'*WARNING* File NSCONNECT.CMD has problems: FCS -'FCSNUM'.
;	'WAKE'*WARNING* This section will be run again.
;
.GOTO TKB0

.FIL2:
.TESTFILE NCCONNECT.CMD
.IF <FILERR> EQ 1 .GOTO FIL3
.SETN FCSNUM 256.-<FILERR>
;
;	'WAKE'*WARNING* File NCCONNECT.CMD has problems: FCS -'FCSNUM'.
;	'WAKE'*WARNING* This section will be run again.
;
.GOTO TKB0

.FIL3:
.TESTFILE NSCPU.CMD
.IF <FILERR> EQ 1 .GOTO FIL4
.SETN FCSNUM 256.-<FILERR>
;
;	'WAKE'*WARNING* File NSCPU.CMD has problems: FCS -'FCSNUM'.
;	'WAKE'*WARNING* This section will be run again.
;
.GOTO TKB0

.FIL4:
.TESTFILE NCCPU.CMD
.IF <FILERR> EQ 1 .GOTO FIL5
.SETN FCSNUM 256.-<FILERR>
;
;	'WAKE'*WARNING* File NCCPU.CMD has problems: FCS -'FCSNUM'.
;	'WAKE'*WARNING* This section will be run again.
;
.GOTO TKB0

.FIL5:
.TESTFILE NONCONN.CMD
.IF <FILERR> EQ 1 .GOTO FIL6
.SETN FCSNUM 256.-<FILERR>
;
;	'WAKE'*WARNING* File NONCONN.CMD has problems: FCS -'FCSNUM'.
;	'WAKE'*WARNING* This section will be run again
;
.GOTO TKB0

.FIL6:
.TESTFILE NONCPU.CMD
.IF <FILERR> EQ 1 .GOTO FIL7
.SETN FCSNUM 256.-<FILERR>
;
;	'WAKE'*WARNING* File NONCPU.CMD has problems: FCS -'FCSNUM'.
;	'WAKE'*WARNING* This section will be run again.
;
.GOTO TKB0

.FIL7:

;
; We are now ready to task build the accounting package.
;
.ASK MAP Do you want task builder maps
.IFF MAP .SETF SPOOL
.IFF MAP ASN NL:=MP:
.IFF MAP .SETF QMG
.IFT MAP .ASK SPOOL Spool map files
.IFT MAP ASN SY:=MP:
.IFT MAP .IFF SPOOL .SETF QMG
.ASK DELOBJ Do you want to clean up OBJ files as we go along
.IFT DELOBJ .IFT $FUNI PIP TEFF.OBJ;*/DE/NM,FMTCPU;*,FMTCON;*,FMTUNI;*
.IFT DELOBJ .IFF $FUNI PIP TEFF.OBJ;*/DE/NM,FMTCPU;*,FMTCON;*,FMTDLR;*
.IFF $RSXV4 .SETF $FCSR
.IFT $RSXV4 .ASK $FCSR Do you have the PLAS FCS resident library built by SYSGEN
;
; '<DATE>' '<TIME>' Start of task building.
;
.IFF $RSXV4 'LINK' @HELV7TV32
.IFT $RSXV4 .IFT $FCSR 'LINK' @HELV7FV40
.IFT $RSXV4 .IFF $FCSR 'LINK' @HELV7TV40
.IFT SPOOL PIP HELV7.MAP/SP
.IFT QMG PRINT /-FL/PRI:'PRTPRI'=HELV7.MAP/DEL
.IFT DELOBJ PIP HELV7.OBJ;*/DE/NM,ACCHEL;*
.;
.IFF $RSXV4 'LINK' @BYEV7TV32
.IFT $RSXV4 .IFT $FCSR 'LINK' @BYEV7FV40
.IFT $RSXV4 .IFF $FCSR 'LINK' @BYEV7TV40
.IFT SPOOL PIP BYEV7.MAP/SP
.IFT QMG PRINT /-FL/PRI:'PRTPRI'=BYEV7.MAP/DEL
.IFT DELOBJ PIP BYEV7.OBJ;*/DE/NM,ACCBYE;*
.;
'LINK' @ACNODEBLD
.IFT SPOOL PIP ACNODE.MAP/SP
.IFT QMG PRINT /-FL/PRI:'PRTPRI'=ACNODE.MAP/DEL
.IFT DELOBJ PIP ACNODE.OBJ;*/DE/NM
.;
.IFT $LOVR 'LINK' @LOGOVRBLD
.IFF $LOVR 'LINK' @LOGBLD
.IFT SPOOL PIP LOG.MAP/SP
.IFT QMG PRINT /-FL/PRI:'PRTPRI'=LOG.MAP/DEL
.;
'LINK' @CHGBLD
.IFT SPOOL PIP CHG.MAP/SP
.IFT QMG PRINT /-FL/PRI:'PRTPRI'=CHG.MAP/DEL
.IFT DELOBJ PIP CHG.OBJ;*/DE/NM
.IFF $SCPU .AND .IFF $ENDS .GOTO DOALT
.;
'LINK' @CPUBLD
.IFT SPOOL PIP CPU.MAP/SP
.IFT QMG PRINT /-FL/PRI:'PRTPRI'=CPU.MAP/DEL
.IFT DELOBJ PIP CPU.OBJ;*/DE/NM
.;

.DOALT:

.IFT $SALT .IFT $FCSR 'LINK' @ALTRESBLD
.IFT $SALT .IFF $FCSR 'LINK' @ALTBLD
.IFT $SALT .IFT SPOOL PIP ALT.MAP/SP
.IFT $SALT .IFT QMG PRINT /-FL/PRI:'PRTPRI'=ALT.MAP/DEL
.IFT $SALT .IFT DELOBJ PIP ALT.OBJ;*/DE/NM
.;
.IFT $STSF 'LINK' @TSFBLD
.IFT $STSF .IFT SPOOL PIP TSF.MAP/SP
.IFT $STSF .IFT QMG PRINT /-FL/PRI:'PRTPRI'=TSF.MAP/DEL
.IFT $STSF .IFT DELOBJ PIP TSF.OBJ;*/DE/NM
.;
.IFT $STSF 'LINK' @WATCHRBLD
.IFT $STSF .IFT SPOOL PIP WATCHR.MAP/SP
.IFT $STSF .IFT QMG PRINT /-FL/PRI:'PRTPRI'=WATCHR.MAP/DEL
.IFT $STSF .IFT DELOBJ PIP WATCHR.OBJ;*/DE/NM
.;
'LINK' @ACLBLD
.IFT SPOOL PIP ACL.MAP/SP
.IFT QMG PRINT /-FL/PRI:'PRTPRI'=ACL.MAP/DEL
.IFT DELOBJ PIP ACL.OBJ;*/DE/NM
.;
.IFT $STSF 'LINK' @CPTASKBLD
.IFT $STSF .IFT SPOOL PIP CPTASK.MAP/SP
.IFT $STSF .IFT QMG PRINT /-FL/PRI:'PRTPRI'=CPTASK.MAP/DEL
.IFT $STSF .IFT DELOBJ PIP CPTASK.OBJ;*/DE/NM
.;
.IFT $SUSE 'LINK' @USEBLD
.IFT $SUSE .IFT SPOOL PIP USE.MAP/SP
.IFT $SUSE .IFT QMG PRINT /-FL/PRI:'PRTPRI'=USE.MAP/DEL
.;
.IFT $SUSE .IFT $FCSR 'LINK' @UPDRESBLD
.IFT $SUSE .IFF $FCSR 'LINK' @UPDBLD
.IFT $SUSE .IFT SPOOL PIP UPD.MAP/SP
.IFT $SUSE .IFT QMG PRINT /-FL/PRI:'PRTPRI'=UPD.MAP/DEL
.IFT $SUSE .IFT DELOBJ PIP USE.OBJ;*/DE/NM,UPD;*
.;
'LINK' @SYSTIMBLD
.IFT SPOOL PIP SYSTIM.MAP/SP
.IFT QMG PRINT /-FL/PRI:'PRTPRI'=SYSTIM.MAP/DEL
.IFT DELOBJ PIP SYSTIM.OBJ;*/DE/NM
.;
'LINK' @RESETBLD
.IFT SPOOL PIP RESET.MAP/SP
.IFT QMG PRINT /-FL/PRI:'PRTPRI'=RESET.MAP/DEL
.IFT DELOBJ PIP RESET.OBJ;*/DE/NM
.;
'LINK' @NONSTABLD
.IFT SPOOL PIP NONSTAN.MAP/SP
.IFT QMG PRINT /-FL/PRI:'PRTPRI'=NONSTAN.MAP/DEL
.;
.IFT $FCSR 'LINK' @BALRESBLD
.IFF $FCSR 'LINK' @BALBLD
.IFT SPOOL PIP BAL.MAP/SP
.IFT QMG PRINT /-FL/PRI:'PRTPRI'=BAL.MAP/DEL
.IFT DELOBJ PIP BAL.OBJ;*/DE/NM
.;
.IFT $FCSR 'LINK' @RSURESBLD
.IFF $FCSR 'LINK' @RSUBLD
.IFT SPOOL PIP RSU.MAP/SP
.IFT QMG PRINT /-FL/PRI:'PRTPRI'=RSU.MAP/DEL
.;
.IFT $FCSR 'LINK' @DSKRESBLD
.IFF $FCSR 'LINK' @DSKBLD
.IFT SPOOL PIP DISK.MAP/SP
.IFT QMG PRINT /-FL/PRI:'PRTPRI'=DISK.MAP/DEL
.IFT DELOBJ PIP DISK.OBJ;*/DE/NM
.;
.IFT $FCSR 'LINK' @DKURESBLD
.IFF $FCSR 'LINK' @DKUBLD
.IFT SPOOL PIP DISKUSE.MAP/SP
.IFT QMG PRINT /-FL/PRI:'PRTPRI'=DISKUSE.MAP/DEL
.IFT DELOBJ PIP DISKUSE.OBJ;*/DE/NM
.;
PIP /FR
.ASK TKBOK Did everything task build OK
.IFT TKBOK .GOTO END
;
;	ACCGEN will now pause while you correct any problems.
;
.PAUSE

.END:

.IFT DELOBJ .SETF DELALO
.IFF DELOBJ .ASK DELALO Do you want to delete OBJ files now
.IFT DELALO PIP *.OBJ;*/DE/NM
;
; '<DATE>' '<TIME>' That''s all folks. You can now boot the system with the
;	accounting package. If you wish to charge for pages printed,
;	make the patch to LPP (as per documentation) using the file
;	JOBEND.POB, which has been created during this ACCGEN run.
;
;	The file [1,2]STARTUP.CMD should be replaced with the version
;	of the file under this UIC. You will have to edit this file for
;	your installation.
;
;	If you did not perform ACCGEN on the boot device, the task
;	image files produced must be copied to it before the system
;	is run, eg. PIP LB:=*.TSK
;
.IFT $RSXV4 ;	If this is your first ACCGEN on RSX-11M V4.0, please run the
.IFT $RSXV4 ;	account file conversion program V3TOV4.TSK. The procedure is
.IFT $RSXV4 ;	described in the documentation.
.IFT $RSXV4 ;
;	Don''t forget to use BAL to give some money to some accounts
;	before you bring up accounting.
;
;	Good Luck!
;
;	Bye bye from ACCGEN.
;
.STOP
.;
.; Subroutines
.;

.ASM:

.SETS LSTNG ""
.SETS EXEFIL ""
.IFT $EXEC .SETS EXEFIL "'LIBUIC'EXEMC/ML,'RSXMC'RSXMC/PA:1,"
.IFT LIST .SETS LSTNG ",'LSTDEV''FILE'"
.IFT LIST .IFT SPOOL .SETS LSTNG LSTNG+"/SP"
.IFT LIST .IFF SPOOL .SETS LSTNG LSTNG+"/-SP"
.OPEN 'FILE'.ASM
.ENABLE DATA
'FILE''LSTNG'=SY:'<UIC>'ACCPRE/PA:1,'EXEFIL'-
'SRCDEV''FILE'
.DISABLE DATA
.CLOSE
MAC @'FILE'.ASM
.IFT QMG PRINT /-FL/PRI:'PRTPRI'='FILE'.LST/DEL
.RETURN
