	.TITLE	$OPEN
	.IDENT	/V1.01/

;
;	PATCH FOR RSX-11M V4.0 OPEN ROUTINE ID F77047 TO IMPLEMENT
;	FILE MANAGER AND FILEDEF COMMAND.
;
;	*NOTE* THIS WILL NOT RUN UNDER RSX-11M V3.2 OR EARLIER.
;
;	STEVE THOMPSON
;	SCHOOL OF CHEMICAL ENGINEERING
;	OLIN HALL
;	CORNELL UNIVERSITY
;	ITHACA
;	NY 14853		(607) 256 3895
;

	.MCALL	SDRC$S,WSIG$S,RCVD$S,WTSE$S
	.MCALL	ALUN$S

	.PSECT	$$OTSI

.=.+1034			; AT THIS POINT WE ARE IN $FLDEF
				; WITH THE (FCS) FDB ADDRESS IN R0.
	JSR	PC,OPNPAT	; GO TO THE PATCH
	BCS	.+4		; IF CS, COULDN'T GET ASSIGNMENT
	RTS	PC		; ELSE RETURN

	.PSECT	OPNPA1

	.EVEN

FILMAN:	.RAD50	/FIL.../	; NAME OF FILE MANAGER
RSBUF:	.BLKW	15.		; SEND/RECEIVE BUFFER
LUN:	.BLKW	1		; LOGICAL UNIT NUMBER

;
;	THIS ROUTINE IS ENTERED FROM $FLDEF IN THE OTS WITH THE FDB
;	ADDRESS IN R0.
;

OPNPAT:	ADD	#36,R1		;* OVERLAYED INSTRUCTION
	MUL	#50,R1		;* OVERLAYED INSTRUCTION
	CLR	RSBUF		; CLEAR BUFFER READY FOR LUN
	BISB	F.LUN(R0),RSBUF	; SET LOGICAL UNIT NUMBER
	MOV	RSBUF,LUN	; SAVE IT
2$:	SDRC$S	#FILMAN,#RSBUF,#29. ; SEND REQUEST AND CONNECT TO FILE MANAGER
	BCC	3$		; IF CC, OK
	CMP	$DSW,#IE.UPN	; FAILED BECAUSE OF LOW DYNAMIC MEMORY?
	BNE	9$		; IF NE NO, SOME OTHER REASON (NOT INSTALLED?)
	WSIG$S			; WAIT FOR SIGNIFICANT EVENT
	BR	2$		; AND TRY AGAIN
3$:	WTSE$S	#29.		; WAIT FOR INTERFACE TASK
5$:	RCVD$S	,#RSBUF		; WHEN AWAKENED, WE SHOULD HAVE SOME DATA
	BCS	10$		; JUST IN CASE
	CMP	RSBUF,FILMAN	; DATA RETURNED BY FIL...?
	BNE	5$		; IF NE NO
	CMP	RSBUF+2,FILMAN+2 ; MAYBE
	BNE	5$		;

;
; REQUEST HAS RETURNED US SOME DATA
;
;	RSBUF+0			FIL (RADIX-50)
;	RSBUF+2			... (RADIX-50)
;	RSBUF+4			DEVICE NAME OR ZERO
;	RSBUF+6			DEVICE NUMBER
;	RSBUF+10		UFD
;	RSBUF+12		FILENAME, WORD #1
;	RSBUF+14		FILENAME, WORD #2
;	RSBUF+16		FILENAME, WORD #3
;	RSBUF+20		FILETYPE
;	RSBUF+22		VERSION NUMBER
;
;	R1 MAY BE USED, BUT NO OTHERS WITHOUT SAVING THEM
;

	TST	RSBUF+4		; ASSIGNMENT IN EFFECT?
	BEQ	9$		; IF EQ, USE NORMAL DEFAULTS
	ALUN$S	LUN,RSBUF+4,RSBUF+6 ; ASSIGN THE NEW LUN
	BCS	10$		; JUST IN CASE
	MOV	RSBUF+12,F.FNB+N.FNAM(R0) ; SET FILENAME
	MOV	RSBUF+14,F.FNB+N.FNAM+2(R0) ;
	MOV	RSBUF+16,F.FNB+N.FNAM+4(R0) ;
	MOV	RSBUF+20,F.FNB+N.FTYP(R0) ; FILETYPE
	MOV	RSBUF+22,F.FNB+N.FVER(R0) ; VERSION NUMBER
	CALL	.RDFUI		; READ DEFAULT UIC
	MOV	R1,RSBUF+24	; SAVE IT
	MOV	RSBUF+10,R1	; GET FILE UFD
	CMP	RSBUF+24,R1	; ARE THEY THE SAME?
	BEQ	8$		; IF EQ YES
	CALL	.WDFUI		; WRITE NEW DEFAULT UIC
	MOV	R0,R1		; SET R1 TO FILENAME BLOCK ADDRESS
	ADD	#F.FNB,R1	;
	CALL	.GTDID		; INSERT DIRECTORY INFORMATION
	MOV	RSBUF+24,R1	; GET ORIGINAL DEFAULT UIC
	CALL	.WDFUI		; AND RESET IT	
8$:	CLC			; SHOW SUCCESS
	BR	10$		; AND RETURN

9$:	SEC			; SHOW AN ERROR
10$:	RETURN			; RETURN

	.END
