#include        <fc.h>          /* fcs header                   */

#DEFINE INLUN1  1               /* lun for fdbin1               */

#DEFINE EOF     -10             /* end of file status           */

#define RECSIZ  132             /* size of the largest record   */

int     fdbin1[ SFDBW ] = {0};  /* fdb for file .stb file       */

char    outbuf[RECSIZ] = {0};    /* input file buffer            */
int     riob[2] = {0};          /* record i/o status block      */

struct {
	int     type;
	struct  {
		long    nam;
		int     filler;
		int     adr;
		} symbol[20];
	} stbbuf = {0};

char   *fil = "RSX11M.STB";          /* parsed file name             */
char   *dev  = "LB:";          /* parsed device name           */
char   *uic  = "[1,54]";          /* parsed uic                   */


int *find_r( ss)
char *ss;
{
int     status;
union{
	int shrt[2];
	long lng;
	}s;

int	adr= 0 ;	/* address of the symbol found		*/
register int     i, j;	/* asorted loop and index counters	*/

	filopn ( fdbin1, dev, uic, fil, INLUN1, FCSEQIO+FCROACC, NOFOB );

	i = lenstr( ss);
	s.lng  = 0l;

	j = (i>3) ? 3 : i;
	s.shrt[0] = rad50(ss,j);
	if((i = i-3) >0 )
		s.shrt[1] = rad50( ss+3,i);

	while (  getrec ( fdbin1, &stbbuf, 132, riob ) != EOF )
		{
		i = (riob[1]- 2)/ 8;    /* loop count   */

		if ( stbbuf.type != 1 )
			continue;

		for ( j=0; j<i; j++ )
			{

			if ( ss )
				{
				if ( s.lng == stbbuf.symbol[j].nam)
					{
					adr = stbbuf.symbol[j].adr;
					break;
					}
				}
			}
		}
	status = fcclos ( fdbin1 );
	return( adr );
}

/*
**      Name:           filopn  -  Open a fcs file using fcopen.
**
**      Arguments:      fdb     - Pointer to an fdb.
**                      filnm   - Pointer to a character name string.
**                      lun     - Lun to be used for the file.
**                      func    - Open file function code.
**
**      Call:           filopn ( fdb, filnm, lun, func, fob )
**
**      Returns:        The status of fcopen is returned.
**
*/

filopn ( fdb, dvnm, dir, filnm, lun, func, fob )

int     *fdb;
char    *dvnm;
char    *dir;
char    *filnm;
int     lun;
int     func;
int     *fob;

{
int     status;

	status = fcopen ( fdb, dvnm, dir, filnm, lun, func, fob );

	if ( status != ISSUC )
		filerr ( fdb, status );

	return ( status );
}


/*
**      Name:           getrec  -  Get an fcs file record.
**
**      Arguments:      fdb     - Pointer to an fdb.
**                      buf     - Pointer to an input character buffer.
**                      size    - Number of bytes to get.
**                      iob     - Record i/o status block pointer.
**
**      Call:           getrec ( fdb, buf, size, iob )
**
**      Returns:        The status of getrc is returned.
**
*/


getrec ( fdb, buf, size, iob )

int     *fdb;
char    *buf;
int     size;
int     iob[];

{
int     status;

	status = getrb ( fdb, buf, size, NORECNUM, iob );

	if ( status != ISSUC )
		status = filerr ( fdb, status );

	return ( status );
}


/*
**      Name:           filerr  - Report an fcs error.
**
**      Arguments:      fdb     - Pointer to an fdb.
**                      status  - Status returned from an fcs function.
**
**      Call:           filerr ( fdb, status )
**
**      Returns:        - none.
*/

filerr ( fdb, status )

int     *fdb;
int     status;

{
char    fclob;
char    lun;

	fclob = status;         /* get low byte of i/o status word      */
	lun = *( fdb + 17 );    /* get lun number out of the fdb        */

	if ( fclob == EOF )
		return;

	putfmt ( "\n--- FCS error %i, on LUN %i\n", fclob, lun );

	exit();
}
