/*
 * Status Control Block (SCB) (no error logging fields)
 * UMR assignment block.
 * Assumes Loadable drivers and memory management!
 *
 * INCLUDE CX.H PRIOR TO INCLUDING THIS FILE
 *
 * Include EXEDF.H for various symbolics
 *
 * Bob Denny
 * 19-Oct-82
 */
struct scb     {
               struct iopkt *s_lhd[2]; /* I/O Packet listhead */
               byte        s_pri;      /* Device priority */
               byte        s_vct;      /* Int. vector / 4 */
               byte        s_ctm;      /* Current timeout count */
               byte        s_itm;      /* Initial timeout count */
               byte        s_con;      /* Controller index */
               byte        s_sts;      /* Controller status (1=busy, 0=idle) */
               address     s_csr;      /* CSR address */
               struct iopkt *s_pkt;    /* --> Current I/O packet */
               word        s_frk[5];   /* Fork block */
               word        s_mpr[7];   /* XM Unibus control blk & buffer wrd */
               struct umrab *s_umhd[2]; /* UMR assignment block listhead */
               word        s_umct;     /* Free UMR count */
               };

/*
 * UMR assignment block
 */
struct umrab   {
               struct umrab *m_lnk;    /* Link word */
               address     m_umra;     /* Address of 1st assigned UMR */
               word        m_umrn;     /* 4 * No. of assigned UMR's */
               word        m_umvl;     /* Lo 16 bits mapped by 1st UMR */
               word        m_umvh;     /* Hi 2 bits in bits 4 & 5 */
               word        m_bfvh;     /* Hi 6 bits of physical buffer addr. */
               word        m_bfvl;     /* Lo 16 bits of physical buffer addr. */
               };
