.Enable Substitution
.Enable Global
.Disable Lowercase
;
;	USGSF82.CMD -- Command file for building USGS submissions
;		       for the Fall 1982 RSX/IAS SIG tape.
;
; Generation begun at '<Time>' on '<Date>'
.;
.;	Date:		14-Dec-82
.;	Written by:	Gary L. Maxwell
.;			U. S. Geological Survey
.;			345 Middlefield Road
.;			Mailstop 77
.;			Menlo Park, California 94025
.;
.; This command file may be invoked in one of two modes.
.;
.; If invoked directly from the terminal, the command file will
.; allow the user to selectively choose which USGS tasks to build,
.; and the command file will prompt for any needed files and device
.; assignments.
.;
.; If invoked with the global symbol $AUTO set to true, then the command
.; file will build all tasks on the kit. In this mode, other symbols
.; defining your operating environment can be defined globally, and this
.; command file will run without interaction.
.;
.; In all cases, this command file will exit with a successful exit
.; status except in the following circumstances:
.;
.;	"Warning" status is returned if any of the tasks on the
.;		  kit did not build successfully.
.;
.;	"Error"   status is returned if the build process was aborted
.;                due to an environment problem (required file not
.;		  found, etc.)
.;
.; The following is a list of global symbols used by this command file,
.; along with default values if the symbol is not defined. In $AUTO
.; mode, unless the symbols are defined, the default value is always
.; taken.
.;
.;   Symbol     Type        Meaning                    Default
.;   ------     ----        -------                    -------
.;   $AUTO    Logical    "Autogen" if true           False
.;   $SUIC    String     Location of RSX11M.STB      LB0: Current <SYSUIC>
.;   $RSXMC   String     Location of RSXMC.MAC       LB:[11,10]
.;   $MPLUS   Logical    RSX-11M-PLUS target system  True if <SYSTEM> = 6
.;   $EXEMC   String     Location of EXEMC.MLB       LB:[1,1]
.;   $EXLIB   String     Location of EXELIB.OLB      LB:[1,1]
.;   $FSRES   Logical    True if FCSRES present      True if LB:[1,1]FCSRES.STB
.;							exists
.;   $FSFSL   Logical    True if FCSFSL preset       True if LB:[1,1]FCSFSL.STB
.;			  and $MPLUS is true            exists and $MPLUS true
.;   $DIST    String     Location of USGS kit        SY0: and current <UIC>
.;   $ASSEM   Logical    True if components in kit   True if .OBJ files missing
.;			   are to be assembled
.;   $MUSER   Logical    True if applicable tasks    True if $MPLUS is true
.;			   are to be built /MU
.;   $CLEAN   Logical    True if files from previous    False
.;			   USGS gens are to be deleted
.;
.; This command file must be entered with the CLI set to either MCR or DCL.
.;
.Setn Exists 1

.; Change CLI to MCR

.Sets Oldcli <Cli>
.If Oldcli = "MCR" .Goto 10
.If Oldcli <> "DCL" .Goto 9
	Set Terminal MCR
	.Goto 10
.9:	;
	; This command file must be invoked by MCR or DCL!
	;
	.Setn Exists 2
	.Goto Exit

.10:

.; Determine if we are in $AUTO mode. If we are, then proceed through
.; the global symbols, defining those that aren't

.Ifndf $Auto .Setf $Auto
.Iff $Auto .Goto Noauto

	;
	; Autogeneration has been selected...
	.Ifndf $Clean   .Setf Clean
	.Ifndf $Suic    .Sets $Suic  "LB0:"+<Sysuic>
	.Ifndf $Rsxmc   .Sets $Rsxmc "LB0:[11,10]"
	.Ifndf $Dist    .Sets $Dist  "SY0:"+<Uic>
	.Ifndf $Exemc   .Sets $Exemc "LB0:[1,1]"
	.Ifndf $Exlib   .Sets $Exlib "LB0:[1,1]"
	.Ifndf $Assem   .Setf $Assem
	.Ifdf  $Mplus   .Goto 50
		.Setn N <System>
		.Setf $Mplus
		.If N EQ 6 .Sett $Mplus
.50:	.Ifdf  $Fsres   .Goto 100
		.Setf $Fsres
		.Testfile Lb:[1,1]Fcsres.stb
		.If <Filerr> Eq 1 .Sett $Fsres
.100:	.Ifdf  $Fsfsl   .Goto 150
		.Setf $Fsfsl
		.Testfile Lb:[1,1]Fcsfsl.Stb
		.If <Filerr> Eq 1 .Ift $Mplus .Sett $Fsfsl
.150:	.Ifndf $Muser   .Setl $Muser $Mplus
	.Sett  $Csh
	.Sett  $Cwd
	.Sett  $Dvc
	.Sett  $Snap
	.Sett  $Who
	.Goto Unload

.Noauto:		

;
; We will now determine the environment of your target system. Since
; all of the USGS submissions are privileged tasks, we require the following
; files relating to your target system:
;
;      EXEMC.MLB        Executive macro library
;      RSXMC.MAC        Configuration file for your system
;      EXELIB.OLB       Executive object library
;      RSX11M.STB       Symbol table for the target system image
;
; This command file will attempt to locate these files automatically,
; and will verify the location interactively.

.; In this mode, we make educated guesses as to the values of the
.; undefined symbols, and then ask the user to either change or accept
.; them. The error checking isn't foolproof, but I know that you know
.; that if you can read this command file, you can work around anything.

.; Always assemble the kit if not autogen

	.Sett  $Assem

.; Find out if old files are to be cleaned up

	.Ifdf  $Clean  .Goto 150
	;
	.Ask $Clean Clean up files from previous USGS kit builds
.150:

.; Determine target system type

	.Ifdf  $Mplus  .Goto Askmpl
	.Setf $Mplus
	.If <System> Eq 6 .Sett $Mplus
		       ;
	.Ift   $Mplus  ; Your current system is an RSX-11M-PLUS system.
	.Iff   $Mplus  ; Your current system is an RSX-11M system.
		       ;
	.Ask L Is this the correct target system type for the USGS tasks
	.Ift L .Goto 200
	;
	; If you answer NO to the following question, the USGS tasks will
	; be built for an RSX-11M system.
	;
	.Ask $Mplus Build USGS kit for a target RSX-11M-PLUS system
.200:

.; Always set the multiuser flag if this is M-PLUS

	.Setl $Muser $Mplus

.; Determine device and UIC for this kit

	.Ifndf $Dist  .Sets $Dist  "SY0:"+<Uic>
	.Testfile '$Dist'Usgsf82.Cmd
	.If <Filerr> Eq 1 .Goto 250

.; We could not simply find the distribution. Ask the user where it is.

	;
.Asks $Dist Enter device and UIC containing the USGS kit (default = SY0:'<UIC>')
.If <Strlen> = 0 .Sets $Dist "SY0:"+<Uic>

.250:

.; Now look for the system symbol table file...

	.Ifndf $Suic .Sets $Suic "LB0:"+<Sysuic>
	.Testfile '$Suic'Rsx11m.Stb
	.If <Filerr> Ne 1 .Goto 300
	;
	; Your current system UIC is '<Sysuic>', and a copy of RSX11M.STB has
	; been found in '$Suic'.
	;
	.Ask L Is this the correct system symbol table file to use
	.Ift L .Goto 310
.300:	;
	; Respond to the following question with the device and UIC where your
	; target system''s symbol table file (RSX11M.STB) is located.
	;
	.Asks $Suic Enter the device and UIC of your system symbol table file

.310:

.; Now find RSXMC.MAC....

	.Ifndf $Rsxmc .Sets $Rsxmc "LB0:[11,10]"
	.Testfile '$Rsxmc'Rsxmc.mac
	.If <Filerr> Ne 1 .Goto 330
	;
	; A copy of RSXMC.MAC has been located in '$Rsxmc'.
	;
	.Ask L Should this copy of RSXMC.MAC be used for assembling the USGS kit
	.Ift L .Goto 350
.330:	;
	.Asks $Rsxmc Enter the device and UIC containing RSXMC.MAC
.350:

.; Look for resident libraries to use. If the logical symbols $Fsres and
.; $Fsfsl are already defined, then we assume that the necessary files exist.

	.Ifdf $Fsres .Goto 400
	.Setf $Fsres
	.Testfile Lb:[1,1]Fcsres.Stb
	.If <Filerr> Ne 1 .Goto 400
	;
	; A copy of FCSRES.STB has been located in LB:[1,1]. Most of the
	; USGS tasks can link to FCSRES.
	;
	.Ask $Fsres Link to FCSRES whenever possible

.400:	.Ifdf $Fsfsl .Goto 410
	.Setf $Fsfsl
	.Testfile Lb:[1,1]Fcsfsl.stb
	.If <Filerr> Ne 1 .Or .Iff $Mplus .Goto 410
	;
	; A copy of FCSFSL.STB has been located in LB:[1,1]. Tasks which
	; cannot link to FCSRES due to size problems can link to FCSFSL.
	;
	.Ask $Fsfsl Link to FCSFSL whenever necessary

.410:

.; Look for EXELIB....

	.Ifndf $Exlib .Sets $Exlib "LB0:[1,1]"
	.Testfile '$Exlib'EXELIB.OLB
	.If <Filerr> Eq 1 .Goto 420
	;
	; A copy of EXELIB.OLB is required for building the USGS tasks, and
	; it could not be found in '$Exlib'.
	;
	.Asks $Exlib Enter the device and UIC containing EXELIB.OLB
.420:

.; Look for EXEMC....

	.Ifndf $Exemc .Sets $Exemc "LB0:[1,1]"
	.Testfile '$Exemc'EXEMC.MLB
	.If <Filerr> Eq 1 .Goto 425
	;
	; A copy of EXEMC.MLB is required for building the USGS tasks, and
	; it could not be found in '$Exemc'.
	;
	.Asks $Exemc Enter the device and UIC containing EXEMC.MLB
.425:

.; Now find out what the user wants to build
;
; We are now ready to to generate the USGS tasks on the kit. You will
; be asked whether you want a particular task to be built or not. If
; you are unsure about whether you want a particular task, hit the
; <ESC> key for a brief description of the task, or consult the release
; notes in the file USGSF82.DOC for a better description.
;
.Enable Escape
	.Ifdf $Csh .Goto 507
	.Goto 505
.500:
	;
	; CSH (Checkpoint Space Hanlder) is a utility which complements
	; the MCR ACS command for managing dynamic checkpoint files on
	; your system. You must have dynamic checkpoint support for CSH
	; to work. CSH can display the current "map" of active checkpoint
	; files, including the names of tasks currently checkpointed.
	;
	; The most useful feature of CSH is for forcibly deallocating a
	; checkpoint file (ACS doesn''t do this!) by causing all tasks
	; on a checkpoint file to be reloaded into memory.
	;
	; CSH is a privileged task.
	;
.505:	.Ask $Csh Do you want to build CSH (Checkpoint Space Handler)
	.Ift <Escape> .Goto 500
.507:	.Ifdf $Cwd .Goto 517
	.Goto 515
.510:
	;
	; CWD (Change Working Directory) and PWD (Print Working Directory)
	; is a utility which allows any user to change the default device
	; SY0: and the current UIC using a very convenient command syntax.
	;
	; Additionally, CWD/PWD will print the percentage of free space
	; available on SY0: along with the total number of free blocks.
	; If that isn''t all, CWD/PWD check to make sure a User File
	; Directory exists on SY0: in the current UIC.
	;
	; With CWD on our system, our users have forgotten the ASN and
	; SET /UIC commands entirely.
	;
	; CWD and PWD (CWD installed with a task name of ...PWD) are
	; privileged.
	;
.515:	.Ask $Cwd Do you want to build CWD (Change Working Directory)
	.Ift <Escape> .Goto 510
.517:	.Ifdf $Dvc .Goto 527
	.Goto 525
.520:
	;
	; DVCDAT is a mini-utility (written by Jim Neeland, modified by
	; Larry Baker for RSX-11M-PLUS) which dumps the device data structures
	; for a specified device. The dump is presented in symbolic form,
	; with standard symbolic offsets along with absolute addresses
	; used to identify each element of the data structure.
	;
	; This tool is most useful for those developing a user-written driver
	; or for system managers wishing to diagnose a device problem.
	;
	; DVCDAT is a privileged program.
	;
.525:	.Ask $Dvc Do you want to build DVCDAT (Display Device Driver Database)
	.Ift <Escape> .Goto 520
.527:	.Ifdf $Snap .Goto 537
	.Goto 535
.530:
	;
	; SNAP is a "magic" utility which performs a SNAP$ macro on behalf
	; of a task. This causes PMD (Post Mortem Dumper) to produce a
	; customized "snapshot" of the task''s running status. When PMD
	; completes, the target task is resumed.
	;
	; Much of SNAP''s functionality has been incorporated into the
	; Task Header display page of RMDemo in V2.0 / V4.0. However, with
	; SNAP, you can dump sections of a task''s virtual address space
	; in three different formats, and the output from PMD can be
	; directed to either a terminal device or to a disk (in [1,4]).
	;
	; The only task on the system that a privileged user cannot SNAP
	; is (you guessed it) PMD!
	;
.535:	.Ask $Snap Do you want to build SNAP (Task Snapshot Utility)
	.Ift <Escape> .Goto 530
.537:	.Ifdf $Who .Goto Unload
	.Goto 545
.540:
	;
	; WHO is a utility which displays the names and UIC''s of all logged
	; in users, the terminals from which they are working, and all tasks
	; that they are running. For each active task, a single character
	; mnemonic shows what each task is up to, e.g., CPU bound, Stopped,
	; Blocked, Waitfor state, Suspended, etc.
	;
	; WHO will also accept the last name or UIC of a user and will search
	; the account file for a matchup. WHO then outputs the user''s full
	; name, logon UIC, and date and time of last login.
	;
	; WHO is a privileged program.
	;
.545:	.Ask $Who Do you want to build WHO (System Activity Utility)
	.Ift <Escape> .Goto 540

.Unload:
	
.; We now have all information required. All that we need to do before
.; generating the tasks is to make sure the USERMAC.MLB file has been
.; unloaded from the library.

;
; Begin task building at '<Time>' on '<Date>'

	.Testfile '$Dist'Usermac.Mlb
	.If <Filerr> Eq 1 .Goto 600

	;
	; Unload the USGS terminal output macro library
	;
	Lbr '$Dist'Usermac.mac='$Dist'UsgsF82.Ulb/Ex:Userma
	Lbr '$Dist'Usermac.mlb/Cr:10.::64.:Mac/Sz='$Dist'Usermac.mac
	.Setn Exists '<EXSTAT>'
	.If Exists Eq 0 .Or .If Exists Gt 1 .Goto Exit
	Pip '$Dist'Usermac.mac;*/de/nm

.600:	.Iff $Csh .Goto 610
	@'$Dist'UsgsF82.Ulb/Lb:Cshcmd
	.If <Exstat> Ne 1 .Setn Exists <Exstat>

.610:	.Iff $Cwd .Goto 620
	@'$Dist'UsgsF82.Ulb/Lb:Cwdcmd
	.If <Exstat> Ne 1 .Setn Exists <Exstat>

.620:	.Iff $Dvc .Goto 630
	@'$Dist'UsgsF82.Ulb/Lb:Dvccmd
	.If <Exstat> Ne 1 .Setn Exists <Exstat>

.630:	.Iff $Snap .Goto 640
	@'$Dist'UsgsF82.Ulb/Lb:Snpcmd
	.If <Exstat> Ne 1 .Setn Exists <Exstat>

.640:	.Iff $Who .Goto 650
	@'$Dist'UsgsF82.Ulb/Lb:Whocmd
	.If <Exstat> Ne 1 .Setn Exists <Exstat>

.650:	;
	; Done with USGS kit build at '<Time>' on '<Date>'
	;
.Exit:	.If Oldcli = "DCL" Set /DCL=Ti:
.Exit Exists
