/*
 *				T . H
 *
 * Definitions for T.
 */

#define	EOS		0		/* End of string		*/
#define	MAXMEM		100		/* Remember one hundred pages	*/
#define	ROWS		24		/* Screen size rows (up/down)	*/
#define	COLS		80		/* Screen size columns (across)	*/
#define	HUGE		32767		/* A very large number		*/
#define	MASK		0100000		/* High bit for short int's	*/

#ifdef	vms
/*
 * Special definitions for RMS I/O package
 */
typedef struct rfa_struct {
	short int	word[3];
} RFAVALUE;
#define	FILETYPE	char
#define	FWILD		rms_fwild
#define	FNEXT		rms_fnext
#define	FGETNAME	rms_getname
#define	FWILDMODE	"r"
#else
/*
 * Normal I/O
 */
#define	RFAVALUE	long
#define	FILETYPE	FILE
#define	FWILD		fwild
#define	FNEXT		fnext
#define	FGETNAME	fgetname
#define	FWILDMODE	"run"
#endif
/*
 * Define information to seek within records
 */

typedef struct {
	RFAVALUE record_rfa;		/* Returned by ftell()		*/
	short int buff_offset;		/* Offset in buff[] of record	*/
					/*   < 0 if <Form-Feed> start	*/
	short int line_offset;		/* Offset in textline[]		*/
					/*   < 0 if saved character	*/
} RFA;

/*
 * To locate a particular text line, the following information is needed:
 *	rec_rfa		the place to seek to.  		set by getrecord()
 *	rec_bor		the place in the record buffer.	set by getbyte()
 *	rec_txt		the start in the text buffer.	set by getline()
 *	rec_savec	not EOS if in a long line.	set by getline()
 * These are saved in memory[] by saveplace().  Saveplace() also remembers
 * whether a record started with a form-feed, and whether a text line
 * is the continuation of a long line.
 */

extern	RFAVALUE magic_cookie;		/* fseek() value to rewind file	*/
extern	RFAVALUE rec_rfa;		/* Current record being read	*/
					/* record.rfa = ftell() info	*/
					/* record.place -> text buffer	*/

extern	char	*rec_bor;		/* Next record start in buffer	*/
extern	char	*rec_eor;		/* End of record in buffer	*/
extern	char	*rec_txt;		/* Text start			*/
extern	char	rec_savec;		/* Saved character		*/

#ifdef rsx

/*
 * The following is needed to handle various flavors of logical
 * records on vms compatibility mode.
 *
 *	R_SEQ	is returned in FDB @ F.RTYP for VMS print file
 *		formatted records. This was determined by inspection.
 *
 *	R_STM	is returned in FDB @ F.RTYP for RMS Stream format.
 *		This, too, was determined the hard way.  Note, however,
 *		that there are several flavors of stream.  This is
 *		vanilla (<CR><LF>).  Vax-11 C writes <LF> only, while
 *		APL is reputed to write <CR> only.
 *
 *	FD_VFC	is returned in FDB @ F.RATT for VMS print file
 *		formatted records. This was determined by inspection.
 *
 *	FD_FTN	is returned in FDB @ F.RATT to indicate that the
 *		first byte of a file contains a Fortran carriage
 *		control character.  This has not been seen in reality.
 *
 *	F_SEQN	is the offset in the FDB to the sequence number
 *		for sequenced records.  (Needed for VMS print files)
 *
 * Note that F.RTYP must be at offset 0 in the FDB and F.RATT must
 * be at offset 1.
 *
 */

#define	R_SEQ	3			/* "Sequenced" records on VMS	*/
#define	R_STM	4			/* RMS Stream (on RSTS, too)	*/
#define	FD_VFC	4			/* VFC on VMS compatibility	*/
#define PRINT_FILE ((FD_VFC << 8) | R_SEQ) /* printer file on VMS	*/
#define	FD_FTN	1			/* Fortran carriage-control	*/
#define	FD_CR	2			/* "Implied CR" in RSX FDB	*/

extern	int		max_size;	/* Maximum file record size	*/
extern	char		*F_SEQN;	/* FDB offset to F.SEQN		*/
extern	int		*fdb_seqn;	/* infdb @ F.SEQN		*/
extern	int		implied_cr;	/* TRUE if vanilla file		*/
extern	int		fortran_cr;	/* TRUE if we hack Fortran VFC	*/
extern	int		vms_printfile;	/* TRUE if VMS VFC file		*/
extern	int		$$vms;		/* VMS compatibility signal	*/

/*
 * buff -> the current record read by getrecord().  Note that it is
 * allocated with guard areas before and after for printfile formats.
 */

extern	char		*allobuff;	/* from calloc()		*/
extern	char		*buff;		/* -> logical record for fget()	*/

#endif

#ifdef	rt11

extern	int		max_size;	/* Maximum record size		*/
extern struct rt11record {
	char		guard;
	char		datum[513];
} rt11record;
#define	buff		(&rt11record.datum[0])

extern int		$$rsts;		/* True if rsts/e emulation	*/
extern int		ctrlc();	/* Trap CTRL/Z on rsts		*/
#endif

#ifdef	vms
/*
 * VMS native
 */
extern	int		max_size;		/* Maximum record size	*/
extern struct vmsrecord {
	char		guard;
	char		datum[513];
} vmsrecord;
#define	buff		(&vmsrecord.datum[0])
#endif

/*
 * Things for screen handling
 */

#define	IS_VT52		(64+1)
#define	IS_VT100	(96+1)

extern	char		**oldbuf;	/* For screen package		*/
extern	char		buffer[];	/* For screen package		*/
extern	int		linesperscreen;	/* Maximum lines per screen	*/
extern	int		columnsperline;	/* Maximum columns per line	*/
extern	int		seeall;		/* True if -e option		*/
extern	int		vt100;		/* True if vt100		*/
extern	int		cursrow;	/* Cursor row after screen	*/
extern	int		curscol;	/* Cursor column after screen	*/

/*
 * Finis is set when the user types CTRL/C or CTRL/Z in response to
 * a "next screen" prompt.  It forces an exit from the program.
 *
 * Breakout is set on end of file or when the user types 'X' in
 * response to a "next screen" prompt.  It exits the current file,
 * going on to the next (wildcard) file.  Note that the <backup> and
 * <rewind> commands clear breakout.
 */

#define	HELPROW	3

extern	char		inline[81];	/* Argument line		*/
extern	FILETYPE	*infd;		/* Input file descriptor	*/
extern	char		textline[513];	/* Current output text line	*/
extern	char		file_name[81];	/* Input file name		*/
extern	char		pfilename[81];	/* Process file name		*/
extern	char		temptext[81];	/* Text work space		*/
extern	char		rx_pattern[];	/* Grep pattern stored here	*/
extern	int		iseof;		/* <End-of-file> switch		*/
extern	int		ff_flag;	/* Magic form feed signal	*/
extern	int		finis;		/* TRUE on CTRL/C or CTRL/Z	*/
extern	int		breakout;	/* TRUE on eXit			*/
extern	RFA		memory[MAXMEM];	/* Top of page memory		*/
extern	RFA		*memptr;	/* Pointer within memory[]	*/
#define	LASTMEM		(&memory[MAXMEM - 1])
extern int		eofseen;	/* TRUE on eof			*/
#ifndef	vms
extern	long		ftell();	/* Returns file position	*/
#endif
