	.TITLE	JOBEND
	.IDENT	/V7.03/

;****************************************************************
;
;	JOBEND.PAT
;
;	THIS MODULE CONTAINS A PATCH WHICH WHEN APPLIED TO THE
;	PRINT SPOOLER TASK LPP CAUSES IT TO SEND TO LOG... A
;	PACKET CONTAINING THE NUMBER OF PAGES PRINTED.
;	FOR USE WITH ACCOUNTING SYSTEM VERSION 7.
;	RSX-11M V3.2 OR V4.0
;
; VERSION:	V7	JULY 1981
;
;	STEVE THOMPSON
;	SCHOOL OF CHEMICAL ENGINEERING
;	OLIN HALL
;	CORNELL UNIVERSITY
;	ITHACA
;	NY 14853
;
;	REVISION HISTORY
;	----------------
;
;	SMT752	29-SEP-81	ADDED NAME OF DESPOOLER TASK TO THE
;				DATA PACKET SENT TO LOG...
;
;	SMT814	12-APR-82	ADDED RSX-11M V4.0 SUPPORT
;
;*****************************************************************

	.MCALL	TCBDF$,HDRDF$

	ACCDF$			; DEFINE ACCOUNTING BLOCK OFFSETS
	BITDF$			; DEFINE ACCOUNTING BITMASKS

	TCBDF$			; DEFINE TCB OFFSETS
	HDRDF$			; DEFINE TASK HEADER OFFSETS

	.IF DF	AA$V40

.=.+262

	.IFF

.=.+272

	.ENDC	; DF AA$V40

	JMP	PATV7		; EXECUTE NEW LOG... INTERFACE ROUTINE
	.PSECT	PATV7
LOGNAM:	.RAD50	/LOG.../	; NAME OF LOGGING TASK

PATV7:	EMT	377		;* OVERWRITTEN INSTRUCTION
	CALL	$SWSTK,10$	; SWITCH STACKS
	MOV	#LOGNAM,R3	;; GET NAME OF LOGGING TASK
	CALL	$SRSTD		;; LOOK IN THE STD FOR IT
	BCS	10$		;; IF CS NOT THERE, Q TO ALT...
	BIT	#TS.EXE,T.STAT(R0) ;; OK, BUT IS IT ACTIVE?
	BNE	10$		;; IF NE NO, FORGET IT
	MOV	R0,R5		;; YES, SAVE TCB ADDRESS
	MOV	#B.LPAG,R1	;; SET LENGTH OF PACKET NEEDED
	CALL	$ALOCB		;; ALLOCATE A BUFFER
	BCS	10$		;; IF CS COULDN'T GET ONE, FORGET IT
	MOV	#<AC.PAG!AC.CMD>,B.MASK(R0) ;; INSERT COMMAND TYPE MASK
	MOV	$HEADR,R2	;; GET OUR HEADER ADDRESS
	MOV	H.CUIC(R2),B.UIC(R0) ;; SAVE PRINTER'S UIC
				;; THIS BIT WORKS BECAUSE THE SPOOLER
				;; TASK HAS SLAVE STATUS
	MOV	JOBPAG,B.PAGE(R0) ;; SAVE PAGE COUNT
	MOV	$TKTCB,R1	;; GET OUR TCB ADDRESS
	MOV	T.NAM(R1),B.SPNM(R0) ;; INSERT OUR TASK NAME
	MOV	T.NAM+2(R1),B.SPNM+2(R0) ;;
	MOV	R0,R1		;; COPY BLOCK ADDRESS TO R1
	MOV	R5,R0		;; GET LOG...'S TCB ADDRESS
	CALLR	$EXRQF		;; QUEUE PACKET AND START LOG... AND
				;; THEN RETURN TO USER STATE
10$:	RETURN			;;* OVERWRITTEN INSTRUCTION

	.END
