/* MODE and DISPLAY subroutines for VT100 terminal
 * AUTHOR: Allen A. Watson, The Record, 150 River St., Hackensack, NJ 07602
 * ORIGINAL VERSION: May 5, 1982
 *
 * FUNCTION AND USAGE:
 *	MODE outputs a mode change code to the VT100. Invocation is
 *	  "mode(type)", where "type" is an integer as defined in the #define
 *	  statements that follow below. MODE does not output any text; only
 *	  an escape sequence.
 *	  To use MODE for double-width or -height characters, first output the
 *	  text, and follow it with the mode setting.
 *
 *	DISPLAY will output text in a given mode at a designated screen 
 *	  location. Invocation is "display(line,column,mode,text)", where 
 *	  "mode" is an integer that is passed to the MODE routine; "line" and
 *	  "column" are positive integers to locate the cursor; and "text" is
 *	  a character string array or literal. DISPLAY will reset the display
 *	  mode to LIGHT (normal VT100 display mode) after outputting the text.
 *
 *	To use mixed modes, e.g. BOLD plus BLINK, first invoke "mode(BOLD)",
 *	and then "display(BLINK,line,col,text)".
 */

#define LIGHT 0
#define BOLD 1
#define USCORE 4
#define BLINK 5
#define REVERSE 7
#define RESET 9
#define GRAPHICS 10
#define NOGRAPH 11
#define HIGHTOP 13
#define HIGHBOT 14
#define DOUBLE 16

mode(type)	/* Set screen display mode on VT100 */
int type;
{
  switch (type) {
	case BOLD: 	scout(0,0,"\233[1m");
			break;
	case USCORE:	scout(0,0,"\233[4m");
			break;
	case BLINK:	scout(0,0,"\233[5m");
			break;
	case REVERSE:	scout(0,0,"\233[7m");
			break;
	case LIGHT:	scout(0,0,"\233[0m");
			break;
	case HIGHTOP:	scout(0,0,"\233#3");
			break;
	case HIGHBOT:	scout(0,0,"\233#4");
			break;
	case DOUBLE:	scout(0,0,"\233#6");
			break;
	case RESET:	scout(0,0,"\233[0m");
			break;
	case GRAPHICS:	scout(0,0,"\233(0");
			break;
	case NOGRAPH:	scout(0,0,"\233(B");
			break;
	default:	scout(0,0,"\233[0m");
			break;
  }
}

display(ln, col, md, text)  /* function to display a line on VT100 */
char text[];
int ln,col,md;
{
  mode(md);  /* change display mode */
  scout(ln,col,text);
  mode(RESET); /* change back to light face */
}
