/* function subroutine to move VT100 cursor.
 * AUTHOR: Allen A. Watson, The Record, 150 River St., Hackensack, NJ.
 * ORIGINAL VERSION: 05-MAY-82
 */

/* NAME: cursor
 * PARAMETERS: cursor(function, &line, &column)
 *    function is one of the defined funtions in the #define statements
 *      below.
 *    line is an integer, and is either a relative or absolute line number
 *      depending on the function being performed; CUD (cursor down), for
 *      example, is relative; CUP (cursor position) is absolute.
 *      Line is ignored (but must be present in the call) for CUB and CUF.
 *    column is an integer which may be relative or absolute. Column is
 *      ignored (but must be present in the call) for CUD and CUU.
 *    Both line and column must be passed as pointers (&line) so that cursor
 *      may return values when function == CPR.
 *
 *    RESTRICTIONS: This function uses SCOUT, and assumes the buffer area,
 *      named BUF, has been set up externally in the calling program.
 */

#include <stdio.h>
#define CPR 1  /* cursor position report (untested) */
#define CUB 2  /* cursor back */
#define CUD 3  /* cursor down */
#define CUF 4  /* cursor forward */
#define CUP 5  /* cursor position; move to line, col */
#define CUU 6  /* cursor up */
#define SETMAR 7  /* set top and bottom scrolling margins */

cursor (funct, line, col)

int funct, *line, *col;

{
	char *cprf, *cubf, *cudf, *cuff, *cupf, *cuuf, *escb, *cled;
	char *backl, *setmar;
	char *semi, *buf;

	escb = "\233[";		/* ESCAPE-bracket */
	cprf = "6n";	/* request position report */
	cubf = "D";
	cudf = "B";
	cuff = "C";
	cupf = "H";
	cuuf = "A";
	semi = ";";
	backl = "\233[1A\0";
	setmar = "r";

	switch (funct) {
	  case CPR: scout(0,0,cprf);
		    fgets(buf,11,stdin);
		    sscanf(buf, "%*2s %d %*1s %d",line, col);
		    break;
	  case CUB: sprintf(buf, "%s%d%s", escb, col, cubf); 
		    break;
	  case CUD: sprintf(buf, "%s%d%s", escb, line, cudf); 
		    break;
	  case CUF: sprintf(buf, "%s%d%s", escb, col, cuff); 
		    break;
	  case CUP: sprintf(buf, "%s%d%s%d%s", escb, line, semi, col, cupf);
		    /* cursor position */
	  	    break;
	  case CUU: sprintf(buf, "%s%d%s", escb, line, cuuf); /* cursor up */
		    break;
	  case SETMAR: sprintf(buf, "%s%d%s%d%s", escb, line, semi, col, 
		       setmar);
		    break;
	  default:  sprintf(buf, "%s", escb, "6q");
	}
	scout(0,0,backl);  /* back one line to make up for newline */
	scout(0,0,buf);
}
